<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.BillInvoice StructType
 * @subpackage Structs
 */
class Sales_BillInvoice extends Sales_Invoice
{
    /**
     * The Payments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_InvoicePaymentRecord
     */
    public $Payments;
    /**
     * Constructor method for Sales.BillInvoice
     * @uses Sales_BillInvoice::setPayments()
     * @param \patest\StructType\RecordSetOfSales_InvoicePaymentRecord $payments
     */
    public function __construct(\patest\StructType\RecordSetOfSales_InvoicePaymentRecord $payments = null)
    {
        $this
            ->setPayments($payments);
    }
    /**
     * Get Payments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_InvoicePaymentRecord|null
     */
    public function getPayments()
    {
        return isset($this->Payments) ? $this->Payments : null;
    }
    /**
     * Set Payments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_InvoicePaymentRecord $payments
     * @return \patest\StructType\Sales_BillInvoice
     */
    public function setPayments(\patest\StructType\RecordSetOfSales_InvoicePaymentRecord $payments = null)
    {
        if (is_null($payments) || (is_array($payments) && empty($payments))) {
            unset($this->Payments);
        } else {
            $this->Payments = $payments;
        }
        return $this;
    }
}
