<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.BatchApplyCreditsHistory StructType
 * @subpackage Structs
 */
class Sales_BatchApplyCreditsHistory extends PersistableEntity
{
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionType;
    /**
     * The ClientCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClientCount;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypeIds;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The DepositCategoryIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepositCategoryIds;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_BatchApplyCreditsDetail
     */
    public $Details;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventIds;
    /**
     * The InstallmentsPaymentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsPaymentOption;
    /**
     * The PaymentPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanId;
    /**
     * The SeriesIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesIds;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TotalAmountDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmountDue;
    /**
     * The TotalAppliedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAppliedAmount;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Sales.BatchApplyCreditsHistory
     * @uses Sales_BatchApplyCreditsHistory::setActionType()
     * @uses Sales_BatchApplyCreditsHistory::setClientCount()
     * @uses Sales_BatchApplyCreditsHistory::setClientTypeIds()
     * @uses Sales_BatchApplyCreditsHistory::setCreationDate()
     * @uses Sales_BatchApplyCreditsHistory::setDepositCategoryIds()
     * @uses Sales_BatchApplyCreditsHistory::setDetails()
     * @uses Sales_BatchApplyCreditsHistory::setEventIds()
     * @uses Sales_BatchApplyCreditsHistory::setInstallmentsPaymentOption()
     * @uses Sales_BatchApplyCreditsHistory::setPaymentPlanId()
     * @uses Sales_BatchApplyCreditsHistory::setSeriesIds()
     * @uses Sales_BatchApplyCreditsHistory::setStatus()
     * @uses Sales_BatchApplyCreditsHistory::setTotalAmountDue()
     * @uses Sales_BatchApplyCreditsHistory::setTotalAppliedAmount()
     * @uses Sales_BatchApplyCreditsHistory::setUserId()
     * @param string $actionType
     * @param int $clientCount
     * @param string $clientTypeIds
     * @param string $creationDate
     * @param string $depositCategoryIds
     * @param \patest\StructType\RecordSetOfSales_BatchApplyCreditsDetail $details
     * @param string $eventIds
     * @param string $installmentsPaymentOption
     * @param string $paymentPlanId
     * @param string $seriesIds
     * @param string $status
     * @param \patest\StructType\Money $totalAmountDue
     * @param \patest\StructType\Money $totalAppliedAmount
     * @param string $userId
     */
    public function __construct($actionType = null, $clientCount = null, $clientTypeIds = null, $creationDate = null, $depositCategoryIds = null, \patest\StructType\RecordSetOfSales_BatchApplyCreditsDetail $details = null, $eventIds = null, $installmentsPaymentOption = null, $paymentPlanId = null, $seriesIds = null, $status = null, \patest\StructType\Money $totalAmountDue = null, \patest\StructType\Money $totalAppliedAmount = null, $userId = null)
    {
        $this
            ->setActionType($actionType)
            ->setClientCount($clientCount)
            ->setClientTypeIds($clientTypeIds)
            ->setCreationDate($creationDate)
            ->setDepositCategoryIds($depositCategoryIds)
            ->setDetails($details)
            ->setEventIds($eventIds)
            ->setInstallmentsPaymentOption($installmentsPaymentOption)
            ->setPaymentPlanId($paymentPlanId)
            ->setSeriesIds($seriesIds)
            ->setStatus($status)
            ->setTotalAmountDue($totalAmountDue)
            ->setTotalAppliedAmount($totalAppliedAmount)
            ->setUserId($userId);
    }
    /**
     * Get ActionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionType()
    {
        return isset($this->ActionType) ? $this->ActionType : null;
    }
    /**
     * Set ActionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchDepositActionType::valueIsValid()
     * @uses \patest\EnumType\BatchDepositActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchDepositActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchDepositActionType', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \patest\EnumType\BatchDepositActionType::getValidValues())), __LINE__);
        }
        if (is_null($actionType) || (is_array($actionType) && empty($actionType))) {
            unset($this->ActionType);
        } else {
            $this->ActionType = $actionType;
        }
        return $this;
    }
    /**
     * Get ClientCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClientCount()
    {
        return isset($this->ClientCount) ? $this->ClientCount : null;
    }
    /**
     * Set ClientCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $clientCount
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setClientCount($clientCount = null)
    {
        // validation for constraint: int
        if (!is_null($clientCount) && !(is_int($clientCount) || ctype_digit($clientCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($clientCount, true), gettype($clientCount)), __LINE__);
        }
        if (is_null($clientCount) || (is_array($clientCount) && empty($clientCount))) {
            unset($this->ClientCount);
        } else {
            $this->ClientCount = $clientCount;
        }
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypeIds
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setClientTypeIds($clientTypeIds = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeIds) && !is_string($clientTypeIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeIds, true), gettype($clientTypeIds)), __LINE__);
        }
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get DepositCategoryIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryIds()
    {
        return isset($this->DepositCategoryIds) ? $this->DepositCategoryIds : null;
    }
    /**
     * Set DepositCategoryIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryIds
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setDepositCategoryIds($depositCategoryIds = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryIds) && !is_string($depositCategoryIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryIds, true), gettype($depositCategoryIds)), __LINE__);
        }
        if (is_null($depositCategoryIds) || (is_array($depositCategoryIds) && empty($depositCategoryIds))) {
            unset($this->DepositCategoryIds);
        } else {
            $this->DepositCategoryIds = $depositCategoryIds;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_BatchApplyCreditsDetail|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_BatchApplyCreditsDetail $details
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setDetails(\patest\StructType\RecordSetOfSales_BatchApplyCreditsDetail $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventIds
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setEventIds($eventIds = null)
    {
        // validation for constraint: string
        if (!is_null($eventIds) && !is_string($eventIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventIds, true), gettype($eventIds)), __LINE__);
        }
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get InstallmentsPaymentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsPaymentOption()
    {
        return isset($this->InstallmentsPaymentOption) ? $this->InstallmentsPaymentOption : null;
    }
    /**
     * Set InstallmentsPaymentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid()
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsPaymentOption
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setInstallmentsPaymentOption($installmentsPaymentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid($installmentsPaymentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsAmountAdjustmentOption', is_array($installmentsPaymentOption) ? implode(', ', $installmentsPaymentOption) : var_export($installmentsPaymentOption, true), implode(', ', \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues())), __LINE__);
        }
        if (is_null($installmentsPaymentOption) || (is_array($installmentsPaymentOption) && empty($installmentsPaymentOption))) {
            unset($this->InstallmentsPaymentOption);
        } else {
            $this->InstallmentsPaymentOption = $installmentsPaymentOption;
        }
        return $this;
    }
    /**
     * Get PaymentPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanId()
    {
        return isset($this->PaymentPlanId) ? $this->PaymentPlanId : null;
    }
    /**
     * Set PaymentPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanId
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setPaymentPlanId($paymentPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanId) && !is_string($paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanId, true), gettype($paymentPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanId, true)), __LINE__);
        }
        if (is_null($paymentPlanId) || (is_array($paymentPlanId) && empty($paymentPlanId))) {
            unset($this->PaymentPlanId);
        } else {
            $this->PaymentPlanId = $paymentPlanId;
        }
        return $this;
    }
    /**
     * Get SeriesIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesIds()
    {
        return isset($this->SeriesIds) ? $this->SeriesIds : null;
    }
    /**
     * Set SeriesIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesIds
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setSeriesIds($seriesIds = null)
    {
        // validation for constraint: string
        if (!is_null($seriesIds) && !is_string($seriesIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesIds, true), gettype($seriesIds)), __LINE__);
        }
        if (is_null($seriesIds) || (is_array($seriesIds) && empty($seriesIds))) {
            unset($this->SeriesIds);
        } else {
            $this->SeriesIds = $seriesIds;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchApplyCreditsStatus::valueIsValid()
     * @uses \patest\EnumType\BatchApplyCreditsStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchApplyCreditsStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchApplyCreditsStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\BatchApplyCreditsStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalAmountDue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmountDue()
    {
        return isset($this->TotalAmountDue) ? $this->TotalAmountDue : null;
    }
    /**
     * Set TotalAmountDue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmountDue
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setTotalAmountDue(\patest\StructType\Money $totalAmountDue = null)
    {
        if (is_null($totalAmountDue) || (is_array($totalAmountDue) && empty($totalAmountDue))) {
            unset($this->TotalAmountDue);
        } else {
            $this->TotalAmountDue = $totalAmountDue;
        }
        return $this;
    }
    /**
     * Get TotalAppliedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAppliedAmount()
    {
        return isset($this->TotalAppliedAmount) ? $this->TotalAppliedAmount : null;
    }
    /**
     * Set TotalAppliedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAppliedAmount
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setTotalAppliedAmount(\patest\StructType\Money $totalAppliedAmount = null)
    {
        if (is_null($totalAppliedAmount) || (is_array($totalAppliedAmount) && empty($totalAppliedAmount))) {
            unset($this->TotalAppliedAmount);
        } else {
            $this->TotalAppliedAmount = $totalAppliedAmount;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Sales_BatchApplyCreditsHistory
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
