<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.BatchApplyCreditsDetail StructType
 * @subpackage Structs
 */
class Sales_BatchApplyCreditsDetail extends PersistableEntity
{
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionType;
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The InstallmentsPaymentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsPaymentOption;
    /**
     * The PaymentPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentPlanId;
    /**
     * The TotalAmountDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmountDue;
    /**
     * The TotalAppliedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAppliedAmount;
    /**
     * Constructor method for Sales.BatchApplyCreditsDetail
     * @uses Sales_BatchApplyCreditsDetail::setActionType()
     * @uses Sales_BatchApplyCreditsDetail::setBatchId()
     * @uses Sales_BatchApplyCreditsDetail::setClientId()
     * @uses Sales_BatchApplyCreditsDetail::setError()
     * @uses Sales_BatchApplyCreditsDetail::setInstallmentsPaymentOption()
     * @uses Sales_BatchApplyCreditsDetail::setPaymentPlanId()
     * @uses Sales_BatchApplyCreditsDetail::setTotalAmountDue()
     * @uses Sales_BatchApplyCreditsDetail::setTotalAppliedAmount()
     * @param string $actionType
     * @param string $batchId
     * @param string $clientId
     * @param string $error
     * @param string $installmentsPaymentOption
     * @param string $paymentPlanId
     * @param \patest\StructType\Money $totalAmountDue
     * @param \patest\StructType\Money $totalAppliedAmount
     */
    public function __construct($actionType = null, $batchId = null, $clientId = null, $error = null, $installmentsPaymentOption = null, $paymentPlanId = null, \patest\StructType\Money $totalAmountDue = null, \patest\StructType\Money $totalAppliedAmount = null)
    {
        $this
            ->setActionType($actionType)
            ->setBatchId($batchId)
            ->setClientId($clientId)
            ->setError($error)
            ->setInstallmentsPaymentOption($installmentsPaymentOption)
            ->setPaymentPlanId($paymentPlanId)
            ->setTotalAmountDue($totalAmountDue)
            ->setTotalAppliedAmount($totalAppliedAmount);
    }
    /**
     * Get ActionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionType()
    {
        return isset($this->ActionType) ? $this->ActionType : null;
    }
    /**
     * Set ActionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchDepositActionType::valueIsValid()
     * @uses \patest\EnumType\BatchDepositActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $actionType
     * @return \patest\StructType\Sales_BatchApplyCreditsDetail
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchDepositActionType::valueIsValid($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchDepositActionType', is_array($actionType) ? implode(', ', $actionType) : var_export($actionType, true), implode(', ', \patest\EnumType\BatchDepositActionType::getValidValues())), __LINE__);
        }
        if (is_null($actionType) || (is_array($actionType) && empty($actionType))) {
            unset($this->ActionType);
        } else {
            $this->ActionType = $actionType;
        }
        return $this;
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\Sales_BatchApplyCreditsDetail
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Sales_BatchApplyCreditsDetail
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \patest\StructType\Sales_BatchApplyCreditsDetail
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get InstallmentsPaymentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsPaymentOption()
    {
        return isset($this->InstallmentsPaymentOption) ? $this->InstallmentsPaymentOption : null;
    }
    /**
     * Set InstallmentsPaymentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid()
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsPaymentOption
     * @return \patest\StructType\Sales_BatchApplyCreditsDetail
     */
    public function setInstallmentsPaymentOption($installmentsPaymentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid($installmentsPaymentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsAmountAdjustmentOption', is_array($installmentsPaymentOption) ? implode(', ', $installmentsPaymentOption) : var_export($installmentsPaymentOption, true), implode(', ', \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues())), __LINE__);
        }
        if (is_null($installmentsPaymentOption) || (is_array($installmentsPaymentOption) && empty($installmentsPaymentOption))) {
            unset($this->InstallmentsPaymentOption);
        } else {
            $this->InstallmentsPaymentOption = $installmentsPaymentOption;
        }
        return $this;
    }
    /**
     * Get PaymentPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentPlanId()
    {
        return isset($this->PaymentPlanId) ? $this->PaymentPlanId : null;
    }
    /**
     * Set PaymentPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentPlanId
     * @return \patest\StructType\Sales_BatchApplyCreditsDetail
     */
    public function setPaymentPlanId($paymentPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentPlanId) && !is_string($paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentPlanId, true), gettype($paymentPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentPlanId, true)), __LINE__);
        }
        if (is_null($paymentPlanId) || (is_array($paymentPlanId) && empty($paymentPlanId))) {
            unset($this->PaymentPlanId);
        } else {
            $this->PaymentPlanId = $paymentPlanId;
        }
        return $this;
    }
    /**
     * Get TotalAmountDue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmountDue()
    {
        return isset($this->TotalAmountDue) ? $this->TotalAmountDue : null;
    }
    /**
     * Set TotalAmountDue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmountDue
     * @return \patest\StructType\Sales_BatchApplyCreditsDetail
     */
    public function setTotalAmountDue(\patest\StructType\Money $totalAmountDue = null)
    {
        if (is_null($totalAmountDue) || (is_array($totalAmountDue) && empty($totalAmountDue))) {
            unset($this->TotalAmountDue);
        } else {
            $this->TotalAmountDue = $totalAmountDue;
        }
        return $this;
    }
    /**
     * Get TotalAppliedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAppliedAmount()
    {
        return isset($this->TotalAppliedAmount) ? $this->TotalAppliedAmount : null;
    }
    /**
     * Set TotalAppliedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAppliedAmount
     * @return \patest\StructType\Sales_BatchApplyCreditsDetail
     */
    public function setTotalAppliedAmount(\patest\StructType\Money $totalAppliedAmount = null)
    {
        if (is_null($totalAppliedAmount) || (is_array($totalAppliedAmount) && empty($totalAppliedAmount))) {
            unset($this->TotalAppliedAmount);
        } else {
            $this->TotalAppliedAmount = $totalAppliedAmount;
        }
        return $this;
    }
}
