<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.Basket StructType
 * @subpackage Structs
 */
class Sales_Basket extends AnyEntity
{
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_Item
     */
    public $Items;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_BasketPriceModifier
     */
    public $PriceModifiers;
    /**
     * The Totals
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_BasketTotals
     */
    public $Totals;
    /**
     * Constructor method for Sales.Basket
     * @uses Sales_Basket::setItems()
     * @uses Sales_Basket::setPriceModifiers()
     * @uses Sales_Basket::setTotals()
     * @param \patest\StructType\RecordSetOfSales_Item $items
     * @param \patest\StructType\RecordSetOfSales_BasketPriceModifier $priceModifiers
     * @param \patest\StructType\Sales_BasketTotals $totals
     */
    public function __construct(\patest\StructType\RecordSetOfSales_Item $items = null, \patest\StructType\RecordSetOfSales_BasketPriceModifier $priceModifiers = null, \patest\StructType\Sales_BasketTotals $totals = null)
    {
        $this
            ->setItems($items)
            ->setPriceModifiers($priceModifiers)
            ->setTotals($totals);
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_Item|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_Item $items
     * @return \patest\StructType\Sales_Basket
     */
    public function setItems(\patest\StructType\RecordSetOfSales_Item $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_BasketPriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_BasketPriceModifier $priceModifiers
     * @return \patest\StructType\Sales_Basket
     */
    public function setPriceModifiers(\patest\StructType\RecordSetOfSales_BasketPriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_BasketTotals|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_BasketTotals $totals
     * @return \patest\StructType\Sales_Basket
     */
    public function setTotals(\patest\StructType\Sales_BasketTotals $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
}
