<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.AccountingJournal StructType
 * @subpackage Structs
 */
class Sales_AccountingJournal extends PersistableEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The FloatAttribute1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FloatAttribute1;
    /**
     * The FloatAttribute2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FloatAttribute2;
    /**
     * The FloatAttribute3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FloatAttribute3;
    /**
     * The GuidAttribute1
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidAttribute1;
    /**
     * The GuidAttribute2
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidAttribute2;
    /**
     * The GuidAttribute3
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidAttribute3;
    /**
     * The IntegerAttribute1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntegerAttribute1;
    /**
     * The IntegerAttribute2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntegerAttribute2;
    /**
     * The IntegerAttribute3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntegerAttribute3;
    /**
     * The Ledger
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ledger;
    /**
     * The MoneyAttribute1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MoneyAttribute1;
    /**
     * The MoneyAttribute2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MoneyAttribute2;
    /**
     * The MoneyAttribute3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MoneyAttribute3;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Owner;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StringAttribute1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringAttribute1;
    /**
     * The StringAttribute2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringAttribute2;
    /**
     * The StringAttribute3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringAttribute3;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Sales.AccountingJournal
     * @uses Sales_AccountingJournal::setAmount()
     * @uses Sales_AccountingJournal::setDateTime()
     * @uses Sales_AccountingJournal::setFloatAttribute1()
     * @uses Sales_AccountingJournal::setFloatAttribute2()
     * @uses Sales_AccountingJournal::setFloatAttribute3()
     * @uses Sales_AccountingJournal::setGuidAttribute1()
     * @uses Sales_AccountingJournal::setGuidAttribute2()
     * @uses Sales_AccountingJournal::setGuidAttribute3()
     * @uses Sales_AccountingJournal::setIntegerAttribute1()
     * @uses Sales_AccountingJournal::setIntegerAttribute2()
     * @uses Sales_AccountingJournal::setIntegerAttribute3()
     * @uses Sales_AccountingJournal::setLedger()
     * @uses Sales_AccountingJournal::setMoneyAttribute1()
     * @uses Sales_AccountingJournal::setMoneyAttribute2()
     * @uses Sales_AccountingJournal::setMoneyAttribute3()
     * @uses Sales_AccountingJournal::setOwner()
     * @uses Sales_AccountingJournal::setQuantity()
     * @uses Sales_AccountingJournal::setStatus()
     * @uses Sales_AccountingJournal::setStringAttribute1()
     * @uses Sales_AccountingJournal::setStringAttribute2()
     * @uses Sales_AccountingJournal::setStringAttribute3()
     * @uses Sales_AccountingJournal::setTransactionNumber()
     * @param \patest\StructType\Money $amount
     * @param string $dateTime
     * @param float $floatAttribute1
     * @param float $floatAttribute2
     * @param float $floatAttribute3
     * @param string $guidAttribute1
     * @param string $guidAttribute2
     * @param string $guidAttribute3
     * @param int $integerAttribute1
     * @param int $integerAttribute2
     * @param int $integerAttribute3
     * @param int $ledger
     * @param \patest\StructType\Money $moneyAttribute1
     * @param \patest\StructType\Money $moneyAttribute2
     * @param \patest\StructType\Money $moneyAttribute3
     * @param string $owner
     * @param int $quantity
     * @param string $status
     * @param string $stringAttribute1
     * @param string $stringAttribute2
     * @param string $stringAttribute3
     * @param int $transactionNumber
     */
    public function __construct(\patest\StructType\Money $amount = null, $dateTime = null, $floatAttribute1 = null, $floatAttribute2 = null, $floatAttribute3 = null, $guidAttribute1 = null, $guidAttribute2 = null, $guidAttribute3 = null, $integerAttribute1 = null, $integerAttribute2 = null, $integerAttribute3 = null, $ledger = null, \patest\StructType\Money $moneyAttribute1 = null, \patest\StructType\Money $moneyAttribute2 = null, \patest\StructType\Money $moneyAttribute3 = null, $owner = null, $quantity = null, $status = null, $stringAttribute1 = null, $stringAttribute2 = null, $stringAttribute3 = null, $transactionNumber = null)
    {
        $this
            ->setAmount($amount)
            ->setDateTime($dateTime)
            ->setFloatAttribute1($floatAttribute1)
            ->setFloatAttribute2($floatAttribute2)
            ->setFloatAttribute3($floatAttribute3)
            ->setGuidAttribute1($guidAttribute1)
            ->setGuidAttribute2($guidAttribute2)
            ->setGuidAttribute3($guidAttribute3)
            ->setIntegerAttribute1($integerAttribute1)
            ->setIntegerAttribute2($integerAttribute2)
            ->setIntegerAttribute3($integerAttribute3)
            ->setLedger($ledger)
            ->setMoneyAttribute1($moneyAttribute1)
            ->setMoneyAttribute2($moneyAttribute2)
            ->setMoneyAttribute3($moneyAttribute3)
            ->setOwner($owner)
            ->setQuantity($quantity)
            ->setStatus($status)
            ->setStringAttribute1($stringAttribute1)
            ->setStringAttribute2($stringAttribute2)
            ->setStringAttribute3($stringAttribute3)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get FloatAttribute1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFloatAttribute1()
    {
        return isset($this->FloatAttribute1) ? $this->FloatAttribute1 : null;
    }
    /**
     * Set FloatAttribute1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $floatAttribute1
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setFloatAttribute1($floatAttribute1 = null)
    {
        // validation for constraint: float
        if (!is_null($floatAttribute1) && !(is_float($floatAttribute1) || is_numeric($floatAttribute1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($floatAttribute1, true), gettype($floatAttribute1)), __LINE__);
        }
        if (is_null($floatAttribute1) || (is_array($floatAttribute1) && empty($floatAttribute1))) {
            unset($this->FloatAttribute1);
        } else {
            $this->FloatAttribute1 = $floatAttribute1;
        }
        return $this;
    }
    /**
     * Get FloatAttribute2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFloatAttribute2()
    {
        return isset($this->FloatAttribute2) ? $this->FloatAttribute2 : null;
    }
    /**
     * Set FloatAttribute2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $floatAttribute2
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setFloatAttribute2($floatAttribute2 = null)
    {
        // validation for constraint: float
        if (!is_null($floatAttribute2) && !(is_float($floatAttribute2) || is_numeric($floatAttribute2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($floatAttribute2, true), gettype($floatAttribute2)), __LINE__);
        }
        if (is_null($floatAttribute2) || (is_array($floatAttribute2) && empty($floatAttribute2))) {
            unset($this->FloatAttribute2);
        } else {
            $this->FloatAttribute2 = $floatAttribute2;
        }
        return $this;
    }
    /**
     * Get FloatAttribute3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFloatAttribute3()
    {
        return isset($this->FloatAttribute3) ? $this->FloatAttribute3 : null;
    }
    /**
     * Set FloatAttribute3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $floatAttribute3
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setFloatAttribute3($floatAttribute3 = null)
    {
        // validation for constraint: float
        if (!is_null($floatAttribute3) && !(is_float($floatAttribute3) || is_numeric($floatAttribute3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($floatAttribute3, true), gettype($floatAttribute3)), __LINE__);
        }
        if (is_null($floatAttribute3) || (is_array($floatAttribute3) && empty($floatAttribute3))) {
            unset($this->FloatAttribute3);
        } else {
            $this->FloatAttribute3 = $floatAttribute3;
        }
        return $this;
    }
    /**
     * Get GuidAttribute1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidAttribute1()
    {
        return isset($this->GuidAttribute1) ? $this->GuidAttribute1 : null;
    }
    /**
     * Set GuidAttribute1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidAttribute1
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setGuidAttribute1($guidAttribute1 = null)
    {
        // validation for constraint: string
        if (!is_null($guidAttribute1) && !is_string($guidAttribute1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidAttribute1, true), gettype($guidAttribute1)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidAttribute1) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidAttribute1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidAttribute1, true)), __LINE__);
        }
        if (is_null($guidAttribute1) || (is_array($guidAttribute1) && empty($guidAttribute1))) {
            unset($this->GuidAttribute1);
        } else {
            $this->GuidAttribute1 = $guidAttribute1;
        }
        return $this;
    }
    /**
     * Get GuidAttribute2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidAttribute2()
    {
        return isset($this->GuidAttribute2) ? $this->GuidAttribute2 : null;
    }
    /**
     * Set GuidAttribute2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidAttribute2
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setGuidAttribute2($guidAttribute2 = null)
    {
        // validation for constraint: string
        if (!is_null($guidAttribute2) && !is_string($guidAttribute2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidAttribute2, true), gettype($guidAttribute2)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidAttribute2) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidAttribute2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidAttribute2, true)), __LINE__);
        }
        if (is_null($guidAttribute2) || (is_array($guidAttribute2) && empty($guidAttribute2))) {
            unset($this->GuidAttribute2);
        } else {
            $this->GuidAttribute2 = $guidAttribute2;
        }
        return $this;
    }
    /**
     * Get GuidAttribute3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidAttribute3()
    {
        return isset($this->GuidAttribute3) ? $this->GuidAttribute3 : null;
    }
    /**
     * Set GuidAttribute3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidAttribute3
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setGuidAttribute3($guidAttribute3 = null)
    {
        // validation for constraint: string
        if (!is_null($guidAttribute3) && !is_string($guidAttribute3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidAttribute3, true), gettype($guidAttribute3)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidAttribute3) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidAttribute3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidAttribute3, true)), __LINE__);
        }
        if (is_null($guidAttribute3) || (is_array($guidAttribute3) && empty($guidAttribute3))) {
            unset($this->GuidAttribute3);
        } else {
            $this->GuidAttribute3 = $guidAttribute3;
        }
        return $this;
    }
    /**
     * Get IntegerAttribute1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntegerAttribute1()
    {
        return isset($this->IntegerAttribute1) ? $this->IntegerAttribute1 : null;
    }
    /**
     * Set IntegerAttribute1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $integerAttribute1
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setIntegerAttribute1($integerAttribute1 = null)
    {
        // validation for constraint: int
        if (!is_null($integerAttribute1) && !(is_int($integerAttribute1) || ctype_digit($integerAttribute1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($integerAttribute1, true), gettype($integerAttribute1)), __LINE__);
        }
        if (is_null($integerAttribute1) || (is_array($integerAttribute1) && empty($integerAttribute1))) {
            unset($this->IntegerAttribute1);
        } else {
            $this->IntegerAttribute1 = $integerAttribute1;
        }
        return $this;
    }
    /**
     * Get IntegerAttribute2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntegerAttribute2()
    {
        return isset($this->IntegerAttribute2) ? $this->IntegerAttribute2 : null;
    }
    /**
     * Set IntegerAttribute2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $integerAttribute2
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setIntegerAttribute2($integerAttribute2 = null)
    {
        // validation for constraint: int
        if (!is_null($integerAttribute2) && !(is_int($integerAttribute2) || ctype_digit($integerAttribute2))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($integerAttribute2, true), gettype($integerAttribute2)), __LINE__);
        }
        if (is_null($integerAttribute2) || (is_array($integerAttribute2) && empty($integerAttribute2))) {
            unset($this->IntegerAttribute2);
        } else {
            $this->IntegerAttribute2 = $integerAttribute2;
        }
        return $this;
    }
    /**
     * Get IntegerAttribute3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntegerAttribute3()
    {
        return isset($this->IntegerAttribute3) ? $this->IntegerAttribute3 : null;
    }
    /**
     * Set IntegerAttribute3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $integerAttribute3
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setIntegerAttribute3($integerAttribute3 = null)
    {
        // validation for constraint: int
        if (!is_null($integerAttribute3) && !(is_int($integerAttribute3) || ctype_digit($integerAttribute3))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($integerAttribute3, true), gettype($integerAttribute3)), __LINE__);
        }
        if (is_null($integerAttribute3) || (is_array($integerAttribute3) && empty($integerAttribute3))) {
            unset($this->IntegerAttribute3);
        } else {
            $this->IntegerAttribute3 = $integerAttribute3;
        }
        return $this;
    }
    /**
     * Get Ledger value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLedger()
    {
        return isset($this->Ledger) ? $this->Ledger : null;
    }
    /**
     * Set Ledger value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ledger
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setLedger($ledger = null)
    {
        // validation for constraint: int
        if (!is_null($ledger) && !(is_int($ledger) || ctype_digit($ledger))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ledger, true), gettype($ledger)), __LINE__);
        }
        if (is_null($ledger) || (is_array($ledger) && empty($ledger))) {
            unset($this->Ledger);
        } else {
            $this->Ledger = $ledger;
        }
        return $this;
    }
    /**
     * Get MoneyAttribute1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMoneyAttribute1()
    {
        return isset($this->MoneyAttribute1) ? $this->MoneyAttribute1 : null;
    }
    /**
     * Set MoneyAttribute1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $moneyAttribute1
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setMoneyAttribute1(\patest\StructType\Money $moneyAttribute1 = null)
    {
        if (is_null($moneyAttribute1) || (is_array($moneyAttribute1) && empty($moneyAttribute1))) {
            unset($this->MoneyAttribute1);
        } else {
            $this->MoneyAttribute1 = $moneyAttribute1;
        }
        return $this;
    }
    /**
     * Get MoneyAttribute2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMoneyAttribute2()
    {
        return isset($this->MoneyAttribute2) ? $this->MoneyAttribute2 : null;
    }
    /**
     * Set MoneyAttribute2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $moneyAttribute2
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setMoneyAttribute2(\patest\StructType\Money $moneyAttribute2 = null)
    {
        if (is_null($moneyAttribute2) || (is_array($moneyAttribute2) && empty($moneyAttribute2))) {
            unset($this->MoneyAttribute2);
        } else {
            $this->MoneyAttribute2 = $moneyAttribute2;
        }
        return $this;
    }
    /**
     * Get MoneyAttribute3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMoneyAttribute3()
    {
        return isset($this->MoneyAttribute3) ? $this->MoneyAttribute3 : null;
    }
    /**
     * Set MoneyAttribute3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $moneyAttribute3
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setMoneyAttribute3(\patest\StructType\Money $moneyAttribute3 = null)
    {
        if (is_null($moneyAttribute3) || (is_array($moneyAttribute3) && empty($moneyAttribute3))) {
            unset($this->MoneyAttribute3);
        } else {
            $this->MoneyAttribute3 = $moneyAttribute3;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $owner
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($owner) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($owner, true)), __LINE__);
        }
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccountingJournalEntryStatus::valueIsValid()
     * @uses \patest\EnumType\AccountingJournalEntryStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AccountingJournalEntryStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccountingJournalEntryStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\AccountingJournalEntryStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StringAttribute1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringAttribute1()
    {
        return isset($this->StringAttribute1) ? $this->StringAttribute1 : null;
    }
    /**
     * Set StringAttribute1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringAttribute1
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setStringAttribute1($stringAttribute1 = null)
    {
        // validation for constraint: string
        if (!is_null($stringAttribute1) && !is_string($stringAttribute1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringAttribute1, true), gettype($stringAttribute1)), __LINE__);
        }
        if (is_null($stringAttribute1) || (is_array($stringAttribute1) && empty($stringAttribute1))) {
            unset($this->StringAttribute1);
        } else {
            $this->StringAttribute1 = $stringAttribute1;
        }
        return $this;
    }
    /**
     * Get StringAttribute2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringAttribute2()
    {
        return isset($this->StringAttribute2) ? $this->StringAttribute2 : null;
    }
    /**
     * Set StringAttribute2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringAttribute2
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setStringAttribute2($stringAttribute2 = null)
    {
        // validation for constraint: string
        if (!is_null($stringAttribute2) && !is_string($stringAttribute2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringAttribute2, true), gettype($stringAttribute2)), __LINE__);
        }
        if (is_null($stringAttribute2) || (is_array($stringAttribute2) && empty($stringAttribute2))) {
            unset($this->StringAttribute2);
        } else {
            $this->StringAttribute2 = $stringAttribute2;
        }
        return $this;
    }
    /**
     * Get StringAttribute3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringAttribute3()
    {
        return isset($this->StringAttribute3) ? $this->StringAttribute3 : null;
    }
    /**
     * Set StringAttribute3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringAttribute3
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setStringAttribute3($stringAttribute3 = null)
    {
        // validation for constraint: string
        if (!is_null($stringAttribute3) && !is_string($stringAttribute3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringAttribute3, true), gettype($stringAttribute3)), __LINE__);
        }
        if (is_null($stringAttribute3) || (is_array($stringAttribute3) && empty($stringAttribute3))) {
            unset($this->StringAttribute3);
        } else {
            $this->StringAttribute3 = $stringAttribute3;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Sales_AccountingJournal
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
