<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.AccountFilter StructType
 * @subpackage Structs
 */
class Sales_AccountFilter extends Sales_ClientFilter
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * Constructor method for Sales.AccountFilter
     * @uses Sales_AccountFilter::setName()
     * @uses Sales_AccountFilter::setVatRegistrationNumber()
     * @param string $name
     * @param string $vatRegistrationNumber
     */
    public function __construct($name = null, $vatRegistrationNumber = null)
    {
        $this
            ->setName($name)
            ->setVatRegistrationNumber($vatRegistrationNumber);
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Sales_AccountFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return isset($this->VatRegistrationNumber) ? $this->VatRegistrationNumber : null;
    }
    /**
     * Set VatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatRegistrationNumber
     * @return \patest\StructType\Sales_AccountFilter
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        if (is_null($vatRegistrationNumber) || (is_array($vatRegistrationNumber) && empty($vatRegistrationNumber))) {
            unset($this->VatRegistrationNumber);
        } else {
            $this->VatRegistrationNumber = $vatRegistrationNumber;
        }
        return $this;
    }
}
