<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sales.AbstractItemDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Sales.AbstractItemDetails
 * @subpackage Structs
 */
class Sales_AbstractItemDetails extends AnyEntity
{
    /**
     * The DetailsText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DetailsText;
    /**
     * The DetailsTextForPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DetailsTextForPrint;
    /**
     * The ExtraDetailsText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraDetailsText;
    /**
     * The IsObsolete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsObsolete;
    /**
     * The ProductId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductId;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductName;
    /**
     * Constructor method for Sales.AbstractItemDetails
     * @uses Sales_AbstractItemDetails::setDetailsText()
     * @uses Sales_AbstractItemDetails::setDetailsTextForPrint()
     * @uses Sales_AbstractItemDetails::setExtraDetailsText()
     * @uses Sales_AbstractItemDetails::setIsObsolete()
     * @uses Sales_AbstractItemDetails::setProductId()
     * @uses Sales_AbstractItemDetails::setProductName()
     * @param string $detailsText
     * @param string $detailsTextForPrint
     * @param string $extraDetailsText
     * @param bool $isObsolete
     * @param string $productId
     * @param string $productName
     */
    public function __construct($detailsText = null, $detailsTextForPrint = null, $extraDetailsText = null, $isObsolete = null, $productId = null, $productName = null)
    {
        $this
            ->setDetailsText($detailsText)
            ->setDetailsTextForPrint($detailsTextForPrint)
            ->setExtraDetailsText($extraDetailsText)
            ->setIsObsolete($isObsolete)
            ->setProductId($productId)
            ->setProductName($productName);
    }
    /**
     * Get DetailsText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetailsText()
    {
        return isset($this->DetailsText) ? $this->DetailsText : null;
    }
    /**
     * Set DetailsText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detailsText
     * @return \patest\StructType\Sales_AbstractItemDetails
     */
    public function setDetailsText($detailsText = null)
    {
        // validation for constraint: string
        if (!is_null($detailsText) && !is_string($detailsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailsText, true), gettype($detailsText)), __LINE__);
        }
        if (is_null($detailsText) || (is_array($detailsText) && empty($detailsText))) {
            unset($this->DetailsText);
        } else {
            $this->DetailsText = $detailsText;
        }
        return $this;
    }
    /**
     * Get DetailsTextForPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetailsTextForPrint()
    {
        return isset($this->DetailsTextForPrint) ? $this->DetailsTextForPrint : null;
    }
    /**
     * Set DetailsTextForPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detailsTextForPrint
     * @return \patest\StructType\Sales_AbstractItemDetails
     */
    public function setDetailsTextForPrint($detailsTextForPrint = null)
    {
        // validation for constraint: string
        if (!is_null($detailsTextForPrint) && !is_string($detailsTextForPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detailsTextForPrint, true), gettype($detailsTextForPrint)), __LINE__);
        }
        if (is_null($detailsTextForPrint) || (is_array($detailsTextForPrint) && empty($detailsTextForPrint))) {
            unset($this->DetailsTextForPrint);
        } else {
            $this->DetailsTextForPrint = $detailsTextForPrint;
        }
        return $this;
    }
    /**
     * Get ExtraDetailsText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraDetailsText()
    {
        return isset($this->ExtraDetailsText) ? $this->ExtraDetailsText : null;
    }
    /**
     * Set ExtraDetailsText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraDetailsText
     * @return \patest\StructType\Sales_AbstractItemDetails
     */
    public function setExtraDetailsText($extraDetailsText = null)
    {
        // validation for constraint: string
        if (!is_null($extraDetailsText) && !is_string($extraDetailsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraDetailsText, true), gettype($extraDetailsText)), __LINE__);
        }
        if (is_null($extraDetailsText) || (is_array($extraDetailsText) && empty($extraDetailsText))) {
            unset($this->ExtraDetailsText);
        } else {
            $this->ExtraDetailsText = $extraDetailsText;
        }
        return $this;
    }
    /**
     * Get IsObsolete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsObsolete()
    {
        return isset($this->IsObsolete) ? $this->IsObsolete : null;
    }
    /**
     * Set IsObsolete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isObsolete
     * @return \patest\StructType\Sales_AbstractItemDetails
     */
    public function setIsObsolete($isObsolete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObsolete) && !is_bool($isObsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObsolete, true), gettype($isObsolete)), __LINE__);
        }
        if (is_null($isObsolete) || (is_array($isObsolete) && empty($isObsolete))) {
            unset($this->IsObsolete);
        } else {
            $this->IsObsolete = $isObsolete;
        }
        return $this;
    }
    /**
     * Get ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductId()
    {
        return isset($this->ProductId) ? $this->ProductId : null;
    }
    /**
     * Set ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productId
     * @return \patest\StructType\Sales_AbstractItemDetails
     */
    public function setProductId($productId = null)
    {
        // validation for constraint: string
        if (!is_null($productId) && !is_string($productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productId, true), gettype($productId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productId, true)), __LINE__);
        }
        if (is_null($productId) || (is_array($productId) && empty($productId))) {
            unset($this->ProductId);
        } else {
            $this->ProductId = $productId;
        }
        return $this;
    }
    /**
     * Get ProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductName()
    {
        return isset($this->ProductName) ? $this->ProductName : null;
    }
    /**
     * Set ProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productName
     * @return \patest\StructType\Sales_AbstractItemDetails
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productName, true), gettype($productName)), __LINE__);
        }
        if (is_null($productName) || (is_array($productName) && empty($productName))) {
            unset($this->ProductName);
        } else {
            $this->ProductName = $productName;
        }
        return $this;
    }
}
