<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleEngine.RuleSummaryInfo StructType
 * @subpackage Structs
 */
class RuleEngine_RuleSummaryInfo extends PersistableEntity
{
    /**
     * The GuidValue
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidValue;
    /**
     * The IntValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IntValue;
    /**
     * The PropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyName;
    /**
     * The RuleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RuleId;
    /**
     * The StringValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StringValue;
    /**
     * Constructor method for RuleEngine.RuleSummaryInfo
     * @uses RuleEngine_RuleSummaryInfo::setGuidValue()
     * @uses RuleEngine_RuleSummaryInfo::setIntValue()
     * @uses RuleEngine_RuleSummaryInfo::setPropertyName()
     * @uses RuleEngine_RuleSummaryInfo::setRuleId()
     * @uses RuleEngine_RuleSummaryInfo::setStringValue()
     * @param string $guidValue
     * @param int $intValue
     * @param string $propertyName
     * @param string $ruleId
     * @param string $stringValue
     */
    public function __construct($guidValue = null, $intValue = null, $propertyName = null, $ruleId = null, $stringValue = null)
    {
        $this
            ->setGuidValue($guidValue)
            ->setIntValue($intValue)
            ->setPropertyName($propertyName)
            ->setRuleId($ruleId)
            ->setStringValue($stringValue);
    }
    /**
     * Get GuidValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuidValue()
    {
        return isset($this->GuidValue) ? $this->GuidValue : null;
    }
    /**
     * Set GuidValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guidValue
     * @return \patest\StructType\RuleEngine_RuleSummaryInfo
     */
    public function setGuidValue($guidValue = null)
    {
        // validation for constraint: string
        if (!is_null($guidValue) && !is_string($guidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidValue, true), gettype($guidValue)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidValue) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidValue, true)), __LINE__);
        }
        if (is_null($guidValue) || (is_array($guidValue) && empty($guidValue))) {
            unset($this->GuidValue);
        } else {
            $this->GuidValue = $guidValue;
        }
        return $this;
    }
    /**
     * Get IntValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIntValue()
    {
        return isset($this->IntValue) ? $this->IntValue : null;
    }
    /**
     * Set IntValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $intValue
     * @return \patest\StructType\RuleEngine_RuleSummaryInfo
     */
    public function setIntValue($intValue = null)
    {
        // validation for constraint: int
        if (!is_null($intValue) && !(is_int($intValue) || ctype_digit($intValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($intValue, true), gettype($intValue)), __LINE__);
        }
        if (is_null($intValue) || (is_array($intValue) && empty($intValue))) {
            unset($this->IntValue);
        } else {
            $this->IntValue = $intValue;
        }
        return $this;
    }
    /**
     * Get PropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyName()
    {
        return isset($this->PropertyName) ? $this->PropertyName : null;
    }
    /**
     * Set PropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyName
     * @return \patest\StructType\RuleEngine_RuleSummaryInfo
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyName, true), gettype($propertyName)), __LINE__);
        }
        if (is_null($propertyName) || (is_array($propertyName) && empty($propertyName))) {
            unset($this->PropertyName);
        } else {
            $this->PropertyName = $propertyName;
        }
        return $this;
    }
    /**
     * Get RuleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleId()
    {
        return isset($this->RuleId) ? $this->RuleId : null;
    }
    /**
     * Set RuleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleId
     * @return \patest\StructType\RuleEngine_RuleSummaryInfo
     */
    public function setRuleId($ruleId = null)
    {
        // validation for constraint: string
        if (!is_null($ruleId) && !is_string($ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleId, true), gettype($ruleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ruleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ruleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ruleId, true)), __LINE__);
        }
        if (is_null($ruleId) || (is_array($ruleId) && empty($ruleId))) {
            unset($this->RuleId);
        } else {
            $this->RuleId = $ruleId;
        }
        return $this;
    }
    /**
     * Get StringValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStringValue()
    {
        return isset($this->StringValue) ? $this->StringValue : null;
    }
    /**
     * Set StringValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stringValue
     * @return \patest\StructType\RuleEngine_RuleSummaryInfo
     */
    public function setStringValue($stringValue = null)
    {
        // validation for constraint: string
        if (!is_null($stringValue) && !is_string($stringValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stringValue, true), gettype($stringValue)), __LINE__);
        }
        if (is_null($stringValue) || (is_array($stringValue) && empty($stringValue))) {
            unset($this->StringValue);
        } else {
            $this->StringValue = $stringValue;
        }
        return $this;
    }
}
