<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RuleEngine.Rule StructType
 * @subpackage Structs
 */
class RuleEngine_Rule extends PersistableEntity
{
    /**
     * The ActionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfRuleEngine_Action
     */
    public $ActionList;
    /**
     * The ContextEntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextEntityId;
    /**
     * The ContextEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextEntityName;
    /**
     * The CreatedByUnitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreatedByUnitId;
    /**
     * The CriterionList
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfRuleEngine_Criterion
     */
    public $CriterionList;
    /**
     * The Dependencies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfRuleEngine_RuleDependency
     */
    public $Dependencies;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Effective
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Effective;
    /**
     * The EffectiveFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveFrom;
    /**
     * The EffectiveUntil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveUntil;
    /**
     * The Ephemeral
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Ephemeral;
    /**
     * The InheritedFrom
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InheritedFrom;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The RuleResolutionOrder
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RuleResolutionOrder;
    /**
     * The RuleSetId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RuleSetId;
    /**
     * The RuleSetName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleSetName;
    /**
     * The RuleSystemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RuleSystemName;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The SummaryInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfRuleEngine_RuleSummaryInfo
     */
    public $SummaryInfo;
    /**
     * Constructor method for RuleEngine.Rule
     * @uses RuleEngine_Rule::setActionList()
     * @uses RuleEngine_Rule::setContextEntityId()
     * @uses RuleEngine_Rule::setContextEntityName()
     * @uses RuleEngine_Rule::setCreatedByUnitId()
     * @uses RuleEngine_Rule::setCriterionList()
     * @uses RuleEngine_Rule::setDependencies()
     * @uses RuleEngine_Rule::setDescription()
     * @uses RuleEngine_Rule::setEffective()
     * @uses RuleEngine_Rule::setEffectiveFrom()
     * @uses RuleEngine_Rule::setEffectiveUntil()
     * @uses RuleEngine_Rule::setEphemeral()
     * @uses RuleEngine_Rule::setInheritedFrom()
     * @uses RuleEngine_Rule::setName()
     * @uses RuleEngine_Rule::setPriority()
     * @uses RuleEngine_Rule::setRuleResolutionOrder()
     * @uses RuleEngine_Rule::setRuleSetId()
     * @uses RuleEngine_Rule::setRuleSetName()
     * @uses RuleEngine_Rule::setRuleSystemName()
     * @uses RuleEngine_Rule::setStatus()
     * @uses RuleEngine_Rule::setSummaryInfo()
     * @param \patest\StructType\RecordSetOfRuleEngine_Action $actionList
     * @param string $contextEntityId
     * @param string $contextEntityName
     * @param string $createdByUnitId
     * @param \patest\StructType\RecordSetOfRuleEngine_Criterion $criterionList
     * @param \patest\StructType\RecordSetOfRuleEngine_RuleDependency $dependencies
     * @param string $description
     * @param bool $effective
     * @param string $effectiveFrom
     * @param string $effectiveUntil
     * @param bool $ephemeral
     * @param string $inheritedFrom
     * @param string $name
     * @param int $priority
     * @param int $ruleResolutionOrder
     * @param string $ruleSetId
     * @param string $ruleSetName
     * @param string $ruleSystemName
     * @param string $status
     * @param \patest\StructType\RecordSetOfRuleEngine_RuleSummaryInfo $summaryInfo
     */
    public function __construct(\patest\StructType\RecordSetOfRuleEngine_Action $actionList = null, $contextEntityId = null, $contextEntityName = null, $createdByUnitId = null, \patest\StructType\RecordSetOfRuleEngine_Criterion $criterionList = null, \patest\StructType\RecordSetOfRuleEngine_RuleDependency $dependencies = null, $description = null, $effective = null, $effectiveFrom = null, $effectiveUntil = null, $ephemeral = null, $inheritedFrom = null, $name = null, $priority = null, $ruleResolutionOrder = null, $ruleSetId = null, $ruleSetName = null, $ruleSystemName = null, $status = null, \patest\StructType\RecordSetOfRuleEngine_RuleSummaryInfo $summaryInfo = null)
    {
        $this
            ->setActionList($actionList)
            ->setContextEntityId($contextEntityId)
            ->setContextEntityName($contextEntityName)
            ->setCreatedByUnitId($createdByUnitId)
            ->setCriterionList($criterionList)
            ->setDependencies($dependencies)
            ->setDescription($description)
            ->setEffective($effective)
            ->setEffectiveFrom($effectiveFrom)
            ->setEffectiveUntil($effectiveUntil)
            ->setEphemeral($ephemeral)
            ->setInheritedFrom($inheritedFrom)
            ->setName($name)
            ->setPriority($priority)
            ->setRuleResolutionOrder($ruleResolutionOrder)
            ->setRuleSetId($ruleSetId)
            ->setRuleSetName($ruleSetName)
            ->setRuleSystemName($ruleSystemName)
            ->setStatus($status)
            ->setSummaryInfo($summaryInfo);
    }
    /**
     * Get ActionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfRuleEngine_Action|null
     */
    public function getActionList()
    {
        return isset($this->ActionList) ? $this->ActionList : null;
    }
    /**
     * Set ActionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfRuleEngine_Action $actionList
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setActionList(\patest\StructType\RecordSetOfRuleEngine_Action $actionList = null)
    {
        if (is_null($actionList) || (is_array($actionList) && empty($actionList))) {
            unset($this->ActionList);
        } else {
            $this->ActionList = $actionList;
        }
        return $this;
    }
    /**
     * Get ContextEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextEntityId()
    {
        return isset($this->ContextEntityId) ? $this->ContextEntityId : null;
    }
    /**
     * Set ContextEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextEntityId
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setContextEntityId($contextEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($contextEntityId) && !is_string($contextEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextEntityId, true), gettype($contextEntityId)), __LINE__);
        }
        if (is_null($contextEntityId) || (is_array($contextEntityId) && empty($contextEntityId))) {
            unset($this->ContextEntityId);
        } else {
            $this->ContextEntityId = $contextEntityId;
        }
        return $this;
    }
    /**
     * Get ContextEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextEntityName()
    {
        return isset($this->ContextEntityName) ? $this->ContextEntityName : null;
    }
    /**
     * Set ContextEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextEntityName
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setContextEntityName($contextEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($contextEntityName) && !is_string($contextEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextEntityName, true), gettype($contextEntityName)), __LINE__);
        }
        if (is_null($contextEntityName) || (is_array($contextEntityName) && empty($contextEntityName))) {
            unset($this->ContextEntityName);
        } else {
            $this->ContextEntityName = $contextEntityName;
        }
        return $this;
    }
    /**
     * Get CreatedByUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreatedByUnitId()
    {
        return isset($this->CreatedByUnitId) ? $this->CreatedByUnitId : null;
    }
    /**
     * Set CreatedByUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createdByUnitId
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setCreatedByUnitId($createdByUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($createdByUnitId) && !is_string($createdByUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdByUnitId, true), gettype($createdByUnitId)), __LINE__);
        }
        if (is_null($createdByUnitId) || (is_array($createdByUnitId) && empty($createdByUnitId))) {
            unset($this->CreatedByUnitId);
        } else {
            $this->CreatedByUnitId = $createdByUnitId;
        }
        return $this;
    }
    /**
     * Get CriterionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfRuleEngine_Criterion|null
     */
    public function getCriterionList()
    {
        return isset($this->CriterionList) ? $this->CriterionList : null;
    }
    /**
     * Set CriterionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfRuleEngine_Criterion $criterionList
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setCriterionList(\patest\StructType\RecordSetOfRuleEngine_Criterion $criterionList = null)
    {
        if (is_null($criterionList) || (is_array($criterionList) && empty($criterionList))) {
            unset($this->CriterionList);
        } else {
            $this->CriterionList = $criterionList;
        }
        return $this;
    }
    /**
     * Get Dependencies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfRuleEngine_RuleDependency|null
     */
    public function getDependencies()
    {
        return isset($this->Dependencies) ? $this->Dependencies : null;
    }
    /**
     * Set Dependencies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfRuleEngine_RuleDependency $dependencies
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setDependencies(\patest\StructType\RecordSetOfRuleEngine_RuleDependency $dependencies = null)
    {
        if (is_null($dependencies) || (is_array($dependencies) && empty($dependencies))) {
            unset($this->Dependencies);
        } else {
            $this->Dependencies = $dependencies;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Effective value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEffective()
    {
        return isset($this->Effective) ? $this->Effective : null;
    }
    /**
     * Set Effective value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $effective
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setEffective($effective = null)
    {
        // validation for constraint: boolean
        if (!is_null($effective) && !is_bool($effective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($effective, true), gettype($effective)), __LINE__);
        }
        if (is_null($effective) || (is_array($effective) && empty($effective))) {
            unset($this->Effective);
        } else {
            $this->Effective = $effective;
        }
        return $this;
    }
    /**
     * Get EffectiveFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveFrom()
    {
        return isset($this->EffectiveFrom) ? $this->EffectiveFrom : null;
    }
    /**
     * Set EffectiveFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveFrom
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setEffectiveFrom($effectiveFrom = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveFrom) && !is_string($effectiveFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveFrom, true), gettype($effectiveFrom)), __LINE__);
        }
        if (is_null($effectiveFrom) || (is_array($effectiveFrom) && empty($effectiveFrom))) {
            unset($this->EffectiveFrom);
        } else {
            $this->EffectiveFrom = $effectiveFrom;
        }
        return $this;
    }
    /**
     * Get EffectiveUntil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveUntil()
    {
        return isset($this->EffectiveUntil) ? $this->EffectiveUntil : null;
    }
    /**
     * Set EffectiveUntil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveUntil
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setEffectiveUntil($effectiveUntil = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveUntil) && !is_string($effectiveUntil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveUntil, true), gettype($effectiveUntil)), __LINE__);
        }
        if (is_null($effectiveUntil) || (is_array($effectiveUntil) && empty($effectiveUntil))) {
            unset($this->EffectiveUntil);
        } else {
            $this->EffectiveUntil = $effectiveUntil;
        }
        return $this;
    }
    /**
     * Get Ephemeral value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEphemeral()
    {
        return isset($this->Ephemeral) ? $this->Ephemeral : null;
    }
    /**
     * Set Ephemeral value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ephemeral
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setEphemeral($ephemeral = null)
    {
        // validation for constraint: boolean
        if (!is_null($ephemeral) && !is_bool($ephemeral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ephemeral, true), gettype($ephemeral)), __LINE__);
        }
        if (is_null($ephemeral) || (is_array($ephemeral) && empty($ephemeral))) {
            unset($this->Ephemeral);
        } else {
            $this->Ephemeral = $ephemeral;
        }
        return $this;
    }
    /**
     * Get InheritedFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInheritedFrom()
    {
        return isset($this->InheritedFrom) ? $this->InheritedFrom : null;
    }
    /**
     * Set InheritedFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inheritedFrom
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setInheritedFrom($inheritedFrom = null)
    {
        // validation for constraint: string
        if (!is_null($inheritedFrom) && !is_string($inheritedFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inheritedFrom, true), gettype($inheritedFrom)), __LINE__);
        }
        if (is_null($inheritedFrom) || (is_array($inheritedFrom) && empty($inheritedFrom))) {
            unset($this->InheritedFrom);
        } else {
            $this->InheritedFrom = $inheritedFrom;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get RuleResolutionOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRuleResolutionOrder()
    {
        return isset($this->RuleResolutionOrder) ? $this->RuleResolutionOrder : null;
    }
    /**
     * Set RuleResolutionOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ruleResolutionOrder
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setRuleResolutionOrder($ruleResolutionOrder = null)
    {
        // validation for constraint: int
        if (!is_null($ruleResolutionOrder) && !(is_int($ruleResolutionOrder) || ctype_digit($ruleResolutionOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ruleResolutionOrder, true), gettype($ruleResolutionOrder)), __LINE__);
        }
        if (is_null($ruleResolutionOrder) || (is_array($ruleResolutionOrder) && empty($ruleResolutionOrder))) {
            unset($this->RuleResolutionOrder);
        } else {
            $this->RuleResolutionOrder = $ruleResolutionOrder;
        }
        return $this;
    }
    /**
     * Get RuleSetId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleSetId()
    {
        return isset($this->RuleSetId) ? $this->RuleSetId : null;
    }
    /**
     * Set RuleSetId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleSetId
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setRuleSetId($ruleSetId = null)
    {
        // validation for constraint: string
        if (!is_null($ruleSetId) && !is_string($ruleSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleSetId, true), gettype($ruleSetId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ruleSetId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ruleSetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ruleSetId, true)), __LINE__);
        }
        if (is_null($ruleSetId) || (is_array($ruleSetId) && empty($ruleSetId))) {
            unset($this->RuleSetId);
        } else {
            $this->RuleSetId = $ruleSetId;
        }
        return $this;
    }
    /**
     * Get RuleSetName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleSetName()
    {
        return isset($this->RuleSetName) ? $this->RuleSetName : null;
    }
    /**
     * Set RuleSetName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleSetName
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setRuleSetName($ruleSetName = null)
    {
        // validation for constraint: string
        if (!is_null($ruleSetName) && !is_string($ruleSetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleSetName, true), gettype($ruleSetName)), __LINE__);
        }
        if (is_null($ruleSetName) || (is_array($ruleSetName) && empty($ruleSetName))) {
            unset($this->RuleSetName);
        } else {
            $this->RuleSetName = $ruleSetName;
        }
        return $this;
    }
    /**
     * Get RuleSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRuleSystemName()
    {
        return isset($this->RuleSystemName) ? $this->RuleSystemName : null;
    }
    /**
     * Set RuleSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ruleSystemName
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setRuleSystemName($ruleSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($ruleSystemName) && !is_string($ruleSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ruleSystemName, true), gettype($ruleSystemName)), __LINE__);
        }
        if (is_null($ruleSystemName) || (is_array($ruleSystemName) && empty($ruleSystemName))) {
            unset($this->RuleSystemName);
        } else {
            $this->RuleSystemName = $ruleSystemName;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RuleStatus::valueIsValid()
     * @uses \patest\EnumType\RuleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RuleStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RuleStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\RuleStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get SummaryInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfRuleEngine_RuleSummaryInfo|null
     */
    public function getSummaryInfo()
    {
        return isset($this->SummaryInfo) ? $this->SummaryInfo : null;
    }
    /**
     * Set SummaryInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfRuleEngine_RuleSummaryInfo $summaryInfo
     * @return \patest\StructType\RuleEngine_Rule
     */
    public function setSummaryInfo(\patest\StructType\RecordSetOfRuleEngine_RuleSummaryInfo $summaryInfo = null)
    {
        if (is_null($summaryInfo) || (is_array($summaryInfo) && empty($summaryInfo))) {
            unset($this->SummaryInfo);
        } else {
            $this->SummaryInfo = $summaryInfo;
        }
        return $this;
    }
}
