<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RetrieveSalesItemsResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RetrieveSalesItemsResponse
 * @subpackage Structs
 */
class RetrieveSalesItemsResponse extends AbstractStructBase
{
    /**
     * The EffectiveLastDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveLastDateTime;
    /**
     * The EffectiveRowVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EffectiveRowVersion;
    /**
     * The IsThereMore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsThereMore;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfReporting_FactItem
     */
    public $Items;
    /**
     * The Watermark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Watermark
     */
    public $Watermark;
    /**
     * Constructor method for RetrieveSalesItemsResponse
     * @uses RetrieveSalesItemsResponse::setEffectiveLastDateTime()
     * @uses RetrieveSalesItemsResponse::setEffectiveRowVersion()
     * @uses RetrieveSalesItemsResponse::setIsThereMore()
     * @uses RetrieveSalesItemsResponse::setItems()
     * @uses RetrieveSalesItemsResponse::setWatermark()
     * @param string $effectiveLastDateTime
     * @param int $effectiveRowVersion
     * @param bool $isThereMore
     * @param \patest\ArrayType\ArrayOfReporting_FactItem $items
     * @param \patest\StructType\Watermark $watermark
     */
    public function __construct($effectiveLastDateTime = null, $effectiveRowVersion = null, $isThereMore = null, \patest\ArrayType\ArrayOfReporting_FactItem $items = null, \patest\StructType\Watermark $watermark = null)
    {
        $this
            ->setEffectiveLastDateTime($effectiveLastDateTime)
            ->setEffectiveRowVersion($effectiveRowVersion)
            ->setIsThereMore($isThereMore)
            ->setItems($items)
            ->setWatermark($watermark);
    }
    /**
     * Get EffectiveLastDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveLastDateTime()
    {
        return isset($this->EffectiveLastDateTime) ? $this->EffectiveLastDateTime : null;
    }
    /**
     * Set EffectiveLastDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveLastDateTime
     * @return \patest\StructType\RetrieveSalesItemsResponse
     */
    public function setEffectiveLastDateTime($effectiveLastDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveLastDateTime) && !is_string($effectiveLastDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveLastDateTime, true), gettype($effectiveLastDateTime)), __LINE__);
        }
        if (is_null($effectiveLastDateTime) || (is_array($effectiveLastDateTime) && empty($effectiveLastDateTime))) {
            unset($this->EffectiveLastDateTime);
        } else {
            $this->EffectiveLastDateTime = $effectiveLastDateTime;
        }
        return $this;
    }
    /**
     * Get EffectiveRowVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEffectiveRowVersion()
    {
        return isset($this->EffectiveRowVersion) ? $this->EffectiveRowVersion : null;
    }
    /**
     * Set EffectiveRowVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $effectiveRowVersion
     * @return \patest\StructType\RetrieveSalesItemsResponse
     */
    public function setEffectiveRowVersion($effectiveRowVersion = null)
    {
        // validation for constraint: int
        if (!is_null($effectiveRowVersion) && !(is_int($effectiveRowVersion) || ctype_digit($effectiveRowVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($effectiveRowVersion, true), gettype($effectiveRowVersion)), __LINE__);
        }
        if (is_null($effectiveRowVersion) || (is_array($effectiveRowVersion) && empty($effectiveRowVersion))) {
            unset($this->EffectiveRowVersion);
        } else {
            $this->EffectiveRowVersion = $effectiveRowVersion;
        }
        return $this;
    }
    /**
     * Get IsThereMore value
     * @return bool|null
     */
    public function getIsThereMore()
    {
        return $this->IsThereMore;
    }
    /**
     * Set IsThereMore value
     * @param bool $isThereMore
     * @return \patest\StructType\RetrieveSalesItemsResponse
     */
    public function setIsThereMore($isThereMore = null)
    {
        // validation for constraint: boolean
        if (!is_null($isThereMore) && !is_bool($isThereMore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isThereMore, true), gettype($isThereMore)), __LINE__);
        }
        $this->IsThereMore = $isThereMore;
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfReporting_FactItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfReporting_FactItem $items
     * @return \patest\StructType\RetrieveSalesItemsResponse
     */
    public function setItems(\patest\ArrayType\ArrayOfReporting_FactItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get Watermark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Watermark|null
     */
    public function getWatermark()
    {
        return isset($this->Watermark) ? $this->Watermark : null;
    }
    /**
     * Set Watermark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Watermark $watermark
     * @return \patest\StructType\RetrieveSalesItemsResponse
     */
    public function setWatermark(\patest\StructType\Watermark $watermark = null)
    {
        if (is_null($watermark) || (is_array($watermark) && empty($watermark))) {
            unset($this->Watermark);
        } else {
            $this->Watermark = $watermark;
        }
        return $this;
    }
}
