<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResumeHeldTransaction-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResumeHeldTransaction-Response
 * @subpackage Structs
 */
class ResumeHeldTransaction_Response extends ExtensibleDataContract
{
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * Constructor method for ResumeHeldTransaction-Response
     * @uses ResumeHeldTransaction_Response::setTransactionGuid()
     * @uses ResumeHeldTransaction_Response::setTransactionSnapshot()
     * @param string $transactionGuid
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     */
    public function __construct($transactionGuid = null, \patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        $this
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshot($transactionSnapshot);
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\ResumeHeldTransaction_Response
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\ResumeHeldTransaction_Response
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
}
