<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResourceEntry StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResourceEntry
 * @subpackage Structs
 */
class ResourceEntry extends AbstractStructBase
{
    /**
     * The Captions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Captions;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The Tooltips
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Tooltips;
    /**
     * The CustomizedCaptionCultures
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $CustomizedCaptionCultures;
    /**
     * Constructor method for ResourceEntry
     * @uses ResourceEntry::setCaptions()
     * @uses ResourceEntry::setId()
     * @uses ResourceEntry::setName()
     * @uses ResourceEntry::setNote()
     * @uses ResourceEntry::setTooltips()
     * @uses ResourceEntry::setCustomizedCaptionCultures()
     * @param \patest\StructType\GlobalString $captions
     * @param int $id
     * @param string $name
     * @param string $note
     * @param \patest\StructType\GlobalString $tooltips
     * @param \patest\ArrayType\ArrayOfint $customizedCaptionCultures
     */
    public function __construct(\patest\StructType\GlobalString $captions = null, $id = null, $name = null, $note = null, \patest\StructType\GlobalString $tooltips = null, \patest\ArrayType\ArrayOfint $customizedCaptionCultures = null)
    {
        $this
            ->setCaptions($captions)
            ->setId($id)
            ->setName($name)
            ->setNote($note)
            ->setTooltips($tooltips)
            ->setCustomizedCaptionCultures($customizedCaptionCultures);
    }
    /**
     * Get Captions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCaptions()
    {
        return isset($this->Captions) ? $this->Captions : null;
    }
    /**
     * Set Captions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $captions
     * @return \patest\StructType\ResourceEntry
     */
    public function setCaptions(\patest\StructType\GlobalString $captions = null)
    {
        if (is_null($captions) || (is_array($captions) && empty($captions))) {
            unset($this->Captions);
        } else {
            $this->Captions = $captions;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \patest\StructType\ResourceEntry
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\ResourceEntry
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\ResourceEntry
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Tooltips value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTooltips()
    {
        return isset($this->Tooltips) ? $this->Tooltips : null;
    }
    /**
     * Set Tooltips value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $tooltips
     * @return \patest\StructType\ResourceEntry
     */
    public function setTooltips(\patest\StructType\GlobalString $tooltips = null)
    {
        if (is_null($tooltips) || (is_array($tooltips) && empty($tooltips))) {
            unset($this->Tooltips);
        } else {
            $this->Tooltips = $tooltips;
        }
        return $this;
    }
    /**
     * Get CustomizedCaptionCultures value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getCustomizedCaptionCultures()
    {
        return isset($this->CustomizedCaptionCultures) ? $this->CustomizedCaptionCultures : null;
    }
    /**
     * Set CustomizedCaptionCultures value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $customizedCaptionCultures
     * @return \patest\StructType\ResourceEntry
     */
    public function setCustomizedCaptionCultures(\patest\ArrayType\ArrayOfint $customizedCaptionCultures = null)
    {
        if (is_null($customizedCaptionCultures) || (is_array($customizedCaptionCultures) && empty($customizedCaptionCultures))) {
            unset($this->CustomizedCaptionCultures);
        } else {
            $this->CustomizedCaptionCultures = $customizedCaptionCultures;
        }
        return $this;
    }
}
