<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reporting.SGAccountLinkingStatus StructType
 * @subpackage Structs
 */
class Reporting_SGAccountLinkingStatus extends AnyEntity
{
    /**
     * The LinkingStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LinkingStatus;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * Constructor method for Reporting.SGAccountLinkingStatus
     * @uses Reporting_SGAccountLinkingStatus::setLinkingStatus()
     * @uses Reporting_SGAccountLinkingStatus::setQueryId()
     * @param int $linkingStatus
     * @param string $queryId
     */
    public function __construct($linkingStatus = null, $queryId = null)
    {
        $this
            ->setLinkingStatus($linkingStatus)
            ->setQueryId($queryId);
    }
    /**
     * Get LinkingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLinkingStatus()
    {
        return isset($this->LinkingStatus) ? $this->LinkingStatus : null;
    }
    /**
     * Set LinkingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $linkingStatus
     * @return \patest\StructType\Reporting_SGAccountLinkingStatus
     */
    public function setLinkingStatus($linkingStatus = null)
    {
        // validation for constraint: int
        if (!is_null($linkingStatus) && !(is_int($linkingStatus) || ctype_digit($linkingStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkingStatus, true), gettype($linkingStatus)), __LINE__);
        }
        if (is_null($linkingStatus) || (is_array($linkingStatus) && empty($linkingStatus))) {
            unset($this->LinkingStatus);
        } else {
            $this->LinkingStatus = $linkingStatus;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\Reporting_SGAccountLinkingStatus
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
}
