<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Reporting.FactItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Reporting.FactItem
 * @subpackage Structs
 */
class Reporting_FactItem extends PersistableEntity
{
    /**
     * The ActionSign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ActionSign;
    /**
     * The ActualDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActualDate;
    /**
     * The AgencyAccountGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyAccountGuid;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The AreaGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaGuid;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AreaName;
    /**
     * The AssociatedClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AssociatedClientId;
    /**
     * The AssociatedWithBenefit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AssociatedWithBenefit;
    /**
     * The BackwardTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BackwardTransactionGuid;
    /**
     * The BasePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $BasePrice;
    /**
     * The BusinessCategory
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BusinessCategory;
    /**
     * The BusinessDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessDate;
    /**
     * The ClientCode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCode;
    /**
     * The ClientGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientGuid;
    /**
     * The ConfirmationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationDate;
    /**
     * The CouponDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponDefinitionId;
    /**
     * The CouponItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponItemId;
    /**
     * The DeliveryItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DeliveryItemId;
    /**
     * The ECardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ECardId;
    /**
     * The EMail
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EMail;
    /**
     * The EntityDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EntityDescription;
    /**
     * The EntityGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityGuid;
    /**
     * The EventCategory
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EventCategory;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraFields;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The ForwardTransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ForwardTransactionGuid;
    /**
     * The GroupOrderGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupOrderGuid;
    /**
     * The GroupOrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupOrderId;
    /**
     * The IdInBackwardTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInBackwardTransaction;
    /**
     * The IdInForwardTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInForwardTransaction;
    /**
     * The IdInTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IdInTransaction;
    /**
     * The IsAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAccount;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsExtraProduct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExtraProduct;
    /**
     * The IsFictivePayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFictivePayment;
    /**
     * The IsModifiedReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsModifiedReservation;
    /**
     * The IsReserved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReserved;
    /**
     * The IsSubsTicket
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubsTicket;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The ItemPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ItemPrice;
    /**
     * The ItemPriceAfterDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ItemPriceAfterDiscount;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The LinkingProductGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LinkingProductGuid;
    /**
     * The LinkingProductTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LinkingProductTypeId;
    /**
     * The ListPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ListPrice;
    /**
     * The MembershipEndDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipEndDate;
    /**
     * The MembershipStartDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipStartDate;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MiddleName;
    /**
     * The OnBehalfOfAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OnBehalfOfAccountId;
    /**
     * The OriginalId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalId;
    /**
     * The OriginalPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalPriceTypeId;
    /**
     * The OriginalServiceSpecificId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalServiceSpecificId;
    /**
     * The PartOfPromptGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PartOfPromptGuid;
    /**
     * The PaymentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentId;
    /**
     * The PaymentMethod
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethod;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PaymentSubType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentSubType;
    /**
     * The PriceEffectivenessEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PriceEffectivenessEnum;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfReporting_SimplifiedFactPriceModifier
     */
    public $PriceModifiers;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceTypeName;
    /**
     * The PricingVariationId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PricingVariationId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The ProductInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProductInstanceId;
    /**
     * The RecoAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RecoAccountId;
    /**
     * The RelatedItemGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedItemGuid;
    /**
     * The RelationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationName;
    /**
     * The RelCommision
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RelCommision;
    /**
     * The RenewOfSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewOfSubscriptionInstanceId;
    /**
     * The RepriceDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RepriceDate;
    /**
     * The RequestedActionEnum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RequestedActionEnum;
    /**
     * The ReservationExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDate;
    /**
     * The RetailerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetailerCompanyId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The RowVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowVersion;
    /**
     * The SaleModeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleModeId;
    /**
     * The SalePointGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointGuid;
    /**
     * The SalePointGuidName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalePointGuidName;
    /**
     * The SalesRepCustomerId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepCustomerId;
    /**
     * The SalesRepresentativeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepresentativeId;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorName;
    /**
     * The SellerBranchGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerBranchGuid;
    /**
     * The ShiftGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShiftGuid;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubsidizedByAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizedByAccountId;
    /**
     * The SupplierBranchGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierBranchGuid;
    /**
     * The SupplierGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierGuid;
    /**
     * The TickSeries
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TickSeries;
    /**
     * The TillGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillGuid;
    /**
     * The TotalCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCommission;
    /**
     * The TotalCommissionIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCommissionIncluded;
    /**
     * The TotalDiscount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalDiscount;
    /**
     * The TotalExtraCharge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalExtraCharge;
    /**
     * The TotalTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTax;
    /**
     * The TotalTaxIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTaxIncluded;
    /**
     * The TotalVat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalVat;
    /**
     * The TotalVatIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalVatIncluded;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionLocalId;
    /**
     * The TransactionNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionNote;
    /**
     * The TransactIssuerCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactIssuerCompanyId;
    /**
     * The TransactNum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactNum;
    /**
     * The TypeDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeDescription;
    /**
     * The TypeNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TypeNumber;
    /**
     * The UserGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserGuid;
    /**
     * The UserOfAffiliateAccountGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserOfAffiliateAccountGuid;
    /**
     * Constructor method for Reporting.FactItem
     * @uses Reporting_FactItem::setActionSign()
     * @uses Reporting_FactItem::setActualDate()
     * @uses Reporting_FactItem::setAgencyAccountGuid()
     * @uses Reporting_FactItem::setApplicationChannel()
     * @uses Reporting_FactItem::setAreaGuid()
     * @uses Reporting_FactItem::setAreaName()
     * @uses Reporting_FactItem::setAssociatedClientId()
     * @uses Reporting_FactItem::setAssociatedWithBenefit()
     * @uses Reporting_FactItem::setBackwardTransactionGuid()
     * @uses Reporting_FactItem::setBasePrice()
     * @uses Reporting_FactItem::setBusinessCategory()
     * @uses Reporting_FactItem::setBusinessDate()
     * @uses Reporting_FactItem::setClientCode()
     * @uses Reporting_FactItem::setClientGuid()
     * @uses Reporting_FactItem::setConfirmationDate()
     * @uses Reporting_FactItem::setCouponDefinitionId()
     * @uses Reporting_FactItem::setCouponItemId()
     * @uses Reporting_FactItem::setDeliveryItemId()
     * @uses Reporting_FactItem::setECardId()
     * @uses Reporting_FactItem::setEMail()
     * @uses Reporting_FactItem::setEntityDescription()
     * @uses Reporting_FactItem::setEntityGuid()
     * @uses Reporting_FactItem::setEventCategory()
     * @uses Reporting_FactItem::setEventDate()
     * @uses Reporting_FactItem::setEventGuid()
     * @uses Reporting_FactItem::setExternalId()
     * @uses Reporting_FactItem::setExtraFields()
     * @uses Reporting_FactItem::setFirstName()
     * @uses Reporting_FactItem::setForwardTransactionGuid()
     * @uses Reporting_FactItem::setGroupOrderGuid()
     * @uses Reporting_FactItem::setGroupOrderId()
     * @uses Reporting_FactItem::setIdInBackwardTransaction()
     * @uses Reporting_FactItem::setIdInForwardTransaction()
     * @uses Reporting_FactItem::setIdInTransaction()
     * @uses Reporting_FactItem::setIsAccount()
     * @uses Reporting_FactItem::setIsComplimentary()
     * @uses Reporting_FactItem::setIsExtraProduct()
     * @uses Reporting_FactItem::setIsFictivePayment()
     * @uses Reporting_FactItem::setIsModifiedReservation()
     * @uses Reporting_FactItem::setIsReserved()
     * @uses Reporting_FactItem::setIsSubsTicket()
     * @uses Reporting_FactItem::setIsValid()
     * @uses Reporting_FactItem::setItemPrice()
     * @uses Reporting_FactItem::setItemPriceAfterDiscount()
     * @uses Reporting_FactItem::setLastName()
     * @uses Reporting_FactItem::setLinkingProductGuid()
     * @uses Reporting_FactItem::setLinkingProductTypeId()
     * @uses Reporting_FactItem::setListPrice()
     * @uses Reporting_FactItem::setMembershipEndDate()
     * @uses Reporting_FactItem::setMembershipStartDate()
     * @uses Reporting_FactItem::setMiddleName()
     * @uses Reporting_FactItem::setOnBehalfOfAccountId()
     * @uses Reporting_FactItem::setOriginalId()
     * @uses Reporting_FactItem::setOriginalPriceTypeId()
     * @uses Reporting_FactItem::setOriginalServiceSpecificId()
     * @uses Reporting_FactItem::setPartOfPromptGuid()
     * @uses Reporting_FactItem::setPaymentId()
     * @uses Reporting_FactItem::setPaymentMethod()
     * @uses Reporting_FactItem::setPaymentMethodName()
     * @uses Reporting_FactItem::setPaymentSubType()
     * @uses Reporting_FactItem::setPriceEffectivenessEnum()
     * @uses Reporting_FactItem::setPriceLevelId()
     * @uses Reporting_FactItem::setPriceModifiers()
     * @uses Reporting_FactItem::setPriceTypeId()
     * @uses Reporting_FactItem::setPriceTypeName()
     * @uses Reporting_FactItem::setPricingVariationId()
     * @uses Reporting_FactItem::setPrintCount()
     * @uses Reporting_FactItem::setProductInstanceId()
     * @uses Reporting_FactItem::setRecoAccountId()
     * @uses Reporting_FactItem::setRelatedItemGuid()
     * @uses Reporting_FactItem::setRelationName()
     * @uses Reporting_FactItem::setRelCommision()
     * @uses Reporting_FactItem::setRenewOfSubscriptionInstanceId()
     * @uses Reporting_FactItem::setRepriceDate()
     * @uses Reporting_FactItem::setRequestedActionEnum()
     * @uses Reporting_FactItem::setReservationExpiryDate()
     * @uses Reporting_FactItem::setRetailerCompanyId()
     * @uses Reporting_FactItem::setRowName()
     * @uses Reporting_FactItem::setRowVersion()
     * @uses Reporting_FactItem::setSaleModeId()
     * @uses Reporting_FactItem::setSalePointGuid()
     * @uses Reporting_FactItem::setSalePointGuidName()
     * @uses Reporting_FactItem::setSalesRepCustomerId()
     * @uses Reporting_FactItem::setSalesRepresentativeId()
     * @uses Reporting_FactItem::setSeatIdInAreaMap()
     * @uses Reporting_FactItem::setSeatName()
     * @uses Reporting_FactItem::setSectorName()
     * @uses Reporting_FactItem::setSellerBranchGuid()
     * @uses Reporting_FactItem::setShiftGuid()
     * @uses Reporting_FactItem::setSubscriptionInstanceId()
     * @uses Reporting_FactItem::setSubsidizedByAccountId()
     * @uses Reporting_FactItem::setSupplierBranchGuid()
     * @uses Reporting_FactItem::setSupplierGuid()
     * @uses Reporting_FactItem::setTickSeries()
     * @uses Reporting_FactItem::setTillGuid()
     * @uses Reporting_FactItem::setTotalCommission()
     * @uses Reporting_FactItem::setTotalCommissionIncluded()
     * @uses Reporting_FactItem::setTotalDiscount()
     * @uses Reporting_FactItem::setTotalExtraCharge()
     * @uses Reporting_FactItem::setTotalTax()
     * @uses Reporting_FactItem::setTotalTaxIncluded()
     * @uses Reporting_FactItem::setTotalVat()
     * @uses Reporting_FactItem::setTotalVatIncluded()
     * @uses Reporting_FactItem::setTransactionGuid()
     * @uses Reporting_FactItem::setTransactionLocalId()
     * @uses Reporting_FactItem::setTransactionNote()
     * @uses Reporting_FactItem::setTransactIssuerCompanyId()
     * @uses Reporting_FactItem::setTransactNum()
     * @uses Reporting_FactItem::setTypeDescription()
     * @uses Reporting_FactItem::setTypeNumber()
     * @uses Reporting_FactItem::setUserGuid()
     * @uses Reporting_FactItem::setUserOfAffiliateAccountGuid()
     * @param int $actionSign
     * @param string $actualDate
     * @param string $agencyAccountGuid
     * @param string $applicationChannel
     * @param string $areaGuid
     * @param \patest\StructType\GlobalString $areaName
     * @param string $associatedClientId
     * @param bool $associatedWithBenefit
     * @param string $backwardTransactionGuid
     * @param \patest\StructType\Money $basePrice
     * @param string $businessCategory
     * @param string $businessDate
     * @param string $clientCode
     * @param string $clientGuid
     * @param string $confirmationDate
     * @param string $couponDefinitionId
     * @param string $couponItemId
     * @param string $deliveryItemId
     * @param string $eCardId
     * @param string $eMail
     * @param \patest\StructType\GlobalString $entityDescription
     * @param string $entityGuid
     * @param \patest\StructType\GlobalString $eventCategory
     * @param string $eventDate
     * @param string $eventGuid
     * @param string $externalId
     * @param string $extraFields
     * @param string $firstName
     * @param string $forwardTransactionGuid
     * @param string $groupOrderGuid
     * @param int $groupOrderId
     * @param int $idInBackwardTransaction
     * @param int $idInForwardTransaction
     * @param int $idInTransaction
     * @param bool $isAccount
     * @param bool $isComplimentary
     * @param bool $isExtraProduct
     * @param bool $isFictivePayment
     * @param bool $isModifiedReservation
     * @param bool $isReserved
     * @param bool $isSubsTicket
     * @param bool $isValid
     * @param \patest\StructType\Money $itemPrice
     * @param \patest\StructType\Money $itemPriceAfterDiscount
     * @param string $lastName
     * @param string $linkingProductGuid
     * @param int $linkingProductTypeId
     * @param \patest\StructType\Money $listPrice
     * @param string $membershipEndDate
     * @param string $membershipStartDate
     * @param string $middleName
     * @param string $onBehalfOfAccountId
     * @param string $originalId
     * @param string $originalPriceTypeId
     * @param string $originalServiceSpecificId
     * @param string $partOfPromptGuid
     * @param string $paymentId
     * @param string $paymentMethod
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param string $paymentSubType
     * @param int $priceEffectivenessEnum
     * @param string $priceLevelId
     * @param \patest\StructType\RecordSetOfReporting_SimplifiedFactPriceModifier $priceModifiers
     * @param string $priceTypeId
     * @param \patest\StructType\GlobalString $priceTypeName
     * @param int $pricingVariationId
     * @param int $printCount
     * @param string $productInstanceId
     * @param string $recoAccountId
     * @param string $relatedItemGuid
     * @param string $relationName
     * @param \patest\StructType\Money $relCommision
     * @param string $renewOfSubscriptionInstanceId
     * @param string $repriceDate
     * @param int $requestedActionEnum
     * @param string $reservationExpiryDate
     * @param int $retailerCompanyId
     * @param string $rowName
     * @param int $rowVersion
     * @param string $saleModeId
     * @param string $salePointGuid
     * @param \patest\StructType\GlobalString $salePointGuidName
     * @param string $salesRepCustomerId
     * @param string $salesRepresentativeId
     * @param int $seatIdInAreaMap
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorName
     * @param string $sellerBranchGuid
     * @param string $shiftGuid
     * @param string $subscriptionInstanceId
     * @param string $subsidizedByAccountId
     * @param string $supplierBranchGuid
     * @param string $supplierGuid
     * @param string $tickSeries
     * @param string $tillGuid
     * @param \patest\StructType\Money $totalCommission
     * @param \patest\StructType\Money $totalCommissionIncluded
     * @param \patest\StructType\Money $totalDiscount
     * @param \patest\StructType\Money $totalExtraCharge
     * @param \patest\StructType\Money $totalTax
     * @param \patest\StructType\Money $totalTaxIncluded
     * @param \patest\StructType\Money $totalVat
     * @param \patest\StructType\Money $totalVatIncluded
     * @param string $transactionGuid
     * @param int $transactionLocalId
     * @param string $transactionNote
     * @param int $transactIssuerCompanyId
     * @param int $transactNum
     * @param string $typeDescription
     * @param int $typeNumber
     * @param string $userGuid
     * @param string $userOfAffiliateAccountGuid
     */
    public function __construct($actionSign = null, $actualDate = null, $agencyAccountGuid = null, $applicationChannel = null, $areaGuid = null, \patest\StructType\GlobalString $areaName = null, $associatedClientId = null, $associatedWithBenefit = null, $backwardTransactionGuid = null, \patest\StructType\Money $basePrice = null, $businessCategory = null, $businessDate = null, $clientCode = null, $clientGuid = null, $confirmationDate = null, $couponDefinitionId = null, $couponItemId = null, $deliveryItemId = null, $eCardId = null, $eMail = null, \patest\StructType\GlobalString $entityDescription = null, $entityGuid = null, \patest\StructType\GlobalString $eventCategory = null, $eventDate = null, $eventGuid = null, $externalId = null, $extraFields = null, $firstName = null, $forwardTransactionGuid = null, $groupOrderGuid = null, $groupOrderId = null, $idInBackwardTransaction = null, $idInForwardTransaction = null, $idInTransaction = null, $isAccount = null, $isComplimentary = null, $isExtraProduct = null, $isFictivePayment = null, $isModifiedReservation = null, $isReserved = null, $isSubsTicket = null, $isValid = null, \patest\StructType\Money $itemPrice = null, \patest\StructType\Money $itemPriceAfterDiscount = null, $lastName = null, $linkingProductGuid = null, $linkingProductTypeId = null, \patest\StructType\Money $listPrice = null, $membershipEndDate = null, $membershipStartDate = null, $middleName = null, $onBehalfOfAccountId = null, $originalId = null, $originalPriceTypeId = null, $originalServiceSpecificId = null, $partOfPromptGuid = null, $paymentId = null, $paymentMethod = null, \patest\StructType\GlobalString $paymentMethodName = null, $paymentSubType = null, $priceEffectivenessEnum = null, $priceLevelId = null, \patest\StructType\RecordSetOfReporting_SimplifiedFactPriceModifier $priceModifiers = null, $priceTypeId = null, \patest\StructType\GlobalString $priceTypeName = null, $pricingVariationId = null, $printCount = null, $productInstanceId = null, $recoAccountId = null, $relatedItemGuid = null, $relationName = null, \patest\StructType\Money $relCommision = null, $renewOfSubscriptionInstanceId = null, $repriceDate = null, $requestedActionEnum = null, $reservationExpiryDate = null, $retailerCompanyId = null, $rowName = null, $rowVersion = null, $saleModeId = null, $salePointGuid = null, \patest\StructType\GlobalString $salePointGuidName = null, $salesRepCustomerId = null, $salesRepresentativeId = null, $seatIdInAreaMap = null, $seatName = null, \patest\StructType\GlobalString $sectorName = null, $sellerBranchGuid = null, $shiftGuid = null, $subscriptionInstanceId = null, $subsidizedByAccountId = null, $supplierBranchGuid = null, $supplierGuid = null, $tickSeries = null, $tillGuid = null, \patest\StructType\Money $totalCommission = null, \patest\StructType\Money $totalCommissionIncluded = null, \patest\StructType\Money $totalDiscount = null, \patest\StructType\Money $totalExtraCharge = null, \patest\StructType\Money $totalTax = null, \patest\StructType\Money $totalTaxIncluded = null, \patest\StructType\Money $totalVat = null, \patest\StructType\Money $totalVatIncluded = null, $transactionGuid = null, $transactionLocalId = null, $transactionNote = null, $transactIssuerCompanyId = null, $transactNum = null, $typeDescription = null, $typeNumber = null, $userGuid = null, $userOfAffiliateAccountGuid = null)
    {
        $this
            ->setActionSign($actionSign)
            ->setActualDate($actualDate)
            ->setAgencyAccountGuid($agencyAccountGuid)
            ->setApplicationChannel($applicationChannel)
            ->setAreaGuid($areaGuid)
            ->setAreaName($areaName)
            ->setAssociatedClientId($associatedClientId)
            ->setAssociatedWithBenefit($associatedWithBenefit)
            ->setBackwardTransactionGuid($backwardTransactionGuid)
            ->setBasePrice($basePrice)
            ->setBusinessCategory($businessCategory)
            ->setBusinessDate($businessDate)
            ->setClientCode($clientCode)
            ->setClientGuid($clientGuid)
            ->setConfirmationDate($confirmationDate)
            ->setCouponDefinitionId($couponDefinitionId)
            ->setCouponItemId($couponItemId)
            ->setDeliveryItemId($deliveryItemId)
            ->setECardId($eCardId)
            ->setEMail($eMail)
            ->setEntityDescription($entityDescription)
            ->setEntityGuid($entityGuid)
            ->setEventCategory($eventCategory)
            ->setEventDate($eventDate)
            ->setEventGuid($eventGuid)
            ->setExternalId($externalId)
            ->setExtraFields($extraFields)
            ->setFirstName($firstName)
            ->setForwardTransactionGuid($forwardTransactionGuid)
            ->setGroupOrderGuid($groupOrderGuid)
            ->setGroupOrderId($groupOrderId)
            ->setIdInBackwardTransaction($idInBackwardTransaction)
            ->setIdInForwardTransaction($idInForwardTransaction)
            ->setIdInTransaction($idInTransaction)
            ->setIsAccount($isAccount)
            ->setIsComplimentary($isComplimentary)
            ->setIsExtraProduct($isExtraProduct)
            ->setIsFictivePayment($isFictivePayment)
            ->setIsModifiedReservation($isModifiedReservation)
            ->setIsReserved($isReserved)
            ->setIsSubsTicket($isSubsTicket)
            ->setIsValid($isValid)
            ->setItemPrice($itemPrice)
            ->setItemPriceAfterDiscount($itemPriceAfterDiscount)
            ->setLastName($lastName)
            ->setLinkingProductGuid($linkingProductGuid)
            ->setLinkingProductTypeId($linkingProductTypeId)
            ->setListPrice($listPrice)
            ->setMembershipEndDate($membershipEndDate)
            ->setMembershipStartDate($membershipStartDate)
            ->setMiddleName($middleName)
            ->setOnBehalfOfAccountId($onBehalfOfAccountId)
            ->setOriginalId($originalId)
            ->setOriginalPriceTypeId($originalPriceTypeId)
            ->setOriginalServiceSpecificId($originalServiceSpecificId)
            ->setPartOfPromptGuid($partOfPromptGuid)
            ->setPaymentId($paymentId)
            ->setPaymentMethod($paymentMethod)
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentSubType($paymentSubType)
            ->setPriceEffectivenessEnum($priceEffectivenessEnum)
            ->setPriceLevelId($priceLevelId)
            ->setPriceModifiers($priceModifiers)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setPricingVariationId($pricingVariationId)
            ->setPrintCount($printCount)
            ->setProductInstanceId($productInstanceId)
            ->setRecoAccountId($recoAccountId)
            ->setRelatedItemGuid($relatedItemGuid)
            ->setRelationName($relationName)
            ->setRelCommision($relCommision)
            ->setRenewOfSubscriptionInstanceId($renewOfSubscriptionInstanceId)
            ->setRepriceDate($repriceDate)
            ->setRequestedActionEnum($requestedActionEnum)
            ->setReservationExpiryDate($reservationExpiryDate)
            ->setRetailerCompanyId($retailerCompanyId)
            ->setRowName($rowName)
            ->setRowVersion($rowVersion)
            ->setSaleModeId($saleModeId)
            ->setSalePointGuid($salePointGuid)
            ->setSalePointGuidName($salePointGuidName)
            ->setSalesRepCustomerId($salesRepCustomerId)
            ->setSalesRepresentativeId($salesRepresentativeId)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setSellerBranchGuid($sellerBranchGuid)
            ->setShiftGuid($shiftGuid)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubsidizedByAccountId($subsidizedByAccountId)
            ->setSupplierBranchGuid($supplierBranchGuid)
            ->setSupplierGuid($supplierGuid)
            ->setTickSeries($tickSeries)
            ->setTillGuid($tillGuid)
            ->setTotalCommission($totalCommission)
            ->setTotalCommissionIncluded($totalCommissionIncluded)
            ->setTotalDiscount($totalDiscount)
            ->setTotalExtraCharge($totalExtraCharge)
            ->setTotalTax($totalTax)
            ->setTotalTaxIncluded($totalTaxIncluded)
            ->setTotalVat($totalVat)
            ->setTotalVatIncluded($totalVatIncluded)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionLocalId($transactionLocalId)
            ->setTransactionNote($transactionNote)
            ->setTransactIssuerCompanyId($transactIssuerCompanyId)
            ->setTransactNum($transactNum)
            ->setTypeDescription($typeDescription)
            ->setTypeNumber($typeNumber)
            ->setUserGuid($userGuid)
            ->setUserOfAffiliateAccountGuid($userOfAffiliateAccountGuid);
    }
    /**
     * Get ActionSign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getActionSign()
    {
        return isset($this->ActionSign) ? $this->ActionSign : null;
    }
    /**
     * Set ActionSign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $actionSign
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setActionSign($actionSign = null)
    {
        // validation for constraint: int
        if (!is_null($actionSign) && !(is_int($actionSign) || ctype_digit($actionSign))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actionSign, true), gettype($actionSign)), __LINE__);
        }
        if (is_null($actionSign) || (is_array($actionSign) && empty($actionSign))) {
            unset($this->ActionSign);
        } else {
            $this->ActionSign = $actionSign;
        }
        return $this;
    }
    /**
     * Get ActualDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActualDate()
    {
        return isset($this->ActualDate) ? $this->ActualDate : null;
    }
    /**
     * Set ActualDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actualDate
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setActualDate($actualDate = null)
    {
        // validation for constraint: string
        if (!is_null($actualDate) && !is_string($actualDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualDate, true), gettype($actualDate)), __LINE__);
        }
        if (is_null($actualDate) || (is_array($actualDate) && empty($actualDate))) {
            unset($this->ActualDate);
        } else {
            $this->ActualDate = $actualDate;
        }
        return $this;
    }
    /**
     * Get AgencyAccountGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyAccountGuid()
    {
        return isset($this->AgencyAccountGuid) ? $this->AgencyAccountGuid : null;
    }
    /**
     * Set AgencyAccountGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyAccountGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setAgencyAccountGuid($agencyAccountGuid = null)
    {
        // validation for constraint: string
        if (!is_null($agencyAccountGuid) && !is_string($agencyAccountGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyAccountGuid, true), gettype($agencyAccountGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyAccountGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyAccountGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyAccountGuid, true)), __LINE__);
        }
        if (is_null($agencyAccountGuid) || (is_array($agencyAccountGuid) && empty($agencyAccountGuid))) {
            unset($this->AgencyAccountGuid);
        } else {
            $this->AgencyAccountGuid = $agencyAccountGuid;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get AreaGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaGuid()
    {
        return isset($this->AreaGuid) ? $this->AreaGuid : null;
    }
    /**
     * Set AreaGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setAreaGuid($areaGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaGuid) && !is_string($areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaGuid, true), gettype($areaGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaGuid, true)), __LINE__);
        }
        if (is_null($areaGuid) || (is_array($areaGuid) && empty($areaGuid))) {
            unset($this->AreaGuid);
        } else {
            $this->AreaGuid = $areaGuid;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $areaName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setAreaName(\patest\StructType\GlobalString $areaName = null)
    {
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get AssociatedClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociatedClientId()
    {
        return isset($this->AssociatedClientId) ? $this->AssociatedClientId : null;
    }
    /**
     * Set AssociatedClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associatedClientId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setAssociatedClientId($associatedClientId = null)
    {
        // validation for constraint: string
        if (!is_null($associatedClientId) && !is_string($associatedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associatedClientId, true), gettype($associatedClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($associatedClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $associatedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($associatedClientId, true)), __LINE__);
        }
        if (is_null($associatedClientId) || (is_array($associatedClientId) && empty($associatedClientId))) {
            unset($this->AssociatedClientId);
        } else {
            $this->AssociatedClientId = $associatedClientId;
        }
        return $this;
    }
    /**
     * Get AssociatedWithBenefit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAssociatedWithBenefit()
    {
        return isset($this->AssociatedWithBenefit) ? $this->AssociatedWithBenefit : null;
    }
    /**
     * Set AssociatedWithBenefit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $associatedWithBenefit
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setAssociatedWithBenefit($associatedWithBenefit = null)
    {
        // validation for constraint: boolean
        if (!is_null($associatedWithBenefit) && !is_bool($associatedWithBenefit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($associatedWithBenefit, true), gettype($associatedWithBenefit)), __LINE__);
        }
        if (is_null($associatedWithBenefit) || (is_array($associatedWithBenefit) && empty($associatedWithBenefit))) {
            unset($this->AssociatedWithBenefit);
        } else {
            $this->AssociatedWithBenefit = $associatedWithBenefit;
        }
        return $this;
    }
    /**
     * Get BackwardTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBackwardTransactionGuid()
    {
        return isset($this->BackwardTransactionGuid) ? $this->BackwardTransactionGuid : null;
    }
    /**
     * Set BackwardTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $backwardTransactionGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setBackwardTransactionGuid($backwardTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($backwardTransactionGuid) && !is_string($backwardTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($backwardTransactionGuid, true), gettype($backwardTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($backwardTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $backwardTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($backwardTransactionGuid, true)), __LINE__);
        }
        if (is_null($backwardTransactionGuid) || (is_array($backwardTransactionGuid) && empty($backwardTransactionGuid))) {
            unset($this->BackwardTransactionGuid);
        } else {
            $this->BackwardTransactionGuid = $backwardTransactionGuid;
        }
        return $this;
    }
    /**
     * Get BasePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getBasePrice()
    {
        return isset($this->BasePrice) ? $this->BasePrice : null;
    }
    /**
     * Set BasePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $basePrice
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setBasePrice(\patest\StructType\Money $basePrice = null)
    {
        if (is_null($basePrice) || (is_array($basePrice) && empty($basePrice))) {
            unset($this->BasePrice);
        } else {
            $this->BasePrice = $basePrice;
        }
        return $this;
    }
    /**
     * Get BusinessCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessCategory()
    {
        return isset($this->BusinessCategory) ? $this->BusinessCategory : null;
    }
    /**
     * Set BusinessCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessCategory
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setBusinessCategory($businessCategory = null)
    {
        // validation for constraint: string
        if (!is_null($businessCategory) && !is_string($businessCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessCategory, true), gettype($businessCategory)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($businessCategory) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $businessCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($businessCategory, true)), __LINE__);
        }
        if (is_null($businessCategory) || (is_array($businessCategory) && empty($businessCategory))) {
            unset($this->BusinessCategory);
        } else {
            $this->BusinessCategory = $businessCategory;
        }
        return $this;
    }
    /**
     * Get BusinessDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessDate()
    {
        return isset($this->BusinessDate) ? $this->BusinessDate : null;
    }
    /**
     * Set BusinessDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessDate
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setBusinessDate($businessDate = null)
    {
        // validation for constraint: string
        if (!is_null($businessDate) && !is_string($businessDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessDate, true), gettype($businessDate)), __LINE__);
        }
        if (is_null($businessDate) || (is_array($businessDate) && empty($businessDate))) {
            unset($this->BusinessDate);
        } else {
            $this->BusinessDate = $businessDate;
        }
        return $this;
    }
    /**
     * Get ClientCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCode()
    {
        return isset($this->ClientCode) ? $this->ClientCode : null;
    }
    /**
     * Set ClientCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCode
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setClientCode($clientCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCode) && !is_string($clientCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCode, true), gettype($clientCode)), __LINE__);
        }
        if (is_null($clientCode) || (is_array($clientCode) && empty($clientCode))) {
            unset($this->ClientCode);
        } else {
            $this->ClientCode = $clientCode;
        }
        return $this;
    }
    /**
     * Get ClientGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientGuid()
    {
        return isset($this->ClientGuid) ? $this->ClientGuid : null;
    }
    /**
     * Set ClientGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setClientGuid($clientGuid = null)
    {
        // validation for constraint: string
        if (!is_null($clientGuid) && !is_string($clientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientGuid, true), gettype($clientGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientGuid, true)), __LINE__);
        }
        if (is_null($clientGuid) || (is_array($clientGuid) && empty($clientGuid))) {
            unset($this->ClientGuid);
        } else {
            $this->ClientGuid = $clientGuid;
        }
        return $this;
    }
    /**
     * Get ConfirmationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationDate()
    {
        return isset($this->ConfirmationDate) ? $this->ConfirmationDate : null;
    }
    /**
     * Set ConfirmationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationDate
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setConfirmationDate($confirmationDate = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationDate) && !is_string($confirmationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationDate, true), gettype($confirmationDate)), __LINE__);
        }
        if (is_null($confirmationDate) || (is_array($confirmationDate) && empty($confirmationDate))) {
            unset($this->ConfirmationDate);
        } else {
            $this->ConfirmationDate = $confirmationDate;
        }
        return $this;
    }
    /**
     * Get CouponDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponDefinitionId()
    {
        return isset($this->CouponDefinitionId) ? $this->CouponDefinitionId : null;
    }
    /**
     * Set CouponDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponDefinitionId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setCouponDefinitionId($couponDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($couponDefinitionId) && !is_string($couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponDefinitionId, true), gettype($couponDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponDefinitionId, true)), __LINE__);
        }
        if (is_null($couponDefinitionId) || (is_array($couponDefinitionId) && empty($couponDefinitionId))) {
            unset($this->CouponDefinitionId);
        } else {
            $this->CouponDefinitionId = $couponDefinitionId;
        }
        return $this;
    }
    /**
     * Get CouponItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponItemId()
    {
        return isset($this->CouponItemId) ? $this->CouponItemId : null;
    }
    /**
     * Set CouponItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponItemId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setCouponItemId($couponItemId = null)
    {
        // validation for constraint: string
        if (!is_null($couponItemId) && !is_string($couponItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponItemId, true), gettype($couponItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponItemId, true)), __LINE__);
        }
        if (is_null($couponItemId) || (is_array($couponItemId) && empty($couponItemId))) {
            unset($this->CouponItemId);
        } else {
            $this->CouponItemId = $couponItemId;
        }
        return $this;
    }
    /**
     * Get DeliveryItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveryItemId()
    {
        return isset($this->DeliveryItemId) ? $this->DeliveryItemId : null;
    }
    /**
     * Set DeliveryItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveryItemId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setDeliveryItemId($deliveryItemId = null)
    {
        // validation for constraint: string
        if (!is_null($deliveryItemId) && !is_string($deliveryItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveryItemId, true), gettype($deliveryItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($deliveryItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $deliveryItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($deliveryItemId, true)), __LINE__);
        }
        if (is_null($deliveryItemId) || (is_array($deliveryItemId) && empty($deliveryItemId))) {
            unset($this->DeliveryItemId);
        } else {
            $this->DeliveryItemId = $deliveryItemId;
        }
        return $this;
    }
    /**
     * Get ECardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getECardId()
    {
        return isset($this->ECardId) ? $this->ECardId : null;
    }
    /**
     * Set ECardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eCardId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setECardId($eCardId = null)
    {
        // validation for constraint: string
        if (!is_null($eCardId) && !is_string($eCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eCardId, true), gettype($eCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eCardId, true)), __LINE__);
        }
        if (is_null($eCardId) || (is_array($eCardId) && empty($eCardId))) {
            unset($this->ECardId);
        } else {
            $this->ECardId = $eCardId;
        }
        return $this;
    }
    /**
     * Get EMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEMail()
    {
        return isset($this->EMail) ? $this->EMail : null;
    }
    /**
     * Set EMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eMail
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setEMail($eMail = null)
    {
        // validation for constraint: string
        if (!is_null($eMail) && !is_string($eMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eMail, true), gettype($eMail)), __LINE__);
        }
        if (is_null($eMail) || (is_array($eMail) && empty($eMail))) {
            unset($this->EMail);
        } else {
            $this->EMail = $eMail;
        }
        return $this;
    }
    /**
     * Get EntityDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEntityDescription()
    {
        return isset($this->EntityDescription) ? $this->EntityDescription : null;
    }
    /**
     * Set EntityDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $entityDescription
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setEntityDescription(\patest\StructType\GlobalString $entityDescription = null)
    {
        if (is_null($entityDescription) || (is_array($entityDescription) && empty($entityDescription))) {
            unset($this->EntityDescription);
        } else {
            $this->EntityDescription = $entityDescription;
        }
        return $this;
    }
    /**
     * Get EntityGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityGuid()
    {
        return isset($this->EntityGuid) ? $this->EntityGuid : null;
    }
    /**
     * Set EntityGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setEntityGuid($entityGuid = null)
    {
        // validation for constraint: string
        if (!is_null($entityGuid) && !is_string($entityGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityGuid, true), gettype($entityGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityGuid, true)), __LINE__);
        }
        if (is_null($entityGuid) || (is_array($entityGuid) && empty($entityGuid))) {
            unset($this->EntityGuid);
        } else {
            $this->EntityGuid = $entityGuid;
        }
        return $this;
    }
    /**
     * Get EventCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEventCategory()
    {
        return isset($this->EventCategory) ? $this->EventCategory : null;
    }
    /**
     * Set EventCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $eventCategory
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setEventCategory(\patest\StructType\GlobalString $eventCategory = null)
    {
        if (is_null($eventCategory) || (is_array($eventCategory) && empty($eventCategory))) {
            unset($this->EventCategory);
        } else {
            $this->EventCategory = $eventCategory;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventGuid()
    {
        return isset($this->EventGuid) ? $this->EventGuid : null;
    }
    /**
     * Set EventGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        if (is_null($eventGuid) || (is_array($eventGuid) && empty($eventGuid))) {
            unset($this->EventGuid);
        } else {
            $this->EventGuid = $eventGuid;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraFields
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setExtraFields($extraFields = null)
    {
        // validation for constraint: string
        if (!is_null($extraFields) && !is_string($extraFields)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraFields, true), gettype($extraFields)), __LINE__);
        }
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get ForwardTransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForwardTransactionGuid()
    {
        return isset($this->ForwardTransactionGuid) ? $this->ForwardTransactionGuid : null;
    }
    /**
     * Set ForwardTransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forwardTransactionGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setForwardTransactionGuid($forwardTransactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($forwardTransactionGuid) && !is_string($forwardTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forwardTransactionGuid, true), gettype($forwardTransactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($forwardTransactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $forwardTransactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($forwardTransactionGuid, true)), __LINE__);
        }
        if (is_null($forwardTransactionGuid) || (is_array($forwardTransactionGuid) && empty($forwardTransactionGuid))) {
            unset($this->ForwardTransactionGuid);
        } else {
            $this->ForwardTransactionGuid = $forwardTransactionGuid;
        }
        return $this;
    }
    /**
     * Get GroupOrderGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupOrderGuid()
    {
        return isset($this->GroupOrderGuid) ? $this->GroupOrderGuid : null;
    }
    /**
     * Set GroupOrderGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupOrderGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setGroupOrderGuid($groupOrderGuid = null)
    {
        // validation for constraint: string
        if (!is_null($groupOrderGuid) && !is_string($groupOrderGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupOrderGuid, true), gettype($groupOrderGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupOrderGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupOrderGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupOrderGuid, true)), __LINE__);
        }
        if (is_null($groupOrderGuid) || (is_array($groupOrderGuid) && empty($groupOrderGuid))) {
            unset($this->GroupOrderGuid);
        } else {
            $this->GroupOrderGuid = $groupOrderGuid;
        }
        return $this;
    }
    /**
     * Get GroupOrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupOrderId()
    {
        return isset($this->GroupOrderId) ? $this->GroupOrderId : null;
    }
    /**
     * Set GroupOrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupOrderId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setGroupOrderId($groupOrderId = null)
    {
        // validation for constraint: int
        if (!is_null($groupOrderId) && !(is_int($groupOrderId) || ctype_digit($groupOrderId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupOrderId, true), gettype($groupOrderId)), __LINE__);
        }
        if (is_null($groupOrderId) || (is_array($groupOrderId) && empty($groupOrderId))) {
            unset($this->GroupOrderId);
        } else {
            $this->GroupOrderId = $groupOrderId;
        }
        return $this;
    }
    /**
     * Get IdInBackwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInBackwardTransaction()
    {
        return isset($this->IdInBackwardTransaction) ? $this->IdInBackwardTransaction : null;
    }
    /**
     * Set IdInBackwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInBackwardTransaction
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIdInBackwardTransaction($idInBackwardTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInBackwardTransaction) && !(is_int($idInBackwardTransaction) || ctype_digit($idInBackwardTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInBackwardTransaction, true), gettype($idInBackwardTransaction)), __LINE__);
        }
        if (is_null($idInBackwardTransaction) || (is_array($idInBackwardTransaction) && empty($idInBackwardTransaction))) {
            unset($this->IdInBackwardTransaction);
        } else {
            $this->IdInBackwardTransaction = $idInBackwardTransaction;
        }
        return $this;
    }
    /**
     * Get IdInForwardTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInForwardTransaction()
    {
        return isset($this->IdInForwardTransaction) ? $this->IdInForwardTransaction : null;
    }
    /**
     * Set IdInForwardTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInForwardTransaction
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIdInForwardTransaction($idInForwardTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInForwardTransaction) && !(is_int($idInForwardTransaction) || ctype_digit($idInForwardTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInForwardTransaction, true), gettype($idInForwardTransaction)), __LINE__);
        }
        if (is_null($idInForwardTransaction) || (is_array($idInForwardTransaction) && empty($idInForwardTransaction))) {
            unset($this->IdInForwardTransaction);
        } else {
            $this->IdInForwardTransaction = $idInForwardTransaction;
        }
        return $this;
    }
    /**
     * Get IdInTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIdInTransaction()
    {
        return isset($this->IdInTransaction) ? $this->IdInTransaction : null;
    }
    /**
     * Set IdInTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $idInTransaction
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIdInTransaction($idInTransaction = null)
    {
        // validation for constraint: int
        if (!is_null($idInTransaction) && !(is_int($idInTransaction) || ctype_digit($idInTransaction))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idInTransaction, true), gettype($idInTransaction)), __LINE__);
        }
        if (is_null($idInTransaction) || (is_array($idInTransaction) && empty($idInTransaction))) {
            unset($this->IdInTransaction);
        } else {
            $this->IdInTransaction = $idInTransaction;
        }
        return $this;
    }
    /**
     * Get IsAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAccount()
    {
        return isset($this->IsAccount) ? $this->IsAccount : null;
    }
    /**
     * Set IsAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAccount
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIsAccount($isAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAccount) && !is_bool($isAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAccount, true), gettype($isAccount)), __LINE__);
        }
        if (is_null($isAccount) || (is_array($isAccount) && empty($isAccount))) {
            unset($this->IsAccount);
        } else {
            $this->IsAccount = $isAccount;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsExtraProduct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExtraProduct()
    {
        return isset($this->IsExtraProduct) ? $this->IsExtraProduct : null;
    }
    /**
     * Set IsExtraProduct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExtraProduct
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIsExtraProduct($isExtraProduct = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExtraProduct) && !is_bool($isExtraProduct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExtraProduct, true), gettype($isExtraProduct)), __LINE__);
        }
        if (is_null($isExtraProduct) || (is_array($isExtraProduct) && empty($isExtraProduct))) {
            unset($this->IsExtraProduct);
        } else {
            $this->IsExtraProduct = $isExtraProduct;
        }
        return $this;
    }
    /**
     * Get IsFictivePayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFictivePayment()
    {
        return isset($this->IsFictivePayment) ? $this->IsFictivePayment : null;
    }
    /**
     * Set IsFictivePayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFictivePayment
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIsFictivePayment($isFictivePayment = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFictivePayment) && !is_bool($isFictivePayment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFictivePayment, true), gettype($isFictivePayment)), __LINE__);
        }
        if (is_null($isFictivePayment) || (is_array($isFictivePayment) && empty($isFictivePayment))) {
            unset($this->IsFictivePayment);
        } else {
            $this->IsFictivePayment = $isFictivePayment;
        }
        return $this;
    }
    /**
     * Get IsModifiedReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsModifiedReservation()
    {
        return isset($this->IsModifiedReservation) ? $this->IsModifiedReservation : null;
    }
    /**
     * Set IsModifiedReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isModifiedReservation
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIsModifiedReservation($isModifiedReservation = null)
    {
        // validation for constraint: boolean
        if (!is_null($isModifiedReservation) && !is_bool($isModifiedReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isModifiedReservation, true), gettype($isModifiedReservation)), __LINE__);
        }
        if (is_null($isModifiedReservation) || (is_array($isModifiedReservation) && empty($isModifiedReservation))) {
            unset($this->IsModifiedReservation);
        } else {
            $this->IsModifiedReservation = $isModifiedReservation;
        }
        return $this;
    }
    /**
     * Get IsReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReserved()
    {
        return isset($this->IsReserved) ? $this->IsReserved : null;
    }
    /**
     * Set IsReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReserved
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIsReserved($isReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReserved) && !is_bool($isReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReserved, true), gettype($isReserved)), __LINE__);
        }
        if (is_null($isReserved) || (is_array($isReserved) && empty($isReserved))) {
            unset($this->IsReserved);
        } else {
            $this->IsReserved = $isReserved;
        }
        return $this;
    }
    /**
     * Get IsSubsTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubsTicket()
    {
        return isset($this->IsSubsTicket) ? $this->IsSubsTicket : null;
    }
    /**
     * Set IsSubsTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubsTicket
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIsSubsTicket($isSubsTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubsTicket) && !is_bool($isSubsTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubsTicket, true), gettype($isSubsTicket)), __LINE__);
        }
        if (is_null($isSubsTicket) || (is_array($isSubsTicket) && empty($isSubsTicket))) {
            unset($this->IsSubsTicket);
        } else {
            $this->IsSubsTicket = $isSubsTicket;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get ItemPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getItemPrice()
    {
        return isset($this->ItemPrice) ? $this->ItemPrice : null;
    }
    /**
     * Set ItemPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $itemPrice
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setItemPrice(\patest\StructType\Money $itemPrice = null)
    {
        if (is_null($itemPrice) || (is_array($itemPrice) && empty($itemPrice))) {
            unset($this->ItemPrice);
        } else {
            $this->ItemPrice = $itemPrice;
        }
        return $this;
    }
    /**
     * Get ItemPriceAfterDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getItemPriceAfterDiscount()
    {
        return isset($this->ItemPriceAfterDiscount) ? $this->ItemPriceAfterDiscount : null;
    }
    /**
     * Set ItemPriceAfterDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $itemPriceAfterDiscount
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setItemPriceAfterDiscount(\patest\StructType\Money $itemPriceAfterDiscount = null)
    {
        if (is_null($itemPriceAfterDiscount) || (is_array($itemPriceAfterDiscount) && empty($itemPriceAfterDiscount))) {
            unset($this->ItemPriceAfterDiscount);
        } else {
            $this->ItemPriceAfterDiscount = $itemPriceAfterDiscount;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get LinkingProductGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkingProductGuid()
    {
        return isset($this->LinkingProductGuid) ? $this->LinkingProductGuid : null;
    }
    /**
     * Set LinkingProductGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkingProductGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setLinkingProductGuid($linkingProductGuid = null)
    {
        // validation for constraint: string
        if (!is_null($linkingProductGuid) && !is_string($linkingProductGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkingProductGuid, true), gettype($linkingProductGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($linkingProductGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $linkingProductGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($linkingProductGuid, true)), __LINE__);
        }
        if (is_null($linkingProductGuid) || (is_array($linkingProductGuid) && empty($linkingProductGuid))) {
            unset($this->LinkingProductGuid);
        } else {
            $this->LinkingProductGuid = $linkingProductGuid;
        }
        return $this;
    }
    /**
     * Get LinkingProductTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLinkingProductTypeId()
    {
        return isset($this->LinkingProductTypeId) ? $this->LinkingProductTypeId : null;
    }
    /**
     * Set LinkingProductTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $linkingProductTypeId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setLinkingProductTypeId($linkingProductTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($linkingProductTypeId) && !(is_int($linkingProductTypeId) || ctype_digit($linkingProductTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($linkingProductTypeId, true), gettype($linkingProductTypeId)), __LINE__);
        }
        if (is_null($linkingProductTypeId) || (is_array($linkingProductTypeId) && empty($linkingProductTypeId))) {
            unset($this->LinkingProductTypeId);
        } else {
            $this->LinkingProductTypeId = $linkingProductTypeId;
        }
        return $this;
    }
    /**
     * Get ListPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getListPrice()
    {
        return isset($this->ListPrice) ? $this->ListPrice : null;
    }
    /**
     * Set ListPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $listPrice
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setListPrice(\patest\StructType\Money $listPrice = null)
    {
        if (is_null($listPrice) || (is_array($listPrice) && empty($listPrice))) {
            unset($this->ListPrice);
        } else {
            $this->ListPrice = $listPrice;
        }
        return $this;
    }
    /**
     * Get MembershipEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipEndDate()
    {
        return isset($this->MembershipEndDate) ? $this->MembershipEndDate : null;
    }
    /**
     * Set MembershipEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipEndDate
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setMembershipEndDate($membershipEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($membershipEndDate) && !is_string($membershipEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipEndDate, true), gettype($membershipEndDate)), __LINE__);
        }
        if (is_null($membershipEndDate) || (is_array($membershipEndDate) && empty($membershipEndDate))) {
            unset($this->MembershipEndDate);
        } else {
            $this->MembershipEndDate = $membershipEndDate;
        }
        return $this;
    }
    /**
     * Get MembershipStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipStartDate()
    {
        return isset($this->MembershipStartDate) ? $this->MembershipStartDate : null;
    }
    /**
     * Set MembershipStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipStartDate
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setMembershipStartDate($membershipStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($membershipStartDate) && !is_string($membershipStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipStartDate, true), gettype($membershipStartDate)), __LINE__);
        }
        if (is_null($membershipStartDate) || (is_array($membershipStartDate) && empty($membershipStartDate))) {
            unset($this->MembershipStartDate);
        } else {
            $this->MembershipStartDate = $membershipStartDate;
        }
        return $this;
    }
    /**
     * Get MiddleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMiddleName()
    {
        return isset($this->MiddleName) ? $this->MiddleName : null;
    }
    /**
     * Set MiddleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $middleName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setMiddleName($middleName = null)
    {
        // validation for constraint: string
        if (!is_null($middleName) && !is_string($middleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($middleName, true), gettype($middleName)), __LINE__);
        }
        if (is_null($middleName) || (is_array($middleName) && empty($middleName))) {
            unset($this->MiddleName);
        } else {
            $this->MiddleName = $middleName;
        }
        return $this;
    }
    /**
     * Get OnBehalfOfAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnBehalfOfAccountId()
    {
        return isset($this->OnBehalfOfAccountId) ? $this->OnBehalfOfAccountId : null;
    }
    /**
     * Set OnBehalfOfAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onBehalfOfAccountId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setOnBehalfOfAccountId($onBehalfOfAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfAccountId) && !is_string($onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfAccountId, true), gettype($onBehalfOfAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($onBehalfOfAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $onBehalfOfAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($onBehalfOfAccountId, true)), __LINE__);
        }
        if (is_null($onBehalfOfAccountId) || (is_array($onBehalfOfAccountId) && empty($onBehalfOfAccountId))) {
            unset($this->OnBehalfOfAccountId);
        } else {
            $this->OnBehalfOfAccountId = $onBehalfOfAccountId;
        }
        return $this;
    }
    /**
     * Get OriginalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalId()
    {
        return isset($this->OriginalId) ? $this->OriginalId : null;
    }
    /**
     * Set OriginalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setOriginalId($originalId = null)
    {
        // validation for constraint: string
        if (!is_null($originalId) && !is_string($originalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalId, true), gettype($originalId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalId, true)), __LINE__);
        }
        if (is_null($originalId) || (is_array($originalId) && empty($originalId))) {
            unset($this->OriginalId);
        } else {
            $this->OriginalId = $originalId;
        }
        return $this;
    }
    /**
     * Get OriginalPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalPriceTypeId()
    {
        return isset($this->OriginalPriceTypeId) ? $this->OriginalPriceTypeId : null;
    }
    /**
     * Set OriginalPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalPriceTypeId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setOriginalPriceTypeId($originalPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($originalPriceTypeId) && !is_string($originalPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalPriceTypeId, true), gettype($originalPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalPriceTypeId, true)), __LINE__);
        }
        if (is_null($originalPriceTypeId) || (is_array($originalPriceTypeId) && empty($originalPriceTypeId))) {
            unset($this->OriginalPriceTypeId);
        } else {
            $this->OriginalPriceTypeId = $originalPriceTypeId;
        }
        return $this;
    }
    /**
     * Get OriginalServiceSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalServiceSpecificId()
    {
        return isset($this->OriginalServiceSpecificId) ? $this->OriginalServiceSpecificId : null;
    }
    /**
     * Set OriginalServiceSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalServiceSpecificId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setOriginalServiceSpecificId($originalServiceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($originalServiceSpecificId) && !is_string($originalServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalServiceSpecificId, true), gettype($originalServiceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalServiceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalServiceSpecificId, true)), __LINE__);
        }
        if (is_null($originalServiceSpecificId) || (is_array($originalServiceSpecificId) && empty($originalServiceSpecificId))) {
            unset($this->OriginalServiceSpecificId);
        } else {
            $this->OriginalServiceSpecificId = $originalServiceSpecificId;
        }
        return $this;
    }
    /**
     * Get PartOfPromptGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartOfPromptGuid()
    {
        return isset($this->PartOfPromptGuid) ? $this->PartOfPromptGuid : null;
    }
    /**
     * Set PartOfPromptGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partOfPromptGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPartOfPromptGuid($partOfPromptGuid = null)
    {
        // validation for constraint: string
        if (!is_null($partOfPromptGuid) && !is_string($partOfPromptGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partOfPromptGuid, true), gettype($partOfPromptGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($partOfPromptGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $partOfPromptGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($partOfPromptGuid, true)), __LINE__);
        }
        if (is_null($partOfPromptGuid) || (is_array($partOfPromptGuid) && empty($partOfPromptGuid))) {
            unset($this->PartOfPromptGuid);
        } else {
            $this->PartOfPromptGuid = $partOfPromptGuid;
        }
        return $this;
    }
    /**
     * Get PaymentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentId()
    {
        return isset($this->PaymentId) ? $this->PaymentId : null;
    }
    /**
     * Set PaymentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentId) && !is_string($paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentId, true), gettype($paymentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentId, true)), __LINE__);
        }
        if (is_null($paymentId) || (is_array($paymentId) && empty($paymentId))) {
            unset($this->PaymentId);
        } else {
            $this->PaymentId = $paymentId;
        }
        return $this;
    }
    /**
     * Get PaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethod()
    {
        return isset($this->PaymentMethod) ? $this->PaymentMethod : null;
    }
    /**
     * Set PaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethod
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPaymentMethod($paymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethod) && !is_string($paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethod, true), gettype($paymentMethod)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethod) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethod, true)), __LINE__);
        }
        if (is_null($paymentMethod) || (is_array($paymentMethod) && empty($paymentMethod))) {
            unset($this->PaymentMethod);
        } else {
            $this->PaymentMethod = $paymentMethod;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentSubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentSubType()
    {
        return isset($this->PaymentSubType) ? $this->PaymentSubType : null;
    }
    /**
     * Set PaymentSubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentSubType
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPaymentSubType($paymentSubType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentSubType) && !is_string($paymentSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentSubType, true), gettype($paymentSubType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentSubType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentSubType, true)), __LINE__);
        }
        if (is_null($paymentSubType) || (is_array($paymentSubType) && empty($paymentSubType))) {
            unset($this->PaymentSubType);
        } else {
            $this->PaymentSubType = $paymentSubType;
        }
        return $this;
    }
    /**
     * Get PriceEffectivenessEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriceEffectivenessEnum()
    {
        return isset($this->PriceEffectivenessEnum) ? $this->PriceEffectivenessEnum : null;
    }
    /**
     * Set PriceEffectivenessEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priceEffectivenessEnum
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPriceEffectivenessEnum($priceEffectivenessEnum = null)
    {
        // validation for constraint: int
        if (!is_null($priceEffectivenessEnum) && !(is_int($priceEffectivenessEnum) || ctype_digit($priceEffectivenessEnum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceEffectivenessEnum, true), gettype($priceEffectivenessEnum)), __LINE__);
        }
        if (is_null($priceEffectivenessEnum) || (is_array($priceEffectivenessEnum) && empty($priceEffectivenessEnum))) {
            unset($this->PriceEffectivenessEnum);
        } else {
            $this->PriceEffectivenessEnum = $priceEffectivenessEnum;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceModifiers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfReporting_SimplifiedFactPriceModifier|null
     */
    public function getPriceModifiers()
    {
        return isset($this->PriceModifiers) ? $this->PriceModifiers : null;
    }
    /**
     * Set PriceModifiers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfReporting_SimplifiedFactPriceModifier $priceModifiers
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPriceModifiers(\patest\StructType\RecordSetOfReporting_SimplifiedFactPriceModifier $priceModifiers = null)
    {
        if (is_null($priceModifiers) || (is_array($priceModifiers) && empty($priceModifiers))) {
            unset($this->PriceModifiers);
        } else {
            $this->PriceModifiers = $priceModifiers;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceTypeName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPriceTypeName(\patest\StructType\GlobalString $priceTypeName = null)
    {
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get PricingVariationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPricingVariationId()
    {
        return isset($this->PricingVariationId) ? $this->PricingVariationId : null;
    }
    /**
     * Set PricingVariationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pricingVariationId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPricingVariationId($pricingVariationId = null)
    {
        // validation for constraint: int
        if (!is_null($pricingVariationId) && !(is_int($pricingVariationId) || ctype_digit($pricingVariationId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pricingVariationId, true), gettype($pricingVariationId)), __LINE__);
        }
        if (is_null($pricingVariationId) || (is_array($pricingVariationId) && empty($pricingVariationId))) {
            unset($this->PricingVariationId);
        } else {
            $this->PricingVariationId = $pricingVariationId;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get ProductInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductInstanceId()
    {
        return isset($this->ProductInstanceId) ? $this->ProductInstanceId : null;
    }
    /**
     * Set ProductInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productInstanceId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setProductInstanceId($productInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($productInstanceId) && !is_string($productInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productInstanceId, true), gettype($productInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($productInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $productInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($productInstanceId, true)), __LINE__);
        }
        if (is_null($productInstanceId) || (is_array($productInstanceId) && empty($productInstanceId))) {
            unset($this->ProductInstanceId);
        } else {
            $this->ProductInstanceId = $productInstanceId;
        }
        return $this;
    }
    /**
     * Get RecoAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRecoAccountId()
    {
        return isset($this->RecoAccountId) ? $this->RecoAccountId : null;
    }
    /**
     * Set RecoAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $recoAccountId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRecoAccountId($recoAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($recoAccountId) && !is_string($recoAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($recoAccountId, true), gettype($recoAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($recoAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $recoAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($recoAccountId, true)), __LINE__);
        }
        if (is_null($recoAccountId) || (is_array($recoAccountId) && empty($recoAccountId))) {
            unset($this->RecoAccountId);
        } else {
            $this->RecoAccountId = $recoAccountId;
        }
        return $this;
    }
    /**
     * Get RelatedItemGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedItemGuid()
    {
        return isset($this->RelatedItemGuid) ? $this->RelatedItemGuid : null;
    }
    /**
     * Set RelatedItemGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedItemGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRelatedItemGuid($relatedItemGuid = null)
    {
        // validation for constraint: string
        if (!is_null($relatedItemGuid) && !is_string($relatedItemGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedItemGuid, true), gettype($relatedItemGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedItemGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedItemGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedItemGuid, true)), __LINE__);
        }
        if (is_null($relatedItemGuid) || (is_array($relatedItemGuid) && empty($relatedItemGuid))) {
            unset($this->RelatedItemGuid);
        } else {
            $this->RelatedItemGuid = $relatedItemGuid;
        }
        return $this;
    }
    /**
     * Get RelationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationName()
    {
        return isset($this->RelationName) ? $this->RelationName : null;
    }
    /**
     * Set RelationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRelationName($relationName = null)
    {
        // validation for constraint: string
        if (!is_null($relationName) && !is_string($relationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationName, true), gettype($relationName)), __LINE__);
        }
        if (is_null($relationName) || (is_array($relationName) && empty($relationName))) {
            unset($this->RelationName);
        } else {
            $this->RelationName = $relationName;
        }
        return $this;
    }
    /**
     * Get RelCommision value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRelCommision()
    {
        return isset($this->RelCommision) ? $this->RelCommision : null;
    }
    /**
     * Set RelCommision value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $relCommision
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRelCommision(\patest\StructType\Money $relCommision = null)
    {
        if (is_null($relCommision) || (is_array($relCommision) && empty($relCommision))) {
            unset($this->RelCommision);
        } else {
            $this->RelCommision = $relCommision;
        }
        return $this;
    }
    /**
     * Get RenewOfSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewOfSubscriptionInstanceId()
    {
        return isset($this->RenewOfSubscriptionInstanceId) ? $this->RenewOfSubscriptionInstanceId : null;
    }
    /**
     * Set RenewOfSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewOfSubscriptionInstanceId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRenewOfSubscriptionInstanceId($renewOfSubscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewOfSubscriptionInstanceId) && !is_string($renewOfSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewOfSubscriptionInstanceId, true), gettype($renewOfSubscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewOfSubscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewOfSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewOfSubscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($renewOfSubscriptionInstanceId) || (is_array($renewOfSubscriptionInstanceId) && empty($renewOfSubscriptionInstanceId))) {
            unset($this->RenewOfSubscriptionInstanceId);
        } else {
            $this->RenewOfSubscriptionInstanceId = $renewOfSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get RepriceDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRepriceDate()
    {
        return isset($this->RepriceDate) ? $this->RepriceDate : null;
    }
    /**
     * Set RepriceDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $repriceDate
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRepriceDate($repriceDate = null)
    {
        // validation for constraint: string
        if (!is_null($repriceDate) && !is_string($repriceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($repriceDate, true), gettype($repriceDate)), __LINE__);
        }
        if (is_null($repriceDate) || (is_array($repriceDate) && empty($repriceDate))) {
            unset($this->RepriceDate);
        } else {
            $this->RepriceDate = $repriceDate;
        }
        return $this;
    }
    /**
     * Get RequestedActionEnum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRequestedActionEnum()
    {
        return isset($this->RequestedActionEnum) ? $this->RequestedActionEnum : null;
    }
    /**
     * Set RequestedActionEnum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $requestedActionEnum
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRequestedActionEnum($requestedActionEnum = null)
    {
        // validation for constraint: int
        if (!is_null($requestedActionEnum) && !(is_int($requestedActionEnum) || ctype_digit($requestedActionEnum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestedActionEnum, true), gettype($requestedActionEnum)), __LINE__);
        }
        if (is_null($requestedActionEnum) || (is_array($requestedActionEnum) && empty($requestedActionEnum))) {
            unset($this->RequestedActionEnum);
        } else {
            $this->RequestedActionEnum = $requestedActionEnum;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDate()
    {
        return isset($this->ReservationExpiryDate) ? $this->ReservationExpiryDate : null;
    }
    /**
     * Set ReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDate
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setReservationExpiryDate($reservationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDate) && !is_string($reservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDate, true), gettype($reservationExpiryDate)), __LINE__);
        }
        if (is_null($reservationExpiryDate) || (is_array($reservationExpiryDate) && empty($reservationExpiryDate))) {
            unset($this->ReservationExpiryDate);
        } else {
            $this->ReservationExpiryDate = $reservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get RetailerCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetailerCompanyId()
    {
        return isset($this->RetailerCompanyId) ? $this->RetailerCompanyId : null;
    }
    /**
     * Set RetailerCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retailerCompanyId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRetailerCompanyId($retailerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($retailerCompanyId) && !(is_int($retailerCompanyId) || ctype_digit($retailerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailerCompanyId, true), gettype($retailerCompanyId)), __LINE__);
        }
        if (is_null($retailerCompanyId) || (is_array($retailerCompanyId) && empty($retailerCompanyId))) {
            unset($this->RetailerCompanyId);
        } else {
            $this->RetailerCompanyId = $retailerCompanyId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get RowVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowVersion()
    {
        return isset($this->RowVersion) ? $this->RowVersion : null;
    }
    /**
     * Set RowVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowVersion
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setRowVersion($rowVersion = null)
    {
        // validation for constraint: int
        if (!is_null($rowVersion) && !(is_int($rowVersion) || ctype_digit($rowVersion))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowVersion, true), gettype($rowVersion)), __LINE__);
        }
        if (is_null($rowVersion) || (is_array($rowVersion) && empty($rowVersion))) {
            unset($this->RowVersion);
        } else {
            $this->RowVersion = $rowVersion;
        }
        return $this;
    }
    /**
     * Get SaleModeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleModeId()
    {
        return isset($this->SaleModeId) ? $this->SaleModeId : null;
    }
    /**
     * Set SaleModeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleModeId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSaleModeId($saleModeId = null)
    {
        // validation for constraint: string
        if (!is_null($saleModeId) && !is_string($saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleModeId, true), gettype($saleModeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleModeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleModeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleModeId, true)), __LINE__);
        }
        if (is_null($saleModeId) || (is_array($saleModeId) && empty($saleModeId))) {
            unset($this->SaleModeId);
        } else {
            $this->SaleModeId = $saleModeId;
        }
        return $this;
    }
    /**
     * Get SalePointGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointGuid()
    {
        return isset($this->SalePointGuid) ? $this->SalePointGuid : null;
    }
    /**
     * Set SalePointGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSalePointGuid($salePointGuid = null)
    {
        // validation for constraint: string
        if (!is_null($salePointGuid) && !is_string($salePointGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointGuid, true), gettype($salePointGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointGuid, true)), __LINE__);
        }
        if (is_null($salePointGuid) || (is_array($salePointGuid) && empty($salePointGuid))) {
            unset($this->SalePointGuid);
        } else {
            $this->SalePointGuid = $salePointGuid;
        }
        return $this;
    }
    /**
     * Get SalePointGuidName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalePointGuidName()
    {
        return isset($this->SalePointGuidName) ? $this->SalePointGuidName : null;
    }
    /**
     * Set SalePointGuidName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salePointGuidName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSalePointGuidName(\patest\StructType\GlobalString $salePointGuidName = null)
    {
        if (is_null($salePointGuidName) || (is_array($salePointGuidName) && empty($salePointGuidName))) {
            unset($this->SalePointGuidName);
        } else {
            $this->SalePointGuidName = $salePointGuidName;
        }
        return $this;
    }
    /**
     * Get SalesRepCustomerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepCustomerId()
    {
        return isset($this->SalesRepCustomerId) ? $this->SalesRepCustomerId : null;
    }
    /**
     * Set SalesRepCustomerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepCustomerId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSalesRepCustomerId($salesRepCustomerId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepCustomerId) && !is_string($salesRepCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepCustomerId, true), gettype($salesRepCustomerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepCustomerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepCustomerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepCustomerId, true)), __LINE__);
        }
        if (is_null($salesRepCustomerId) || (is_array($salesRepCustomerId) && empty($salesRepCustomerId))) {
            unset($this->SalesRepCustomerId);
        } else {
            $this->SalesRepCustomerId = $salesRepCustomerId;
        }
        return $this;
    }
    /**
     * Get SalesRepresentativeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepresentativeId()
    {
        return isset($this->SalesRepresentativeId) ? $this->SalesRepresentativeId : null;
    }
    /**
     * Set SalesRepresentativeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepresentativeId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSalesRepresentativeId($salesRepresentativeId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepresentativeId) && !is_string($salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepresentativeId, true), gettype($salesRepresentativeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepresentativeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepresentativeId, true)), __LINE__);
        }
        if (is_null($salesRepresentativeId) || (is_array($salesRepresentativeId) && empty($salesRepresentativeId))) {
            unset($this->SalesRepresentativeId);
        } else {
            $this->SalesRepresentativeId = $salesRepresentativeId;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorName
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSectorName(\patest\StructType\GlobalString $sectorName = null)
    {
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SellerBranchGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerBranchGuid()
    {
        return isset($this->SellerBranchGuid) ? $this->SellerBranchGuid : null;
    }
    /**
     * Set SellerBranchGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerBranchGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSellerBranchGuid($sellerBranchGuid = null)
    {
        // validation for constraint: string
        if (!is_null($sellerBranchGuid) && !is_string($sellerBranchGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerBranchGuid, true), gettype($sellerBranchGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerBranchGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerBranchGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerBranchGuid, true)), __LINE__);
        }
        if (is_null($sellerBranchGuid) || (is_array($sellerBranchGuid) && empty($sellerBranchGuid))) {
            unset($this->SellerBranchGuid);
        } else {
            $this->SellerBranchGuid = $sellerBranchGuid;
        }
        return $this;
    }
    /**
     * Get ShiftGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShiftGuid()
    {
        return isset($this->ShiftGuid) ? $this->ShiftGuid : null;
    }
    /**
     * Set ShiftGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $shiftGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setShiftGuid($shiftGuid = null)
    {
        // validation for constraint: string
        if (!is_null($shiftGuid) && !is_string($shiftGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shiftGuid, true), gettype($shiftGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($shiftGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $shiftGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($shiftGuid, true)), __LINE__);
        }
        if (is_null($shiftGuid) || (is_array($shiftGuid) && empty($shiftGuid))) {
            unset($this->ShiftGuid);
        } else {
            $this->ShiftGuid = $shiftGuid;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubsidizedByAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizedByAccountId()
    {
        return isset($this->SubsidizedByAccountId) ? $this->SubsidizedByAccountId : null;
    }
    /**
     * Set SubsidizedByAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizedByAccountId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSubsidizedByAccountId($subsidizedByAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizedByAccountId) && !is_string($subsidizedByAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizedByAccountId, true), gettype($subsidizedByAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizedByAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizedByAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizedByAccountId, true)), __LINE__);
        }
        if (is_null($subsidizedByAccountId) || (is_array($subsidizedByAccountId) && empty($subsidizedByAccountId))) {
            unset($this->SubsidizedByAccountId);
        } else {
            $this->SubsidizedByAccountId = $subsidizedByAccountId;
        }
        return $this;
    }
    /**
     * Get SupplierBranchGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierBranchGuid()
    {
        return isset($this->SupplierBranchGuid) ? $this->SupplierBranchGuid : null;
    }
    /**
     * Set SupplierBranchGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierBranchGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSupplierBranchGuid($supplierBranchGuid = null)
    {
        // validation for constraint: string
        if (!is_null($supplierBranchGuid) && !is_string($supplierBranchGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierBranchGuid, true), gettype($supplierBranchGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierBranchGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierBranchGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierBranchGuid, true)), __LINE__);
        }
        if (is_null($supplierBranchGuid) || (is_array($supplierBranchGuid) && empty($supplierBranchGuid))) {
            unset($this->SupplierBranchGuid);
        } else {
            $this->SupplierBranchGuid = $supplierBranchGuid;
        }
        return $this;
    }
    /**
     * Get SupplierGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierGuid()
    {
        return isset($this->SupplierGuid) ? $this->SupplierGuid : null;
    }
    /**
     * Set SupplierGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setSupplierGuid($supplierGuid = null)
    {
        // validation for constraint: string
        if (!is_null($supplierGuid) && !is_string($supplierGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierGuid, true), gettype($supplierGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierGuid, true)), __LINE__);
        }
        if (is_null($supplierGuid) || (is_array($supplierGuid) && empty($supplierGuid))) {
            unset($this->SupplierGuid);
        } else {
            $this->SupplierGuid = $supplierGuid;
        }
        return $this;
    }
    /**
     * Get TickSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTickSeries()
    {
        return isset($this->TickSeries) ? $this->TickSeries : null;
    }
    /**
     * Set TickSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tickSeries
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTickSeries($tickSeries = null)
    {
        // validation for constraint: string
        if (!is_null($tickSeries) && !is_string($tickSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tickSeries, true), gettype($tickSeries)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tickSeries) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tickSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tickSeries, true)), __LINE__);
        }
        if (is_null($tickSeries) || (is_array($tickSeries) && empty($tickSeries))) {
            unset($this->TickSeries);
        } else {
            $this->TickSeries = $tickSeries;
        }
        return $this;
    }
    /**
     * Get TillGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillGuid()
    {
        return isset($this->TillGuid) ? $this->TillGuid : null;
    }
    /**
     * Set TillGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTillGuid($tillGuid = null)
    {
        // validation for constraint: string
        if (!is_null($tillGuid) && !is_string($tillGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillGuid, true), gettype($tillGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillGuid, true)), __LINE__);
        }
        if (is_null($tillGuid) || (is_array($tillGuid) && empty($tillGuid))) {
            unset($this->TillGuid);
        } else {
            $this->TillGuid = $tillGuid;
        }
        return $this;
    }
    /**
     * Get TotalCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCommission()
    {
        return isset($this->TotalCommission) ? $this->TotalCommission : null;
    }
    /**
     * Set TotalCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCommission
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTotalCommission(\patest\StructType\Money $totalCommission = null)
    {
        if (is_null($totalCommission) || (is_array($totalCommission) && empty($totalCommission))) {
            unset($this->TotalCommission);
        } else {
            $this->TotalCommission = $totalCommission;
        }
        return $this;
    }
    /**
     * Get TotalCommissionIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCommissionIncluded()
    {
        return isset($this->TotalCommissionIncluded) ? $this->TotalCommissionIncluded : null;
    }
    /**
     * Set TotalCommissionIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCommissionIncluded
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTotalCommissionIncluded(\patest\StructType\Money $totalCommissionIncluded = null)
    {
        if (is_null($totalCommissionIncluded) || (is_array($totalCommissionIncluded) && empty($totalCommissionIncluded))) {
            unset($this->TotalCommissionIncluded);
        } else {
            $this->TotalCommissionIncluded = $totalCommissionIncluded;
        }
        return $this;
    }
    /**
     * Get TotalDiscount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalDiscount()
    {
        return isset($this->TotalDiscount) ? $this->TotalDiscount : null;
    }
    /**
     * Set TotalDiscount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalDiscount
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTotalDiscount(\patest\StructType\Money $totalDiscount = null)
    {
        if (is_null($totalDiscount) || (is_array($totalDiscount) && empty($totalDiscount))) {
            unset($this->TotalDiscount);
        } else {
            $this->TotalDiscount = $totalDiscount;
        }
        return $this;
    }
    /**
     * Get TotalExtraCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalExtraCharge()
    {
        return isset($this->TotalExtraCharge) ? $this->TotalExtraCharge : null;
    }
    /**
     * Set TotalExtraCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalExtraCharge
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTotalExtraCharge(\patest\StructType\Money $totalExtraCharge = null)
    {
        if (is_null($totalExtraCharge) || (is_array($totalExtraCharge) && empty($totalExtraCharge))) {
            unset($this->TotalExtraCharge);
        } else {
            $this->TotalExtraCharge = $totalExtraCharge;
        }
        return $this;
    }
    /**
     * Get TotalTax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTax()
    {
        return isset($this->TotalTax) ? $this->TotalTax : null;
    }
    /**
     * Set TotalTax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTax
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTotalTax(\patest\StructType\Money $totalTax = null)
    {
        if (is_null($totalTax) || (is_array($totalTax) && empty($totalTax))) {
            unset($this->TotalTax);
        } else {
            $this->TotalTax = $totalTax;
        }
        return $this;
    }
    /**
     * Get TotalTaxIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTaxIncluded()
    {
        return isset($this->TotalTaxIncluded) ? $this->TotalTaxIncluded : null;
    }
    /**
     * Set TotalTaxIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTaxIncluded
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTotalTaxIncluded(\patest\StructType\Money $totalTaxIncluded = null)
    {
        if (is_null($totalTaxIncluded) || (is_array($totalTaxIncluded) && empty($totalTaxIncluded))) {
            unset($this->TotalTaxIncluded);
        } else {
            $this->TotalTaxIncluded = $totalTaxIncluded;
        }
        return $this;
    }
    /**
     * Get TotalVat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalVat()
    {
        return isset($this->TotalVat) ? $this->TotalVat : null;
    }
    /**
     * Set TotalVat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalVat
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTotalVat(\patest\StructType\Money $totalVat = null)
    {
        if (is_null($totalVat) || (is_array($totalVat) && empty($totalVat))) {
            unset($this->TotalVat);
        } else {
            $this->TotalVat = $totalVat;
        }
        return $this;
    }
    /**
     * Get TotalVatIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalVatIncluded()
    {
        return isset($this->TotalVatIncluded) ? $this->TotalVatIncluded : null;
    }
    /**
     * Set TotalVatIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalVatIncluded
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTotalVatIncluded(\patest\StructType\Money $totalVatIncluded = null)
    {
        if (is_null($totalVatIncluded) || (is_array($totalVatIncluded) && empty($totalVatIncluded))) {
            unset($this->TotalVatIncluded);
        } else {
            $this->TotalVatIncluded = $totalVatIncluded;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionLocalId()
    {
        return isset($this->TransactionLocalId) ? $this->TransactionLocalId : null;
    }
    /**
     * Set TransactionLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionLocalId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTransactionLocalId($transactionLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($transactionLocalId) && !(is_int($transactionLocalId) || ctype_digit($transactionLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionLocalId, true), gettype($transactionLocalId)), __LINE__);
        }
        if (is_null($transactionLocalId) || (is_array($transactionLocalId) && empty($transactionLocalId))) {
            unset($this->TransactionLocalId);
        } else {
            $this->TransactionLocalId = $transactionLocalId;
        }
        return $this;
    }
    /**
     * Get TransactionNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionNote()
    {
        return isset($this->TransactionNote) ? $this->TransactionNote : null;
    }
    /**
     * Set TransactionNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionNote
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTransactionNote($transactionNote = null)
    {
        // validation for constraint: string
        if (!is_null($transactionNote) && !is_string($transactionNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionNote, true), gettype($transactionNote)), __LINE__);
        }
        if (is_null($transactionNote) || (is_array($transactionNote) && empty($transactionNote))) {
            unset($this->TransactionNote);
        } else {
            $this->TransactionNote = $transactionNote;
        }
        return $this;
    }
    /**
     * Get TransactIssuerCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactIssuerCompanyId()
    {
        return isset($this->TransactIssuerCompanyId) ? $this->TransactIssuerCompanyId : null;
    }
    /**
     * Set TransactIssuerCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactIssuerCompanyId
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTransactIssuerCompanyId($transactIssuerCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($transactIssuerCompanyId) && !(is_int($transactIssuerCompanyId) || ctype_digit($transactIssuerCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactIssuerCompanyId, true), gettype($transactIssuerCompanyId)), __LINE__);
        }
        if (is_null($transactIssuerCompanyId) || (is_array($transactIssuerCompanyId) && empty($transactIssuerCompanyId))) {
            unset($this->TransactIssuerCompanyId);
        } else {
            $this->TransactIssuerCompanyId = $transactIssuerCompanyId;
        }
        return $this;
    }
    /**
     * Get TransactNum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactNum()
    {
        return isset($this->TransactNum) ? $this->TransactNum : null;
    }
    /**
     * Set TransactNum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactNum
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTransactNum($transactNum = null)
    {
        // validation for constraint: int
        if (!is_null($transactNum) && !(is_int($transactNum) || ctype_digit($transactNum))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactNum, true), gettype($transactNum)), __LINE__);
        }
        if (is_null($transactNum) || (is_array($transactNum) && empty($transactNum))) {
            unset($this->TransactNum);
        } else {
            $this->TransactNum = $transactNum;
        }
        return $this;
    }
    /**
     * Get TypeDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeDescription()
    {
        return isset($this->TypeDescription) ? $this->TypeDescription : null;
    }
    /**
     * Set TypeDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $typeDescription
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTypeDescription($typeDescription = null)
    {
        // validation for constraint: string
        if (!is_null($typeDescription) && !is_string($typeDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeDescription, true), gettype($typeDescription)), __LINE__);
        }
        if (is_null($typeDescription) || (is_array($typeDescription) && empty($typeDescription))) {
            unset($this->TypeDescription);
        } else {
            $this->TypeDescription = $typeDescription;
        }
        return $this;
    }
    /**
     * Get TypeNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTypeNumber()
    {
        return isset($this->TypeNumber) ? $this->TypeNumber : null;
    }
    /**
     * Set TypeNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $typeNumber
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setTypeNumber($typeNumber = null)
    {
        // validation for constraint: int
        if (!is_null($typeNumber) && !(is_int($typeNumber) || ctype_digit($typeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($typeNumber, true), gettype($typeNumber)), __LINE__);
        }
        if (is_null($typeNumber) || (is_array($typeNumber) && empty($typeNumber))) {
            unset($this->TypeNumber);
        } else {
            $this->TypeNumber = $typeNumber;
        }
        return $this;
    }
    /**
     * Get UserGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserGuid()
    {
        return isset($this->UserGuid) ? $this->UserGuid : null;
    }
    /**
     * Set UserGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setUserGuid($userGuid = null)
    {
        // validation for constraint: string
        if (!is_null($userGuid) && !is_string($userGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userGuid, true), gettype($userGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userGuid, true)), __LINE__);
        }
        if (is_null($userGuid) || (is_array($userGuid) && empty($userGuid))) {
            unset($this->UserGuid);
        } else {
            $this->UserGuid = $userGuid;
        }
        return $this;
    }
    /**
     * Get UserOfAffiliateAccountGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserOfAffiliateAccountGuid()
    {
        return isset($this->UserOfAffiliateAccountGuid) ? $this->UserOfAffiliateAccountGuid : null;
    }
    /**
     * Set UserOfAffiliateAccountGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userOfAffiliateAccountGuid
     * @return \patest\StructType\Reporting_FactItem
     */
    public function setUserOfAffiliateAccountGuid($userOfAffiliateAccountGuid = null)
    {
        // validation for constraint: string
        if (!is_null($userOfAffiliateAccountGuid) && !is_string($userOfAffiliateAccountGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userOfAffiliateAccountGuid, true), gettype($userOfAffiliateAccountGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userOfAffiliateAccountGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userOfAffiliateAccountGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userOfAffiliateAccountGuid, true)), __LINE__);
        }
        if (is_null($userOfAffiliateAccountGuid) || (is_array($userOfAffiliateAccountGuid) && empty($userOfAffiliateAccountGuid))) {
            unset($this->UserOfAffiliateAccountGuid);
        } else {
            $this->UserOfAffiliateAccountGuid = $userOfAffiliateAccountGuid;
        }
        return $this;
    }
}
