<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportOfflineScanBarcodeUsagesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportOfflineScanBarcodeUsagesRequest
 * @subpackage Structs
 */
class ReportOfflineScanBarcodeUsagesRequest extends ExtensibleDataContract
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The BarcodeUsages
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfOfflineScanBarcodeUsage
     */
    public $BarcodeUsages;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The ScannerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScannerId;
    /**
     * The ScanningSessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScanningSessionId;
    /**
     * Constructor method for ReportOfflineScanBarcodeUsagesRequest
     * @uses ReportOfflineScanBarcodeUsagesRequest::setAccessControlSystemId()
     * @uses ReportOfflineScanBarcodeUsagesRequest::setBarcodeUsages()
     * @uses ReportOfflineScanBarcodeUsagesRequest::setEventId()
     * @uses ReportOfflineScanBarcodeUsagesRequest::setScannerId()
     * @uses ReportOfflineScanBarcodeUsagesRequest::setScanningSessionId()
     * @param string $accessControlSystemId
     * @param \patest\ArrayType\ArrayOfOfflineScanBarcodeUsage $barcodeUsages
     * @param string $eventId
     * @param string $scannerId
     * @param string $scanningSessionId
     */
    public function __construct($accessControlSystemId = null, \patest\ArrayType\ArrayOfOfflineScanBarcodeUsage $barcodeUsages = null, $eventId = null, $scannerId = null, $scanningSessionId = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setBarcodeUsages($barcodeUsages)
            ->setEventId($eventId)
            ->setScannerId($scannerId)
            ->setScanningSessionId($scanningSessionId);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\ReportOfflineScanBarcodeUsagesRequest
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get BarcodeUsages value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfOfflineScanBarcodeUsage|null
     */
    public function getBarcodeUsages()
    {
        return isset($this->BarcodeUsages) ? $this->BarcodeUsages : null;
    }
    /**
     * Set BarcodeUsages value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfOfflineScanBarcodeUsage $barcodeUsages
     * @return \patest\StructType\ReportOfflineScanBarcodeUsagesRequest
     */
    public function setBarcodeUsages(\patest\ArrayType\ArrayOfOfflineScanBarcodeUsage $barcodeUsages = null)
    {
        if (is_null($barcodeUsages) || (is_array($barcodeUsages) && empty($barcodeUsages))) {
            unset($this->BarcodeUsages);
        } else {
            $this->BarcodeUsages = $barcodeUsages;
        }
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\ReportOfflineScanBarcodeUsagesRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get ScannerId value
     * @return string|null
     */
    public function getScannerId()
    {
        return $this->ScannerId;
    }
    /**
     * Set ScannerId value
     * @param string $scannerId
     * @return \patest\StructType\ReportOfflineScanBarcodeUsagesRequest
     */
    public function setScannerId($scannerId = null)
    {
        // validation for constraint: string
        if (!is_null($scannerId) && !is_string($scannerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannerId, true), gettype($scannerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scannerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scannerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scannerId, true)), __LINE__);
        }
        $this->ScannerId = $scannerId;
        return $this;
    }
    /**
     * Get ScanningSessionId value
     * @return string|null
     */
    public function getScanningSessionId()
    {
        return $this->ScanningSessionId;
    }
    /**
     * Set ScanningSessionId value
     * @param string $scanningSessionId
     * @return \patest\StructType\ReportOfflineScanBarcodeUsagesRequest
     */
    public function setScanningSessionId($scanningSessionId = null)
    {
        // validation for constraint: string
        if (!is_null($scanningSessionId) && !is_string($scanningSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scanningSessionId, true), gettype($scanningSessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scanningSessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scanningSessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scanningSessionId, true)), __LINE__);
        }
        $this->ScanningSessionId = $scanningSessionId;
        return $this;
    }
}
