<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenderedDocumentDataEntity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RenderedDocumentDataEntity
 * @subpackage Structs
 */
class RenderedDocumentDataEntity extends AbstractStructBase
{
    /**
     * The Entity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AnyEntity
     */
    public $Entity;
    /**
     * The EntityAlias
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityAlias;
    /**
     * Constructor method for RenderedDocumentDataEntity
     * @uses RenderedDocumentDataEntity::setEntity()
     * @uses RenderedDocumentDataEntity::setEntityAlias()
     * @param \patest\StructType\AnyEntity $entity
     * @param string $entityAlias
     */
    public function __construct(\patest\StructType\AnyEntity $entity = null, $entityAlias = null)
    {
        $this
            ->setEntity($entity)
            ->setEntityAlias($entityAlias);
    }
    /**
     * Get Entity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AnyEntity|null
     */
    public function getEntity()
    {
        return isset($this->Entity) ? $this->Entity : null;
    }
    /**
     * Set Entity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AnyEntity $entity
     * @return \patest\StructType\RenderedDocumentDataEntity
     */
    public function setEntity(\patest\StructType\AnyEntity $entity = null)
    {
        if (is_null($entity) || (is_array($entity) && empty($entity))) {
            unset($this->Entity);
        } else {
            $this->Entity = $entity;
        }
        return $this;
    }
    /**
     * Get EntityAlias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityAlias()
    {
        return isset($this->EntityAlias) ? $this->EntityAlias : null;
    }
    /**
     * Set EntityAlias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityAlias
     * @return \patest\StructType\RenderedDocumentDataEntity
     */
    public function setEntityAlias($entityAlias = null)
    {
        // validation for constraint: string
        if (!is_null($entityAlias) && !is_string($entityAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityAlias, true), gettype($entityAlias)), __LINE__);
        }
        if (is_null($entityAlias) || (is_array($entityAlias) && empty($entityAlias))) {
            unset($this->EntityAlias);
        } else {
            $this->EntityAlias = $entityAlias;
        }
        return $this;
    }
}
