<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RenderSingleDocumentRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RenderSingleDocumentRequest
 * @subpackage Structs
 */
class RenderSingleDocumentRequest extends AbstractStructBase
{
    /**
     * The DataEntities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfRenderedDocumentDataEntity
     */
    public $DataEntities;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentId;
    /**
     * The RenderingCultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RenderingCultureId;
    /**
     * The RenderingFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RenderingFormat;
    /**
     * Constructor method for RenderSingleDocumentRequest
     * @uses RenderSingleDocumentRequest::setDataEntities()
     * @uses RenderSingleDocumentRequest::setDocumentId()
     * @uses RenderSingleDocumentRequest::setRenderingCultureId()
     * @uses RenderSingleDocumentRequest::setRenderingFormat()
     * @param \patest\ArrayType\ArrayOfRenderedDocumentDataEntity $dataEntities
     * @param string $documentId
     * @param int $renderingCultureId
     * @param string $renderingFormat
     */
    public function __construct(\patest\ArrayType\ArrayOfRenderedDocumentDataEntity $dataEntities = null, $documentId = null, $renderingCultureId = null, $renderingFormat = null)
    {
        $this
            ->setDataEntities($dataEntities)
            ->setDocumentId($documentId)
            ->setRenderingCultureId($renderingCultureId)
            ->setRenderingFormat($renderingFormat);
    }
    /**
     * Get DataEntities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfRenderedDocumentDataEntity|null
     */
    public function getDataEntities()
    {
        return isset($this->DataEntities) ? $this->DataEntities : null;
    }
    /**
     * Set DataEntities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfRenderedDocumentDataEntity $dataEntities
     * @return \patest\StructType\RenderSingleDocumentRequest
     */
    public function setDataEntities(\patest\ArrayType\ArrayOfRenderedDocumentDataEntity $dataEntities = null)
    {
        if (is_null($dataEntities) || (is_array($dataEntities) && empty($dataEntities))) {
            unset($this->DataEntities);
        } else {
            $this->DataEntities = $dataEntities;
        }
        return $this;
    }
    /**
     * Get DocumentId value
     * @return string|null
     */
    public function getDocumentId()
    {
        return $this->DocumentId;
    }
    /**
     * Set DocumentId value
     * @param string $documentId
     * @return \patest\StructType\RenderSingleDocumentRequest
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentId, true)), __LINE__);
        }
        $this->DocumentId = $documentId;
        return $this;
    }
    /**
     * Get RenderingCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRenderingCultureId()
    {
        return isset($this->RenderingCultureId) ? $this->RenderingCultureId : null;
    }
    /**
     * Set RenderingCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $renderingCultureId
     * @return \patest\StructType\RenderSingleDocumentRequest
     */
    public function setRenderingCultureId($renderingCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($renderingCultureId) && !(is_int($renderingCultureId) || ctype_digit($renderingCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($renderingCultureId, true), gettype($renderingCultureId)), __LINE__);
        }
        if (is_null($renderingCultureId) || (is_array($renderingCultureId) && empty($renderingCultureId))) {
            unset($this->RenderingCultureId);
        } else {
            $this->RenderingCultureId = $renderingCultureId;
        }
        return $this;
    }
    /**
     * Get RenderingFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenderingFormat()
    {
        return isset($this->RenderingFormat) ? $this->RenderingFormat : null;
    }
    /**
     * Set RenderingFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renderingFormat
     * @return \patest\StructType\RenderSingleDocumentRequest
     */
    public function setRenderingFormat($renderingFormat = null)
    {
        // validation for constraint: string
        if (!is_null($renderingFormat) && !is_string($renderingFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renderingFormat, true), gettype($renderingFormat)), __LINE__);
        }
        if (is_null($renderingFormat) || (is_array($renderingFormat) && empty($renderingFormat))) {
            unset($this->RenderingFormat);
        } else {
            $this->RenderingFormat = $renderingFormat;
        }
        return $this;
    }
}
