<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveCustomSeatPricesRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RemoveCustomSeatPricesRequest
 * @subpackage Structs
 */
class RemoveCustomSeatPricesRequest extends CustomSeatPricesRequest
{
    /**
     * The EntireEventOrArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventAndArea
     */
    public $EntireEventOrArea;
    /**
     * The Seats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSeatInArea
     */
    public $Seats;
    /**
     * The SkipSeatsExistenceValidation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SkipSeatsExistenceValidation;
    /**
     * Constructor method for RemoveCustomSeatPricesRequest
     * @uses RemoveCustomSeatPricesRequest::setEntireEventOrArea()
     * @uses RemoveCustomSeatPricesRequest::setSeats()
     * @uses RemoveCustomSeatPricesRequest::setSkipSeatsExistenceValidation()
     * @param \patest\StructType\EventAndArea $entireEventOrArea
     * @param \patest\ArrayType\ArrayOfSeatInArea $seats
     * @param bool $skipSeatsExistenceValidation
     */
    public function __construct(\patest\StructType\EventAndArea $entireEventOrArea = null, \patest\ArrayType\ArrayOfSeatInArea $seats = null, $skipSeatsExistenceValidation = null)
    {
        $this
            ->setEntireEventOrArea($entireEventOrArea)
            ->setSeats($seats)
            ->setSkipSeatsExistenceValidation($skipSeatsExistenceValidation);
    }
    /**
     * Get EntireEventOrArea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventAndArea|null
     */
    public function getEntireEventOrArea()
    {
        return isset($this->EntireEventOrArea) ? $this->EntireEventOrArea : null;
    }
    /**
     * Set EntireEventOrArea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventAndArea $entireEventOrArea
     * @return \patest\StructType\RemoveCustomSeatPricesRequest
     */
    public function setEntireEventOrArea(\patest\StructType\EventAndArea $entireEventOrArea = null)
    {
        if (is_null($entireEventOrArea) || (is_array($entireEventOrArea) && empty($entireEventOrArea))) {
            unset($this->EntireEventOrArea);
        } else {
            $this->EntireEventOrArea = $entireEventOrArea;
        }
        return $this;
    }
    /**
     * Get Seats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSeatInArea|null
     */
    public function getSeats()
    {
        return isset($this->Seats) ? $this->Seats : null;
    }
    /**
     * Set Seats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSeatInArea $seats
     * @return \patest\StructType\RemoveCustomSeatPricesRequest
     */
    public function setSeats(\patest\ArrayType\ArrayOfSeatInArea $seats = null)
    {
        if (is_null($seats) || (is_array($seats) && empty($seats))) {
            unset($this->Seats);
        } else {
            $this->Seats = $seats;
        }
        return $this;
    }
    /**
     * Get SkipSeatsExistenceValidation value
     * @return bool|null
     */
    public function getSkipSeatsExistenceValidation()
    {
        return $this->SkipSeatsExistenceValidation;
    }
    /**
     * Set SkipSeatsExistenceValidation value
     * @param bool $skipSeatsExistenceValidation
     * @return \patest\StructType\RemoveCustomSeatPricesRequest
     */
    public function setSkipSeatsExistenceValidation($skipSeatsExistenceValidation = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipSeatsExistenceValidation) && !is_bool($skipSeatsExistenceValidation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipSeatsExistenceValidation, true), gettype($skipSeatsExistenceValidation)), __LINE__);
        }
        $this->SkipSeatsExistenceValidation = $skipSeatsExistenceValidation;
        return $this;
    }
}
