<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemoveClientTypeFromClientsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RemoveClientTypeFromClientsRequest
 * @subpackage Structs
 */
class RemoveClientTypeFromClientsRequest extends AbstractStructBase
{
    /**
     * The ClientIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ClientIds;
    /**
     * The ClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientTypeId;
    /**
     * Constructor method for RemoveClientTypeFromClientsRequest
     * @uses RemoveClientTypeFromClientsRequest::setClientIds()
     * @uses RemoveClientTypeFromClientsRequest::setClientTypeId()
     * @param \patest\ArrayType\ArrayOfguid $clientIds
     * @param string $clientTypeId
     */
    public function __construct(\patest\ArrayType\ArrayOfguid $clientIds = null, $clientTypeId = null)
    {
        $this
            ->setClientIds($clientIds)
            ->setClientTypeId($clientTypeId);
    }
    /**
     * Get ClientIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getClientIds()
    {
        return isset($this->ClientIds) ? $this->ClientIds : null;
    }
    /**
     * Set ClientIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $clientIds
     * @return \patest\StructType\RemoveClientTypeFromClientsRequest
     */
    public function setClientIds(\patest\ArrayType\ArrayOfguid $clientIds = null)
    {
        if (is_null($clientIds) || (is_array($clientIds) && empty($clientIds))) {
            unset($this->ClientIds);
        } else {
            $this->ClientIds = $clientIds;
        }
        return $this;
    }
    /**
     * Get ClientTypeId value
     * @return string|null
     */
    public function getClientTypeId()
    {
        return $this->ClientTypeId;
    }
    /**
     * Set ClientTypeId value
     * @param string $clientTypeId
     * @return \patest\StructType\RemoveClientTypeFromClientsRequest
     */
    public function setClientTypeId($clientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypeId) && !is_string($clientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypeId, true), gettype($clientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientTypeId, true)), __LINE__);
        }
        $this->ClientTypeId = $clientTypeId;
        return $this;
    }
}
