<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RelativeTime StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RelativeTime
 * @subpackage Structs
 */
class RelativeTime extends AbstractStructBase
{
    /**
     * The SpecificDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecificDate;
    /**
     * The TimeDelta
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $TimeDelta;
    /**
     * The When
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $When;
    /**
     * Constructor method for RelativeTime
     * @uses RelativeTime::setSpecificDate()
     * @uses RelativeTime::setTimeDelta()
     * @uses RelativeTime::setWhen()
     * @param string $specificDate
     * @param string $timeDelta
     * @param string $when
     */
    public function __construct($specificDate = null, $timeDelta = null, $when = null)
    {
        $this
            ->setSpecificDate($specificDate)
            ->setTimeDelta($timeDelta)
            ->setWhen($when);
    }
    /**
     * Get SpecificDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificDate()
    {
        return isset($this->SpecificDate) ? $this->SpecificDate : null;
    }
    /**
     * Set SpecificDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificDate
     * @return \patest\StructType\RelativeTime
     */
    public function setSpecificDate($specificDate = null)
    {
        // validation for constraint: string
        if (!is_null($specificDate) && !is_string($specificDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificDate, true), gettype($specificDate)), __LINE__);
        }
        if (is_null($specificDate) || (is_array($specificDate) && empty($specificDate))) {
            unset($this->SpecificDate);
        } else {
            $this->SpecificDate = $specificDate;
        }
        return $this;
    }
    /**
     * Get TimeDelta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTimeDelta()
    {
        return isset($this->TimeDelta) ? $this->TimeDelta : null;
    }
    /**
     * Set TimeDelta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $timeDelta
     * @return \patest\StructType\RelativeTime
     */
    public function setTimeDelta($timeDelta = null)
    {
        // validation for constraint: string
        if (!is_null($timeDelta) && !is_string($timeDelta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeDelta, true), gettype($timeDelta)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($timeDelta) && false === mb_strpos($timeDelta, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $timeDelta)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($timeDelta, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($timeDelta) && false !== mb_strpos($timeDelta, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $timeDelta)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($timeDelta, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($timeDelta) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $timeDelta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($timeDelta, true)), __LINE__);
        }
        if (is_null($timeDelta) || (is_array($timeDelta) && empty($timeDelta))) {
            unset($this->TimeDelta);
        } else {
            $this->TimeDelta = $timeDelta;
        }
        return $this;
    }
    /**
     * Get When value
     * @return string|null
     */
    public function getWhen()
    {
        return $this->When;
    }
    /**
     * Set When value
     * @uses \patest\EnumType\RelativeTimeType::valueIsValid()
     * @uses \patest\EnumType\RelativeTimeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $when
     * @return \patest\StructType\RelativeTime
     */
    public function setWhen($when = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RelativeTimeType::valueIsValid($when)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RelativeTimeType', is_array($when) ? implode(', ', $when) : var_export($when, true), implode(', ', \patest\EnumType\RelativeTimeType::getValidValues())), __LINE__);
        }
        $this->When = $when;
        return $this;
    }
}
