<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RecordSetOfAccessControl.SaleItemAccessCardInformation
 * StructType
 * @subpackage Structs
 */
class RecordSetOfAccessControl_SaleItemAccessCardInformation extends AbstractStructBase
{
    /**
     * The Record
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AccessControl_SaleItemAccessCardInformation[]
     */
    public $Record;
    /**
     * Constructor method for RecordSetOfAccessControl.SaleItemAccessCardInformation
     * @uses RecordSetOfAccessControl_SaleItemAccessCardInformation::setRecord()
     * @param \patest\StructType\AccessControl_SaleItemAccessCardInformation[] $record
     */
    public function __construct(array $record = array())
    {
        $this
            ->setRecord($record);
    }
    /**
     * Get Record value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AccessControl_SaleItemAccessCardInformation[]|null
     */
    public function getRecord()
    {
        return isset($this->Record) ? $this->Record : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRecord method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRecord method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRecordForArrayConstraintsFromSetRecord(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $recordSetOfAccessControl_SaleItemAccessCardInformationRecordItem) {
            // validation for constraint: itemType
            if (!$recordSetOfAccessControl_SaleItemAccessCardInformationRecordItem instanceof \patest\StructType\AccessControl_SaleItemAccessCardInformation) {
                $invalidValues[] = is_object($recordSetOfAccessControl_SaleItemAccessCardInformationRecordItem) ? get_class($recordSetOfAccessControl_SaleItemAccessCardInformationRecordItem) : sprintf('%s(%s)', gettype($recordSetOfAccessControl_SaleItemAccessCardInformationRecordItem), var_export($recordSetOfAccessControl_SaleItemAccessCardInformationRecordItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Record property can only contain items of type \patest\StructType\AccessControl_SaleItemAccessCardInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Record value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \patest\StructType\AccessControl_SaleItemAccessCardInformation[] $record
     * @return \patest\StructType\RecordSetOfAccessControl_SaleItemAccessCardInformation
     */
    public function setRecord(array $record = array())
    {
        // validation for constraint: array
        if ('' !== ($recordArrayErrorMessage = self::validateRecordForArrayConstraintsFromSetRecord($record))) {
            throw new \InvalidArgumentException($recordArrayErrorMessage, __LINE__);
        }
        if (is_null($record) || (is_array($record) && empty($record))) {
            unset($this->Record);
        } else {
            $this->Record = $record;
        }
        return $this;
    }
    /**
     * Add item to Record value
     * @throws \InvalidArgumentException
     * @param \patest\StructType\AccessControl_SaleItemAccessCardInformation $item
     * @return \patest\StructType\RecordSetOfAccessControl_SaleItemAccessCardInformation
     */
    public function addToRecord(\patest\StructType\AccessControl_SaleItemAccessCardInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \patest\StructType\AccessControl_SaleItemAccessCardInformation) {
            throw new \InvalidArgumentException(sprintf('The Record property can only contain items of type \patest\StructType\AccessControl_SaleItemAccessCardInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Record[] = $item;
        return $this;
    }
}
