<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReLockTickets-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReLockTickets-Request
 * @subpackage Structs
 */
class ReLockTickets_Request extends ExtensibleDataContract
{
    /**
     * The NewLockId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewLockId;
    /**
     * The Tickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTicketItem
     */
    public $Tickets;
    /**
     * Constructor method for ReLockTickets-Request
     * @uses ReLockTickets_Request::setNewLockId()
     * @uses ReLockTickets_Request::setTickets()
     * @param string $newLockId
     * @param \patest\ArrayType\ArrayOfTicketItem $tickets
     */
    public function __construct($newLockId = null, \patest\ArrayType\ArrayOfTicketItem $tickets = null)
    {
        $this
            ->setNewLockId($newLockId)
            ->setTickets($tickets);
    }
    /**
     * Get NewLockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewLockId()
    {
        return isset($this->NewLockId) ? $this->NewLockId : null;
    }
    /**
     * Set NewLockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newLockId
     * @return \patest\StructType\ReLockTickets_Request
     */
    public function setNewLockId($newLockId = null)
    {
        // validation for constraint: string
        if (!is_null($newLockId) && !is_string($newLockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newLockId, true), gettype($newLockId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newLockId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newLockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newLockId, true)), __LINE__);
        }
        if (is_null($newLockId) || (is_array($newLockId) && empty($newLockId))) {
            unset($this->NewLockId);
        } else {
            $this->NewLockId = $newLockId;
        }
        return $this;
    }
    /**
     * Get Tickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTicketItem|null
     */
    public function getTickets()
    {
        return isset($this->Tickets) ? $this->Tickets : null;
    }
    /**
     * Set Tickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTicketItem $tickets
     * @return \patest\StructType\ReLockTickets_Request
     */
    public function setTickets(\patest\ArrayType\ArrayOfTicketItem $tickets = null)
    {
        if (is_null($tickets) || (is_array($tickets) && empty($tickets))) {
            unset($this->Tickets);
        } else {
            $this->Tickets = $tickets;
        }
        return $this;
    }
}
