<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryTransaction-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryTransaction-Response
 * @subpackage Structs
 */
class QueryTransaction_Response extends ExtensibleDataContract
{
    /**
     * The ContinuedItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfTransactionItem
     */
    public $ContinuedItems;
    /**
     * The TransactionSnapshot
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionSnapshot
     */
    public $TransactionSnapshot;
    /**
     * Constructor method for QueryTransaction-Response
     * @uses QueryTransaction_Response::setContinuedItems()
     * @uses QueryTransaction_Response::setTransactionSnapshot()
     * @param \patest\ArrayType\ArrayOfTransactionItem $continuedItems
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     */
    public function __construct(\patest\ArrayType\ArrayOfTransactionItem $continuedItems = null, \patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        $this
            ->setContinuedItems($continuedItems)
            ->setTransactionSnapshot($transactionSnapshot);
    }
    /**
     * Get ContinuedItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfTransactionItem|null
     */
    public function getContinuedItems()
    {
        return isset($this->ContinuedItems) ? $this->ContinuedItems : null;
    }
    /**
     * Set ContinuedItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfTransactionItem $continuedItems
     * @return \patest\StructType\QueryTransaction_Response
     */
    public function setContinuedItems(\patest\ArrayType\ArrayOfTransactionItem $continuedItems = null)
    {
        if (is_null($continuedItems) || (is_array($continuedItems) && empty($continuedItems))) {
            unset($this->ContinuedItems);
        } else {
            $this->ContinuedItems = $continuedItems;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshot value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionSnapshot|null
     */
    public function getTransactionSnapshot()
    {
        return isset($this->TransactionSnapshot) ? $this->TransactionSnapshot : null;
    }
    /**
     * Set TransactionSnapshot value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionSnapshot $transactionSnapshot
     * @return \patest\StructType\QueryTransaction_Response
     */
    public function setTransactionSnapshot(\patest\StructType\TransactionSnapshot $transactionSnapshot = null)
    {
        if (is_null($transactionSnapshot) || (is_array($transactionSnapshot) && empty($transactionSnapshot))) {
            unset($this->TransactionSnapshot);
        } else {
            $this->TransactionSnapshot = $transactionSnapshot;
        }
        return $this;
    }
}
