<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryMultipleSeatingPlansAvailabilityRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryMultipleSeatingPlansAvailabilityRequest
 * @subpackage Structs
 */
class QueryMultipleSeatingPlansAvailabilityRequest extends ExtensibleDataContract
{
    /**
     * The AccessContext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatingPlanAccessContext
     */
    public $AccessContext;
    /**
     * The IsConvertSeriesPartiallyAvailableSeatsIntoUnavailable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsConvertSeriesPartiallyAvailableSeatsIntoUnavailable;
    /**
     * The IsSkipSeatingPlansWithoutStatistics
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsSkipSeatingPlansWithoutStatistics;
    /**
     * The SeatingPlanRequests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfQuerySeatingPlanAvailabilityRequest
     */
    public $SeatingPlanRequests;
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SessionId;
    /**
     * The EffectiveAvailabilityFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterIdentification
     */
    public $EffectiveAvailabilityFilter;
    /**
     * The CanReturnErrors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanReturnErrors;
    /**
     * Constructor method for QueryMultipleSeatingPlansAvailabilityRequest
     * @uses QueryMultipleSeatingPlansAvailabilityRequest::setAccessContext()
     * @uses QueryMultipleSeatingPlansAvailabilityRequest::setIsConvertSeriesPartiallyAvailableSeatsIntoUnavailable()
     * @uses QueryMultipleSeatingPlansAvailabilityRequest::setIsSkipSeatingPlansWithoutStatistics()
     * @uses QueryMultipleSeatingPlansAvailabilityRequest::setSeatingPlanRequests()
     * @uses QueryMultipleSeatingPlansAvailabilityRequest::setSessionId()
     * @uses QueryMultipleSeatingPlansAvailabilityRequest::setEffectiveAvailabilityFilter()
     * @uses QueryMultipleSeatingPlansAvailabilityRequest::setCanReturnErrors()
     * @param \patest\StructType\SeatingPlanAccessContext $accessContext
     * @param bool $isConvertSeriesPartiallyAvailableSeatsIntoUnavailable
     * @param bool $isSkipSeatingPlansWithoutStatistics
     * @param \patest\ArrayType\ArrayOfQuerySeatingPlanAvailabilityRequest $seatingPlanRequests
     * @param string $sessionId
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @param bool $canReturnErrors
     */
    public function __construct(\patest\StructType\SeatingPlanAccessContext $accessContext = null, $isConvertSeriesPartiallyAvailableSeatsIntoUnavailable = null, $isSkipSeatingPlansWithoutStatistics = null, \patest\ArrayType\ArrayOfQuerySeatingPlanAvailabilityRequest $seatingPlanRequests = null, $sessionId = null, \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null, $canReturnErrors = null)
    {
        $this
            ->setAccessContext($accessContext)
            ->setIsConvertSeriesPartiallyAvailableSeatsIntoUnavailable($isConvertSeriesPartiallyAvailableSeatsIntoUnavailable)
            ->setIsSkipSeatingPlansWithoutStatistics($isSkipSeatingPlansWithoutStatistics)
            ->setSeatingPlanRequests($seatingPlanRequests)
            ->setSessionId($sessionId)
            ->setEffectiveAvailabilityFilter($effectiveAvailabilityFilter)
            ->setCanReturnErrors($canReturnErrors);
    }
    /**
     * Get AccessContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatingPlanAccessContext|null
     */
    public function getAccessContext()
    {
        return isset($this->AccessContext) ? $this->AccessContext : null;
    }
    /**
     * Set AccessContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatingPlanAccessContext $accessContext
     * @return \patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest
     */
    public function setAccessContext(\patest\StructType\SeatingPlanAccessContext $accessContext = null)
    {
        if (is_null($accessContext) || (is_array($accessContext) && empty($accessContext))) {
            unset($this->AccessContext);
        } else {
            $this->AccessContext = $accessContext;
        }
        return $this;
    }
    /**
     * Get IsConvertSeriesPartiallyAvailableSeatsIntoUnavailable value
     * @return bool|null
     */
    public function getIsConvertSeriesPartiallyAvailableSeatsIntoUnavailable()
    {
        return $this->IsConvertSeriesPartiallyAvailableSeatsIntoUnavailable;
    }
    /**
     * Set IsConvertSeriesPartiallyAvailableSeatsIntoUnavailable value
     * @param bool $isConvertSeriesPartiallyAvailableSeatsIntoUnavailable
     * @return \patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest
     */
    public function setIsConvertSeriesPartiallyAvailableSeatsIntoUnavailable($isConvertSeriesPartiallyAvailableSeatsIntoUnavailable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConvertSeriesPartiallyAvailableSeatsIntoUnavailable) && !is_bool($isConvertSeriesPartiallyAvailableSeatsIntoUnavailable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConvertSeriesPartiallyAvailableSeatsIntoUnavailable, true), gettype($isConvertSeriesPartiallyAvailableSeatsIntoUnavailable)), __LINE__);
        }
        $this->IsConvertSeriesPartiallyAvailableSeatsIntoUnavailable = $isConvertSeriesPartiallyAvailableSeatsIntoUnavailable;
        return $this;
    }
    /**
     * Get IsSkipSeatingPlansWithoutStatistics value
     * @return bool|null
     */
    public function getIsSkipSeatingPlansWithoutStatistics()
    {
        return $this->IsSkipSeatingPlansWithoutStatistics;
    }
    /**
     * Set IsSkipSeatingPlansWithoutStatistics value
     * @param bool $isSkipSeatingPlansWithoutStatistics
     * @return \patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest
     */
    public function setIsSkipSeatingPlansWithoutStatistics($isSkipSeatingPlansWithoutStatistics = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSkipSeatingPlansWithoutStatistics) && !is_bool($isSkipSeatingPlansWithoutStatistics)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSkipSeatingPlansWithoutStatistics, true), gettype($isSkipSeatingPlansWithoutStatistics)), __LINE__);
        }
        $this->IsSkipSeatingPlansWithoutStatistics = $isSkipSeatingPlansWithoutStatistics;
        return $this;
    }
    /**
     * Get SeatingPlanRequests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfQuerySeatingPlanAvailabilityRequest|null
     */
    public function getSeatingPlanRequests()
    {
        return isset($this->SeatingPlanRequests) ? $this->SeatingPlanRequests : null;
    }
    /**
     * Set SeatingPlanRequests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfQuerySeatingPlanAvailabilityRequest $seatingPlanRequests
     * @return \patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest
     */
    public function setSeatingPlanRequests(\patest\ArrayType\ArrayOfQuerySeatingPlanAvailabilityRequest $seatingPlanRequests = null)
    {
        if (is_null($seatingPlanRequests) || (is_array($seatingPlanRequests) && empty($seatingPlanRequests))) {
            unset($this->SeatingPlanRequests);
        } else {
            $this->SeatingPlanRequests = $seatingPlanRequests;
        }
        return $this;
    }
    /**
     * Get SessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionId()
    {
        return isset($this->SessionId) ? $this->SessionId : null;
    }
    /**
     * Set SessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionId
     * @return \patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sessionId, true)), __LINE__);
        }
        if (is_null($sessionId) || (is_array($sessionId) && empty($sessionId))) {
            unset($this->SessionId);
        } else {
            $this->SessionId = $sessionId;
        }
        return $this;
    }
    /**
     * Get EffectiveAvailabilityFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterIdentification|null
     */
    public function getEffectiveAvailabilityFilter()
    {
        return isset($this->EffectiveAvailabilityFilter) ? $this->EffectiveAvailabilityFilter : null;
    }
    /**
     * Set EffectiveAvailabilityFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @return \patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest
     */
    public function setEffectiveAvailabilityFilter(\patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null)
    {
        if (is_null($effectiveAvailabilityFilter) || (is_array($effectiveAvailabilityFilter) && empty($effectiveAvailabilityFilter))) {
            unset($this->EffectiveAvailabilityFilter);
        } else {
            $this->EffectiveAvailabilityFilter = $effectiveAvailabilityFilter;
        }
        return $this;
    }
    /**
     * Get CanReturnErrors value
     * @return bool|null
     */
    public function getCanReturnErrors()
    {
        return $this->CanReturnErrors;
    }
    /**
     * Set CanReturnErrors value
     * @param bool $canReturnErrors
     * @return \patest\StructType\QueryMultipleSeatingPlansAvailabilityRequest
     */
    public function setCanReturnErrors($canReturnErrors = null)
    {
        // validation for constraint: boolean
        if (!is_null($canReturnErrors) && !is_bool($canReturnErrors)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canReturnErrors, true), gettype($canReturnErrors)), __LINE__);
        }
        $this->CanReturnErrors = $canReturnErrors;
        return $this;
    }
}
