<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PublishEsroEventRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PublishEsroEventRequest
 * @subpackage Structs
 */
class PublishEsroEventRequest extends AbstractStructBase
{
    /**
     * The EventArgs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EsroPubSubEventArgs
     */
    public $EventArgs;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventName;
    /**
     * Constructor method for PublishEsroEventRequest
     * @uses PublishEsroEventRequest::setEventArgs()
     * @uses PublishEsroEventRequest::setEventName()
     * @param \patest\StructType\EsroPubSubEventArgs $eventArgs
     * @param string $eventName
     */
    public function __construct(\patest\StructType\EsroPubSubEventArgs $eventArgs = null, $eventName = null)
    {
        $this
            ->setEventArgs($eventArgs)
            ->setEventName($eventName);
    }
    /**
     * Get EventArgs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EsroPubSubEventArgs|null
     */
    public function getEventArgs()
    {
        return isset($this->EventArgs) ? $this->EventArgs : null;
    }
    /**
     * Set EventArgs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EsroPubSubEventArgs $eventArgs
     * @return \patest\StructType\PublishEsroEventRequest
     */
    public function setEventArgs(\patest\StructType\EsroPubSubEventArgs $eventArgs = null)
    {
        if (is_null($eventArgs) || (is_array($eventArgs) && empty($eventArgs))) {
            unset($this->EventArgs);
        } else {
            $this->EventArgs = $eventArgs;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventName
     * @return \patest\StructType\PublishEsroEventRequest
     */
    public function setEventName($eventName = null)
    {
        // validation for constraint: string
        if (!is_null($eventName) && !is_string($eventName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventName, true), gettype($eventName)), __LINE__);
        }
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
}
