<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProcessFilter StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProcessFilter
 * @subpackage Structs
 */
class ProcessFilter extends AbstractStructBase
{
    /**
     * The DeclarationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeclarationName;
    /**
     * The DefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefinitionId;
    /**
     * The DefinitionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefinitionName;
    /**
     * The InstanceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $InstanceId;
    /**
     * The InstanceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstanceName;
    /**
     * The IsAutoStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAutoStart;
    /**
     * Constructor method for ProcessFilter
     * @uses ProcessFilter::setDeclarationName()
     * @uses ProcessFilter::setDefinitionId()
     * @uses ProcessFilter::setDefinitionName()
     * @uses ProcessFilter::setInstanceId()
     * @uses ProcessFilter::setInstanceName()
     * @uses ProcessFilter::setIsAutoStart()
     * @param string $declarationName
     * @param string $definitionId
     * @param string $definitionName
     * @param int $instanceId
     * @param string $instanceName
     * @param bool $isAutoStart
     */
    public function __construct($declarationName = null, $definitionId = null, $definitionName = null, $instanceId = null, $instanceName = null, $isAutoStart = null)
    {
        $this
            ->setDeclarationName($declarationName)
            ->setDefinitionId($definitionId)
            ->setDefinitionName($definitionName)
            ->setInstanceId($instanceId)
            ->setInstanceName($instanceName)
            ->setIsAutoStart($isAutoStart);
    }
    /**
     * Get DeclarationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeclarationName()
    {
        return isset($this->DeclarationName) ? $this->DeclarationName : null;
    }
    /**
     * Set DeclarationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $declarationName
     * @return \patest\StructType\ProcessFilter
     */
    public function setDeclarationName($declarationName = null)
    {
        // validation for constraint: string
        if (!is_null($declarationName) && !is_string($declarationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($declarationName, true), gettype($declarationName)), __LINE__);
        }
        if (is_null($declarationName) || (is_array($declarationName) && empty($declarationName))) {
            unset($this->DeclarationName);
        } else {
            $this->DeclarationName = $declarationName;
        }
        return $this;
    }
    /**
     * Get DefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinitionId()
    {
        return isset($this->DefinitionId) ? $this->DefinitionId : null;
    }
    /**
     * Set DefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definitionId
     * @return \patest\StructType\ProcessFilter
     */
    public function setDefinitionId($definitionId = null)
    {
        // validation for constraint: string
        if (!is_null($definitionId) && !is_string($definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionId, true), gettype($definitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($definitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $definitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($definitionId, true)), __LINE__);
        }
        if (is_null($definitionId) || (is_array($definitionId) && empty($definitionId))) {
            unset($this->DefinitionId);
        } else {
            $this->DefinitionId = $definitionId;
        }
        return $this;
    }
    /**
     * Get DefinitionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefinitionName()
    {
        return isset($this->DefinitionName) ? $this->DefinitionName : null;
    }
    /**
     * Set DefinitionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $definitionName
     * @return \patest\StructType\ProcessFilter
     */
    public function setDefinitionName($definitionName = null)
    {
        // validation for constraint: string
        if (!is_null($definitionName) && !is_string($definitionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($definitionName, true), gettype($definitionName)), __LINE__);
        }
        if (is_null($definitionName) || (is_array($definitionName) && empty($definitionName))) {
            unset($this->DefinitionName);
        } else {
            $this->DefinitionName = $definitionName;
        }
        return $this;
    }
    /**
     * Get InstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstanceId()
    {
        return isset($this->InstanceId) ? $this->InstanceId : null;
    }
    /**
     * Set InstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $instanceId
     * @return \patest\StructType\ProcessFilter
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: int
        if (!is_null($instanceId) && !(is_int($instanceId) || ctype_digit($instanceId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($instanceId, true), gettype($instanceId)), __LINE__);
        }
        if (is_null($instanceId) || (is_array($instanceId) && empty($instanceId))) {
            unset($this->InstanceId);
        } else {
            $this->InstanceId = $instanceId;
        }
        return $this;
    }
    /**
     * Get InstanceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstanceName()
    {
        return isset($this->InstanceName) ? $this->InstanceName : null;
    }
    /**
     * Set InstanceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instanceName
     * @return \patest\StructType\ProcessFilter
     */
    public function setInstanceName($instanceName = null)
    {
        // validation for constraint: string
        if (!is_null($instanceName) && !is_string($instanceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceName, true), gettype($instanceName)), __LINE__);
        }
        if (is_null($instanceName) || (is_array($instanceName) && empty($instanceName))) {
            unset($this->InstanceName);
        } else {
            $this->InstanceName = $instanceName;
        }
        return $this;
    }
    /**
     * Get IsAutoStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAutoStart()
    {
        return isset($this->IsAutoStart) ? $this->IsAutoStart : null;
    }
    /**
     * Set IsAutoStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAutoStart
     * @return \patest\StructType\ProcessFilter
     */
    public function setIsAutoStart($isAutoStart = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoStart) && !is_bool($isAutoStart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoStart, true), gettype($isAutoStart)), __LINE__);
        }
        if (is_null($isAutoStart) || (is_array($isAutoStart) && empty($isAutoStart))) {
            unset($this->IsAutoStart);
        } else {
            $this->IsAutoStart = $isAutoStart;
        }
        return $this;
    }
}
