<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.Sales.PriceModifier StructType
 * @subpackage Structs
 */
class Printing_Sales_PriceModifier extends Printing_Item_ComplexProperty_Base
{
    /**
     * The BaseAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $BaseAmount;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The EffectiveAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $EffectiveAmount;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionMode;
    /**
     * The IsEffective
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEffective;
    /**
     * The IsIncluded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsIncluded;
    /**
     * The IsPartOfFacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartOfFacePrice;
    /**
     * The IsSubscriptionSourcedCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscriptionSourcedCommission;
    /**
     * The Master
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Master;
    /**
     * The Origin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Origin;
    /**
     * The PayEffectiveness
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayEffectiveness;
    /**
     * The PriceModifierDefinition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_Sales_PriceModifiersDefinitionInfo
     */
    public $PriceModifierDefinition;
    /**
     * The SourceAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SourceAmount;
    /**
     * The SystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SystemName;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Type;
    /**
     * Constructor method for Printing.Sales.PriceModifier
     * @uses Printing_Sales_PriceModifier::setBaseAmount()
     * @uses Printing_Sales_PriceModifier::setDescription()
     * @uses Printing_Sales_PriceModifier::setEffectiveAmount()
     * @uses Printing_Sales_PriceModifier::setInsertionMode()
     * @uses Printing_Sales_PriceModifier::setIsEffective()
     * @uses Printing_Sales_PriceModifier::setIsIncluded()
     * @uses Printing_Sales_PriceModifier::setIsPartOfFacePrice()
     * @uses Printing_Sales_PriceModifier::setIsSubscriptionSourcedCommission()
     * @uses Printing_Sales_PriceModifier::setMaster()
     * @uses Printing_Sales_PriceModifier::setOrigin()
     * @uses Printing_Sales_PriceModifier::setPayEffectiveness()
     * @uses Printing_Sales_PriceModifier::setPriceModifierDefinition()
     * @uses Printing_Sales_PriceModifier::setSourceAmount()
     * @uses Printing_Sales_PriceModifier::setSystemName()
     * @uses Printing_Sales_PriceModifier::setTotalAmount()
     * @uses Printing_Sales_PriceModifier::setType()
     * @param \patest\StructType\Money $baseAmount
     * @param \patest\StructType\GlobalString $description
     * @param \patest\StructType\Money $effectiveAmount
     * @param string $insertionMode
     * @param bool $isEffective
     * @param bool $isIncluded
     * @param bool $isPartOfFacePrice
     * @param bool $isSubscriptionSourcedCommission
     * @param int $master
     * @param string $origin
     * @param string $payEffectiveness
     * @param \patest\StructType\Printing_Sales_PriceModifiersDefinitionInfo $priceModifierDefinition
     * @param \patest\StructType\Money $sourceAmount
     * @param string $systemName
     * @param \patest\StructType\Money $totalAmount
     * @param int $type
     */
    public function __construct(\patest\StructType\Money $baseAmount = null, \patest\StructType\GlobalString $description = null, \patest\StructType\Money $effectiveAmount = null, $insertionMode = null, $isEffective = null, $isIncluded = null, $isPartOfFacePrice = null, $isSubscriptionSourcedCommission = null, $master = null, $origin = null, $payEffectiveness = null, \patest\StructType\Printing_Sales_PriceModifiersDefinitionInfo $priceModifierDefinition = null, \patest\StructType\Money $sourceAmount = null, $systemName = null, \patest\StructType\Money $totalAmount = null, $type = null)
    {
        $this
            ->setBaseAmount($baseAmount)
            ->setDescription($description)
            ->setEffectiveAmount($effectiveAmount)
            ->setInsertionMode($insertionMode)
            ->setIsEffective($isEffective)
            ->setIsIncluded($isIncluded)
            ->setIsPartOfFacePrice($isPartOfFacePrice)
            ->setIsSubscriptionSourcedCommission($isSubscriptionSourcedCommission)
            ->setMaster($master)
            ->setOrigin($origin)
            ->setPayEffectiveness($payEffectiveness)
            ->setPriceModifierDefinition($priceModifierDefinition)
            ->setSourceAmount($sourceAmount)
            ->setSystemName($systemName)
            ->setTotalAmount($totalAmount)
            ->setType($type);
    }
    /**
     * Get BaseAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getBaseAmount()
    {
        return isset($this->BaseAmount) ? $this->BaseAmount : null;
    }
    /**
     * Set BaseAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $baseAmount
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setBaseAmount(\patest\StructType\Money $baseAmount = null)
    {
        if (is_null($baseAmount) || (is_array($baseAmount) && empty($baseAmount))) {
            unset($this->BaseAmount);
        } else {
            $this->BaseAmount = $baseAmount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EffectiveAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getEffectiveAmount()
    {
        return isset($this->EffectiveAmount) ? $this->EffectiveAmount : null;
    }
    /**
     * Set EffectiveAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $effectiveAmount
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setEffectiveAmount(\patest\StructType\Money $effectiveAmount = null)
    {
        if (is_null($effectiveAmount) || (is_array($effectiveAmount) && empty($effectiveAmount))) {
            unset($this->EffectiveAmount);
        } else {
            $this->EffectiveAmount = $effectiveAmount;
        }
        return $this;
    }
    /**
     * Get InsertionMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionMode()
    {
        return isset($this->InsertionMode) ? $this->InsertionMode : null;
    }
    /**
     * Set InsertionMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        if (is_null($insertionMode) || (is_array($insertionMode) && empty($insertionMode))) {
            unset($this->InsertionMode);
        } else {
            $this->InsertionMode = $insertionMode;
        }
        return $this;
    }
    /**
     * Get IsEffective value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEffective()
    {
        return isset($this->IsEffective) ? $this->IsEffective : null;
    }
    /**
     * Set IsEffective value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEffective
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setIsEffective($isEffective = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEffective) && !is_bool($isEffective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEffective, true), gettype($isEffective)), __LINE__);
        }
        if (is_null($isEffective) || (is_array($isEffective) && empty($isEffective))) {
            unset($this->IsEffective);
        } else {
            $this->IsEffective = $isEffective;
        }
        return $this;
    }
    /**
     * Get IsIncluded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsIncluded()
    {
        return isset($this->IsIncluded) ? $this->IsIncluded : null;
    }
    /**
     * Set IsIncluded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isIncluded
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setIsIncluded($isIncluded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isIncluded) && !is_bool($isIncluded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isIncluded, true), gettype($isIncluded)), __LINE__);
        }
        if (is_null($isIncluded) || (is_array($isIncluded) && empty($isIncluded))) {
            unset($this->IsIncluded);
        } else {
            $this->IsIncluded = $isIncluded;
        }
        return $this;
    }
    /**
     * Get IsPartOfFacePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartOfFacePrice()
    {
        return isset($this->IsPartOfFacePrice) ? $this->IsPartOfFacePrice : null;
    }
    /**
     * Set IsPartOfFacePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartOfFacePrice
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setIsPartOfFacePrice($isPartOfFacePrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartOfFacePrice) && !is_bool($isPartOfFacePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartOfFacePrice, true), gettype($isPartOfFacePrice)), __LINE__);
        }
        if (is_null($isPartOfFacePrice) || (is_array($isPartOfFacePrice) && empty($isPartOfFacePrice))) {
            unset($this->IsPartOfFacePrice);
        } else {
            $this->IsPartOfFacePrice = $isPartOfFacePrice;
        }
        return $this;
    }
    /**
     * Get IsSubscriptionSourcedCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscriptionSourcedCommission()
    {
        return isset($this->IsSubscriptionSourcedCommission) ? $this->IsSubscriptionSourcedCommission : null;
    }
    /**
     * Set IsSubscriptionSourcedCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscriptionSourcedCommission
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setIsSubscriptionSourcedCommission($isSubscriptionSourcedCommission = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriptionSourcedCommission) && !is_bool($isSubscriptionSourcedCommission)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriptionSourcedCommission, true), gettype($isSubscriptionSourcedCommission)), __LINE__);
        }
        if (is_null($isSubscriptionSourcedCommission) || (is_array($isSubscriptionSourcedCommission) && empty($isSubscriptionSourcedCommission))) {
            unset($this->IsSubscriptionSourcedCommission);
        } else {
            $this->IsSubscriptionSourcedCommission = $isSubscriptionSourcedCommission;
        }
        return $this;
    }
    /**
     * Get Master value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaster()
    {
        return isset($this->Master) ? $this->Master : null;
    }
    /**
     * Set Master value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $master
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setMaster($master = null)
    {
        // validation for constraint: int
        if (!is_null($master) && !(is_int($master) || ctype_digit($master))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($master, true), gettype($master)), __LINE__);
        }
        if (is_null($master) || (is_array($master) && empty($master))) {
            unset($this->Master);
        } else {
            $this->Master = $master;
        }
        return $this;
    }
    /**
     * Get Origin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigin()
    {
        return isset($this->Origin) ? $this->Origin : null;
    }
    /**
     * Set Origin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierOrigin::valueIsValid()
     * @uses \patest\EnumType\PriceModifierOrigin::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $origin
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setOrigin($origin = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierOrigin::valueIsValid($origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierOrigin', is_array($origin) ? implode(', ', $origin) : var_export($origin, true), implode(', ', \patest\EnumType\PriceModifierOrigin::getValidValues())), __LINE__);
        }
        if (is_null($origin) || (is_array($origin) && empty($origin))) {
            unset($this->Origin);
        } else {
            $this->Origin = $origin;
        }
        return $this;
    }
    /**
     * Get PayEffectiveness value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayEffectiveness()
    {
        return isset($this->PayEffectiveness) ? $this->PayEffectiveness : null;
    }
    /**
     * Set PayEffectiveness value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PriceModifierPayEffectiveness::valueIsValid()
     * @uses \patest\EnumType\PriceModifierPayEffectiveness::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payEffectiveness
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setPayEffectiveness($payEffectiveness = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PriceModifierPayEffectiveness::valueIsValid($payEffectiveness)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PriceModifierPayEffectiveness', is_array($payEffectiveness) ? implode(', ', $payEffectiveness) : var_export($payEffectiveness, true), implode(', ', \patest\EnumType\PriceModifierPayEffectiveness::getValidValues())), __LINE__);
        }
        if (is_null($payEffectiveness) || (is_array($payEffectiveness) && empty($payEffectiveness))) {
            unset($this->PayEffectiveness);
        } else {
            $this->PayEffectiveness = $payEffectiveness;
        }
        return $this;
    }
    /**
     * Get PriceModifierDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_Sales_PriceModifiersDefinitionInfo|null
     */
    public function getPriceModifierDefinition()
    {
        return isset($this->PriceModifierDefinition) ? $this->PriceModifierDefinition : null;
    }
    /**
     * Set PriceModifierDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_Sales_PriceModifiersDefinitionInfo $priceModifierDefinition
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setPriceModifierDefinition(\patest\StructType\Printing_Sales_PriceModifiersDefinitionInfo $priceModifierDefinition = null)
    {
        if (is_null($priceModifierDefinition) || (is_array($priceModifierDefinition) && empty($priceModifierDefinition))) {
            unset($this->PriceModifierDefinition);
        } else {
            $this->PriceModifierDefinition = $priceModifierDefinition;
        }
        return $this;
    }
    /**
     * Get SourceAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSourceAmount()
    {
        return isset($this->SourceAmount) ? $this->SourceAmount : null;
    }
    /**
     * Set SourceAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $sourceAmount
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setSourceAmount(\patest\StructType\Money $sourceAmount = null)
    {
        if (is_null($sourceAmount) || (is_array($sourceAmount) && empty($sourceAmount))) {
            unset($this->SourceAmount);
        } else {
            $this->SourceAmount = $sourceAmount;
        }
        return $this;
    }
    /**
     * Get SystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSystemName()
    {
        return isset($this->SystemName) ? $this->SystemName : null;
    }
    /**
     * Set SystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $systemName
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($systemName, true), gettype($systemName)), __LINE__);
        }
        if (is_null($systemName) || (is_array($systemName) && empty($systemName))) {
            unset($this->SystemName);
        } else {
            $this->SystemName = $systemName;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $type
     * @return \patest\StructType\Printing_Sales_PriceModifier
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !(is_int($type) || ctype_digit($type))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
