<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrinterType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Printing.PrinterType
 * @subpackage Structs
 */
class Printing_PrinterType extends AnyEntity
{
    /**
     * The AccessPermissions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccessPermissions;
    /**
     * The CustomHeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CustomHeight;
    /**
     * The CustomWidth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CustomWidth;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The DocumentSizeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentSizeId;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The IsInternal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInternal;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The PrintingDriverName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintingDriverName;
    /**
     * The RequiresDocumentAssignment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RequiresDocumentAssignment;
    /**
     * Constructor method for Printing.PrinterType
     * @uses Printing_PrinterType::setAccessPermissions()
     * @uses Printing_PrinterType::setCustomHeight()
     * @uses Printing_PrinterType::setCustomWidth()
     * @uses Printing_PrinterType::setDescription()
     * @uses Printing_PrinterType::setDocumentSizeId()
     * @uses Printing_PrinterType::setHolderTenantId()
     * @uses Printing_PrinterType::setId()
     * @uses Printing_PrinterType::setIsInternal()
     * @uses Printing_PrinterType::setLocalId()
     * @uses Printing_PrinterType::setName()
     * @uses Printing_PrinterType::setPrintingDriverName()
     * @uses Printing_PrinterType::setRequiresDocumentAssignment()
     * @param string[] $accessPermissions
     * @param float $customHeight
     * @param float $customWidth
     * @param \patest\StructType\GlobalString $description
     * @param string $documentSizeId
     * @param int $holderTenantId
     * @param string $id
     * @param bool $isInternal
     * @param int $localId
     * @param \patest\StructType\GlobalString $name
     * @param string $printingDriverName
     * @param bool $requiresDocumentAssignment
     */
    public function __construct(array $accessPermissions = array(), $customHeight = null, $customWidth = null, \patest\StructType\GlobalString $description = null, $documentSizeId = null, $holderTenantId = null, $id = null, $isInternal = null, $localId = null, \patest\StructType\GlobalString $name = null, $printingDriverName = null, $requiresDocumentAssignment = null)
    {
        $this
            ->setAccessPermissions($accessPermissions)
            ->setCustomHeight($customHeight)
            ->setCustomWidth($customWidth)
            ->setDescription($description)
            ->setDocumentSizeId($documentSizeId)
            ->setHolderTenantId($holderTenantId)
            ->setId($id)
            ->setIsInternal($isInternal)
            ->setLocalId($localId)
            ->setName($name)
            ->setPrintingDriverName($printingDriverName)
            ->setRequiresDocumentAssignment($requiresDocumentAssignment);
    }
    /**
     * Get AccessPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccessPermissions()
    {
        return isset($this->AccessPermissions) ? $this->AccessPermissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $printing_PrinterTypeAccessPermissionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EntityAccessPermission::valueIsValid($printing_PrinterTypeAccessPermissionsItem)) {
                $invalidValues[] = is_object($printing_PrinterTypeAccessPermissionsItem) ? get_class($printing_PrinterTypeAccessPermissionsItem) : sprintf('%s(%s)', gettype($printing_PrinterTypeAccessPermissionsItem), var_export($printing_PrinterTypeAccessPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EntityAccessPermission', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EntityAccessPermission::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EntityAccessPermission::valueIsValid()
     * @uses \patest\EnumType\EntityAccessPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessPermissions
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setAccessPermissions(array $accessPermissions = array())
    {
        // validation for constraint: list
        if ('' !== ($accessPermissionsArrayErrorMessage = self::validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions($accessPermissions))) {
            throw new \InvalidArgumentException($accessPermissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($accessPermissions) || (is_array($accessPermissions) && empty($accessPermissions))) {
            unset($this->AccessPermissions);
        } else {
            $this->AccessPermissions = is_array($accessPermissions) ? implode(' ', $accessPermissions) : null;
        }
        return $this;
    }
    /**
     * Get CustomHeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCustomHeight()
    {
        return isset($this->CustomHeight) ? $this->CustomHeight : null;
    }
    /**
     * Set CustomHeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $customHeight
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setCustomHeight($customHeight = null)
    {
        // validation for constraint: float
        if (!is_null($customHeight) && !(is_float($customHeight) || is_numeric($customHeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($customHeight, true), gettype($customHeight)), __LINE__);
        }
        if (is_null($customHeight) || (is_array($customHeight) && empty($customHeight))) {
            unset($this->CustomHeight);
        } else {
            $this->CustomHeight = $customHeight;
        }
        return $this;
    }
    /**
     * Get CustomWidth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCustomWidth()
    {
        return isset($this->CustomWidth) ? $this->CustomWidth : null;
    }
    /**
     * Set CustomWidth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $customWidth
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setCustomWidth($customWidth = null)
    {
        // validation for constraint: float
        if (!is_null($customWidth) && !(is_float($customWidth) || is_numeric($customWidth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($customWidth, true), gettype($customWidth)), __LINE__);
        }
        if (is_null($customWidth) || (is_array($customWidth) && empty($customWidth))) {
            unset($this->CustomWidth);
        } else {
            $this->CustomWidth = $customWidth;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DocumentSizeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentSizeId()
    {
        return isset($this->DocumentSizeId) ? $this->DocumentSizeId : null;
    }
    /**
     * Set DocumentSizeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentSizeId
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setDocumentSizeId($documentSizeId = null)
    {
        // validation for constraint: string
        if (!is_null($documentSizeId) && !is_string($documentSizeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentSizeId, true), gettype($documentSizeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentSizeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentSizeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentSizeId, true)), __LINE__);
        }
        if (is_null($documentSizeId) || (is_array($documentSizeId) && empty($documentSizeId))) {
            unset($this->DocumentSizeId);
        } else {
            $this->DocumentSizeId = $documentSizeId;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsInternal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInternal()
    {
        return isset($this->IsInternal) ? $this->IsInternal : null;
    }
    /**
     * Set IsInternal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInternal
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setIsInternal($isInternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInternal) && !is_bool($isInternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInternal, true), gettype($isInternal)), __LINE__);
        }
        if (is_null($isInternal) || (is_array($isInternal) && empty($isInternal))) {
            unset($this->IsInternal);
        } else {
            $this->IsInternal = $isInternal;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalId()
    {
        return isset($this->LocalId) ? $this->LocalId : null;
    }
    /**
     * Set LocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localId
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        if (is_null($localId) || (is_array($localId) && empty($localId))) {
            unset($this->LocalId);
        } else {
            $this->LocalId = $localId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PrintingDriverName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintingDriverName()
    {
        return isset($this->PrintingDriverName) ? $this->PrintingDriverName : null;
    }
    /**
     * Set PrintingDriverName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printingDriverName
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setPrintingDriverName($printingDriverName = null)
    {
        // validation for constraint: string
        if (!is_null($printingDriverName) && !is_string($printingDriverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printingDriverName, true), gettype($printingDriverName)), __LINE__);
        }
        if (is_null($printingDriverName) || (is_array($printingDriverName) && empty($printingDriverName))) {
            unset($this->PrintingDriverName);
        } else {
            $this->PrintingDriverName = $printingDriverName;
        }
        return $this;
    }
    /**
     * Get RequiresDocumentAssignment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRequiresDocumentAssignment()
    {
        return isset($this->RequiresDocumentAssignment) ? $this->RequiresDocumentAssignment : null;
    }
    /**
     * Set RequiresDocumentAssignment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $requiresDocumentAssignment
     * @return \patest\StructType\Printing_PrinterType
     */
    public function setRequiresDocumentAssignment($requiresDocumentAssignment = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiresDocumentAssignment) && !is_bool($requiresDocumentAssignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiresDocumentAssignment, true), gettype($requiresDocumentAssignment)), __LINE__);
        }
        if (is_null($requiresDocumentAssignment) || (is_array($requiresDocumentAssignment) && empty($requiresDocumentAssignment))) {
            unset($this->RequiresDocumentAssignment);
        } else {
            $this->RequiresDocumentAssignment = $requiresDocumentAssignment;
        }
        return $this;
    }
}
