<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrinterTray StructType
 * @subpackage Structs
 */
class Printing_PrinterTray extends AnyEntity
{
    /**
     * The AlertStockAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AlertStockAmount;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The NextPrintedDocumentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NextPrintedDocumentNumber;
    /**
     * The PrinterTrayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrinterTrayName;
    /**
     * The StockAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StockAmount;
    /**
     * Constructor method for Printing.PrinterTray
     * @uses Printing_PrinterTray::setAlertStockAmount()
     * @uses Printing_PrinterTray::setCultureId()
     * @uses Printing_PrinterTray::setDescription()
     * @uses Printing_PrinterTray::setId()
     * @uses Printing_PrinterTray::setName()
     * @uses Printing_PrinterTray::setNextPrintedDocumentNumber()
     * @uses Printing_PrinterTray::setPrinterTrayName()
     * @uses Printing_PrinterTray::setStockAmount()
     * @param int $alertStockAmount
     * @param int $cultureId
     * @param \patest\StructType\GlobalString $description
     * @param string $id
     * @param \patest\StructType\GlobalString $name
     * @param int $nextPrintedDocumentNumber
     * @param string $printerTrayName
     * @param int $stockAmount
     */
    public function __construct($alertStockAmount = null, $cultureId = null, \patest\StructType\GlobalString $description = null, $id = null, \patest\StructType\GlobalString $name = null, $nextPrintedDocumentNumber = null, $printerTrayName = null, $stockAmount = null)
    {
        $this
            ->setAlertStockAmount($alertStockAmount)
            ->setCultureId($cultureId)
            ->setDescription($description)
            ->setId($id)
            ->setName($name)
            ->setNextPrintedDocumentNumber($nextPrintedDocumentNumber)
            ->setPrinterTrayName($printerTrayName)
            ->setStockAmount($stockAmount);
    }
    /**
     * Get AlertStockAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAlertStockAmount()
    {
        return isset($this->AlertStockAmount) ? $this->AlertStockAmount : null;
    }
    /**
     * Set AlertStockAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $alertStockAmount
     * @return \patest\StructType\Printing_PrinterTray
     */
    public function setAlertStockAmount($alertStockAmount = null)
    {
        // validation for constraint: int
        if (!is_null($alertStockAmount) && !(is_int($alertStockAmount) || ctype_digit($alertStockAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alertStockAmount, true), gettype($alertStockAmount)), __LINE__);
        }
        if (is_null($alertStockAmount) || (is_array($alertStockAmount) && empty($alertStockAmount))) {
            unset($this->AlertStockAmount);
        } else {
            $this->AlertStockAmount = $alertStockAmount;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Printing_PrinterTray
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Printing_PrinterTray
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Printing_PrinterTray
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Printing_PrinterTray
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get NextPrintedDocumentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNextPrintedDocumentNumber()
    {
        return isset($this->NextPrintedDocumentNumber) ? $this->NextPrintedDocumentNumber : null;
    }
    /**
     * Set NextPrintedDocumentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nextPrintedDocumentNumber
     * @return \patest\StructType\Printing_PrinterTray
     */
    public function setNextPrintedDocumentNumber($nextPrintedDocumentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($nextPrintedDocumentNumber) && !(is_int($nextPrintedDocumentNumber) || ctype_digit($nextPrintedDocumentNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextPrintedDocumentNumber, true), gettype($nextPrintedDocumentNumber)), __LINE__);
        }
        if (is_null($nextPrintedDocumentNumber) || (is_array($nextPrintedDocumentNumber) && empty($nextPrintedDocumentNumber))) {
            unset($this->NextPrintedDocumentNumber);
        } else {
            $this->NextPrintedDocumentNumber = $nextPrintedDocumentNumber;
        }
        return $this;
    }
    /**
     * Get PrinterTrayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrinterTrayName()
    {
        return isset($this->PrinterTrayName) ? $this->PrinterTrayName : null;
    }
    /**
     * Set PrinterTrayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printerTrayName
     * @return \patest\StructType\Printing_PrinterTray
     */
    public function setPrinterTrayName($printerTrayName = null)
    {
        // validation for constraint: string
        if (!is_null($printerTrayName) && !is_string($printerTrayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerTrayName, true), gettype($printerTrayName)), __LINE__);
        }
        if (is_null($printerTrayName) || (is_array($printerTrayName) && empty($printerTrayName))) {
            unset($this->PrinterTrayName);
        } else {
            $this->PrinterTrayName = $printerTrayName;
        }
        return $this;
    }
    /**
     * Get StockAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStockAmount()
    {
        return isset($this->StockAmount) ? $this->StockAmount : null;
    }
    /**
     * Set StockAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $stockAmount
     * @return \patest\StructType\Printing_PrinterTray
     */
    public function setStockAmount($stockAmount = null)
    {
        // validation for constraint: int
        if (!is_null($stockAmount) && !(is_int($stockAmount) || ctype_digit($stockAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stockAmount, true), gettype($stockAmount)), __LINE__);
        }
        if (is_null($stockAmount) || (is_array($stockAmount) && empty($stockAmount))) {
            unset($this->StockAmount);
        } else {
            $this->StockAmount = $stockAmount;
        }
        return $this;
    }
}
