<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrinterServerExtended StructType
 * @subpackage Structs
 */
class Printing_PrinterServerExtended extends Printing_PrinterServer
{
    /**
     * The ConnectedComputerIP
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectedComputerIP;
    /**
     * The ConnectedComputerMacAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectedComputerMacAddress;
    /**
     * The ConnectedComputerName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConnectedComputerName;
    /**
     * The DeploymentError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeploymentError;
    /**
     * The LastActionTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastActionTime;
    /**
     * The LastConnectTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastConnectTime;
    /**
     * The LastDeploymentAttemptTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDeploymentAttemptTime;
    /**
     * The LastDisconnectTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastDisconnectTime;
    /**
     * The MarkedForRestart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MarkedForRestart;
    /**
     * The ServerRunMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServerRunMode;
    /**
     * The UpToDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UpToDate;
    /**
     * Constructor method for Printing.PrinterServerExtended
     * @uses Printing_PrinterServerExtended::setConnectedComputerIP()
     * @uses Printing_PrinterServerExtended::setConnectedComputerMacAddress()
     * @uses Printing_PrinterServerExtended::setConnectedComputerName()
     * @uses Printing_PrinterServerExtended::setDeploymentError()
     * @uses Printing_PrinterServerExtended::setLastActionTime()
     * @uses Printing_PrinterServerExtended::setLastConnectTime()
     * @uses Printing_PrinterServerExtended::setLastDeploymentAttemptTime()
     * @uses Printing_PrinterServerExtended::setLastDisconnectTime()
     * @uses Printing_PrinterServerExtended::setMarkedForRestart()
     * @uses Printing_PrinterServerExtended::setServerRunMode()
     * @uses Printing_PrinterServerExtended::setUpToDate()
     * @param string $connectedComputerIP
     * @param string $connectedComputerMacAddress
     * @param string $connectedComputerName
     * @param string $deploymentError
     * @param string $lastActionTime
     * @param string $lastConnectTime
     * @param string $lastDeploymentAttemptTime
     * @param string $lastDisconnectTime
     * @param bool $markedForRestart
     * @param string $serverRunMode
     * @param bool $upToDate
     */
    public function __construct($connectedComputerIP = null, $connectedComputerMacAddress = null, $connectedComputerName = null, $deploymentError = null, $lastActionTime = null, $lastConnectTime = null, $lastDeploymentAttemptTime = null, $lastDisconnectTime = null, $markedForRestart = null, $serverRunMode = null, $upToDate = null)
    {
        $this
            ->setConnectedComputerIP($connectedComputerIP)
            ->setConnectedComputerMacAddress($connectedComputerMacAddress)
            ->setConnectedComputerName($connectedComputerName)
            ->setDeploymentError($deploymentError)
            ->setLastActionTime($lastActionTime)
            ->setLastConnectTime($lastConnectTime)
            ->setLastDeploymentAttemptTime($lastDeploymentAttemptTime)
            ->setLastDisconnectTime($lastDisconnectTime)
            ->setMarkedForRestart($markedForRestart)
            ->setServerRunMode($serverRunMode)
            ->setUpToDate($upToDate);
    }
    /**
     * Get ConnectedComputerIP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectedComputerIP()
    {
        return isset($this->ConnectedComputerIP) ? $this->ConnectedComputerIP : null;
    }
    /**
     * Set ConnectedComputerIP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectedComputerIP
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setConnectedComputerIP($connectedComputerIP = null)
    {
        // validation for constraint: string
        if (!is_null($connectedComputerIP) && !is_string($connectedComputerIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectedComputerIP, true), gettype($connectedComputerIP)), __LINE__);
        }
        if (is_null($connectedComputerIP) || (is_array($connectedComputerIP) && empty($connectedComputerIP))) {
            unset($this->ConnectedComputerIP);
        } else {
            $this->ConnectedComputerIP = $connectedComputerIP;
        }
        return $this;
    }
    /**
     * Get ConnectedComputerMacAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectedComputerMacAddress()
    {
        return isset($this->ConnectedComputerMacAddress) ? $this->ConnectedComputerMacAddress : null;
    }
    /**
     * Set ConnectedComputerMacAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectedComputerMacAddress
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setConnectedComputerMacAddress($connectedComputerMacAddress = null)
    {
        // validation for constraint: string
        if (!is_null($connectedComputerMacAddress) && !is_string($connectedComputerMacAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectedComputerMacAddress, true), gettype($connectedComputerMacAddress)), __LINE__);
        }
        if (is_null($connectedComputerMacAddress) || (is_array($connectedComputerMacAddress) && empty($connectedComputerMacAddress))) {
            unset($this->ConnectedComputerMacAddress);
        } else {
            $this->ConnectedComputerMacAddress = $connectedComputerMacAddress;
        }
        return $this;
    }
    /**
     * Get ConnectedComputerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConnectedComputerName()
    {
        return isset($this->ConnectedComputerName) ? $this->ConnectedComputerName : null;
    }
    /**
     * Set ConnectedComputerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $connectedComputerName
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setConnectedComputerName($connectedComputerName = null)
    {
        // validation for constraint: string
        if (!is_null($connectedComputerName) && !is_string($connectedComputerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectedComputerName, true), gettype($connectedComputerName)), __LINE__);
        }
        if (is_null($connectedComputerName) || (is_array($connectedComputerName) && empty($connectedComputerName))) {
            unset($this->ConnectedComputerName);
        } else {
            $this->ConnectedComputerName = $connectedComputerName;
        }
        return $this;
    }
    /**
     * Get DeploymentError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeploymentError()
    {
        return isset($this->DeploymentError) ? $this->DeploymentError : null;
    }
    /**
     * Set DeploymentError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deploymentError
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setDeploymentError($deploymentError = null)
    {
        // validation for constraint: string
        if (!is_null($deploymentError) && !is_string($deploymentError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deploymentError, true), gettype($deploymentError)), __LINE__);
        }
        if (is_null($deploymentError) || (is_array($deploymentError) && empty($deploymentError))) {
            unset($this->DeploymentError);
        } else {
            $this->DeploymentError = $deploymentError;
        }
        return $this;
    }
    /**
     * Get LastActionTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastActionTime()
    {
        return isset($this->LastActionTime) ? $this->LastActionTime : null;
    }
    /**
     * Set LastActionTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastActionTime
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setLastActionTime($lastActionTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastActionTime) && !is_string($lastActionTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastActionTime, true), gettype($lastActionTime)), __LINE__);
        }
        if (is_null($lastActionTime) || (is_array($lastActionTime) && empty($lastActionTime))) {
            unset($this->LastActionTime);
        } else {
            $this->LastActionTime = $lastActionTime;
        }
        return $this;
    }
    /**
     * Get LastConnectTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastConnectTime()
    {
        return isset($this->LastConnectTime) ? $this->LastConnectTime : null;
    }
    /**
     * Set LastConnectTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastConnectTime
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setLastConnectTime($lastConnectTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastConnectTime) && !is_string($lastConnectTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastConnectTime, true), gettype($lastConnectTime)), __LINE__);
        }
        if (is_null($lastConnectTime) || (is_array($lastConnectTime) && empty($lastConnectTime))) {
            unset($this->LastConnectTime);
        } else {
            $this->LastConnectTime = $lastConnectTime;
        }
        return $this;
    }
    /**
     * Get LastDeploymentAttemptTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDeploymentAttemptTime()
    {
        return isset($this->LastDeploymentAttemptTime) ? $this->LastDeploymentAttemptTime : null;
    }
    /**
     * Set LastDeploymentAttemptTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDeploymentAttemptTime
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setLastDeploymentAttemptTime($lastDeploymentAttemptTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDeploymentAttemptTime) && !is_string($lastDeploymentAttemptTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDeploymentAttemptTime, true), gettype($lastDeploymentAttemptTime)), __LINE__);
        }
        if (is_null($lastDeploymentAttemptTime) || (is_array($lastDeploymentAttemptTime) && empty($lastDeploymentAttemptTime))) {
            unset($this->LastDeploymentAttemptTime);
        } else {
            $this->LastDeploymentAttemptTime = $lastDeploymentAttemptTime;
        }
        return $this;
    }
    /**
     * Get LastDisconnectTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastDisconnectTime()
    {
        return isset($this->LastDisconnectTime) ? $this->LastDisconnectTime : null;
    }
    /**
     * Set LastDisconnectTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastDisconnectTime
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setLastDisconnectTime($lastDisconnectTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastDisconnectTime) && !is_string($lastDisconnectTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDisconnectTime, true), gettype($lastDisconnectTime)), __LINE__);
        }
        if (is_null($lastDisconnectTime) || (is_array($lastDisconnectTime) && empty($lastDisconnectTime))) {
            unset($this->LastDisconnectTime);
        } else {
            $this->LastDisconnectTime = $lastDisconnectTime;
        }
        return $this;
    }
    /**
     * Get MarkedForRestart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMarkedForRestart()
    {
        return isset($this->MarkedForRestart) ? $this->MarkedForRestart : null;
    }
    /**
     * Set MarkedForRestart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $markedForRestart
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setMarkedForRestart($markedForRestart = null)
    {
        // validation for constraint: boolean
        if (!is_null($markedForRestart) && !is_bool($markedForRestart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($markedForRestart, true), gettype($markedForRestart)), __LINE__);
        }
        if (is_null($markedForRestart) || (is_array($markedForRestart) && empty($markedForRestart))) {
            unset($this->MarkedForRestart);
        } else {
            $this->MarkedForRestart = $markedForRestart;
        }
        return $this;
    }
    /**
     * Get ServerRunMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServerRunMode()
    {
        return isset($this->ServerRunMode) ? $this->ServerRunMode : null;
    }
    /**
     * Set ServerRunMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ServerRunMode::valueIsValid()
     * @uses \patest\EnumType\ServerRunMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serverRunMode
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setServerRunMode($serverRunMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ServerRunMode::valueIsValid($serverRunMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ServerRunMode', is_array($serverRunMode) ? implode(', ', $serverRunMode) : var_export($serverRunMode, true), implode(', ', \patest\EnumType\ServerRunMode::getValidValues())), __LINE__);
        }
        if (is_null($serverRunMode) || (is_array($serverRunMode) && empty($serverRunMode))) {
            unset($this->ServerRunMode);
        } else {
            $this->ServerRunMode = $serverRunMode;
        }
        return $this;
    }
    /**
     * Get UpToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUpToDate()
    {
        return isset($this->UpToDate) ? $this->UpToDate : null;
    }
    /**
     * Set UpToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $upToDate
     * @return \patest\StructType\Printing_PrinterServerExtended
     */
    public function setUpToDate($upToDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($upToDate) && !is_bool($upToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($upToDate, true), gettype($upToDate)), __LINE__);
        }
        if (is_null($upToDate) || (is_array($upToDate) && empty($upToDate))) {
            unset($this->UpToDate);
        } else {
            $this->UpToDate = $upToDate;
        }
        return $this;
    }
}
