<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.Printer StructType
 * @subpackage Structs
 */
class Printing_Printer extends MaintainableNotDistributableGlobalizedEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The AvgDocumentPrintTime
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvgDocumentPrintTime;
    /**
     * The DefaultTray
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrinterTray
     */
    public $DefaultTray;
    /**
     * The DefaultTrayId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultTrayId;
    /**
     * The DoNotStoreGeneratedDocumentInDB
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoNotStoreGeneratedDocumentInDB;
    /**
     * The GroupPdfTicketsForEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GroupPdfTicketsForEmail;
    /**
     * The Interface
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Interface;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The LastError
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastError;
    /**
     * The MonitorWindowsSpooler
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MonitorWindowsSpooler;
    /**
     * The NotifyPrintedAfterNDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NotifyPrintedAfterNDocuments;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PhysicalPrinterPath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhysicalPrinterPath;
    /**
     * The PrintedNotificationPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedNotificationPolicy;
    /**
     * The PrinterGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrinterGroupId;
    /**
     * The PrinterTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrinterTypeId;
    /**
     * The PrintGroupAsSingleDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintGroupAsSingleDocument;
    /**
     * The PrintServerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrintServerId;
    /**
     * The PrintTimeoutRetries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintTimeoutRetries;
    /**
     * The PrintTimeoutSec
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintTimeoutSec;
    /**
     * The RedirectTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RedirectTo;
    /**
     * The ReportErrorToUsers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ReportErrorToUsers
     */
    public $ReportErrorToUsers;
    /**
     * The ReportPrintTimeoutAsError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReportPrintTimeoutAsError;
    /**
     * The ScanTicketsAfterPrint
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ScanTicketsAfterPrint;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TargetDocumentPath
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetDocumentPath;
    /**
     * The Trays
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrinterTray
     */
    public $Trays;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for Printing.Printer
     * @uses Printing_Printer::setAccessControlSystemId()
     * @uses Printing_Printer::setAvgDocumentPrintTime()
     * @uses Printing_Printer::setDefaultTray()
     * @uses Printing_Printer::setDefaultTrayId()
     * @uses Printing_Printer::setDoNotStoreGeneratedDocumentInDB()
     * @uses Printing_Printer::setGroupPdfTicketsForEmail()
     * @uses Printing_Printer::setInterface()
     * @uses Printing_Printer::setIsSystem()
     * @uses Printing_Printer::setLastError()
     * @uses Printing_Printer::setMonitorWindowsSpooler()
     * @uses Printing_Printer::setNotifyPrintedAfterNDocuments()
     * @uses Printing_Printer::setOrganizationUnitId()
     * @uses Printing_Printer::setPhysicalPrinterPath()
     * @uses Printing_Printer::setPrintedNotificationPolicy()
     * @uses Printing_Printer::setPrinterGroupId()
     * @uses Printing_Printer::setPrinterTypeId()
     * @uses Printing_Printer::setPrintGroupAsSingleDocument()
     * @uses Printing_Printer::setPrintServerId()
     * @uses Printing_Printer::setPrintTimeoutRetries()
     * @uses Printing_Printer::setPrintTimeoutSec()
     * @uses Printing_Printer::setRedirectTo()
     * @uses Printing_Printer::setReportErrorToUsers()
     * @uses Printing_Printer::setReportPrintTimeoutAsError()
     * @uses Printing_Printer::setScanTicketsAfterPrint()
     * @uses Printing_Printer::setStatus()
     * @uses Printing_Printer::setTargetDocumentPath()
     * @uses Printing_Printer::setTrays()
     * @uses Printing_Printer::setVisibleBySubordinates()
     * @uses Printing_Printer::setXmlContainer()
     * @param string $accessControlSystemId
     * @param int $avgDocumentPrintTime
     * @param \patest\StructType\Printing_PrinterTray $defaultTray
     * @param string $defaultTrayId
     * @param bool $doNotStoreGeneratedDocumentInDB
     * @param bool $groupPdfTicketsForEmail
     * @param string $interface
     * @param bool $isSystem
     * @param string $lastError
     * @param bool $monitorWindowsSpooler
     * @param int $notifyPrintedAfterNDocuments
     * @param string $organizationUnitId
     * @param string $physicalPrinterPath
     * @param string $printedNotificationPolicy
     * @param string $printerGroupId
     * @param string $printerTypeId
     * @param bool $printGroupAsSingleDocument
     * @param string $printServerId
     * @param int $printTimeoutRetries
     * @param int $printTimeoutSec
     * @param string $redirectTo
     * @param \patest\StructType\ReportErrorToUsers $reportErrorToUsers
     * @param bool $reportPrintTimeoutAsError
     * @param bool $scanTicketsAfterPrint
     * @param string $status
     * @param string $targetDocumentPath
     * @param \patest\StructType\RecordSetOfPrinting_PrinterTray $trays
     * @param bool $visibleBySubordinates
     * @param string $xmlContainer
     */
    public function __construct($accessControlSystemId = null, $avgDocumentPrintTime = null, \patest\StructType\Printing_PrinterTray $defaultTray = null, $defaultTrayId = null, $doNotStoreGeneratedDocumentInDB = null, $groupPdfTicketsForEmail = null, $interface = null, $isSystem = null, $lastError = null, $monitorWindowsSpooler = null, $notifyPrintedAfterNDocuments = null, $organizationUnitId = null, $physicalPrinterPath = null, $printedNotificationPolicy = null, $printerGroupId = null, $printerTypeId = null, $printGroupAsSingleDocument = null, $printServerId = null, $printTimeoutRetries = null, $printTimeoutSec = null, $redirectTo = null, \patest\StructType\ReportErrorToUsers $reportErrorToUsers = null, $reportPrintTimeoutAsError = null, $scanTicketsAfterPrint = null, $status = null, $targetDocumentPath = null, \patest\StructType\RecordSetOfPrinting_PrinterTray $trays = null, $visibleBySubordinates = null, $xmlContainer = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setAvgDocumentPrintTime($avgDocumentPrintTime)
            ->setDefaultTray($defaultTray)
            ->setDefaultTrayId($defaultTrayId)
            ->setDoNotStoreGeneratedDocumentInDB($doNotStoreGeneratedDocumentInDB)
            ->setGroupPdfTicketsForEmail($groupPdfTicketsForEmail)
            ->setInterface($interface)
            ->setIsSystem($isSystem)
            ->setLastError($lastError)
            ->setMonitorWindowsSpooler($monitorWindowsSpooler)
            ->setNotifyPrintedAfterNDocuments($notifyPrintedAfterNDocuments)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPhysicalPrinterPath($physicalPrinterPath)
            ->setPrintedNotificationPolicy($printedNotificationPolicy)
            ->setPrinterGroupId($printerGroupId)
            ->setPrinterTypeId($printerTypeId)
            ->setPrintGroupAsSingleDocument($printGroupAsSingleDocument)
            ->setPrintServerId($printServerId)
            ->setPrintTimeoutRetries($printTimeoutRetries)
            ->setPrintTimeoutSec($printTimeoutSec)
            ->setRedirectTo($redirectTo)
            ->setReportErrorToUsers($reportErrorToUsers)
            ->setReportPrintTimeoutAsError($reportPrintTimeoutAsError)
            ->setScanTicketsAfterPrint($scanTicketsAfterPrint)
            ->setStatus($status)
            ->setTargetDocumentPath($targetDocumentPath)
            ->setTrays($trays)
            ->setVisibleBySubordinates($visibleBySubordinates)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\Printing_Printer
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get AvgDocumentPrintTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvgDocumentPrintTime()
    {
        return isset($this->AvgDocumentPrintTime) ? $this->AvgDocumentPrintTime : null;
    }
    /**
     * Set AvgDocumentPrintTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $avgDocumentPrintTime
     * @return \patest\StructType\Printing_Printer
     */
    public function setAvgDocumentPrintTime($avgDocumentPrintTime = null)
    {
        // validation for constraint: int
        if (!is_null($avgDocumentPrintTime) && !(is_int($avgDocumentPrintTime) || ctype_digit($avgDocumentPrintTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($avgDocumentPrintTime, true), gettype($avgDocumentPrintTime)), __LINE__);
        }
        if (is_null($avgDocumentPrintTime) || (is_array($avgDocumentPrintTime) && empty($avgDocumentPrintTime))) {
            unset($this->AvgDocumentPrintTime);
        } else {
            $this->AvgDocumentPrintTime = $avgDocumentPrintTime;
        }
        return $this;
    }
    /**
     * Get DefaultTray value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrinterTray|null
     */
    public function getDefaultTray()
    {
        return isset($this->DefaultTray) ? $this->DefaultTray : null;
    }
    /**
     * Set DefaultTray value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrinterTray $defaultTray
     * @return \patest\StructType\Printing_Printer
     */
    public function setDefaultTray(\patest\StructType\Printing_PrinterTray $defaultTray = null)
    {
        if (is_null($defaultTray) || (is_array($defaultTray) && empty($defaultTray))) {
            unset($this->DefaultTray);
        } else {
            $this->DefaultTray = $defaultTray;
        }
        return $this;
    }
    /**
     * Get DefaultTrayId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultTrayId()
    {
        return isset($this->DefaultTrayId) ? $this->DefaultTrayId : null;
    }
    /**
     * Set DefaultTrayId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultTrayId
     * @return \patest\StructType\Printing_Printer
     */
    public function setDefaultTrayId($defaultTrayId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTrayId) && !is_string($defaultTrayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTrayId, true), gettype($defaultTrayId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultTrayId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultTrayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultTrayId, true)), __LINE__);
        }
        if (is_null($defaultTrayId) || (is_array($defaultTrayId) && empty($defaultTrayId))) {
            unset($this->DefaultTrayId);
        } else {
            $this->DefaultTrayId = $defaultTrayId;
        }
        return $this;
    }
    /**
     * Get DoNotStoreGeneratedDocumentInDB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoNotStoreGeneratedDocumentInDB()
    {
        return isset($this->DoNotStoreGeneratedDocumentInDB) ? $this->DoNotStoreGeneratedDocumentInDB : null;
    }
    /**
     * Set DoNotStoreGeneratedDocumentInDB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doNotStoreGeneratedDocumentInDB
     * @return \patest\StructType\Printing_Printer
     */
    public function setDoNotStoreGeneratedDocumentInDB($doNotStoreGeneratedDocumentInDB = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotStoreGeneratedDocumentInDB) && !is_bool($doNotStoreGeneratedDocumentInDB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotStoreGeneratedDocumentInDB, true), gettype($doNotStoreGeneratedDocumentInDB)), __LINE__);
        }
        if (is_null($doNotStoreGeneratedDocumentInDB) || (is_array($doNotStoreGeneratedDocumentInDB) && empty($doNotStoreGeneratedDocumentInDB))) {
            unset($this->DoNotStoreGeneratedDocumentInDB);
        } else {
            $this->DoNotStoreGeneratedDocumentInDB = $doNotStoreGeneratedDocumentInDB;
        }
        return $this;
    }
    /**
     * Get GroupPdfTicketsForEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGroupPdfTicketsForEmail()
    {
        return isset($this->GroupPdfTicketsForEmail) ? $this->GroupPdfTicketsForEmail : null;
    }
    /**
     * Set GroupPdfTicketsForEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $groupPdfTicketsForEmail
     * @return \patest\StructType\Printing_Printer
     */
    public function setGroupPdfTicketsForEmail($groupPdfTicketsForEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupPdfTicketsForEmail) && !is_bool($groupPdfTicketsForEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupPdfTicketsForEmail, true), gettype($groupPdfTicketsForEmail)), __LINE__);
        }
        if (is_null($groupPdfTicketsForEmail) || (is_array($groupPdfTicketsForEmail) && empty($groupPdfTicketsForEmail))) {
            unset($this->GroupPdfTicketsForEmail);
        } else {
            $this->GroupPdfTicketsForEmail = $groupPdfTicketsForEmail;
        }
        return $this;
    }
    /**
     * Get Interface value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInterface()
    {
        return isset($this->Interface) ? $this->Interface : null;
    }
    /**
     * Set Interface value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrinterInterface::valueIsValid()
     * @uses \patest\EnumType\PrinterInterface::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interface
     * @return \patest\StructType\Printing_Printer
     */
    public function setInterface($interface = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrinterInterface::valueIsValid($interface)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrinterInterface', is_array($interface) ? implode(', ', $interface) : var_export($interface, true), implode(', ', \patest\EnumType\PrinterInterface::getValidValues())), __LINE__);
        }
        if (is_null($interface) || (is_array($interface) && empty($interface))) {
            unset($this->Interface);
        } else {
            $this->Interface = $interface;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Printing_Printer
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get LastError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastError()
    {
        return isset($this->LastError) ? $this->LastError : null;
    }
    /**
     * Set LastError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastError
     * @return \patest\StructType\Printing_Printer
     */
    public function setLastError($lastError = null)
    {
        // validation for constraint: string
        if (!is_null($lastError) && !is_string($lastError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastError, true), gettype($lastError)), __LINE__);
        }
        if (is_null($lastError) || (is_array($lastError) && empty($lastError))) {
            unset($this->LastError);
        } else {
            $this->LastError = $lastError;
        }
        return $this;
    }
    /**
     * Get MonitorWindowsSpooler value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMonitorWindowsSpooler()
    {
        return isset($this->MonitorWindowsSpooler) ? $this->MonitorWindowsSpooler : null;
    }
    /**
     * Set MonitorWindowsSpooler value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $monitorWindowsSpooler
     * @return \patest\StructType\Printing_Printer
     */
    public function setMonitorWindowsSpooler($monitorWindowsSpooler = null)
    {
        // validation for constraint: boolean
        if (!is_null($monitorWindowsSpooler) && !is_bool($monitorWindowsSpooler)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($monitorWindowsSpooler, true), gettype($monitorWindowsSpooler)), __LINE__);
        }
        if (is_null($monitorWindowsSpooler) || (is_array($monitorWindowsSpooler) && empty($monitorWindowsSpooler))) {
            unset($this->MonitorWindowsSpooler);
        } else {
            $this->MonitorWindowsSpooler = $monitorWindowsSpooler;
        }
        return $this;
    }
    /**
     * Get NotifyPrintedAfterNDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNotifyPrintedAfterNDocuments()
    {
        return isset($this->NotifyPrintedAfterNDocuments) ? $this->NotifyPrintedAfterNDocuments : null;
    }
    /**
     * Set NotifyPrintedAfterNDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $notifyPrintedAfterNDocuments
     * @return \patest\StructType\Printing_Printer
     */
    public function setNotifyPrintedAfterNDocuments($notifyPrintedAfterNDocuments = null)
    {
        // validation for constraint: int
        if (!is_null($notifyPrintedAfterNDocuments) && !(is_int($notifyPrintedAfterNDocuments) || ctype_digit($notifyPrintedAfterNDocuments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($notifyPrintedAfterNDocuments, true), gettype($notifyPrintedAfterNDocuments)), __LINE__);
        }
        if (is_null($notifyPrintedAfterNDocuments) || (is_array($notifyPrintedAfterNDocuments) && empty($notifyPrintedAfterNDocuments))) {
            unset($this->NotifyPrintedAfterNDocuments);
        } else {
            $this->NotifyPrintedAfterNDocuments = $notifyPrintedAfterNDocuments;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_Printer
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PhysicalPrinterPath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhysicalPrinterPath()
    {
        return isset($this->PhysicalPrinterPath) ? $this->PhysicalPrinterPath : null;
    }
    /**
     * Set PhysicalPrinterPath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $physicalPrinterPath
     * @return \patest\StructType\Printing_Printer
     */
    public function setPhysicalPrinterPath($physicalPrinterPath = null)
    {
        // validation for constraint: string
        if (!is_null($physicalPrinterPath) && !is_string($physicalPrinterPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalPrinterPath, true), gettype($physicalPrinterPath)), __LINE__);
        }
        if (is_null($physicalPrinterPath) || (is_array($physicalPrinterPath) && empty($physicalPrinterPath))) {
            unset($this->PhysicalPrinterPath);
        } else {
            $this->PhysicalPrinterPath = $physicalPrinterPath;
        }
        return $this;
    }
    /**
     * Get PrintedNotificationPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedNotificationPolicy()
    {
        return isset($this->PrintedNotificationPolicy) ? $this->PrintedNotificationPolicy : null;
    }
    /**
     * Set PrintedNotificationPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrintedDocumentNotificationPolicy::valueIsValid()
     * @uses \patest\EnumType\PrintedDocumentNotificationPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printedNotificationPolicy
     * @return \patest\StructType\Printing_Printer
     */
    public function setPrintedNotificationPolicy($printedNotificationPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrintedDocumentNotificationPolicy::valueIsValid($printedNotificationPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrintedDocumentNotificationPolicy', is_array($printedNotificationPolicy) ? implode(', ', $printedNotificationPolicy) : var_export($printedNotificationPolicy, true), implode(', ', \patest\EnumType\PrintedDocumentNotificationPolicy::getValidValues())), __LINE__);
        }
        if (is_null($printedNotificationPolicy) || (is_array($printedNotificationPolicy) && empty($printedNotificationPolicy))) {
            unset($this->PrintedNotificationPolicy);
        } else {
            $this->PrintedNotificationPolicy = $printedNotificationPolicy;
        }
        return $this;
    }
    /**
     * Get PrinterGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrinterGroupId()
    {
        return isset($this->PrinterGroupId) ? $this->PrinterGroupId : null;
    }
    /**
     * Set PrinterGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printerGroupId
     * @return \patest\StructType\Printing_Printer
     */
    public function setPrinterGroupId($printerGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($printerGroupId) && !is_string($printerGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerGroupId, true), gettype($printerGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($printerGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $printerGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($printerGroupId, true)), __LINE__);
        }
        if (is_null($printerGroupId) || (is_array($printerGroupId) && empty($printerGroupId))) {
            unset($this->PrinterGroupId);
        } else {
            $this->PrinterGroupId = $printerGroupId;
        }
        return $this;
    }
    /**
     * Get PrinterTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrinterTypeId()
    {
        return isset($this->PrinterTypeId) ? $this->PrinterTypeId : null;
    }
    /**
     * Set PrinterTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printerTypeId
     * @return \patest\StructType\Printing_Printer
     */
    public function setPrinterTypeId($printerTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($printerTypeId) && !is_string($printerTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerTypeId, true), gettype($printerTypeId)), __LINE__);
        }
        if (is_null($printerTypeId) || (is_array($printerTypeId) && empty($printerTypeId))) {
            unset($this->PrinterTypeId);
        } else {
            $this->PrinterTypeId = $printerTypeId;
        }
        return $this;
    }
    /**
     * Get PrintGroupAsSingleDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintGroupAsSingleDocument()
    {
        return isset($this->PrintGroupAsSingleDocument) ? $this->PrintGroupAsSingleDocument : null;
    }
    /**
     * Set PrintGroupAsSingleDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printGroupAsSingleDocument
     * @return \patest\StructType\Printing_Printer
     */
    public function setPrintGroupAsSingleDocument($printGroupAsSingleDocument = null)
    {
        // validation for constraint: boolean
        if (!is_null($printGroupAsSingleDocument) && !is_bool($printGroupAsSingleDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printGroupAsSingleDocument, true), gettype($printGroupAsSingleDocument)), __LINE__);
        }
        if (is_null($printGroupAsSingleDocument) || (is_array($printGroupAsSingleDocument) && empty($printGroupAsSingleDocument))) {
            unset($this->PrintGroupAsSingleDocument);
        } else {
            $this->PrintGroupAsSingleDocument = $printGroupAsSingleDocument;
        }
        return $this;
    }
    /**
     * Get PrintServerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintServerId()
    {
        return isset($this->PrintServerId) ? $this->PrintServerId : null;
    }
    /**
     * Set PrintServerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printServerId
     * @return \patest\StructType\Printing_Printer
     */
    public function setPrintServerId($printServerId = null)
    {
        // validation for constraint: string
        if (!is_null($printServerId) && !is_string($printServerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printServerId, true), gettype($printServerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($printServerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $printServerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($printServerId, true)), __LINE__);
        }
        if (is_null($printServerId) || (is_array($printServerId) && empty($printServerId))) {
            unset($this->PrintServerId);
        } else {
            $this->PrintServerId = $printServerId;
        }
        return $this;
    }
    /**
     * Get PrintTimeoutRetries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintTimeoutRetries()
    {
        return isset($this->PrintTimeoutRetries) ? $this->PrintTimeoutRetries : null;
    }
    /**
     * Set PrintTimeoutRetries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printTimeoutRetries
     * @return \patest\StructType\Printing_Printer
     */
    public function setPrintTimeoutRetries($printTimeoutRetries = null)
    {
        // validation for constraint: int
        if (!is_null($printTimeoutRetries) && !(is_int($printTimeoutRetries) || ctype_digit($printTimeoutRetries))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printTimeoutRetries, true), gettype($printTimeoutRetries)), __LINE__);
        }
        if (is_null($printTimeoutRetries) || (is_array($printTimeoutRetries) && empty($printTimeoutRetries))) {
            unset($this->PrintTimeoutRetries);
        } else {
            $this->PrintTimeoutRetries = $printTimeoutRetries;
        }
        return $this;
    }
    /**
     * Get PrintTimeoutSec value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintTimeoutSec()
    {
        return isset($this->PrintTimeoutSec) ? $this->PrintTimeoutSec : null;
    }
    /**
     * Set PrintTimeoutSec value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printTimeoutSec
     * @return \patest\StructType\Printing_Printer
     */
    public function setPrintTimeoutSec($printTimeoutSec = null)
    {
        // validation for constraint: int
        if (!is_null($printTimeoutSec) && !(is_int($printTimeoutSec) || ctype_digit($printTimeoutSec))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printTimeoutSec, true), gettype($printTimeoutSec)), __LINE__);
        }
        if (is_null($printTimeoutSec) || (is_array($printTimeoutSec) && empty($printTimeoutSec))) {
            unset($this->PrintTimeoutSec);
        } else {
            $this->PrintTimeoutSec = $printTimeoutSec;
        }
        return $this;
    }
    /**
     * Get RedirectTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRedirectTo()
    {
        return isset($this->RedirectTo) ? $this->RedirectTo : null;
    }
    /**
     * Set RedirectTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $redirectTo
     * @return \patest\StructType\Printing_Printer
     */
    public function setRedirectTo($redirectTo = null)
    {
        // validation for constraint: string
        if (!is_null($redirectTo) && !is_string($redirectTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($redirectTo, true), gettype($redirectTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($redirectTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $redirectTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($redirectTo, true)), __LINE__);
        }
        if (is_null($redirectTo) || (is_array($redirectTo) && empty($redirectTo))) {
            unset($this->RedirectTo);
        } else {
            $this->RedirectTo = $redirectTo;
        }
        return $this;
    }
    /**
     * Get ReportErrorToUsers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ReportErrorToUsers|null
     */
    public function getReportErrorToUsers()
    {
        return isset($this->ReportErrorToUsers) ? $this->ReportErrorToUsers : null;
    }
    /**
     * Set ReportErrorToUsers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ReportErrorToUsers $reportErrorToUsers
     * @return \patest\StructType\Printing_Printer
     */
    public function setReportErrorToUsers(\patest\StructType\ReportErrorToUsers $reportErrorToUsers = null)
    {
        if (is_null($reportErrorToUsers) || (is_array($reportErrorToUsers) && empty($reportErrorToUsers))) {
            unset($this->ReportErrorToUsers);
        } else {
            $this->ReportErrorToUsers = $reportErrorToUsers;
        }
        return $this;
    }
    /**
     * Get ReportPrintTimeoutAsError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReportPrintTimeoutAsError()
    {
        return isset($this->ReportPrintTimeoutAsError) ? $this->ReportPrintTimeoutAsError : null;
    }
    /**
     * Set ReportPrintTimeoutAsError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reportPrintTimeoutAsError
     * @return \patest\StructType\Printing_Printer
     */
    public function setReportPrintTimeoutAsError($reportPrintTimeoutAsError = null)
    {
        // validation for constraint: boolean
        if (!is_null($reportPrintTimeoutAsError) && !is_bool($reportPrintTimeoutAsError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reportPrintTimeoutAsError, true), gettype($reportPrintTimeoutAsError)), __LINE__);
        }
        if (is_null($reportPrintTimeoutAsError) || (is_array($reportPrintTimeoutAsError) && empty($reportPrintTimeoutAsError))) {
            unset($this->ReportPrintTimeoutAsError);
        } else {
            $this->ReportPrintTimeoutAsError = $reportPrintTimeoutAsError;
        }
        return $this;
    }
    /**
     * Get ScanTicketsAfterPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getScanTicketsAfterPrint()
    {
        return isset($this->ScanTicketsAfterPrint) ? $this->ScanTicketsAfterPrint : null;
    }
    /**
     * Set ScanTicketsAfterPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $scanTicketsAfterPrint
     * @return \patest\StructType\Printing_Printer
     */
    public function setScanTicketsAfterPrint($scanTicketsAfterPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($scanTicketsAfterPrint) && !is_bool($scanTicketsAfterPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scanTicketsAfterPrint, true), gettype($scanTicketsAfterPrint)), __LINE__);
        }
        if (is_null($scanTicketsAfterPrint) || (is_array($scanTicketsAfterPrint) && empty($scanTicketsAfterPrint))) {
            unset($this->ScanTicketsAfterPrint);
        } else {
            $this->ScanTicketsAfterPrint = $scanTicketsAfterPrint;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WorkingStatus::valueIsValid()
     * @uses \patest\EnumType\WorkingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Printing_Printer
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WorkingStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WorkingStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\WorkingStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TargetDocumentPath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetDocumentPath()
    {
        return isset($this->TargetDocumentPath) ? $this->TargetDocumentPath : null;
    }
    /**
     * Set TargetDocumentPath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetDocumentPath
     * @return \patest\StructType\Printing_Printer
     */
    public function setTargetDocumentPath($targetDocumentPath = null)
    {
        // validation for constraint: string
        if (!is_null($targetDocumentPath) && !is_string($targetDocumentPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetDocumentPath, true), gettype($targetDocumentPath)), __LINE__);
        }
        if (is_null($targetDocumentPath) || (is_array($targetDocumentPath) && empty($targetDocumentPath))) {
            unset($this->TargetDocumentPath);
        } else {
            $this->TargetDocumentPath = $targetDocumentPath;
        }
        return $this;
    }
    /**
     * Get Trays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrinterTray|null
     */
    public function getTrays()
    {
        return isset($this->Trays) ? $this->Trays : null;
    }
    /**
     * Set Trays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrinterTray $trays
     * @return \patest\StructType\Printing_Printer
     */
    public function setTrays(\patest\StructType\RecordSetOfPrinting_PrinterTray $trays = null)
    {
        if (is_null($trays) || (is_array($trays) && empty($trays))) {
            unset($this->Trays);
        } else {
            $this->Trays = $trays;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Printing_Printer
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\Printing_Printer
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
