<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.VisitAttachment StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_VisitAttachment extends Printing_PrintableItem_Base
{
    /**
     * The OrderData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_OrderData
     */
    public $OrderData;
    /**
     * The QuotationExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QuotationExpiryDate;
    /**
     * The Visit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public $Visit;
    /**
     * Constructor method for Printing.PrintableItem.VisitAttachment
     * @uses Printing_PrintableItem_VisitAttachment::setOrderData()
     * @uses Printing_PrintableItem_VisitAttachment::setQuotationExpiryDate()
     * @uses Printing_PrintableItem_VisitAttachment::setVisit()
     * @param \patest\StructType\Printing_PrintableItem_OrderData $orderData
     * @param string $quotationExpiryDate
     * @param \patest\StructType\Printing_PrintableItem_OrderVisit $visit
     */
    public function __construct(\patest\StructType\Printing_PrintableItem_OrderData $orderData = null, $quotationExpiryDate = null, \patest\StructType\Printing_PrintableItem_OrderVisit $visit = null)
    {
        $this
            ->setOrderData($orderData)
            ->setQuotationExpiryDate($quotationExpiryDate)
            ->setVisit($visit);
    }
    /**
     * Get OrderData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_OrderData|null
     */
    public function getOrderData()
    {
        return isset($this->OrderData) ? $this->OrderData : null;
    }
    /**
     * Set OrderData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_OrderData $orderData
     * @return \patest\StructType\Printing_PrintableItem_VisitAttachment
     */
    public function setOrderData(\patest\StructType\Printing_PrintableItem_OrderData $orderData = null)
    {
        if (is_null($orderData) || (is_array($orderData) && empty($orderData))) {
            unset($this->OrderData);
        } else {
            $this->OrderData = $orderData;
        }
        return $this;
    }
    /**
     * Get QuotationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQuotationExpiryDate()
    {
        return isset($this->QuotationExpiryDate) ? $this->QuotationExpiryDate : null;
    }
    /**
     * Set QuotationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $quotationExpiryDate
     * @return \patest\StructType\Printing_PrintableItem_VisitAttachment
     */
    public function setQuotationExpiryDate($quotationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($quotationExpiryDate) && !is_string($quotationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quotationExpiryDate, true), gettype($quotationExpiryDate)), __LINE__);
        }
        if (is_null($quotationExpiryDate) || (is_array($quotationExpiryDate) && empty($quotationExpiryDate))) {
            unset($this->QuotationExpiryDate);
        } else {
            $this->QuotationExpiryDate = $quotationExpiryDate;
        }
        return $this;
    }
    /**
     * Get Visit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit|null
     */
    public function getVisit()
    {
        return isset($this->Visit) ? $this->Visit : null;
    }
    /**
     * Set Visit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_OrderVisit $visit
     * @return \patest\StructType\Printing_PrintableItem_VisitAttachment
     */
    public function setVisit(\patest\StructType\Printing_PrintableItem_OrderVisit $visit = null)
    {
        if (is_null($visit) || (is_array($visit) && empty($visit))) {
            unset($this->Visit);
        } else {
            $this->Visit = $visit;
        }
        return $this;
    }
}
