<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.UnionSubsidyPaymentItem StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_UnionSubsidyPaymentItem extends Printing_PrintableItem_PaymentItemBase
{
    /**
     * The SubsidizingAccount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_Account
     */
    public $SubsidizingAccount;
    /**
     * The SubsidizingAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubsidizingAccountId;
    /**
     * The SubsidizingAccountName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubsidizingAccountName;
    /**
     * Constructor method for Printing.PrintableItem.UnionSubsidyPaymentItem
     * @uses Printing_PrintableItem_UnionSubsidyPaymentItem::setSubsidizingAccount()
     * @uses Printing_PrintableItem_UnionSubsidyPaymentItem::setSubsidizingAccountId()
     * @uses Printing_PrintableItem_UnionSubsidyPaymentItem::setSubsidizingAccountName()
     * @param \patest\StructType\Crm_Account $subsidizingAccount
     * @param string $subsidizingAccountId
     * @param string $subsidizingAccountName
     */
    public function __construct(\patest\StructType\Crm_Account $subsidizingAccount = null, $subsidizingAccountId = null, $subsidizingAccountName = null)
    {
        $this
            ->setSubsidizingAccount($subsidizingAccount)
            ->setSubsidizingAccountId($subsidizingAccountId)
            ->setSubsidizingAccountName($subsidizingAccountName);
    }
    /**
     * Get SubsidizingAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_Account|null
     */
    public function getSubsidizingAccount()
    {
        return isset($this->SubsidizingAccount) ? $this->SubsidizingAccount : null;
    }
    /**
     * Set SubsidizingAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_Account $subsidizingAccount
     * @return \patest\StructType\Printing_PrintableItem_UnionSubsidyPaymentItem
     */
    public function setSubsidizingAccount(\patest\StructType\Crm_Account $subsidizingAccount = null)
    {
        if (is_null($subsidizingAccount) || (is_array($subsidizingAccount) && empty($subsidizingAccount))) {
            unset($this->SubsidizingAccount);
        } else {
            $this->SubsidizingAccount = $subsidizingAccount;
        }
        return $this;
    }
    /**
     * Get SubsidizingAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizingAccountId()
    {
        return isset($this->SubsidizingAccountId) ? $this->SubsidizingAccountId : null;
    }
    /**
     * Set SubsidizingAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizingAccountId
     * @return \patest\StructType\Printing_PrintableItem_UnionSubsidyPaymentItem
     */
    public function setSubsidizingAccountId($subsidizingAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizingAccountId) && !is_string($subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizingAccountId, true), gettype($subsidizingAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subsidizingAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subsidizingAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subsidizingAccountId, true)), __LINE__);
        }
        if (is_null($subsidizingAccountId) || (is_array($subsidizingAccountId) && empty($subsidizingAccountId))) {
            unset($this->SubsidizingAccountId);
        } else {
            $this->SubsidizingAccountId = $subsidizingAccountId;
        }
        return $this;
    }
    /**
     * Get SubsidizingAccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizingAccountName()
    {
        return isset($this->SubsidizingAccountName) ? $this->SubsidizingAccountName : null;
    }
    /**
     * Set SubsidizingAccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizingAccountName
     * @return \patest\StructType\Printing_PrintableItem_UnionSubsidyPaymentItem
     */
    public function setSubsidizingAccountName($subsidizingAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizingAccountName) && !is_string($subsidizingAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizingAccountName, true), gettype($subsidizingAccountName)), __LINE__);
        }
        if (is_null($subsidizingAccountName) || (is_array($subsidizingAccountName) && empty($subsidizingAccountName))) {
            unset($this->SubsidizingAccountName);
        } else {
            $this->SubsidizingAccountName = $subsidizingAccountName;
        }
        return $this;
    }
}
