<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.SeatAllocationAuditDetails
 * StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_SeatAllocationAuditDetails extends AnyEntity
{
    /**
     * The AllocationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_AllocationType
     */
    public $AllocationType;
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Area
     */
    public $Area;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTime;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Event
     */
    public $Event;
    /**
     * The FaceValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $FaceValue;
    /**
     * The Hall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Hall
     */
    public $Hall;
    /**
     * The PriceLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_PriceLevel
     */
    public $PriceLevel;
    /**
     * The RestorationLevy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RestorationLevy;
    /**
     * The Row
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Row;
    /**
     * The SeatActivity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatActivity;
    /**
     * The SeatCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatCount;
    /**
     * The SeatRange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatRange;
    /**
     * The SeatTypeNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTypeNote;
    /**
     * The Sector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Sector
     */
    public $Sector;
    /**
     * The Show
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Show
     */
    public $Show;
    /**
     * The ShowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_ShowType
     */
    public $ShowType;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The Venue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Venue
     */
    public $Venue;
    /**
     * Constructor method for Printing.PrintableItem.SeatAllocationAuditDetails
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setAllocationType()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setArea()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setDateTime()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setEvent()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setFaceValue()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setHall()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setPriceLevel()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setRestorationLevy()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setRow()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setSeatActivity()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setSeatCount()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setSeatRange()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setSeatTypeNote()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setSector()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setShow()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setShowType()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setUserName()
     * @uses Printing_PrintableItem_SeatAllocationAuditDetails::setVenue()
     * @param \patest\StructType\Ticketing_Printing_AllocationType $allocationType
     * @param \patest\StructType\Ticketing_Printing_Area $area
     * @param string $dateTime
     * @param \patest\StructType\Ticketing_Printing_Event $event
     * @param \patest\StructType\Money $faceValue
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @param \patest\StructType\Ticketing_Printing_PriceLevel $priceLevel
     * @param \patest\StructType\Money $restorationLevy
     * @param string $row
     * @param string $seatActivity
     * @param int $seatCount
     * @param string $seatRange
     * @param string $seatTypeNote
     * @param \patest\StructType\Ticketing_Printing_Sector $sector
     * @param \patest\StructType\Ticketing_Printing_Show $show
     * @param \patest\StructType\Ticketing_Printing_ShowType $showType
     * @param string $userName
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     */
    public function __construct(\patest\StructType\Ticketing_Printing_AllocationType $allocationType = null, \patest\StructType\Ticketing_Printing_Area $area = null, $dateTime = null, \patest\StructType\Ticketing_Printing_Event $event = null, \patest\StructType\Money $faceValue = null, \patest\StructType\Ticketing_Printing_Hall $hall = null, \patest\StructType\Ticketing_Printing_PriceLevel $priceLevel = null, \patest\StructType\Money $restorationLevy = null, $row = null, $seatActivity = null, $seatCount = null, $seatRange = null, $seatTypeNote = null, \patest\StructType\Ticketing_Printing_Sector $sector = null, \patest\StructType\Ticketing_Printing_Show $show = null, \patest\StructType\Ticketing_Printing_ShowType $showType = null, $userName = null, \patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        $this
            ->setAllocationType($allocationType)
            ->setArea($area)
            ->setDateTime($dateTime)
            ->setEvent($event)
            ->setFaceValue($faceValue)
            ->setHall($hall)
            ->setPriceLevel($priceLevel)
            ->setRestorationLevy($restorationLevy)
            ->setRow($row)
            ->setSeatActivity($seatActivity)
            ->setSeatCount($seatCount)
            ->setSeatRange($seatRange)
            ->setSeatTypeNote($seatTypeNote)
            ->setSector($sector)
            ->setShow($show)
            ->setShowType($showType)
            ->setUserName($userName)
            ->setVenue($venue);
    }
    /**
     * Get AllocationType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_AllocationType|null
     */
    public function getAllocationType()
    {
        return isset($this->AllocationType) ? $this->AllocationType : null;
    }
    /**
     * Set AllocationType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_AllocationType $allocationType
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setAllocationType(\patest\StructType\Ticketing_Printing_AllocationType $allocationType = null)
    {
        if (is_null($allocationType) || (is_array($allocationType) && empty($allocationType))) {
            unset($this->AllocationType);
        } else {
            $this->AllocationType = $allocationType;
        }
        return $this;
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Area|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Area $area
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setArea(\patest\StructType\Ticketing_Printing_Area $area = null)
    {
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get DateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTime()
    {
        return isset($this->DateTime) ? $this->DateTime : null;
    }
    /**
     * Set DateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTime
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        if (is_null($dateTime) || (is_array($dateTime) && empty($dateTime))) {
            unset($this->DateTime);
        } else {
            $this->DateTime = $dateTime;
        }
        return $this;
    }
    /**
     * Get Event value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Event|null
     */
    public function getEvent()
    {
        return isset($this->Event) ? $this->Event : null;
    }
    /**
     * Set Event value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Event $event
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setEvent(\patest\StructType\Ticketing_Printing_Event $event = null)
    {
        if (is_null($event) || (is_array($event) && empty($event))) {
            unset($this->Event);
        } else {
            $this->Event = $event;
        }
        return $this;
    }
    /**
     * Get FaceValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getFaceValue()
    {
        return isset($this->FaceValue) ? $this->FaceValue : null;
    }
    /**
     * Set FaceValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $faceValue
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setFaceValue(\patest\StructType\Money $faceValue = null)
    {
        if (is_null($faceValue) || (is_array($faceValue) && empty($faceValue))) {
            unset($this->FaceValue);
        } else {
            $this->FaceValue = $faceValue;
        }
        return $this;
    }
    /**
     * Get Hall value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Hall|null
     */
    public function getHall()
    {
        return isset($this->Hall) ? $this->Hall : null;
    }
    /**
     * Set Hall value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setHall(\patest\StructType\Ticketing_Printing_Hall $hall = null)
    {
        if (is_null($hall) || (is_array($hall) && empty($hall))) {
            unset($this->Hall);
        } else {
            $this->Hall = $hall;
        }
        return $this;
    }
    /**
     * Get PriceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_PriceLevel|null
     */
    public function getPriceLevel()
    {
        return isset($this->PriceLevel) ? $this->PriceLevel : null;
    }
    /**
     * Set PriceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_PriceLevel $priceLevel
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setPriceLevel(\patest\StructType\Ticketing_Printing_PriceLevel $priceLevel = null)
    {
        if (is_null($priceLevel) || (is_array($priceLevel) && empty($priceLevel))) {
            unset($this->PriceLevel);
        } else {
            $this->PriceLevel = $priceLevel;
        }
        return $this;
    }
    /**
     * Get RestorationLevy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRestorationLevy()
    {
        return isset($this->RestorationLevy) ? $this->RestorationLevy : null;
    }
    /**
     * Set RestorationLevy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $restorationLevy
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setRestorationLevy(\patest\StructType\Money $restorationLevy = null)
    {
        if (is_null($restorationLevy) || (is_array($restorationLevy) && empty($restorationLevy))) {
            unset($this->RestorationLevy);
        } else {
            $this->RestorationLevy = $restorationLevy;
        }
        return $this;
    }
    /**
     * Get Row value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRow()
    {
        return isset($this->Row) ? $this->Row : null;
    }
    /**
     * Set Row value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $row
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setRow($row = null)
    {
        // validation for constraint: string
        if (!is_null($row) && !is_string($row)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($row, true), gettype($row)), __LINE__);
        }
        if (is_null($row) || (is_array($row) && empty($row))) {
            unset($this->Row);
        } else {
            $this->Row = $row;
        }
        return $this;
    }
    /**
     * Get SeatActivity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatActivity()
    {
        return isset($this->SeatActivity) ? $this->SeatActivity : null;
    }
    /**
     * Set SeatActivity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatActivity::valueIsValid()
     * @uses \patest\EnumType\SeatActivity::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seatActivity
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setSeatActivity($seatActivity = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SeatActivity::valueIsValid($seatActivity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatActivity', is_array($seatActivity) ? implode(', ', $seatActivity) : var_export($seatActivity, true), implode(', ', \patest\EnumType\SeatActivity::getValidValues())), __LINE__);
        }
        if (is_null($seatActivity) || (is_array($seatActivity) && empty($seatActivity))) {
            unset($this->SeatActivity);
        } else {
            $this->SeatActivity = $seatActivity;
        }
        return $this;
    }
    /**
     * Get SeatCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatCount()
    {
        return isset($this->SeatCount) ? $this->SeatCount : null;
    }
    /**
     * Set SeatCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatCount
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setSeatCount($seatCount = null)
    {
        // validation for constraint: int
        if (!is_null($seatCount) && !(is_int($seatCount) || ctype_digit($seatCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatCount, true), gettype($seatCount)), __LINE__);
        }
        if (is_null($seatCount) || (is_array($seatCount) && empty($seatCount))) {
            unset($this->SeatCount);
        } else {
            $this->SeatCount = $seatCount;
        }
        return $this;
    }
    /**
     * Get SeatRange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatRange()
    {
        return isset($this->SeatRange) ? $this->SeatRange : null;
    }
    /**
     * Set SeatRange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatRange
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setSeatRange($seatRange = null)
    {
        // validation for constraint: string
        if (!is_null($seatRange) && !is_string($seatRange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRange, true), gettype($seatRange)), __LINE__);
        }
        if (is_null($seatRange) || (is_array($seatRange) && empty($seatRange))) {
            unset($this->SeatRange);
        } else {
            $this->SeatRange = $seatRange;
        }
        return $this;
    }
    /**
     * Get SeatTypeNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTypeNote()
    {
        return isset($this->SeatTypeNote) ? $this->SeatTypeNote : null;
    }
    /**
     * Set SeatTypeNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTypeNote
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setSeatTypeNote($seatTypeNote = null)
    {
        // validation for constraint: string
        if (!is_null($seatTypeNote) && !is_string($seatTypeNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTypeNote, true), gettype($seatTypeNote)), __LINE__);
        }
        if (is_null($seatTypeNote) || (is_array($seatTypeNote) && empty($seatTypeNote))) {
            unset($this->SeatTypeNote);
        } else {
            $this->SeatTypeNote = $seatTypeNote;
        }
        return $this;
    }
    /**
     * Get Sector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Sector|null
     */
    public function getSector()
    {
        return isset($this->Sector) ? $this->Sector : null;
    }
    /**
     * Set Sector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Sector $sector
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setSector(\patest\StructType\Ticketing_Printing_Sector $sector = null)
    {
        if (is_null($sector) || (is_array($sector) && empty($sector))) {
            unset($this->Sector);
        } else {
            $this->Sector = $sector;
        }
        return $this;
    }
    /**
     * Get Show value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Show|null
     */
    public function getShow()
    {
        return isset($this->Show) ? $this->Show : null;
    }
    /**
     * Set Show value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Show $show
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setShow(\patest\StructType\Ticketing_Printing_Show $show = null)
    {
        if (is_null($show) || (is_array($show) && empty($show))) {
            unset($this->Show);
        } else {
            $this->Show = $show;
        }
        return $this;
    }
    /**
     * Get ShowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_ShowType|null
     */
    public function getShowType()
    {
        return isset($this->ShowType) ? $this->ShowType : null;
    }
    /**
     * Set ShowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_ShowType $showType
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setShowType(\patest\StructType\Ticketing_Printing_ShowType $showType = null)
    {
        if (is_null($showType) || (is_array($showType) && empty($showType))) {
            unset($this->ShowType);
        } else {
            $this->ShowType = $showType;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get Venue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Venue|null
     */
    public function getVenue()
    {
        return isset($this->Venue) ? $this->Venue : null;
    }
    /**
     * Set Venue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     * @return \patest\StructType\Printing_PrintableItem_SeatAllocationAuditDetails
     */
    public function setVenue(\patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        if (is_null($venue) || (is_array($venue) && empty($venue))) {
            unset($this->Venue);
        } else {
            $this->Venue = $venue;
        }
        return $this;
    }
}
