<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.OrderVisit StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_OrderVisit extends Printing_PrintableItem_Base
{
    /**
     * The Activities
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_Activity
     */
    public $Activities;
    /**
     * The ActivitiesSchedule
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_ActivitySchedule
     */
    public $ActivitiesSchedule;
    /**
     * The Classes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Classes;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_Comment
     */
    public $Comments;
    /**
     * The Contact
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_StandaloneCustomer
     */
    public $Contact;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The GradeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GradeName;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupName;
    /**
     * The GroupSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupSize;
    /**
     * The MinStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinStartTime;
    /**
     * The Payer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_StandaloneAccount
     */
    public $Payer;
    /**
     * The PreferredEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredEndDate;
    /**
     * The PreferredStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredStartDate;
    /**
     * The Prices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_VisitPrice
     */
    public $Prices;
    /**
     * The PricingPerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingPerType;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalAmount;
    /**
     * The VisitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitDate;
    /**
     * The VisitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitName;
    /**
     * The VisitNatureId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitNatureId;
    /**
     * The VisitNatureName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $VisitNatureName;
    /**
     * The VisitPlanId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPlanId;
    /**
     * The VisitPlanName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $VisitPlanName;
    /**
     * The VisitServices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_Service
     */
    public $VisitServices;
    /**
     * The VisitTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitTypeId;
    /**
     * The VisitTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $VisitTypeName;
    /**
     * Constructor method for Printing.PrintableItem.OrderVisit
     * @uses Printing_PrintableItem_OrderVisit::setActivities()
     * @uses Printing_PrintableItem_OrderVisit::setActivitiesSchedule()
     * @uses Printing_PrintableItem_OrderVisit::setClasses()
     * @uses Printing_PrintableItem_OrderVisit::setComments()
     * @uses Printing_PrintableItem_OrderVisit::setContact()
     * @uses Printing_PrintableItem_OrderVisit::setEmail()
     * @uses Printing_PrintableItem_OrderVisit::setGradeName()
     * @uses Printing_PrintableItem_OrderVisit::setGroupName()
     * @uses Printing_PrintableItem_OrderVisit::setGroupSize()
     * @uses Printing_PrintableItem_OrderVisit::setMinStartTime()
     * @uses Printing_PrintableItem_OrderVisit::setPayer()
     * @uses Printing_PrintableItem_OrderVisit::setPreferredEndDate()
     * @uses Printing_PrintableItem_OrderVisit::setPreferredStartDate()
     * @uses Printing_PrintableItem_OrderVisit::setPrices()
     * @uses Printing_PrintableItem_OrderVisit::setPricingPerType()
     * @uses Printing_PrintableItem_OrderVisit::setTotalAmount()
     * @uses Printing_PrintableItem_OrderVisit::setVisitDate()
     * @uses Printing_PrintableItem_OrderVisit::setVisitName()
     * @uses Printing_PrintableItem_OrderVisit::setVisitNatureId()
     * @uses Printing_PrintableItem_OrderVisit::setVisitNatureName()
     * @uses Printing_PrintableItem_OrderVisit::setVisitPlanId()
     * @uses Printing_PrintableItem_OrderVisit::setVisitPlanName()
     * @uses Printing_PrintableItem_OrderVisit::setVisitServices()
     * @uses Printing_PrintableItem_OrderVisit::setVisitTypeId()
     * @uses Printing_PrintableItem_OrderVisit::setVisitTypeName()
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Activity $activities
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_ActivitySchedule $activitiesSchedule
     * @param string $classes
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Comment $comments
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneCustomer $contact
     * @param string $email
     * @param \patest\StructType\GlobalString $gradeName
     * @param string $groupName
     * @param int $groupSize
     * @param string $minStartTime
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer
     * @param string $preferredEndDate
     * @param string $preferredStartDate
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_VisitPrice $prices
     * @param string $pricingPerType
     * @param float $totalAmount
     * @param string $visitDate
     * @param string $visitName
     * @param string $visitNatureId
     * @param \patest\StructType\GlobalString $visitNatureName
     * @param string $visitPlanId
     * @param \patest\StructType\GlobalString $visitPlanName
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Service $visitServices
     * @param string $visitTypeId
     * @param \patest\StructType\GlobalString $visitTypeName
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_PrintableItem_Activity $activities = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_ActivitySchedule $activitiesSchedule = null, $classes = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_Comment $comments = null, \patest\StructType\Printing_AuxDataItem_StandaloneCustomer $contact = null, $email = null, \patest\StructType\GlobalString $gradeName = null, $groupName = null, $groupSize = null, $minStartTime = null, \patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer = null, $preferredEndDate = null, $preferredStartDate = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_VisitPrice $prices = null, $pricingPerType = null, $totalAmount = null, $visitDate = null, $visitName = null, $visitNatureId = null, \patest\StructType\GlobalString $visitNatureName = null, $visitPlanId = null, \patest\StructType\GlobalString $visitPlanName = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_Service $visitServices = null, $visitTypeId = null, \patest\StructType\GlobalString $visitTypeName = null)
    {
        $this
            ->setActivities($activities)
            ->setActivitiesSchedule($activitiesSchedule)
            ->setClasses($classes)
            ->setComments($comments)
            ->setContact($contact)
            ->setEmail($email)
            ->setGradeName($gradeName)
            ->setGroupName($groupName)
            ->setGroupSize($groupSize)
            ->setMinStartTime($minStartTime)
            ->setPayer($payer)
            ->setPreferredEndDate($preferredEndDate)
            ->setPreferredStartDate($preferredStartDate)
            ->setPrices($prices)
            ->setPricingPerType($pricingPerType)
            ->setTotalAmount($totalAmount)
            ->setVisitDate($visitDate)
            ->setVisitName($visitName)
            ->setVisitNatureId($visitNatureId)
            ->setVisitNatureName($visitNatureName)
            ->setVisitPlanId($visitPlanId)
            ->setVisitPlanName($visitPlanName)
            ->setVisitServices($visitServices)
            ->setVisitTypeId($visitTypeId)
            ->setVisitTypeName($visitTypeName);
    }
    /**
     * Get Activities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_Activity|null
     */
    public function getActivities()
    {
        return isset($this->Activities) ? $this->Activities : null;
    }
    /**
     * Set Activities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Activity $activities
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setActivities(\patest\StructType\RecordSetOfPrinting_PrintableItem_Activity $activities = null)
    {
        if (is_null($activities) || (is_array($activities) && empty($activities))) {
            unset($this->Activities);
        } else {
            $this->Activities = $activities;
        }
        return $this;
    }
    /**
     * Get ActivitiesSchedule value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_ActivitySchedule|null
     */
    public function getActivitiesSchedule()
    {
        return isset($this->ActivitiesSchedule) ? $this->ActivitiesSchedule : null;
    }
    /**
     * Set ActivitiesSchedule value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_ActivitySchedule $activitiesSchedule
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setActivitiesSchedule(\patest\StructType\RecordSetOfPrinting_PrintableItem_ActivitySchedule $activitiesSchedule = null)
    {
        if (is_null($activitiesSchedule) || (is_array($activitiesSchedule) && empty($activitiesSchedule))) {
            unset($this->ActivitiesSchedule);
        } else {
            $this->ActivitiesSchedule = $activitiesSchedule;
        }
        return $this;
    }
    /**
     * Get Classes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClasses()
    {
        return isset($this->Classes) ? $this->Classes : null;
    }
    /**
     * Set Classes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classes
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setClasses($classes = null)
    {
        // validation for constraint: string
        if (!is_null($classes) && !is_string($classes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classes, true), gettype($classes)), __LINE__);
        }
        if (is_null($classes) || (is_array($classes) && empty($classes))) {
            unset($this->Classes);
        } else {
            $this->Classes = $classes;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_Comment|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Comment $comments
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setComments(\patest\StructType\RecordSetOfPrinting_PrintableItem_Comment $comments = null)
    {
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneCustomer|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneCustomer $contact
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setContact(\patest\StructType\Printing_AuxDataItem_StandaloneCustomer $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get GradeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGradeName()
    {
        return isset($this->GradeName) ? $this->GradeName : null;
    }
    /**
     * Set GradeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $gradeName
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setGradeName(\patest\StructType\GlobalString $gradeName = null)
    {
        if (is_null($gradeName) || (is_array($gradeName) && empty($gradeName))) {
            unset($this->GradeName);
        } else {
            $this->GradeName = $gradeName;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupName
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get GroupSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupSize()
    {
        return isset($this->GroupSize) ? $this->GroupSize : null;
    }
    /**
     * Set GroupSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupSize
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setGroupSize($groupSize = null)
    {
        // validation for constraint: int
        if (!is_null($groupSize) && !(is_int($groupSize) || ctype_digit($groupSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupSize, true), gettype($groupSize)), __LINE__);
        }
        if (is_null($groupSize) || (is_array($groupSize) && empty($groupSize))) {
            unset($this->GroupSize);
        } else {
            $this->GroupSize = $groupSize;
        }
        return $this;
    }
    /**
     * Get MinStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinStartTime()
    {
        return isset($this->MinStartTime) ? $this->MinStartTime : null;
    }
    /**
     * Set MinStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minStartTime
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setMinStartTime($minStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($minStartTime) && !is_string($minStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minStartTime, true), gettype($minStartTime)), __LINE__);
        }
        if (is_null($minStartTime) || (is_array($minStartTime) && empty($minStartTime))) {
            unset($this->MinStartTime);
        } else {
            $this->MinStartTime = $minStartTime;
        }
        return $this;
    }
    /**
     * Get Payer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneAccount|null
     */
    public function getPayer()
    {
        return isset($this->Payer) ? $this->Payer : null;
    }
    /**
     * Set Payer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setPayer(\patest\StructType\Printing_AuxDataItem_StandaloneAccount $payer = null)
    {
        if (is_null($payer) || (is_array($payer) && empty($payer))) {
            unset($this->Payer);
        } else {
            $this->Payer = $payer;
        }
        return $this;
    }
    /**
     * Get PreferredEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredEndDate()
    {
        return isset($this->PreferredEndDate) ? $this->PreferredEndDate : null;
    }
    /**
     * Set PreferredEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredEndDate
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setPreferredEndDate($preferredEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredEndDate) && !is_string($preferredEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredEndDate, true), gettype($preferredEndDate)), __LINE__);
        }
        if (is_null($preferredEndDate) || (is_array($preferredEndDate) && empty($preferredEndDate))) {
            unset($this->PreferredEndDate);
        } else {
            $this->PreferredEndDate = $preferredEndDate;
        }
        return $this;
    }
    /**
     * Get PreferredStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredStartDate()
    {
        return isset($this->PreferredStartDate) ? $this->PreferredStartDate : null;
    }
    /**
     * Set PreferredStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredStartDate
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setPreferredStartDate($preferredStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredStartDate) && !is_string($preferredStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredStartDate, true), gettype($preferredStartDate)), __LINE__);
        }
        if (is_null($preferredStartDate) || (is_array($preferredStartDate) && empty($preferredStartDate))) {
            unset($this->PreferredStartDate);
        } else {
            $this->PreferredStartDate = $preferredStartDate;
        }
        return $this;
    }
    /**
     * Get Prices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_VisitPrice|null
     */
    public function getPrices()
    {
        return isset($this->Prices) ? $this->Prices : null;
    }
    /**
     * Set Prices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_VisitPrice $prices
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setPrices(\patest\StructType\RecordSetOfPrinting_PrintableItem_VisitPrice $prices = null)
    {
        if (is_null($prices) || (is_array($prices) && empty($prices))) {
            unset($this->Prices);
        } else {
            $this->Prices = $prices;
        }
        return $this;
    }
    /**
     * Get PricingPerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingPerType()
    {
        return isset($this->PricingPerType) ? $this->PricingPerType : null;
    }
    /**
     * Set PricingPerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingPerType::valueIsValid()
     * @uses \patest\EnumType\PricingPerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingPerType
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setPricingPerType($pricingPerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingPerType::valueIsValid($pricingPerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingPerType', is_array($pricingPerType) ? implode(', ', $pricingPerType) : var_export($pricingPerType, true), implode(', ', \patest\EnumType\PricingPerType::getValidValues())), __LINE__);
        }
        if (is_null($pricingPerType) || (is_array($pricingPerType) && empty($pricingPerType))) {
            unset($this->PricingPerType);
        } else {
            $this->PricingPerType = $pricingPerType;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalAmount
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setTotalAmount($totalAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalAmount) && !(is_float($totalAmount) || is_numeric($totalAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAmount, true), gettype($totalAmount)), __LINE__);
        }
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get VisitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitDate()
    {
        return isset($this->VisitDate) ? $this->VisitDate : null;
    }
    /**
     * Set VisitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitDate
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setVisitDate($visitDate = null)
    {
        // validation for constraint: string
        if (!is_null($visitDate) && !is_string($visitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitDate, true), gettype($visitDate)), __LINE__);
        }
        if (is_null($visitDate) || (is_array($visitDate) && empty($visitDate))) {
            unset($this->VisitDate);
        } else {
            $this->VisitDate = $visitDate;
        }
        return $this;
    }
    /**
     * Get VisitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitName()
    {
        return isset($this->VisitName) ? $this->VisitName : null;
    }
    /**
     * Set VisitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitName
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setVisitName($visitName = null)
    {
        // validation for constraint: string
        if (!is_null($visitName) && !is_string($visitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitName, true), gettype($visitName)), __LINE__);
        }
        if (is_null($visitName) || (is_array($visitName) && empty($visitName))) {
            unset($this->VisitName);
        } else {
            $this->VisitName = $visitName;
        }
        return $this;
    }
    /**
     * Get VisitNatureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitNatureId()
    {
        return isset($this->VisitNatureId) ? $this->VisitNatureId : null;
    }
    /**
     * Set VisitNatureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitNatureId
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setVisitNatureId($visitNatureId = null)
    {
        // validation for constraint: string
        if (!is_null($visitNatureId) && !is_string($visitNatureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitNatureId, true), gettype($visitNatureId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitNatureId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitNatureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitNatureId, true)), __LINE__);
        }
        if (is_null($visitNatureId) || (is_array($visitNatureId) && empty($visitNatureId))) {
            unset($this->VisitNatureId);
        } else {
            $this->VisitNatureId = $visitNatureId;
        }
        return $this;
    }
    /**
     * Get VisitNatureName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getVisitNatureName()
    {
        return isset($this->VisitNatureName) ? $this->VisitNatureName : null;
    }
    /**
     * Set VisitNatureName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $visitNatureName
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setVisitNatureName(\patest\StructType\GlobalString $visitNatureName = null)
    {
        if (is_null($visitNatureName) || (is_array($visitNatureName) && empty($visitNatureName))) {
            unset($this->VisitNatureName);
        } else {
            $this->VisitNatureName = $visitNatureName;
        }
        return $this;
    }
    /**
     * Get VisitPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPlanId()
    {
        return isset($this->VisitPlanId) ? $this->VisitPlanId : null;
    }
    /**
     * Set VisitPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPlanId
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setVisitPlanId($visitPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPlanId) && !is_string($visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPlanId, true), gettype($visitPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPlanId, true)), __LINE__);
        }
        if (is_null($visitPlanId) || (is_array($visitPlanId) && empty($visitPlanId))) {
            unset($this->VisitPlanId);
        } else {
            $this->VisitPlanId = $visitPlanId;
        }
        return $this;
    }
    /**
     * Get VisitPlanName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getVisitPlanName()
    {
        return isset($this->VisitPlanName) ? $this->VisitPlanName : null;
    }
    /**
     * Set VisitPlanName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $visitPlanName
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setVisitPlanName(\patest\StructType\GlobalString $visitPlanName = null)
    {
        if (is_null($visitPlanName) || (is_array($visitPlanName) && empty($visitPlanName))) {
            unset($this->VisitPlanName);
        } else {
            $this->VisitPlanName = $visitPlanName;
        }
        return $this;
    }
    /**
     * Get VisitServices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_Service|null
     */
    public function getVisitServices()
    {
        return isset($this->VisitServices) ? $this->VisitServices : null;
    }
    /**
     * Set VisitServices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_Service $visitServices
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setVisitServices(\patest\StructType\RecordSetOfPrinting_PrintableItem_Service $visitServices = null)
    {
        if (is_null($visitServices) || (is_array($visitServices) && empty($visitServices))) {
            unset($this->VisitServices);
        } else {
            $this->VisitServices = $visitServices;
        }
        return $this;
    }
    /**
     * Get VisitTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitTypeId()
    {
        return isset($this->VisitTypeId) ? $this->VisitTypeId : null;
    }
    /**
     * Set VisitTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitTypeId
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setVisitTypeId($visitTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($visitTypeId) && !is_string($visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitTypeId, true), gettype($visitTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitTypeId, true)), __LINE__);
        }
        if (is_null($visitTypeId) || (is_array($visitTypeId) && empty($visitTypeId))) {
            unset($this->VisitTypeId);
        } else {
            $this->VisitTypeId = $visitTypeId;
        }
        return $this;
    }
    /**
     * Get VisitTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getVisitTypeName()
    {
        return isset($this->VisitTypeName) ? $this->VisitTypeName : null;
    }
    /**
     * Set VisitTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $visitTypeName
     * @return \patest\StructType\Printing_PrintableItem_OrderVisit
     */
    public function setVisitTypeName(\patest\StructType\GlobalString $visitTypeName = null)
    {
        if (is_null($visitTypeName) || (is_array($visitTypeName) && empty($visitTypeName))) {
            unset($this->VisitTypeName);
        } else {
            $this->VisitTypeName = $visitTypeName;
        }
        return $this;
    }
}
