<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.MerchandiseItem StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_MerchandiseItem extends Printing_PrintableItem_BasketItemBase
{
    /**
     * The AddOns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_MerchandiseAddOn
     */
    public $AddOns;
    /**
     * The Category_Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Category_Description;
    /**
     * The Category_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Category_Name;
    /**
     * The ItemType_Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ItemType_Description;
    /**
     * The ItemType_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ItemType_Name;
    /**
     * The Media_BriefOverview
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Media_BriefOverview;
    /**
     * The Media_DetailOverview
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Media_DetailOverview;
    /**
     * The Media_ReviewUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Media_ReviewUrl;
    /**
     * The Media_TrailerUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Media_TrailerUrl;
    /**
     * The Merchandise_Barcode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Merchandise_Barcode;
    /**
     * The Merchandise_CategoryId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Merchandise_CategoryId;
    /**
     * The Merchandise_Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Merchandise_Description;
    /**
     * The Merchandise_Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Merchandise_Id;
    /**
     * The Merchandise_ItemTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Merchandise_ItemTypeId;
    /**
     * The Merchandise_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Merchandise_Name;
    /**
     * The Merchandise_ProductId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Merchandise_ProductId;
    /**
     * The Merchandise_QuantityInStock
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Merchandise_QuantityInStock;
    /**
     * The Merchandise_StockType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Merchandise_StockType;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The TotalAddonsPrice
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalAddonsPrice;
    /**
     * The TotalAddonsPriceWithoutTax
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalAddonsPriceWithoutTax;
    /**
     * Constructor method for Printing.PrintableItem.MerchandiseItem
     * @uses Printing_PrintableItem_MerchandiseItem::setAddOns()
     * @uses Printing_PrintableItem_MerchandiseItem::setCategory_Description()
     * @uses Printing_PrintableItem_MerchandiseItem::setCategory_Name()
     * @uses Printing_PrintableItem_MerchandiseItem::setItemType_Description()
     * @uses Printing_PrintableItem_MerchandiseItem::setItemType_Name()
     * @uses Printing_PrintableItem_MerchandiseItem::setMedia_BriefOverview()
     * @uses Printing_PrintableItem_MerchandiseItem::setMedia_DetailOverview()
     * @uses Printing_PrintableItem_MerchandiseItem::setMedia_ReviewUrl()
     * @uses Printing_PrintableItem_MerchandiseItem::setMedia_TrailerUrl()
     * @uses Printing_PrintableItem_MerchandiseItem::setMerchandise_Barcode()
     * @uses Printing_PrintableItem_MerchandiseItem::setMerchandise_CategoryId()
     * @uses Printing_PrintableItem_MerchandiseItem::setMerchandise_Description()
     * @uses Printing_PrintableItem_MerchandiseItem::setMerchandise_Id()
     * @uses Printing_PrintableItem_MerchandiseItem::setMerchandise_ItemTypeId()
     * @uses Printing_PrintableItem_MerchandiseItem::setMerchandise_Name()
     * @uses Printing_PrintableItem_MerchandiseItem::setMerchandise_ProductId()
     * @uses Printing_PrintableItem_MerchandiseItem::setMerchandise_QuantityInStock()
     * @uses Printing_PrintableItem_MerchandiseItem::setMerchandise_StockType()
     * @uses Printing_PrintableItem_MerchandiseItem::setPrintCount()
     * @uses Printing_PrintableItem_MerchandiseItem::setTotalAddonsPrice()
     * @uses Printing_PrintableItem_MerchandiseItem::setTotalAddonsPriceWithoutTax()
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_MerchandiseAddOn $addOns
     * @param \patest\StructType\GlobalString $category_Description
     * @param \patest\StructType\GlobalString $category_Name
     * @param \patest\StructType\GlobalString $itemType_Description
     * @param \patest\StructType\GlobalString $itemType_Name
     * @param \patest\StructType\GlobalString $media_BriefOverview
     * @param \patest\StructType\GlobalString $media_DetailOverview
     * @param \patest\StructType\GlobalString $media_ReviewUrl
     * @param \patest\StructType\GlobalString $media_TrailerUrl
     * @param string $merchandise_Barcode
     * @param string $merchandise_CategoryId
     * @param \patest\StructType\GlobalString $merchandise_Description
     * @param string $merchandise_Id
     * @param string $merchandise_ItemTypeId
     * @param \patest\StructType\GlobalString $merchandise_Name
     * @param string $merchandise_ProductId
     * @param float $merchandise_QuantityInStock
     * @param string $merchandise_StockType
     * @param int $printCount
     * @param float $totalAddonsPrice
     * @param float $totalAddonsPriceWithoutTax
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_PrintableItem_MerchandiseAddOn $addOns = null, \patest\StructType\GlobalString $category_Description = null, \patest\StructType\GlobalString $category_Name = null, \patest\StructType\GlobalString $itemType_Description = null, \patest\StructType\GlobalString $itemType_Name = null, \patest\StructType\GlobalString $media_BriefOverview = null, \patest\StructType\GlobalString $media_DetailOverview = null, \patest\StructType\GlobalString $media_ReviewUrl = null, \patest\StructType\GlobalString $media_TrailerUrl = null, $merchandise_Barcode = null, $merchandise_CategoryId = null, \patest\StructType\GlobalString $merchandise_Description = null, $merchandise_Id = null, $merchandise_ItemTypeId = null, \patest\StructType\GlobalString $merchandise_Name = null, $merchandise_ProductId = null, $merchandise_QuantityInStock = null, $merchandise_StockType = null, $printCount = null, $totalAddonsPrice = null, $totalAddonsPriceWithoutTax = null)
    {
        $this
            ->setAddOns($addOns)
            ->setCategory_Description($category_Description)
            ->setCategory_Name($category_Name)
            ->setItemType_Description($itemType_Description)
            ->setItemType_Name($itemType_Name)
            ->setMedia_BriefOverview($media_BriefOverview)
            ->setMedia_DetailOverview($media_DetailOverview)
            ->setMedia_ReviewUrl($media_ReviewUrl)
            ->setMedia_TrailerUrl($media_TrailerUrl)
            ->setMerchandise_Barcode($merchandise_Barcode)
            ->setMerchandise_CategoryId($merchandise_CategoryId)
            ->setMerchandise_Description($merchandise_Description)
            ->setMerchandise_Id($merchandise_Id)
            ->setMerchandise_ItemTypeId($merchandise_ItemTypeId)
            ->setMerchandise_Name($merchandise_Name)
            ->setMerchandise_ProductId($merchandise_ProductId)
            ->setMerchandise_QuantityInStock($merchandise_QuantityInStock)
            ->setMerchandise_StockType($merchandise_StockType)
            ->setPrintCount($printCount)
            ->setTotalAddonsPrice($totalAddonsPrice)
            ->setTotalAddonsPriceWithoutTax($totalAddonsPriceWithoutTax);
    }
    /**
     * Get AddOns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_MerchandiseAddOn|null
     */
    public function getAddOns()
    {
        return isset($this->AddOns) ? $this->AddOns : null;
    }
    /**
     * Set AddOns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_MerchandiseAddOn $addOns
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setAddOns(\patest\StructType\RecordSetOfPrinting_PrintableItem_MerchandiseAddOn $addOns = null)
    {
        if (is_null($addOns) || (is_array($addOns) && empty($addOns))) {
            unset($this->AddOns);
        } else {
            $this->AddOns = $addOns;
        }
        return $this;
    }
    /**
     * Get Category_Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCategory_Description()
    {
        return isset($this->Category_Description) ? $this->Category_Description : null;
    }
    /**
     * Set Category_Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $category_Description
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setCategory_Description(\patest\StructType\GlobalString $category_Description = null)
    {
        if (is_null($category_Description) || (is_array($category_Description) && empty($category_Description))) {
            unset($this->Category_Description);
        } else {
            $this->Category_Description = $category_Description;
        }
        return $this;
    }
    /**
     * Get Category_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCategory_Name()
    {
        return isset($this->Category_Name) ? $this->Category_Name : null;
    }
    /**
     * Set Category_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $category_Name
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setCategory_Name(\patest\StructType\GlobalString $category_Name = null)
    {
        if (is_null($category_Name) || (is_array($category_Name) && empty($category_Name))) {
            unset($this->Category_Name);
        } else {
            $this->Category_Name = $category_Name;
        }
        return $this;
    }
    /**
     * Get ItemType_Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getItemType_Description()
    {
        return isset($this->ItemType_Description) ? $this->ItemType_Description : null;
    }
    /**
     * Set ItemType_Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $itemType_Description
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setItemType_Description(\patest\StructType\GlobalString $itemType_Description = null)
    {
        if (is_null($itemType_Description) || (is_array($itemType_Description) && empty($itemType_Description))) {
            unset($this->ItemType_Description);
        } else {
            $this->ItemType_Description = $itemType_Description;
        }
        return $this;
    }
    /**
     * Get ItemType_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getItemType_Name()
    {
        return isset($this->ItemType_Name) ? $this->ItemType_Name : null;
    }
    /**
     * Set ItemType_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $itemType_Name
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setItemType_Name(\patest\StructType\GlobalString $itemType_Name = null)
    {
        if (is_null($itemType_Name) || (is_array($itemType_Name) && empty($itemType_Name))) {
            unset($this->ItemType_Name);
        } else {
            $this->ItemType_Name = $itemType_Name;
        }
        return $this;
    }
    /**
     * Get Media_BriefOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMedia_BriefOverview()
    {
        return isset($this->Media_BriefOverview) ? $this->Media_BriefOverview : null;
    }
    /**
     * Set Media_BriefOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $media_BriefOverview
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMedia_BriefOverview(\patest\StructType\GlobalString $media_BriefOverview = null)
    {
        if (is_null($media_BriefOverview) || (is_array($media_BriefOverview) && empty($media_BriefOverview))) {
            unset($this->Media_BriefOverview);
        } else {
            $this->Media_BriefOverview = $media_BriefOverview;
        }
        return $this;
    }
    /**
     * Get Media_DetailOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMedia_DetailOverview()
    {
        return isset($this->Media_DetailOverview) ? $this->Media_DetailOverview : null;
    }
    /**
     * Set Media_DetailOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $media_DetailOverview
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMedia_DetailOverview(\patest\StructType\GlobalString $media_DetailOverview = null)
    {
        if (is_null($media_DetailOverview) || (is_array($media_DetailOverview) && empty($media_DetailOverview))) {
            unset($this->Media_DetailOverview);
        } else {
            $this->Media_DetailOverview = $media_DetailOverview;
        }
        return $this;
    }
    /**
     * Get Media_ReviewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMedia_ReviewUrl()
    {
        return isset($this->Media_ReviewUrl) ? $this->Media_ReviewUrl : null;
    }
    /**
     * Set Media_ReviewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $media_ReviewUrl
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMedia_ReviewUrl(\patest\StructType\GlobalString $media_ReviewUrl = null)
    {
        if (is_null($media_ReviewUrl) || (is_array($media_ReviewUrl) && empty($media_ReviewUrl))) {
            unset($this->Media_ReviewUrl);
        } else {
            $this->Media_ReviewUrl = $media_ReviewUrl;
        }
        return $this;
    }
    /**
     * Get Media_TrailerUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMedia_TrailerUrl()
    {
        return isset($this->Media_TrailerUrl) ? $this->Media_TrailerUrl : null;
    }
    /**
     * Set Media_TrailerUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $media_TrailerUrl
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMedia_TrailerUrl(\patest\StructType\GlobalString $media_TrailerUrl = null)
    {
        if (is_null($media_TrailerUrl) || (is_array($media_TrailerUrl) && empty($media_TrailerUrl))) {
            unset($this->Media_TrailerUrl);
        } else {
            $this->Media_TrailerUrl = $media_TrailerUrl;
        }
        return $this;
    }
    /**
     * Get Merchandise_Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_Barcode()
    {
        return isset($this->Merchandise_Barcode) ? $this->Merchandise_Barcode : null;
    }
    /**
     * Set Merchandise_Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandise_Barcode
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMerchandise_Barcode($merchandise_Barcode = null)
    {
        // validation for constraint: string
        if (!is_null($merchandise_Barcode) && !is_string($merchandise_Barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandise_Barcode, true), gettype($merchandise_Barcode)), __LINE__);
        }
        if (is_null($merchandise_Barcode) || (is_array($merchandise_Barcode) && empty($merchandise_Barcode))) {
            unset($this->Merchandise_Barcode);
        } else {
            $this->Merchandise_Barcode = $merchandise_Barcode;
        }
        return $this;
    }
    /**
     * Get Merchandise_CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_CategoryId()
    {
        return isset($this->Merchandise_CategoryId) ? $this->Merchandise_CategoryId : null;
    }
    /**
     * Set Merchandise_CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandise_CategoryId
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMerchandise_CategoryId($merchandise_CategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandise_CategoryId) && !is_string($merchandise_CategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandise_CategoryId, true), gettype($merchandise_CategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandise_CategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandise_CategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandise_CategoryId, true)), __LINE__);
        }
        if (is_null($merchandise_CategoryId) || (is_array($merchandise_CategoryId) && empty($merchandise_CategoryId))) {
            unset($this->Merchandise_CategoryId);
        } else {
            $this->Merchandise_CategoryId = $merchandise_CategoryId;
        }
        return $this;
    }
    /**
     * Get Merchandise_Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMerchandise_Description()
    {
        return isset($this->Merchandise_Description) ? $this->Merchandise_Description : null;
    }
    /**
     * Set Merchandise_Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $merchandise_Description
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMerchandise_Description(\patest\StructType\GlobalString $merchandise_Description = null)
    {
        if (is_null($merchandise_Description) || (is_array($merchandise_Description) && empty($merchandise_Description))) {
            unset($this->Merchandise_Description);
        } else {
            $this->Merchandise_Description = $merchandise_Description;
        }
        return $this;
    }
    /**
     * Get Merchandise_Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_Id()
    {
        return isset($this->Merchandise_Id) ? $this->Merchandise_Id : null;
    }
    /**
     * Set Merchandise_Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandise_Id
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMerchandise_Id($merchandise_Id = null)
    {
        // validation for constraint: string
        if (!is_null($merchandise_Id) && !is_string($merchandise_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandise_Id, true), gettype($merchandise_Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandise_Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandise_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandise_Id, true)), __LINE__);
        }
        if (is_null($merchandise_Id) || (is_array($merchandise_Id) && empty($merchandise_Id))) {
            unset($this->Merchandise_Id);
        } else {
            $this->Merchandise_Id = $merchandise_Id;
        }
        return $this;
    }
    /**
     * Get Merchandise_ItemTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_ItemTypeId()
    {
        return isset($this->Merchandise_ItemTypeId) ? $this->Merchandise_ItemTypeId : null;
    }
    /**
     * Set Merchandise_ItemTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandise_ItemTypeId
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMerchandise_ItemTypeId($merchandise_ItemTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandise_ItemTypeId) && !is_string($merchandise_ItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandise_ItemTypeId, true), gettype($merchandise_ItemTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandise_ItemTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandise_ItemTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandise_ItemTypeId, true)), __LINE__);
        }
        if (is_null($merchandise_ItemTypeId) || (is_array($merchandise_ItemTypeId) && empty($merchandise_ItemTypeId))) {
            unset($this->Merchandise_ItemTypeId);
        } else {
            $this->Merchandise_ItemTypeId = $merchandise_ItemTypeId;
        }
        return $this;
    }
    /**
     * Get Merchandise_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMerchandise_Name()
    {
        return isset($this->Merchandise_Name) ? $this->Merchandise_Name : null;
    }
    /**
     * Set Merchandise_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $merchandise_Name
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMerchandise_Name(\patest\StructType\GlobalString $merchandise_Name = null)
    {
        if (is_null($merchandise_Name) || (is_array($merchandise_Name) && empty($merchandise_Name))) {
            unset($this->Merchandise_Name);
        } else {
            $this->Merchandise_Name = $merchandise_Name;
        }
        return $this;
    }
    /**
     * Get Merchandise_ProductId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_ProductId()
    {
        return isset($this->Merchandise_ProductId) ? $this->Merchandise_ProductId : null;
    }
    /**
     * Set Merchandise_ProductId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandise_ProductId
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMerchandise_ProductId($merchandise_ProductId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandise_ProductId) && !is_string($merchandise_ProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandise_ProductId, true), gettype($merchandise_ProductId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandise_ProductId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandise_ProductId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandise_ProductId, true)), __LINE__);
        }
        if (is_null($merchandise_ProductId) || (is_array($merchandise_ProductId) && empty($merchandise_ProductId))) {
            unset($this->Merchandise_ProductId);
        } else {
            $this->Merchandise_ProductId = $merchandise_ProductId;
        }
        return $this;
    }
    /**
     * Get Merchandise_QuantityInStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMerchandise_QuantityInStock()
    {
        return isset($this->Merchandise_QuantityInStock) ? $this->Merchandise_QuantityInStock : null;
    }
    /**
     * Set Merchandise_QuantityInStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $merchandise_QuantityInStock
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMerchandise_QuantityInStock($merchandise_QuantityInStock = null)
    {
        // validation for constraint: float
        if (!is_null($merchandise_QuantityInStock) && !(is_float($merchandise_QuantityInStock) || is_numeric($merchandise_QuantityInStock))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($merchandise_QuantityInStock, true), gettype($merchandise_QuantityInStock)), __LINE__);
        }
        if (is_null($merchandise_QuantityInStock) || (is_array($merchandise_QuantityInStock) && empty($merchandise_QuantityInStock))) {
            unset($this->Merchandise_QuantityInStock);
        } else {
            $this->Merchandise_QuantityInStock = $merchandise_QuantityInStock;
        }
        return $this;
    }
    /**
     * Get Merchandise_StockType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandise_StockType()
    {
        return isset($this->Merchandise_StockType) ? $this->Merchandise_StockType : null;
    }
    /**
     * Set Merchandise_StockType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StockType::valueIsValid()
     * @uses \patest\EnumType\StockType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $merchandise_StockType
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setMerchandise_StockType($merchandise_StockType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StockType::valueIsValid($merchandise_StockType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StockType', is_array($merchandise_StockType) ? implode(', ', $merchandise_StockType) : var_export($merchandise_StockType, true), implode(', ', \patest\EnumType\StockType::getValidValues())), __LINE__);
        }
        if (is_null($merchandise_StockType) || (is_array($merchandise_StockType) && empty($merchandise_StockType))) {
            unset($this->Merchandise_StockType);
        } else {
            $this->Merchandise_StockType = $merchandise_StockType;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get TotalAddonsPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalAddonsPrice()
    {
        return isset($this->TotalAddonsPrice) ? $this->TotalAddonsPrice : null;
    }
    /**
     * Set TotalAddonsPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalAddonsPrice
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setTotalAddonsPrice($totalAddonsPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalAddonsPrice) && !(is_float($totalAddonsPrice) || is_numeric($totalAddonsPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAddonsPrice, true), gettype($totalAddonsPrice)), __LINE__);
        }
        if (is_null($totalAddonsPrice) || (is_array($totalAddonsPrice) && empty($totalAddonsPrice))) {
            unset($this->TotalAddonsPrice);
        } else {
            $this->TotalAddonsPrice = $totalAddonsPrice;
        }
        return $this;
    }
    /**
     * Get TotalAddonsPriceWithoutTax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalAddonsPriceWithoutTax()
    {
        return isset($this->TotalAddonsPriceWithoutTax) ? $this->TotalAddonsPriceWithoutTax : null;
    }
    /**
     * Set TotalAddonsPriceWithoutTax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalAddonsPriceWithoutTax
     * @return \patest\StructType\Printing_PrintableItem_MerchandiseItem
     */
    public function setTotalAddonsPriceWithoutTax($totalAddonsPriceWithoutTax = null)
    {
        // validation for constraint: float
        if (!is_null($totalAddonsPriceWithoutTax) && !(is_float($totalAddonsPriceWithoutTax) || is_numeric($totalAddonsPriceWithoutTax))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAddonsPriceWithoutTax, true), gettype($totalAddonsPriceWithoutTax)), __LINE__);
        }
        if (is_null($totalAddonsPriceWithoutTax) || (is_array($totalAddonsPriceWithoutTax) && empty($totalAddonsPriceWithoutTax))) {
            unset($this->TotalAddonsPriceWithoutTax);
        } else {
            $this->TotalAddonsPriceWithoutTax = $totalAddonsPriceWithoutTax;
        }
        return $this;
    }
}
