<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.MatchingGiftDonation StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_MatchingGiftDonation extends Printing_Item_ComplexProperty_Base
{
    /**
     * The BatchUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchUnitId;
    /**
     * The BillingDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillingDate;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The DonatedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DonatedAmount;
    /**
     * The DonationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DonationName;
    /**
     * The DonationProductItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DonationProductItemId;
    /**
     * The Donor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_MatchingGiftDonor
     */
    public $Donor;
    /**
     * The MatchedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MatchedAmount;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The WasBilled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WasBilled;
    /**
     * The WasCancelled
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WasCancelled;
    /**
     * The WasPaid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WasPaid;
    /**
     * Constructor method for Printing.PrintableItem.MatchingGiftDonation
     * @uses Printing_PrintableItem_MatchingGiftDonation::setBatchUnitId()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setBillingDate()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setCommitDate()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setDonatedAmount()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setDonationName()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setDonationProductItemId()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setDonor()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setMatchedAmount()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setReferenceNumber()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setTransactionNumber()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setWasBilled()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setWasCancelled()
     * @uses Printing_PrintableItem_MatchingGiftDonation::setWasPaid()
     * @param string $batchUnitId
     * @param string $billingDate
     * @param string $commitDate
     * @param float $donatedAmount
     * @param \patest\StructType\GlobalString $donationName
     * @param string $donationProductItemId
     * @param \patest\StructType\Printing_PrintableItem_MatchingGiftDonor $donor
     * @param float $matchedAmount
     * @param int $referenceNumber
     * @param int $transactionNumber
     * @param bool $wasBilled
     * @param bool $wasCancelled
     * @param bool $wasPaid
     */
    public function __construct($batchUnitId = null, $billingDate = null, $commitDate = null, $donatedAmount = null, \patest\StructType\GlobalString $donationName = null, $donationProductItemId = null, \patest\StructType\Printing_PrintableItem_MatchingGiftDonor $donor = null, $matchedAmount = null, $referenceNumber = null, $transactionNumber = null, $wasBilled = null, $wasCancelled = null, $wasPaid = null)
    {
        $this
            ->setBatchUnitId($batchUnitId)
            ->setBillingDate($billingDate)
            ->setCommitDate($commitDate)
            ->setDonatedAmount($donatedAmount)
            ->setDonationName($donationName)
            ->setDonationProductItemId($donationProductItemId)
            ->setDonor($donor)
            ->setMatchedAmount($matchedAmount)
            ->setReferenceNumber($referenceNumber)
            ->setTransactionNumber($transactionNumber)
            ->setWasBilled($wasBilled)
            ->setWasCancelled($wasCancelled)
            ->setWasPaid($wasPaid);
    }
    /**
     * Get BatchUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchUnitId()
    {
        return isset($this->BatchUnitId) ? $this->BatchUnitId : null;
    }
    /**
     * Set BatchUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchUnitId
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setBatchUnitId($batchUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($batchUnitId) && !is_string($batchUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchUnitId, true), gettype($batchUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchUnitId, true)), __LINE__);
        }
        if (is_null($batchUnitId) || (is_array($batchUnitId) && empty($batchUnitId))) {
            unset($this->BatchUnitId);
        } else {
            $this->BatchUnitId = $batchUnitId;
        }
        return $this;
    }
    /**
     * Get BillingDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillingDate()
    {
        return isset($this->BillingDate) ? $this->BillingDate : null;
    }
    /**
     * Set BillingDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billingDate
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setBillingDate($billingDate = null)
    {
        // validation for constraint: string
        if (!is_null($billingDate) && !is_string($billingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingDate, true), gettype($billingDate)), __LINE__);
        }
        if (is_null($billingDate) || (is_array($billingDate) && empty($billingDate))) {
            unset($this->BillingDate);
        } else {
            $this->BillingDate = $billingDate;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get DonatedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDonatedAmount()
    {
        return isset($this->DonatedAmount) ? $this->DonatedAmount : null;
    }
    /**
     * Set DonatedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $donatedAmount
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setDonatedAmount($donatedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($donatedAmount) && !(is_float($donatedAmount) || is_numeric($donatedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($donatedAmount, true), gettype($donatedAmount)), __LINE__);
        }
        if (is_null($donatedAmount) || (is_array($donatedAmount) && empty($donatedAmount))) {
            unset($this->DonatedAmount);
        } else {
            $this->DonatedAmount = $donatedAmount;
        }
        return $this;
    }
    /**
     * Get DonationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDonationName()
    {
        return isset($this->DonationName) ? $this->DonationName : null;
    }
    /**
     * Set DonationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $donationName
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setDonationName(\patest\StructType\GlobalString $donationName = null)
    {
        if (is_null($donationName) || (is_array($donationName) && empty($donationName))) {
            unset($this->DonationName);
        } else {
            $this->DonationName = $donationName;
        }
        return $this;
    }
    /**
     * Get DonationProductItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationProductItemId()
    {
        return isset($this->DonationProductItemId) ? $this->DonationProductItemId : null;
    }
    /**
     * Set DonationProductItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationProductItemId
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setDonationProductItemId($donationProductItemId = null)
    {
        // validation for constraint: string
        if (!is_null($donationProductItemId) && !is_string($donationProductItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationProductItemId, true), gettype($donationProductItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donationProductItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donationProductItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donationProductItemId, true)), __LINE__);
        }
        if (is_null($donationProductItemId) || (is_array($donationProductItemId) && empty($donationProductItemId))) {
            unset($this->DonationProductItemId);
        } else {
            $this->DonationProductItemId = $donationProductItemId;
        }
        return $this;
    }
    /**
     * Get Donor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonor|null
     */
    public function getDonor()
    {
        return isset($this->Donor) ? $this->Donor : null;
    }
    /**
     * Set Donor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_MatchingGiftDonor $donor
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setDonor(\patest\StructType\Printing_PrintableItem_MatchingGiftDonor $donor = null)
    {
        if (is_null($donor) || (is_array($donor) && empty($donor))) {
            unset($this->Donor);
        } else {
            $this->Donor = $donor;
        }
        return $this;
    }
    /**
     * Get MatchedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMatchedAmount()
    {
        return isset($this->MatchedAmount) ? $this->MatchedAmount : null;
    }
    /**
     * Set MatchedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $matchedAmount
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setMatchedAmount($matchedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($matchedAmount) && !(is_float($matchedAmount) || is_numeric($matchedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($matchedAmount, true), gettype($matchedAmount)), __LINE__);
        }
        if (is_null($matchedAmount) || (is_array($matchedAmount) && empty($matchedAmount))) {
            unset($this->MatchedAmount);
        } else {
            $this->MatchedAmount = $matchedAmount;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $referenceNumber
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get WasBilled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWasBilled()
    {
        return isset($this->WasBilled) ? $this->WasBilled : null;
    }
    /**
     * Set WasBilled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wasBilled
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setWasBilled($wasBilled = null)
    {
        // validation for constraint: boolean
        if (!is_null($wasBilled) && !is_bool($wasBilled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wasBilled, true), gettype($wasBilled)), __LINE__);
        }
        if (is_null($wasBilled) || (is_array($wasBilled) && empty($wasBilled))) {
            unset($this->WasBilled);
        } else {
            $this->WasBilled = $wasBilled;
        }
        return $this;
    }
    /**
     * Get WasCancelled value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWasCancelled()
    {
        return isset($this->WasCancelled) ? $this->WasCancelled : null;
    }
    /**
     * Set WasCancelled value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wasCancelled
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setWasCancelled($wasCancelled = null)
    {
        // validation for constraint: boolean
        if (!is_null($wasCancelled) && !is_bool($wasCancelled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wasCancelled, true), gettype($wasCancelled)), __LINE__);
        }
        if (is_null($wasCancelled) || (is_array($wasCancelled) && empty($wasCancelled))) {
            unset($this->WasCancelled);
        } else {
            $this->WasCancelled = $wasCancelled;
        }
        return $this;
    }
    /**
     * Get WasPaid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWasPaid()
    {
        return isset($this->WasPaid) ? $this->WasPaid : null;
    }
    /**
     * Set WasPaid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $wasPaid
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonation
     */
    public function setWasPaid($wasPaid = null)
    {
        // validation for constraint: boolean
        if (!is_null($wasPaid) && !is_bool($wasPaid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($wasPaid, true), gettype($wasPaid)), __LINE__);
        }
        if (is_null($wasPaid) || (is_array($wasPaid) && empty($wasPaid))) {
            unset($this->WasPaid);
        } else {
            $this->WasPaid = $wasPaid;
        }
        return $this;
    }
}
