<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.InventoryForm.Line StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_InventoryForm_Line extends Printing_Item_ComplexProperty_Base
{
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The CompanyTotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyTotalCost;
    /**
     * The CompanyTotalEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyTotalEsv;
    /**
     * The CostPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CostPrice;
    /**
     * The CurrencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyName;
    /**
     * The CurrencyRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CurrencyRate;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The Esv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Esv;
    /**
     * The FormQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FormQuantity;
    /**
     * The FromLocaltionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FromLocaltionName;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ItemName;
    /**
     * The LineNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LineNo;
    /**
     * The ProductName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ProductName;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantity;
    /**
     * The QuantityMultiplier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantityMultiplier;
    /**
     * The RemainQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $RemainQuantity;
    /**
     * The StockAdjReasonName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockAdjReasonName;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCost;
    /**
     * The TotalEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalEsv;
    /**
     * The UomName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $UomName;
    /**
     * Constructor method for Printing.PrintableItem.InventoryForm.Line
     * @uses Printing_PrintableItem_InventoryForm_Line::setBarcode()
     * @uses Printing_PrintableItem_InventoryForm_Line::setCompanyTotalCost()
     * @uses Printing_PrintableItem_InventoryForm_Line::setCompanyTotalEsv()
     * @uses Printing_PrintableItem_InventoryForm_Line::setCostPrice()
     * @uses Printing_PrintableItem_InventoryForm_Line::setCurrencyName()
     * @uses Printing_PrintableItem_InventoryForm_Line::setCurrencyRate()
     * @uses Printing_PrintableItem_InventoryForm_Line::setDueDate()
     * @uses Printing_PrintableItem_InventoryForm_Line::setEsv()
     * @uses Printing_PrintableItem_InventoryForm_Line::setFormQuantity()
     * @uses Printing_PrintableItem_InventoryForm_Line::setFromLocaltionName()
     * @uses Printing_PrintableItem_InventoryForm_Line::setItemName()
     * @uses Printing_PrintableItem_InventoryForm_Line::setLineNo()
     * @uses Printing_PrintableItem_InventoryForm_Line::setProductName()
     * @uses Printing_PrintableItem_InventoryForm_Line::setQuantity()
     * @uses Printing_PrintableItem_InventoryForm_Line::setQuantityMultiplier()
     * @uses Printing_PrintableItem_InventoryForm_Line::setRemainQuantity()
     * @uses Printing_PrintableItem_InventoryForm_Line::setStockAdjReasonName()
     * @uses Printing_PrintableItem_InventoryForm_Line::setTotalCost()
     * @uses Printing_PrintableItem_InventoryForm_Line::setTotalEsv()
     * @uses Printing_PrintableItem_InventoryForm_Line::setUomName()
     * @param string $barcode
     * @param \patest\StructType\Money $companyTotalCost
     * @param \patest\StructType\Money $companyTotalEsv
     * @param \patest\StructType\Money $costPrice
     * @param string $currencyName
     * @param float $currencyRate
     * @param string $dueDate
     * @param \patest\StructType\Money $esv
     * @param float $formQuantity
     * @param \patest\StructType\GlobalString $fromLocaltionName
     * @param \patest\StructType\GlobalString $itemName
     * @param int $lineNo
     * @param \patest\StructType\GlobalString $productName
     * @param float $quantity
     * @param float $quantityMultiplier
     * @param float $remainQuantity
     * @param string $stockAdjReasonName
     * @param \patest\StructType\Money $totalCost
     * @param \patest\StructType\Money $totalEsv
     * @param \patest\StructType\GlobalString $uomName
     */
    public function __construct($barcode = null, \patest\StructType\Money $companyTotalCost = null, \patest\StructType\Money $companyTotalEsv = null, \patest\StructType\Money $costPrice = null, $currencyName = null, $currencyRate = null, $dueDate = null, \patest\StructType\Money $esv = null, $formQuantity = null, \patest\StructType\GlobalString $fromLocaltionName = null, \patest\StructType\GlobalString $itemName = null, $lineNo = null, \patest\StructType\GlobalString $productName = null, $quantity = null, $quantityMultiplier = null, $remainQuantity = null, $stockAdjReasonName = null, \patest\StructType\Money $totalCost = null, \patest\StructType\Money $totalEsv = null, \patest\StructType\GlobalString $uomName = null)
    {
        $this
            ->setBarcode($barcode)
            ->setCompanyTotalCost($companyTotalCost)
            ->setCompanyTotalEsv($companyTotalEsv)
            ->setCostPrice($costPrice)
            ->setCurrencyName($currencyName)
            ->setCurrencyRate($currencyRate)
            ->setDueDate($dueDate)
            ->setEsv($esv)
            ->setFormQuantity($formQuantity)
            ->setFromLocaltionName($fromLocaltionName)
            ->setItemName($itemName)
            ->setLineNo($lineNo)
            ->setProductName($productName)
            ->setQuantity($quantity)
            ->setQuantityMultiplier($quantityMultiplier)
            ->setRemainQuantity($remainQuantity)
            ->setStockAdjReasonName($stockAdjReasonName)
            ->setTotalCost($totalCost)
            ->setTotalEsv($totalEsv)
            ->setUomName($uomName);
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get CompanyTotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyTotalCost()
    {
        return isset($this->CompanyTotalCost) ? $this->CompanyTotalCost : null;
    }
    /**
     * Set CompanyTotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyTotalCost
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setCompanyTotalCost(\patest\StructType\Money $companyTotalCost = null)
    {
        if (is_null($companyTotalCost) || (is_array($companyTotalCost) && empty($companyTotalCost))) {
            unset($this->CompanyTotalCost);
        } else {
            $this->CompanyTotalCost = $companyTotalCost;
        }
        return $this;
    }
    /**
     * Get CompanyTotalEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyTotalEsv()
    {
        return isset($this->CompanyTotalEsv) ? $this->CompanyTotalEsv : null;
    }
    /**
     * Set CompanyTotalEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyTotalEsv
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setCompanyTotalEsv(\patest\StructType\Money $companyTotalEsv = null)
    {
        if (is_null($companyTotalEsv) || (is_array($companyTotalEsv) && empty($companyTotalEsv))) {
            unset($this->CompanyTotalEsv);
        } else {
            $this->CompanyTotalEsv = $companyTotalEsv;
        }
        return $this;
    }
    /**
     * Get CostPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCostPrice()
    {
        return isset($this->CostPrice) ? $this->CostPrice : null;
    }
    /**
     * Set CostPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $costPrice
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setCostPrice(\patest\StructType\Money $costPrice = null)
    {
        if (is_null($costPrice) || (is_array($costPrice) && empty($costPrice))) {
            unset($this->CostPrice);
        } else {
            $this->CostPrice = $costPrice;
        }
        return $this;
    }
    /**
     * Get CurrencyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyName()
    {
        return isset($this->CurrencyName) ? $this->CurrencyName : null;
    }
    /**
     * Set CurrencyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        if (is_null($currencyName) || (is_array($currencyName) && empty($currencyName))) {
            unset($this->CurrencyName);
        } else {
            $this->CurrencyName = $currencyName;
        }
        return $this;
    }
    /**
     * Get CurrencyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCurrencyRate()
    {
        return isset($this->CurrencyRate) ? $this->CurrencyRate : null;
    }
    /**
     * Set CurrencyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $currencyRate
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setCurrencyRate($currencyRate = null)
    {
        // validation for constraint: float
        if (!is_null($currencyRate) && !(is_float($currencyRate) || is_numeric($currencyRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currencyRate, true), gettype($currencyRate)), __LINE__);
        }
        if (is_null($currencyRate) || (is_array($currencyRate) && empty($currencyRate))) {
            unset($this->CurrencyRate);
        } else {
            $this->CurrencyRate = $currencyRate;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDate
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get Esv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getEsv()
    {
        return isset($this->Esv) ? $this->Esv : null;
    }
    /**
     * Set Esv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $esv
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setEsv(\patest\StructType\Money $esv = null)
    {
        if (is_null($esv) || (is_array($esv) && empty($esv))) {
            unset($this->Esv);
        } else {
            $this->Esv = $esv;
        }
        return $this;
    }
    /**
     * Get FormQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFormQuantity()
    {
        return isset($this->FormQuantity) ? $this->FormQuantity : null;
    }
    /**
     * Set FormQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $formQuantity
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setFormQuantity($formQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($formQuantity) && !(is_float($formQuantity) || is_numeric($formQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($formQuantity, true), gettype($formQuantity)), __LINE__);
        }
        if (is_null($formQuantity) || (is_array($formQuantity) && empty($formQuantity))) {
            unset($this->FormQuantity);
        } else {
            $this->FormQuantity = $formQuantity;
        }
        return $this;
    }
    /**
     * Get FromLocaltionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFromLocaltionName()
    {
        return isset($this->FromLocaltionName) ? $this->FromLocaltionName : null;
    }
    /**
     * Set FromLocaltionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fromLocaltionName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setFromLocaltionName(\patest\StructType\GlobalString $fromLocaltionName = null)
    {
        if (is_null($fromLocaltionName) || (is_array($fromLocaltionName) && empty($fromLocaltionName))) {
            unset($this->FromLocaltionName);
        } else {
            $this->FromLocaltionName = $fromLocaltionName;
        }
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $itemName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setItemName(\patest\StructType\GlobalString $itemName = null)
    {
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
    /**
     * Get LineNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLineNo()
    {
        return isset($this->LineNo) ? $this->LineNo : null;
    }
    /**
     * Set LineNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lineNo
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setLineNo($lineNo = null)
    {
        // validation for constraint: int
        if (!is_null($lineNo) && !(is_int($lineNo) || ctype_digit($lineNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineNo, true), gettype($lineNo)), __LINE__);
        }
        if (is_null($lineNo) || (is_array($lineNo) && empty($lineNo))) {
            unset($this->LineNo);
        } else {
            $this->LineNo = $lineNo;
        }
        return $this;
    }
    /**
     * Get ProductName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getProductName()
    {
        return isset($this->ProductName) ? $this->ProductName : null;
    }
    /**
     * Set ProductName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $productName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setProductName(\patest\StructType\GlobalString $productName = null)
    {
        if (is_null($productName) || (is_array($productName) && empty($productName))) {
            unset($this->ProductName);
        } else {
            $this->ProductName = $productName;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantity
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get QuantityMultiplier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantityMultiplier()
    {
        return isset($this->QuantityMultiplier) ? $this->QuantityMultiplier : null;
    }
    /**
     * Set QuantityMultiplier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantityMultiplier
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setQuantityMultiplier($quantityMultiplier = null)
    {
        // validation for constraint: float
        if (!is_null($quantityMultiplier) && !(is_float($quantityMultiplier) || is_numeric($quantityMultiplier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantityMultiplier, true), gettype($quantityMultiplier)), __LINE__);
        }
        if (is_null($quantityMultiplier) || (is_array($quantityMultiplier) && empty($quantityMultiplier))) {
            unset($this->QuantityMultiplier);
        } else {
            $this->QuantityMultiplier = $quantityMultiplier;
        }
        return $this;
    }
    /**
     * Get RemainQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getRemainQuantity()
    {
        return isset($this->RemainQuantity) ? $this->RemainQuantity : null;
    }
    /**
     * Set RemainQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $remainQuantity
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setRemainQuantity($remainQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($remainQuantity) && !(is_float($remainQuantity) || is_numeric($remainQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($remainQuantity, true), gettype($remainQuantity)), __LINE__);
        }
        if (is_null($remainQuantity) || (is_array($remainQuantity) && empty($remainQuantity))) {
            unset($this->RemainQuantity);
        } else {
            $this->RemainQuantity = $remainQuantity;
        }
        return $this;
    }
    /**
     * Get StockAdjReasonName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockAdjReasonName()
    {
        return isset($this->StockAdjReasonName) ? $this->StockAdjReasonName : null;
    }
    /**
     * Set StockAdjReasonName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockAdjReasonName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setStockAdjReasonName($stockAdjReasonName = null)
    {
        // validation for constraint: string
        if (!is_null($stockAdjReasonName) && !is_string($stockAdjReasonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockAdjReasonName, true), gettype($stockAdjReasonName)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockAdjReasonName) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockAdjReasonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockAdjReasonName, true)), __LINE__);
        }
        if (is_null($stockAdjReasonName) || (is_array($stockAdjReasonName) && empty($stockAdjReasonName))) {
            unset($this->StockAdjReasonName);
        } else {
            $this->StockAdjReasonName = $stockAdjReasonName;
        }
        return $this;
    }
    /**
     * Get TotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCost()
    {
        return isset($this->TotalCost) ? $this->TotalCost : null;
    }
    /**
     * Set TotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCost
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setTotalCost(\patest\StructType\Money $totalCost = null)
    {
        if (is_null($totalCost) || (is_array($totalCost) && empty($totalCost))) {
            unset($this->TotalCost);
        } else {
            $this->TotalCost = $totalCost;
        }
        return $this;
    }
    /**
     * Get TotalEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalEsv()
    {
        return isset($this->TotalEsv) ? $this->TotalEsv : null;
    }
    /**
     * Set TotalEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalEsv
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setTotalEsv(\patest\StructType\Money $totalEsv = null)
    {
        if (is_null($totalEsv) || (is_array($totalEsv) && empty($totalEsv))) {
            unset($this->TotalEsv);
        } else {
            $this->TotalEsv = $totalEsv;
        }
        return $this;
    }
    /**
     * Get UomName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getUomName()
    {
        return isset($this->UomName) ? $this->UomName : null;
    }
    /**
     * Set UomName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $uomName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm_Line
     */
    public function setUomName(\patest\StructType\GlobalString $uomName = null)
    {
        if (is_null($uomName) || (is_array($uomName) && empty($uomName))) {
            unset($this->UomName);
        } else {
            $this->UomName = $uomName;
        }
        return $this;
    }
}
