<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.GuideRequest StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_GuideRequest extends AnyEntity
{
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duration;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Event;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The Guide
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Guide;
    /**
     * The MinutesFromStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinutesFromStart;
    /**
     * The Skills
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Skills;
    /**
     * The StartAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartAt;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * Constructor method for Printing.PrintableItem.GuideRequest
     * @uses Printing_PrintableItem_GuideRequest::setDuration()
     * @uses Printing_PrintableItem_GuideRequest::setEvent()
     * @uses Printing_PrintableItem_GuideRequest::setFromDate()
     * @uses Printing_PrintableItem_GuideRequest::setGuide()
     * @uses Printing_PrintableItem_GuideRequest::setMinutesFromStart()
     * @uses Printing_PrintableItem_GuideRequest::setSkills()
     * @uses Printing_PrintableItem_GuideRequest::setStartAt()
     * @uses Printing_PrintableItem_GuideRequest::setUntilDate()
     * @param int $duration
     * @param string $event
     * @param string $fromDate
     * @param string $guide
     * @param int $minutesFromStart
     * @param string $skills
     * @param string $startAt
     * @param string $untilDate
     */
    public function __construct($duration = null, $event = null, $fromDate = null, $guide = null, $minutesFromStart = null, $skills = null, $startAt = null, $untilDate = null)
    {
        $this
            ->setDuration($duration)
            ->setEvent($event)
            ->setFromDate($fromDate)
            ->setGuide($guide)
            ->setMinutesFromStart($minutesFromStart)
            ->setSkills($skills)
            ->setStartAt($startAt)
            ->setUntilDate($untilDate);
    }
    /**
     * Get Duration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuration()
    {
        return isset($this->Duration) ? $this->Duration : null;
    }
    /**
     * Set Duration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duration
     * @return \patest\StructType\Printing_PrintableItem_GuideRequest
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !(is_int($duration) || ctype_digit($duration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        if (is_null($duration) || (is_array($duration) && empty($duration))) {
            unset($this->Duration);
        } else {
            $this->Duration = $duration;
        }
        return $this;
    }
    /**
     * Get Event value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEvent()
    {
        return isset($this->Event) ? $this->Event : null;
    }
    /**
     * Set Event value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $event
     * @return \patest\StructType\Printing_PrintableItem_GuideRequest
     */
    public function setEvent($event = null)
    {
        // validation for constraint: string
        if (!is_null($event) && !is_string($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($event, true), gettype($event)), __LINE__);
        }
        if (is_null($event) || (is_array($event) && empty($event))) {
            unset($this->Event);
        } else {
            $this->Event = $event;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\Printing_PrintableItem_GuideRequest
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get Guide value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuide()
    {
        return isset($this->Guide) ? $this->Guide : null;
    }
    /**
     * Set Guide value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guide
     * @return \patest\StructType\Printing_PrintableItem_GuideRequest
     */
    public function setGuide($guide = null)
    {
        // validation for constraint: string
        if (!is_null($guide) && !is_string($guide)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guide, true), gettype($guide)), __LINE__);
        }
        if (is_null($guide) || (is_array($guide) && empty($guide))) {
            unset($this->Guide);
        } else {
            $this->Guide = $guide;
        }
        return $this;
    }
    /**
     * Get MinutesFromStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinutesFromStart()
    {
        return isset($this->MinutesFromStart) ? $this->MinutesFromStart : null;
    }
    /**
     * Set MinutesFromStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minutesFromStart
     * @return \patest\StructType\Printing_PrintableItem_GuideRequest
     */
    public function setMinutesFromStart($minutesFromStart = null)
    {
        // validation for constraint: int
        if (!is_null($minutesFromStart) && !(is_int($minutesFromStart) || ctype_digit($minutesFromStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minutesFromStart, true), gettype($minutesFromStart)), __LINE__);
        }
        if (is_null($minutesFromStart) || (is_array($minutesFromStart) && empty($minutesFromStart))) {
            unset($this->MinutesFromStart);
        } else {
            $this->MinutesFromStart = $minutesFromStart;
        }
        return $this;
    }
    /**
     * Get Skills value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSkills()
    {
        return isset($this->Skills) ? $this->Skills : null;
    }
    /**
     * Set Skills value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $skills
     * @return \patest\StructType\Printing_PrintableItem_GuideRequest
     */
    public function setSkills($skills = null)
    {
        // validation for constraint: string
        if (!is_null($skills) && !is_string($skills)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($skills, true), gettype($skills)), __LINE__);
        }
        if (is_null($skills) || (is_array($skills) && empty($skills))) {
            unset($this->Skills);
        } else {
            $this->Skills = $skills;
        }
        return $this;
    }
    /**
     * Get StartAt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartAt()
    {
        return isset($this->StartAt) ? $this->StartAt : null;
    }
    /**
     * Set StartAt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestStartType::valueIsValid()
     * @uses \patest\EnumType\RequestStartType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $startAt
     * @return \patest\StructType\Printing_PrintableItem_GuideRequest
     */
    public function setStartAt($startAt = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestStartType::valueIsValid($startAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestStartType', is_array($startAt) ? implode(', ', $startAt) : var_export($startAt, true), implode(', ', \patest\EnumType\RequestStartType::getValidValues())), __LINE__);
        }
        if (is_null($startAt) || (is_array($startAt) && empty($startAt))) {
            unset($this->StartAt);
        } else {
            $this->StartAt = $startAt;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\Printing_PrintableItem_GuideRequest
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
}
