<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.BallotApplicationSummary StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_BallotApplicationSummary extends Printing_PrintableItem_Base
{
    /**
     * The ApplicationSummaryMaxPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ApplicationSummaryMaxPrice;
    /**
     * The ApplicationSummaryMinPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ApplicationSummaryMinPrice;
    /**
     * The BallotName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BallotName;
    /**
     * The BallotNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BallotNumber;
    /**
     * The ClientCrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCrmId;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_BallotApplicationDetail
     */
    public $Details;
    /**
     * The PaymentMethodDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodDetails;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodName;
    /**
     * Constructor method for Printing.PrintableItem.BallotApplicationSummary
     * @uses Printing_PrintableItem_BallotApplicationSummary::setApplicationSummaryMaxPrice()
     * @uses Printing_PrintableItem_BallotApplicationSummary::setApplicationSummaryMinPrice()
     * @uses Printing_PrintableItem_BallotApplicationSummary::setBallotName()
     * @uses Printing_PrintableItem_BallotApplicationSummary::setBallotNumber()
     * @uses Printing_PrintableItem_BallotApplicationSummary::setClientCrmId()
     * @uses Printing_PrintableItem_BallotApplicationSummary::setClientId()
     * @uses Printing_PrintableItem_BallotApplicationSummary::setClientName()
     * @uses Printing_PrintableItem_BallotApplicationSummary::setDetails()
     * @uses Printing_PrintableItem_BallotApplicationSummary::setPaymentMethodDetails()
     * @uses Printing_PrintableItem_BallotApplicationSummary::setPaymentMethodName()
     * @param \patest\StructType\Money $applicationSummaryMaxPrice
     * @param \patest\StructType\Money $applicationSummaryMinPrice
     * @param string $ballotName
     * @param int $ballotNumber
     * @param string $clientCrmId
     * @param string $clientId
     * @param string $clientName
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_BallotApplicationDetail $details
     * @param string $paymentMethodDetails
     * @param string $paymentMethodName
     */
    public function __construct(\patest\StructType\Money $applicationSummaryMaxPrice = null, \patest\StructType\Money $applicationSummaryMinPrice = null, $ballotName = null, $ballotNumber = null, $clientCrmId = null, $clientId = null, $clientName = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_BallotApplicationDetail $details = null, $paymentMethodDetails = null, $paymentMethodName = null)
    {
        $this
            ->setApplicationSummaryMaxPrice($applicationSummaryMaxPrice)
            ->setApplicationSummaryMinPrice($applicationSummaryMinPrice)
            ->setBallotName($ballotName)
            ->setBallotNumber($ballotNumber)
            ->setClientCrmId($clientCrmId)
            ->setClientId($clientId)
            ->setClientName($clientName)
            ->setDetails($details)
            ->setPaymentMethodDetails($paymentMethodDetails)
            ->setPaymentMethodName($paymentMethodName);
    }
    /**
     * Get ApplicationSummaryMaxPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getApplicationSummaryMaxPrice()
    {
        return isset($this->ApplicationSummaryMaxPrice) ? $this->ApplicationSummaryMaxPrice : null;
    }
    /**
     * Set ApplicationSummaryMaxPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $applicationSummaryMaxPrice
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setApplicationSummaryMaxPrice(\patest\StructType\Money $applicationSummaryMaxPrice = null)
    {
        if (is_null($applicationSummaryMaxPrice) || (is_array($applicationSummaryMaxPrice) && empty($applicationSummaryMaxPrice))) {
            unset($this->ApplicationSummaryMaxPrice);
        } else {
            $this->ApplicationSummaryMaxPrice = $applicationSummaryMaxPrice;
        }
        return $this;
    }
    /**
     * Get ApplicationSummaryMinPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getApplicationSummaryMinPrice()
    {
        return isset($this->ApplicationSummaryMinPrice) ? $this->ApplicationSummaryMinPrice : null;
    }
    /**
     * Set ApplicationSummaryMinPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $applicationSummaryMinPrice
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setApplicationSummaryMinPrice(\patest\StructType\Money $applicationSummaryMinPrice = null)
    {
        if (is_null($applicationSummaryMinPrice) || (is_array($applicationSummaryMinPrice) && empty($applicationSummaryMinPrice))) {
            unset($this->ApplicationSummaryMinPrice);
        } else {
            $this->ApplicationSummaryMinPrice = $applicationSummaryMinPrice;
        }
        return $this;
    }
    /**
     * Get BallotName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotName()
    {
        return isset($this->BallotName) ? $this->BallotName : null;
    }
    /**
     * Set BallotName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotName
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setBallotName($ballotName = null)
    {
        // validation for constraint: string
        if (!is_null($ballotName) && !is_string($ballotName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotName, true), gettype($ballotName)), __LINE__);
        }
        if (is_null($ballotName) || (is_array($ballotName) && empty($ballotName))) {
            unset($this->BallotName);
        } else {
            $this->BallotName = $ballotName;
        }
        return $this;
    }
    /**
     * Get BallotNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBallotNumber()
    {
        return isset($this->BallotNumber) ? $this->BallotNumber : null;
    }
    /**
     * Set BallotNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ballotNumber
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setBallotNumber($ballotNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ballotNumber) && !(is_int($ballotNumber) || ctype_digit($ballotNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ballotNumber, true), gettype($ballotNumber)), __LINE__);
        }
        if (is_null($ballotNumber) || (is_array($ballotNumber) && empty($ballotNumber))) {
            unset($this->BallotNumber);
        } else {
            $this->BallotNumber = $ballotNumber;
        }
        return $this;
    }
    /**
     * Get ClientCrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCrmId()
    {
        return isset($this->ClientCrmId) ? $this->ClientCrmId : null;
    }
    /**
     * Set ClientCrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCrmId
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setClientCrmId($clientCrmId = null)
    {
        // validation for constraint: string
        if (!is_null($clientCrmId) && !is_string($clientCrmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCrmId, true), gettype($clientCrmId)), __LINE__);
        }
        if (is_null($clientCrmId) || (is_array($clientCrmId) && empty($clientCrmId))) {
            unset($this->ClientCrmId);
        } else {
            $this->ClientCrmId = $clientCrmId;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_BallotApplicationDetail|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_BallotApplicationDetail $details
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setDetails(\patest\StructType\RecordSetOfPrinting_PrintableItem_BallotApplicationDetail $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get PaymentMethodDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodDetails()
    {
        return isset($this->PaymentMethodDetails) ? $this->PaymentMethodDetails : null;
    }
    /**
     * Set PaymentMethodDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodDetails
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setPaymentMethodDetails($paymentMethodDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodDetails) && !is_string($paymentMethodDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodDetails, true), gettype($paymentMethodDetails)), __LINE__);
        }
        if (is_null($paymentMethodDetails) || (is_array($paymentMethodDetails) && empty($paymentMethodDetails))) {
            unset($this->PaymentMethodDetails);
        } else {
            $this->PaymentMethodDetails = $paymentMethodDetails;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodName
     * @return \patest\StructType\Printing_PrintableItem_BallotApplicationSummary
     */
    public function setPaymentMethodName($paymentMethodName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodName) && !is_string($paymentMethodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodName, true), gettype($paymentMethodName)), __LINE__);
        }
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
}
