<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableDocumentType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Printing.PrintableDocumentType
 * @subpackage Structs
 */
class Printing_PrintableDocumentType extends AnyEntity
{
    /**
     * The AccessPermissions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $AccessPermissions;
    /**
     * The AccountSalutationFormatId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountSalutationFormatId;
    /**
     * The BarcodeProviderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeProviderId;
    /**
     * The CustomerSalutationFormatId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerSalutationFormatId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Filter;
    /**
     * The HasBarcode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasBarcode;
    /**
     * The HolderTenantId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderTenantId;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Id;
    /**
     * The ImpersonatesDocumentType
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImpersonatesDocumentType;
    /**
     * The IsUsed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUsed;
    /**
     * The Kind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Kind;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The PrecedenceOrder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrecedenceOrder;
    /**
     * The SkipDesign
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipDesign;
    /**
     * Constructor method for Printing.PrintableDocumentType
     * @uses Printing_PrintableDocumentType::setAccessPermissions()
     * @uses Printing_PrintableDocumentType::setAccountSalutationFormatId()
     * @uses Printing_PrintableDocumentType::setBarcodeProviderId()
     * @uses Printing_PrintableDocumentType::setCustomerSalutationFormatId()
     * @uses Printing_PrintableDocumentType::setDescription()
     * @uses Printing_PrintableDocumentType::setFilter()
     * @uses Printing_PrintableDocumentType::setHasBarcode()
     * @uses Printing_PrintableDocumentType::setHolderTenantId()
     * @uses Printing_PrintableDocumentType::setId()
     * @uses Printing_PrintableDocumentType::setImpersonatesDocumentType()
     * @uses Printing_PrintableDocumentType::setIsUsed()
     * @uses Printing_PrintableDocumentType::setKind()
     * @uses Printing_PrintableDocumentType::setLocalId()
     * @uses Printing_PrintableDocumentType::setName()
     * @uses Printing_PrintableDocumentType::setPrecedenceOrder()
     * @uses Printing_PrintableDocumentType::setSkipDesign()
     * @param string[] $accessPermissions
     * @param string $accountSalutationFormatId
     * @param string $barcodeProviderId
     * @param string $customerSalutationFormatId
     * @param \patest\StructType\GlobalString $description
     * @param string $filter
     * @param bool $hasBarcode
     * @param int $holderTenantId
     * @param string $id
     * @param string $impersonatesDocumentType
     * @param bool $isUsed
     * @param string $kind
     * @param int $localId
     * @param \patest\StructType\GlobalString $name
     * @param int $precedenceOrder
     * @param bool $skipDesign
     */
    public function __construct(array $accessPermissions = array(), $accountSalutationFormatId = null, $barcodeProviderId = null, $customerSalutationFormatId = null, \patest\StructType\GlobalString $description = null, $filter = null, $hasBarcode = null, $holderTenantId = null, $id = null, $impersonatesDocumentType = null, $isUsed = null, $kind = null, $localId = null, \patest\StructType\GlobalString $name = null, $precedenceOrder = null, $skipDesign = null)
    {
        $this
            ->setAccessPermissions($accessPermissions)
            ->setAccountSalutationFormatId($accountSalutationFormatId)
            ->setBarcodeProviderId($barcodeProviderId)
            ->setCustomerSalutationFormatId($customerSalutationFormatId)
            ->setDescription($description)
            ->setFilter($filter)
            ->setHasBarcode($hasBarcode)
            ->setHolderTenantId($holderTenantId)
            ->setId($id)
            ->setImpersonatesDocumentType($impersonatesDocumentType)
            ->setIsUsed($isUsed)
            ->setKind($kind)
            ->setLocalId($localId)
            ->setName($name)
            ->setPrecedenceOrder($precedenceOrder)
            ->setSkipDesign($skipDesign);
    }
    /**
     * Get AccessPermissions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getAccessPermissions()
    {
        return isset($this->AccessPermissions) ? $this->AccessPermissions : null;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessPermissions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessPermissions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $printing_PrintableDocumentTypeAccessPermissionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\EntityAccessPermission::valueIsValid($printing_PrintableDocumentTypeAccessPermissionsItem)) {
                $invalidValues[] = is_object($printing_PrintableDocumentTypeAccessPermissionsItem) ? get_class($printing_PrintableDocumentTypeAccessPermissionsItem) : sprintf('%s(%s)', gettype($printing_PrintableDocumentTypeAccessPermissionsItem), var_export($printing_PrintableDocumentTypeAccessPermissionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EntityAccessPermission', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\EntityAccessPermission::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessPermissions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EntityAccessPermission::valueIsValid()
     * @uses \patest\EnumType\EntityAccessPermission::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessPermissions
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setAccessPermissions(array $accessPermissions = array())
    {
        // validation for constraint: list
        if ('' !== ($accessPermissionsArrayErrorMessage = self::validateAccessPermissionsForArrayConstraintsFromSetAccessPermissions($accessPermissions))) {
            throw new \InvalidArgumentException($accessPermissionsArrayErrorMessage, __LINE__);
        }
        if (is_null($accessPermissions) || (is_array($accessPermissions) && empty($accessPermissions))) {
            unset($this->AccessPermissions);
        } else {
            $this->AccessPermissions = is_array($accessPermissions) ? implode(' ', $accessPermissions) : null;
        }
        return $this;
    }
    /**
     * Get AccountSalutationFormatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountSalutationFormatId()
    {
        return isset($this->AccountSalutationFormatId) ? $this->AccountSalutationFormatId : null;
    }
    /**
     * Set AccountSalutationFormatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountSalutationFormatId
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setAccountSalutationFormatId($accountSalutationFormatId = null)
    {
        // validation for constraint: string
        if (!is_null($accountSalutationFormatId) && !is_string($accountSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountSalutationFormatId, true), gettype($accountSalutationFormatId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountSalutationFormatId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountSalutationFormatId, true)), __LINE__);
        }
        if (is_null($accountSalutationFormatId) || (is_array($accountSalutationFormatId) && empty($accountSalutationFormatId))) {
            unset($this->AccountSalutationFormatId);
        } else {
            $this->AccountSalutationFormatId = $accountSalutationFormatId;
        }
        return $this;
    }
    /**
     * Get BarcodeProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeProviderId()
    {
        return isset($this->BarcodeProviderId) ? $this->BarcodeProviderId : null;
    }
    /**
     * Set BarcodeProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeProviderId
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setBarcodeProviderId($barcodeProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeProviderId) && !is_string($barcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeProviderId, true), gettype($barcodeProviderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeProviderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeProviderId, true)), __LINE__);
        }
        if (is_null($barcodeProviderId) || (is_array($barcodeProviderId) && empty($barcodeProviderId))) {
            unset($this->BarcodeProviderId);
        } else {
            $this->BarcodeProviderId = $barcodeProviderId;
        }
        return $this;
    }
    /**
     * Get CustomerSalutationFormatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerSalutationFormatId()
    {
        return isset($this->CustomerSalutationFormatId) ? $this->CustomerSalutationFormatId : null;
    }
    /**
     * Set CustomerSalutationFormatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerSalutationFormatId
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setCustomerSalutationFormatId($customerSalutationFormatId = null)
    {
        // validation for constraint: string
        if (!is_null($customerSalutationFormatId) && !is_string($customerSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerSalutationFormatId, true), gettype($customerSalutationFormatId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerSalutationFormatId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerSalutationFormatId, true)), __LINE__);
        }
        if (is_null($customerSalutationFormatId) || (is_array($customerSalutationFormatId) && empty($customerSalutationFormatId))) {
            unset($this->CustomerSalutationFormatId);
        } else {
            $this->CustomerSalutationFormatId = $customerSalutationFormatId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Filter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilter()
    {
        return isset($this->Filter) ? $this->Filter : null;
    }
    /**
     * Set Filter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filter
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter, true), gettype($filter)), __LINE__);
        }
        if (is_null($filter) || (is_array($filter) && empty($filter))) {
            unset($this->Filter);
        } else {
            $this->Filter = $filter;
        }
        return $this;
    }
    /**
     * Get HasBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasBarcode()
    {
        return isset($this->HasBarcode) ? $this->HasBarcode : null;
    }
    /**
     * Set HasBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasBarcode
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setHasBarcode($hasBarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasBarcode) && !is_bool($hasBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasBarcode, true), gettype($hasBarcode)), __LINE__);
        }
        if (is_null($hasBarcode) || (is_array($hasBarcode) && empty($hasBarcode))) {
            unset($this->HasBarcode);
        } else {
            $this->HasBarcode = $hasBarcode;
        }
        return $this;
    }
    /**
     * Get HolderTenantId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderTenantId()
    {
        return isset($this->HolderTenantId) ? $this->HolderTenantId : null;
    }
    /**
     * Set HolderTenantId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderTenantId
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setHolderTenantId($holderTenantId = null)
    {
        // validation for constraint: int
        if (!is_null($holderTenantId) && !(is_int($holderTenantId) || ctype_digit($holderTenantId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderTenantId, true), gettype($holderTenantId)), __LINE__);
        }
        if (is_null($holderTenantId) || (is_array($holderTenantId) && empty($holderTenantId))) {
            unset($this->HolderTenantId);
        } else {
            $this->HolderTenantId = $holderTenantId;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get ImpersonatesDocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImpersonatesDocumentType()
    {
        return isset($this->ImpersonatesDocumentType) ? $this->ImpersonatesDocumentType : null;
    }
    /**
     * Set ImpersonatesDocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $impersonatesDocumentType
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setImpersonatesDocumentType($impersonatesDocumentType = null)
    {
        // validation for constraint: string
        if (!is_null($impersonatesDocumentType) && !is_string($impersonatesDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($impersonatesDocumentType, true), gettype($impersonatesDocumentType)), __LINE__);
        }
        if (is_null($impersonatesDocumentType) || (is_array($impersonatesDocumentType) && empty($impersonatesDocumentType))) {
            unset($this->ImpersonatesDocumentType);
        } else {
            $this->ImpersonatesDocumentType = $impersonatesDocumentType;
        }
        return $this;
    }
    /**
     * Get IsUsed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUsed()
    {
        return isset($this->IsUsed) ? $this->IsUsed : null;
    }
    /**
     * Set IsUsed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUsed
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setIsUsed($isUsed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUsed) && !is_bool($isUsed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUsed, true), gettype($isUsed)), __LINE__);
        }
        if (is_null($isUsed) || (is_array($isUsed) && empty($isUsed))) {
            unset($this->IsUsed);
        } else {
            $this->IsUsed = $isUsed;
        }
        return $this;
    }
    /**
     * Get Kind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getKind()
    {
        return isset($this->Kind) ? $this->Kind : null;
    }
    /**
     * Set Kind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $kind
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setKind($kind = null)
    {
        // validation for constraint: string
        if (!is_null($kind) && !is_string($kind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kind, true), gettype($kind)), __LINE__);
        }
        if (is_null($kind) || (is_array($kind) && empty($kind))) {
            unset($this->Kind);
        } else {
            $this->Kind = $kind;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalId()
    {
        return isset($this->LocalId) ? $this->LocalId : null;
    }
    /**
     * Set LocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localId
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        if (is_null($localId) || (is_array($localId) && empty($localId))) {
            unset($this->LocalId);
        } else {
            $this->LocalId = $localId;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PrecedenceOrder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrecedenceOrder()
    {
        return isset($this->PrecedenceOrder) ? $this->PrecedenceOrder : null;
    }
    /**
     * Set PrecedenceOrder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $precedenceOrder
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setPrecedenceOrder($precedenceOrder = null)
    {
        // validation for constraint: int
        if (!is_null($precedenceOrder) && !(is_int($precedenceOrder) || ctype_digit($precedenceOrder))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($precedenceOrder, true), gettype($precedenceOrder)), __LINE__);
        }
        if (is_null($precedenceOrder) || (is_array($precedenceOrder) && empty($precedenceOrder))) {
            unset($this->PrecedenceOrder);
        } else {
            $this->PrecedenceOrder = $precedenceOrder;
        }
        return $this;
    }
    /**
     * Get SkipDesign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipDesign()
    {
        return isset($this->SkipDesign) ? $this->SkipDesign : null;
    }
    /**
     * Set SkipDesign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipDesign
     * @return \patest\StructType\Printing_PrintableDocumentType
     */
    public function setSkipDesign($skipDesign = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipDesign) && !is_bool($skipDesign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipDesign, true), gettype($skipDesign)), __LINE__);
        }
        if (is_null($skipDesign) || (is_array($skipDesign) && empty($skipDesign))) {
            unset($this->SkipDesign);
        } else {
            $this->SkipDesign = $skipDesign;
        }
        return $this;
    }
}
