<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.DataItem.PaymentMethodSummary StructType
 * @subpackage Structs
 */
class Printing_DataItem_PaymentMethodSummary extends AnyEntity
{
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PaymentMethodSystemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodSystemName;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The TotalClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalClientAmount;
    /**
     * The TotalCompanyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCompanyAmount;
    /**
     * The TotalSiteAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalSiteAmount;
    /**
     * Constructor method for Printing.DataItem.PaymentMethodSummary
     * @uses Printing_DataItem_PaymentMethodSummary::setPaymentMethodName()
     * @uses Printing_DataItem_PaymentMethodSummary::setPaymentMethodSystemName()
     * @uses Printing_DataItem_PaymentMethodSummary::setPaymentMethodType()
     * @uses Printing_DataItem_PaymentMethodSummary::setTotalClientAmount()
     * @uses Printing_DataItem_PaymentMethodSummary::setTotalCompanyAmount()
     * @uses Printing_DataItem_PaymentMethodSummary::setTotalSiteAmount()
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param string $paymentMethodSystemName
     * @param string $paymentMethodType
     * @param \patest\StructType\Money $totalClientAmount
     * @param \patest\StructType\Money $totalCompanyAmount
     * @param \patest\StructType\Money $totalSiteAmount
     */
    public function __construct(\patest\StructType\GlobalString $paymentMethodName = null, $paymentMethodSystemName = null, $paymentMethodType = null, \patest\StructType\Money $totalClientAmount = null, \patest\StructType\Money $totalCompanyAmount = null, \patest\StructType\Money $totalSiteAmount = null)
    {
        $this
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentMethodSystemName($paymentMethodSystemName)
            ->setPaymentMethodType($paymentMethodType)
            ->setTotalClientAmount($totalClientAmount)
            ->setTotalCompanyAmount($totalCompanyAmount)
            ->setTotalSiteAmount($totalSiteAmount);
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Printing_DataItem_PaymentMethodSummary
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentMethodSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodSystemName()
    {
        return isset($this->PaymentMethodSystemName) ? $this->PaymentMethodSystemName : null;
    }
    /**
     * Set PaymentMethodSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodSystemName
     * @return \patest\StructType\Printing_DataItem_PaymentMethodSummary
     */
    public function setPaymentMethodSystemName($paymentMethodSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodSystemName) && !is_string($paymentMethodSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodSystemName, true), gettype($paymentMethodSystemName)), __LINE__);
        }
        if (is_null($paymentMethodSystemName) || (is_array($paymentMethodSystemName) && empty($paymentMethodSystemName))) {
            unset($this->PaymentMethodSystemName);
        } else {
            $this->PaymentMethodSystemName = $paymentMethodSystemName;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\Printing_DataItem_PaymentMethodSummary
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get TotalClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalClientAmount()
    {
        return isset($this->TotalClientAmount) ? $this->TotalClientAmount : null;
    }
    /**
     * Set TotalClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalClientAmount
     * @return \patest\StructType\Printing_DataItem_PaymentMethodSummary
     */
    public function setTotalClientAmount(\patest\StructType\Money $totalClientAmount = null)
    {
        if (is_null($totalClientAmount) || (is_array($totalClientAmount) && empty($totalClientAmount))) {
            unset($this->TotalClientAmount);
        } else {
            $this->TotalClientAmount = $totalClientAmount;
        }
        return $this;
    }
    /**
     * Get TotalCompanyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCompanyAmount()
    {
        return isset($this->TotalCompanyAmount) ? $this->TotalCompanyAmount : null;
    }
    /**
     * Set TotalCompanyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCompanyAmount
     * @return \patest\StructType\Printing_DataItem_PaymentMethodSummary
     */
    public function setTotalCompanyAmount(\patest\StructType\Money $totalCompanyAmount = null)
    {
        if (is_null($totalCompanyAmount) || (is_array($totalCompanyAmount) && empty($totalCompanyAmount))) {
            unset($this->TotalCompanyAmount);
        } else {
            $this->TotalCompanyAmount = $totalCompanyAmount;
        }
        return $this;
    }
    /**
     * Get TotalSiteAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalSiteAmount()
    {
        return isset($this->TotalSiteAmount) ? $this->TotalSiteAmount : null;
    }
    /**
     * Set TotalSiteAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalSiteAmount
     * @return \patest\StructType\Printing_DataItem_PaymentMethodSummary
     */
    public function setTotalSiteAmount(\patest\StructType\Money $totalSiteAmount = null)
    {
        if (is_null($totalSiteAmount) || (is_array($totalSiteAmount) && empty($totalSiteAmount))) {
            unset($this->TotalSiteAmount);
        } else {
            $this->TotalSiteAmount = $totalSiteAmount;
        }
        return $this;
    }
}
