<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxiliaryDataItem.Bundle StructType
 * @subpackage Structs
 */
class Printing_AuxiliaryDataItem_Bundle extends Printing_Item_ComplexProperty_Base
{
    /**
     * The BundleName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BundleName;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The PriceTypeComplex
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_PriceType
     */
    public $PriceTypeComplex;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceType_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceType_Name;
    /**
     * The PriceType_PrintDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceType_PrintDescription;
    /**
     * The PriceType_ShortDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceType_ShortDescription;
    /**
     * The Totals
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Printing_ItemTotals
     */
    public $Totals;
    /**
     * Constructor method for Printing.AuxiliaryDataItem.Bundle
     * @uses Printing_AuxiliaryDataItem_Bundle::setBundleName()
     * @uses Printing_AuxiliaryDataItem_Bundle::setItemId()
     * @uses Printing_AuxiliaryDataItem_Bundle::setPriceTypeComplex()
     * @uses Printing_AuxiliaryDataItem_Bundle::setPriceTypeId()
     * @uses Printing_AuxiliaryDataItem_Bundle::setPriceType_Name()
     * @uses Printing_AuxiliaryDataItem_Bundle::setPriceType_PrintDescription()
     * @uses Printing_AuxiliaryDataItem_Bundle::setPriceType_ShortDescription()
     * @uses Printing_AuxiliaryDataItem_Bundle::setTotals()
     * @param \patest\StructType\GlobalString $bundleName
     * @param int $itemId
     * @param \patest\StructType\Sales_PriceType $priceTypeComplex
     * @param string $priceTypeId
     * @param \patest\StructType\GlobalString $priceType_Name
     * @param \patest\StructType\GlobalString $priceType_PrintDescription
     * @param \patest\StructType\GlobalString $priceType_ShortDescription
     * @param \patest\StructType\Sales_Printing_ItemTotals $totals
     */
    public function __construct(\patest\StructType\GlobalString $bundleName = null, $itemId = null, \patest\StructType\Sales_PriceType $priceTypeComplex = null, $priceTypeId = null, \patest\StructType\GlobalString $priceType_Name = null, \patest\StructType\GlobalString $priceType_PrintDescription = null, \patest\StructType\GlobalString $priceType_ShortDescription = null, \patest\StructType\Sales_Printing_ItemTotals $totals = null)
    {
        $this
            ->setBundleName($bundleName)
            ->setItemId($itemId)
            ->setPriceTypeComplex($priceTypeComplex)
            ->setPriceTypeId($priceTypeId)
            ->setPriceType_Name($priceType_Name)
            ->setPriceType_PrintDescription($priceType_PrintDescription)
            ->setPriceType_ShortDescription($priceType_ShortDescription)
            ->setTotals($totals);
    }
    /**
     * Get BundleName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBundleName()
    {
        return isset($this->BundleName) ? $this->BundleName : null;
    }
    /**
     * Set BundleName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $bundleName
     * @return \patest\StructType\Printing_AuxiliaryDataItem_Bundle
     */
    public function setBundleName(\patest\StructType\GlobalString $bundleName = null)
    {
        if (is_null($bundleName) || (is_array($bundleName) && empty($bundleName))) {
            unset($this->BundleName);
        } else {
            $this->BundleName = $bundleName;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Printing_AuxiliaryDataItem_Bundle
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get PriceTypeComplex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_PriceType|null
     */
    public function getPriceTypeComplex()
    {
        return isset($this->PriceTypeComplex) ? $this->PriceTypeComplex : null;
    }
    /**
     * Set PriceTypeComplex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_PriceType $priceTypeComplex
     * @return \patest\StructType\Printing_AuxiliaryDataItem_Bundle
     */
    public function setPriceTypeComplex(\patest\StructType\Sales_PriceType $priceTypeComplex = null)
    {
        if (is_null($priceTypeComplex) || (is_array($priceTypeComplex) && empty($priceTypeComplex))) {
            unset($this->PriceTypeComplex);
        } else {
            $this->PriceTypeComplex = $priceTypeComplex;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Printing_AuxiliaryDataItem_Bundle
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceType_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceType_Name()
    {
        return isset($this->PriceType_Name) ? $this->PriceType_Name : null;
    }
    /**
     * Set PriceType_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceType_Name
     * @return \patest\StructType\Printing_AuxiliaryDataItem_Bundle
     */
    public function setPriceType_Name(\patest\StructType\GlobalString $priceType_Name = null)
    {
        if (is_null($priceType_Name) || (is_array($priceType_Name) && empty($priceType_Name))) {
            unset($this->PriceType_Name);
        } else {
            $this->PriceType_Name = $priceType_Name;
        }
        return $this;
    }
    /**
     * Get PriceType_PrintDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceType_PrintDescription()
    {
        return isset($this->PriceType_PrintDescription) ? $this->PriceType_PrintDescription : null;
    }
    /**
     * Set PriceType_PrintDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceType_PrintDescription
     * @return \patest\StructType\Printing_AuxiliaryDataItem_Bundle
     */
    public function setPriceType_PrintDescription(\patest\StructType\GlobalString $priceType_PrintDescription = null)
    {
        if (is_null($priceType_PrintDescription) || (is_array($priceType_PrintDescription) && empty($priceType_PrintDescription))) {
            unset($this->PriceType_PrintDescription);
        } else {
            $this->PriceType_PrintDescription = $priceType_PrintDescription;
        }
        return $this;
    }
    /**
     * Get PriceType_ShortDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceType_ShortDescription()
    {
        return isset($this->PriceType_ShortDescription) ? $this->PriceType_ShortDescription : null;
    }
    /**
     * Set PriceType_ShortDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceType_ShortDescription
     * @return \patest\StructType\Printing_AuxiliaryDataItem_Bundle
     */
    public function setPriceType_ShortDescription(\patest\StructType\GlobalString $priceType_ShortDescription = null)
    {
        if (is_null($priceType_ShortDescription) || (is_array($priceType_ShortDescription) && empty($priceType_ShortDescription))) {
            unset($this->PriceType_ShortDescription);
        } else {
            $this->PriceType_ShortDescription = $priceType_ShortDescription;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Printing_ItemTotals|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Printing_ItemTotals $totals
     * @return \patest\StructType\Printing_AuxiliaryDataItem_Bundle
     */
    public function setTotals(\patest\StructType\Sales_Printing_ItemTotals $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
}
