<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Printing.AuxDataItem.TransactionSeatsSummaryByPriceType.SummaryItem StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem extends Printing_AuxDataItem_TransactionSeatsSummary_BaseSummaryItem
{
    /**
     * The IsFirstForEvent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFirstForEvent;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The PriceTypeName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceTypeName;
    /**
     * The SeatsSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatsSummary;
    /**
     * Constructor method for
     * Printing.AuxDataItem.TransactionSeatsSummaryByPriceType.SummaryItem
     * @uses Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem::setIsFirstForEvent()
     * @uses Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem::setPrice()
     * @uses Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem::setPriceTypeId()
     * @uses Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem::setPriceTypeName()
     * @uses Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem::setSeatsSummary()
     * @param bool $isFirstForEvent
     * @param \patest\StructType\Money $price
     * @param string $priceTypeId
     * @param \patest\StructType\GlobalString $priceTypeName
     * @param string $seatsSummary
     */
    public function __construct($isFirstForEvent = null, \patest\StructType\Money $price = null, $priceTypeId = null, \patest\StructType\GlobalString $priceTypeName = null, $seatsSummary = null)
    {
        $this
            ->setIsFirstForEvent($isFirstForEvent)
            ->setPrice($price)
            ->setPriceTypeId($priceTypeId)
            ->setPriceTypeName($priceTypeName)
            ->setSeatsSummary($seatsSummary);
    }
    /**
     * Get IsFirstForEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFirstForEvent()
    {
        return isset($this->IsFirstForEvent) ? $this->IsFirstForEvent : null;
    }
    /**
     * Set IsFirstForEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFirstForEvent
     * @return \patest\StructType\Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem
     */
    public function setIsFirstForEvent($isFirstForEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstForEvent) && !is_bool($isFirstForEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFirstForEvent, true), gettype($isFirstForEvent)), __LINE__);
        }
        if (is_null($isFirstForEvent) || (is_array($isFirstForEvent) && empty($isFirstForEvent))) {
            unset($this->IsFirstForEvent);
        } else {
            $this->IsFirstForEvent = $isFirstForEvent;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get PriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceTypeName()
    {
        return isset($this->PriceTypeName) ? $this->PriceTypeName : null;
    }
    /**
     * Set PriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceTypeName
     * @return \patest\StructType\Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem
     */
    public function setPriceTypeName(\patest\StructType\GlobalString $priceTypeName = null)
    {
        if (is_null($priceTypeName) || (is_array($priceTypeName) && empty($priceTypeName))) {
            unset($this->PriceTypeName);
        } else {
            $this->PriceTypeName = $priceTypeName;
        }
        return $this;
    }
    /**
     * Get SeatsSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatsSummary()
    {
        return isset($this->SeatsSummary) ? $this->SeatsSummary : null;
    }
    /**
     * Set SeatsSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatsSummary
     * @return \patest\StructType\Printing_AuxDataItem_TransactionSeatsSummaryByPriceType_SummaryItem
     */
    public function setSeatsSummary($seatsSummary = null)
    {
        // validation for constraint: string
        if (!is_null($seatsSummary) && !is_string($seatsSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatsSummary, true), gettype($seatsSummary)), __LINE__);
        }
        if (is_null($seatsSummary) || (is_array($seatsSummary) && empty($seatsSummary))) {
            unset($this->SeatsSummary);
        } else {
            $this->SeatsSummary = $seatsSummary;
        }
        return $this;
    }
}
