<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.Transaction StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_Transaction extends Printing_AuxiliaryDataItem_Base
{
    /**
     * The AffiliatedAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_StandaloneAccount
     */
    public $AffiliatedAccount;
    /**
     * The AgencyAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_StandaloneAccount
     */
    public $AgencyAccount;
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The Basket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Printing_Basket
     */
    public $Basket;
    /**
     * The CommitDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CommitDate;
    /**
     * The ConnectionProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public $ConnectionProperties;
    /**
     * The ExtraInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExtraInfo;
    /**
     * The InteractionChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InteractionChannel;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The OnBehalfOfAccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OnBehalfOfAccountName;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The RetailerTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RetailerTransactionNumber;
    /**
     * The SaleMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Printing_SaleMode
     */
    public $SaleMode;
    /**
     * The SellerAccount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount
     */
    public $SellerAccount;
    /**
     * The SellerBranchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SellerBranchId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * The TicketsCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsCount;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Printing.AuxDataItem.Transaction
     * @uses Printing_AuxDataItem_Transaction::setAffiliatedAccount()
     * @uses Printing_AuxDataItem_Transaction::setAgencyAccount()
     * @uses Printing_AuxDataItem_Transaction::setApplicationChannel()
     * @uses Printing_AuxDataItem_Transaction::setBasket()
     * @uses Printing_AuxDataItem_Transaction::setCommitDate()
     * @uses Printing_AuxDataItem_Transaction::setConnectionProperties()
     * @uses Printing_AuxDataItem_Transaction::setExtraInfo()
     * @uses Printing_AuxDataItem_Transaction::setInteractionChannel()
     * @uses Printing_AuxDataItem_Transaction::setNotes()
     * @uses Printing_AuxDataItem_Transaction::setOnBehalfOfAccountName()
     * @uses Printing_AuxDataItem_Transaction::setReferenceNumber()
     * @uses Printing_AuxDataItem_Transaction::setRetailerTransactionNumber()
     * @uses Printing_AuxDataItem_Transaction::setSaleMode()
     * @uses Printing_AuxDataItem_Transaction::setSellerAccount()
     * @uses Printing_AuxDataItem_Transaction::setSellerBranchId()
     * @uses Printing_AuxDataItem_Transaction::setState()
     * @uses Printing_AuxDataItem_Transaction::setTicketsCount()
     * @uses Printing_AuxDataItem_Transaction::setTransactionNumber()
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $affiliatedAccount
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $agencyAccount
     * @param string $applicationChannel
     * @param \patest\StructType\Sales_Printing_Basket $basket
     * @param string $commitDate
     * @param \patest\StructType\Printing_AuxDataItem_ConnectionProperties $connectionProperties
     * @param string $extraInfo
     * @param string $interactionChannel
     * @param string $notes
     * @param string $onBehalfOfAccountName
     * @param int $referenceNumber
     * @param int $retailerTransactionNumber
     * @param \patest\StructType\Sales_Printing_SaleMode $saleMode
     * @param \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $sellerAccount
     * @param string $sellerBranchId
     * @param string $state
     * @param int $ticketsCount
     * @param int $transactionNumber
     */
    public function __construct(\patest\StructType\Printing_AuxDataItem_StandaloneAccount $affiliatedAccount = null, \patest\StructType\Printing_AuxDataItem_StandaloneAccount $agencyAccount = null, $applicationChannel = null, \patest\StructType\Sales_Printing_Basket $basket = null, $commitDate = null, \patest\StructType\Printing_AuxDataItem_ConnectionProperties $connectionProperties = null, $extraInfo = null, $interactionChannel = null, $notes = null, $onBehalfOfAccountName = null, $referenceNumber = null, $retailerTransactionNumber = null, \patest\StructType\Sales_Printing_SaleMode $saleMode = null, \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $sellerAccount = null, $sellerBranchId = null, $state = null, $ticketsCount = null, $transactionNumber = null)
    {
        $this
            ->setAffiliatedAccount($affiliatedAccount)
            ->setAgencyAccount($agencyAccount)
            ->setApplicationChannel($applicationChannel)
            ->setBasket($basket)
            ->setCommitDate($commitDate)
            ->setConnectionProperties($connectionProperties)
            ->setExtraInfo($extraInfo)
            ->setInteractionChannel($interactionChannel)
            ->setNotes($notes)
            ->setOnBehalfOfAccountName($onBehalfOfAccountName)
            ->setReferenceNumber($referenceNumber)
            ->setRetailerTransactionNumber($retailerTransactionNumber)
            ->setSaleMode($saleMode)
            ->setSellerAccount($sellerAccount)
            ->setSellerBranchId($sellerBranchId)
            ->setState($state)
            ->setTicketsCount($ticketsCount)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get AffiliatedAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneAccount|null
     */
    public function getAffiliatedAccount()
    {
        return isset($this->AffiliatedAccount) ? $this->AffiliatedAccount : null;
    }
    /**
     * Set AffiliatedAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $affiliatedAccount
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setAffiliatedAccount(\patest\StructType\Printing_AuxDataItem_StandaloneAccount $affiliatedAccount = null)
    {
        if (is_null($affiliatedAccount) || (is_array($affiliatedAccount) && empty($affiliatedAccount))) {
            unset($this->AffiliatedAccount);
        } else {
            $this->AffiliatedAccount = $affiliatedAccount;
        }
        return $this;
    }
    /**
     * Get AgencyAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneAccount|null
     */
    public function getAgencyAccount()
    {
        return isset($this->AgencyAccount) ? $this->AgencyAccount : null;
    }
    /**
     * Set AgencyAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_StandaloneAccount $agencyAccount
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setAgencyAccount(\patest\StructType\Printing_AuxDataItem_StandaloneAccount $agencyAccount = null)
    {
        if (is_null($agencyAccount) || (is_array($agencyAccount) && empty($agencyAccount))) {
            unset($this->AgencyAccount);
        } else {
            $this->AgencyAccount = $agencyAccount;
        }
        return $this;
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get Basket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Printing_Basket|null
     */
    public function getBasket()
    {
        return isset($this->Basket) ? $this->Basket : null;
    }
    /**
     * Set Basket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Printing_Basket $basket
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setBasket(\patest\StructType\Sales_Printing_Basket $basket = null)
    {
        if (is_null($basket) || (is_array($basket) && empty($basket))) {
            unset($this->Basket);
        } else {
            $this->Basket = $basket;
        }
        return $this;
    }
    /**
     * Get CommitDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommitDate()
    {
        return isset($this->CommitDate) ? $this->CommitDate : null;
    }
    /**
     * Set CommitDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commitDate
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setCommitDate($commitDate = null)
    {
        // validation for constraint: string
        if (!is_null($commitDate) && !is_string($commitDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commitDate, true), gettype($commitDate)), __LINE__);
        }
        if (is_null($commitDate) || (is_array($commitDate) && empty($commitDate))) {
            unset($this->CommitDate);
        } else {
            $this->CommitDate = $commitDate;
        }
        return $this;
    }
    /**
     * Get ConnectionProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties|null
     */
    public function getConnectionProperties()
    {
        return isset($this->ConnectionProperties) ? $this->ConnectionProperties : null;
    }
    /**
     * Set ConnectionProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ConnectionProperties $connectionProperties
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setConnectionProperties(\patest\StructType\Printing_AuxDataItem_ConnectionProperties $connectionProperties = null)
    {
        if (is_null($connectionProperties) || (is_array($connectionProperties) && empty($connectionProperties))) {
            unset($this->ConnectionProperties);
        } else {
            $this->ConnectionProperties = $connectionProperties;
        }
        return $this;
    }
    /**
     * Get ExtraInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtraInfo()
    {
        return isset($this->ExtraInfo) ? $this->ExtraInfo : null;
    }
    /**
     * Set ExtraInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extraInfo
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setExtraInfo($extraInfo = null)
    {
        // validation for constraint: string
        if (!is_null($extraInfo) && !is_string($extraInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extraInfo, true), gettype($extraInfo)), __LINE__);
        }
        if (is_null($extraInfo) || (is_array($extraInfo) && empty($extraInfo))) {
            unset($this->ExtraInfo);
        } else {
            $this->ExtraInfo = $extraInfo;
        }
        return $this;
    }
    /**
     * Get InteractionChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInteractionChannel()
    {
        return isset($this->InteractionChannel) ? $this->InteractionChannel : null;
    }
    /**
     * Set InteractionChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionInteractionChannel::valueIsValid()
     * @uses \patest\EnumType\TransactionInteractionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $interactionChannel
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setInteractionChannel($interactionChannel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionInteractionChannel::valueIsValid($interactionChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionInteractionChannel', is_array($interactionChannel) ? implode(', ', $interactionChannel) : var_export($interactionChannel, true), implode(', ', \patest\EnumType\TransactionInteractionChannel::getValidValues())), __LINE__);
        }
        if (is_null($interactionChannel) || (is_array($interactionChannel) && empty($interactionChannel))) {
            unset($this->InteractionChannel);
        } else {
            $this->InteractionChannel = $interactionChannel;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OnBehalfOfAccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOnBehalfOfAccountName()
    {
        return isset($this->OnBehalfOfAccountName) ? $this->OnBehalfOfAccountName : null;
    }
    /**
     * Set OnBehalfOfAccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $onBehalfOfAccountName
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setOnBehalfOfAccountName($onBehalfOfAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($onBehalfOfAccountName) && !is_string($onBehalfOfAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($onBehalfOfAccountName, true), gettype($onBehalfOfAccountName)), __LINE__);
        }
        if (is_null($onBehalfOfAccountName) || (is_array($onBehalfOfAccountName) && empty($onBehalfOfAccountName))) {
            unset($this->OnBehalfOfAccountName);
        } else {
            $this->OnBehalfOfAccountName = $onBehalfOfAccountName;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $referenceNumber
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get RetailerTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRetailerTransactionNumber()
    {
        return isset($this->RetailerTransactionNumber) ? $this->RetailerTransactionNumber : null;
    }
    /**
     * Set RetailerTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $retailerTransactionNumber
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setRetailerTransactionNumber($retailerTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($retailerTransactionNumber) && !(is_int($retailerTransactionNumber) || ctype_digit($retailerTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($retailerTransactionNumber, true), gettype($retailerTransactionNumber)), __LINE__);
        }
        if (is_null($retailerTransactionNumber) || (is_array($retailerTransactionNumber) && empty($retailerTransactionNumber))) {
            unset($this->RetailerTransactionNumber);
        } else {
            $this->RetailerTransactionNumber = $retailerTransactionNumber;
        }
        return $this;
    }
    /**
     * Get SaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Printing_SaleMode|null
     */
    public function getSaleMode()
    {
        return isset($this->SaleMode) ? $this->SaleMode : null;
    }
    /**
     * Set SaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Printing_SaleMode $saleMode
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setSaleMode(\patest\StructType\Sales_Printing_SaleMode $saleMode = null)
    {
        if (is_null($saleMode) || (is_array($saleMode) && empty($saleMode))) {
            unset($this->SaleMode);
        } else {
            $this->SaleMode = $saleMode;
        }
        return $this;
    }
    /**
     * Get SellerAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount|null
     */
    public function getSellerAccount()
    {
        return isset($this->SellerAccount) ? $this->SellerAccount : null;
    }
    /**
     * Set SellerAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $sellerAccount
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setSellerAccount(\patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $sellerAccount = null)
    {
        if (is_null($sellerAccount) || (is_array($sellerAccount) && empty($sellerAccount))) {
            unset($this->SellerAccount);
        } else {
            $this->SellerAccount = $sellerAccount;
        }
        return $this;
    }
    /**
     * Get SellerBranchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellerBranchId()
    {
        return isset($this->SellerBranchId) ? $this->SellerBranchId : null;
    }
    /**
     * Set SellerBranchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellerBranchId
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setSellerBranchId($sellerBranchId = null)
    {
        // validation for constraint: string
        if (!is_null($sellerBranchId) && !is_string($sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellerBranchId, true), gettype($sellerBranchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sellerBranchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sellerBranchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sellerBranchId, true)), __LINE__);
        }
        if (is_null($sellerBranchId) || (is_array($sellerBranchId) && empty($sellerBranchId))) {
            unset($this->SellerBranchId);
        } else {
            $this->SellerBranchId = $sellerBranchId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionState::valueIsValid()
     * @uses \patest\EnumType\TransactionState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\TransactionState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
    /**
     * Get TicketsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsCount()
    {
        return isset($this->TicketsCount) ? $this->TicketsCount : null;
    }
    /**
     * Set TicketsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsCount
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setTicketsCount($ticketsCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsCount) && !(is_int($ticketsCount) || ctype_digit($ticketsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsCount, true), gettype($ticketsCount)), __LINE__);
        }
        if (is_null($ticketsCount) || (is_array($ticketsCount) && empty($ticketsCount))) {
            unset($this->TicketsCount);
        } else {
            $this->TicketsCount = $ticketsCount;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Printing_AuxDataItem_Transaction
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
