<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.StandaloneClient StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_StandaloneClient extends Printing_AuxiliaryDataItem_Base
{
    /**
     * The BusinessAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress
     */
    public $BusinessAddress;
    /**
     * The BusinessPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessPhone;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientExtraFields
     */
    public $ExtraFields;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The HomeAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress
     */
    public $HomeAddress;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The IsGroupLeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupLeader;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PictureUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PictureUrl;
    /**
     * The PrimaryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress
     */
    public $PrimaryAddress;
    /**
     * The SalutationIndividualText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalutationIndividualText;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Type;
    /**
     * The WebSite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebSite;
    /**
     * Constructor method for Printing.AuxDataItem.StandaloneClient
     * @uses Printing_AuxDataItem_StandaloneClient::setBusinessAddress()
     * @uses Printing_AuxDataItem_StandaloneClient::setBusinessPhone()
     * @uses Printing_AuxDataItem_StandaloneClient::setCreationDateTime()
     * @uses Printing_AuxDataItem_StandaloneClient::setCrmId()
     * @uses Printing_AuxDataItem_StandaloneClient::setCultureId()
     * @uses Printing_AuxDataItem_StandaloneClient::setDisplayName()
     * @uses Printing_AuxDataItem_StandaloneClient::setEmail()
     * @uses Printing_AuxDataItem_StandaloneClient::setExternalId()
     * @uses Printing_AuxDataItem_StandaloneClient::setExtraFields()
     * @uses Printing_AuxDataItem_StandaloneClient::setFax()
     * @uses Printing_AuxDataItem_StandaloneClient::setHomeAddress()
     * @uses Printing_AuxDataItem_StandaloneClient::setHomePhone()
     * @uses Printing_AuxDataItem_StandaloneClient::setIsGroupLeader()
     * @uses Printing_AuxDataItem_StandaloneClient::setMobilePhone()
     * @uses Printing_AuxDataItem_StandaloneClient::setNote()
     * @uses Printing_AuxDataItem_StandaloneClient::setOrganizationUnitId()
     * @uses Printing_AuxDataItem_StandaloneClient::setPictureUrl()
     * @uses Printing_AuxDataItem_StandaloneClient::setPrimaryAddress()
     * @uses Printing_AuxDataItem_StandaloneClient::setSalutationIndividualText()
     * @uses Printing_AuxDataItem_StandaloneClient::setType()
     * @uses Printing_AuxDataItem_StandaloneClient::setWebSite()
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $businessAddress
     * @param string $businessPhone
     * @param string $creationDateTime
     * @param string $crmId
     * @param int $cultureId
     * @param string $displayName
     * @param string $email
     * @param string $externalId
     * @param \patest\StructType\Printing_AuxDataItem_ClientExtraFields $extraFields
     * @param string $fax
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $homeAddress
     * @param string $homePhone
     * @param bool $isGroupLeader
     * @param string $mobilePhone
     * @param \patest\StructType\GlobalString $note
     * @param string $organizationUnitId
     * @param string $pictureUrl
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $primaryAddress
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @param string[] $type
     * @param string $webSite
     */
    public function __construct(\patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $businessAddress = null, $businessPhone = null, $creationDateTime = null, $crmId = null, $cultureId = null, $displayName = null, $email = null, $externalId = null, \patest\StructType\Printing_AuxDataItem_ClientExtraFields $extraFields = null, $fax = null, \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $homeAddress = null, $homePhone = null, $isGroupLeader = null, $mobilePhone = null, \patest\StructType\GlobalString $note = null, $organizationUnitId = null, $pictureUrl = null, \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $primaryAddress = null, \patest\StructType\GlobalString $salutationIndividualText = null, array $type = array(), $webSite = null)
    {
        $this
            ->setBusinessAddress($businessAddress)
            ->setBusinessPhone($businessPhone)
            ->setCreationDateTime($creationDateTime)
            ->setCrmId($crmId)
            ->setCultureId($cultureId)
            ->setDisplayName($displayName)
            ->setEmail($email)
            ->setExternalId($externalId)
            ->setExtraFields($extraFields)
            ->setFax($fax)
            ->setHomeAddress($homeAddress)
            ->setHomePhone($homePhone)
            ->setIsGroupLeader($isGroupLeader)
            ->setMobilePhone($mobilePhone)
            ->setNote($note)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPictureUrl($pictureUrl)
            ->setPrimaryAddress($primaryAddress)
            ->setSalutationIndividualText($salutationIndividualText)
            ->setType($type)
            ->setWebSite($webSite);
    }
    /**
     * Get BusinessAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress|null
     */
    public function getBusinessAddress()
    {
        return isset($this->BusinessAddress) ? $this->BusinessAddress : null;
    }
    /**
     * Set BusinessAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $businessAddress
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setBusinessAddress(\patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $businessAddress = null)
    {
        if (is_null($businessAddress) || (is_array($businessAddress) && empty($businessAddress))) {
            unset($this->BusinessAddress);
        } else {
            $this->BusinessAddress = $businessAddress;
        }
        return $this;
    }
    /**
     * Get BusinessPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessPhone()
    {
        return isset($this->BusinessPhone) ? $this->BusinessPhone : null;
    }
    /**
     * Set BusinessPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessPhone
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setBusinessPhone($businessPhone = null)
    {
        // validation for constraint: string
        if (!is_null($businessPhone) && !is_string($businessPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessPhone, true), gettype($businessPhone)), __LINE__);
        }
        if (is_null($businessPhone) || (is_array($businessPhone) && empty($businessPhone))) {
            unset($this->BusinessPhone);
        } else {
            $this->BusinessPhone = $businessPhone;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientExtraFields|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientExtraFields $extraFields
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setExtraFields(\patest\StructType\Printing_AuxDataItem_ClientExtraFields $extraFields = null)
    {
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get HomeAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress|null
     */
    public function getHomeAddress()
    {
        return isset($this->HomeAddress) ? $this->HomeAddress : null;
    }
    /**
     * Set HomeAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $homeAddress
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setHomeAddress(\patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $homeAddress = null)
    {
        if (is_null($homeAddress) || (is_array($homeAddress) && empty($homeAddress))) {
            unset($this->HomeAddress);
        } else {
            $this->HomeAddress = $homeAddress;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get IsGroupLeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupLeader()
    {
        return isset($this->IsGroupLeader) ? $this->IsGroupLeader : null;
    }
    /**
     * Set IsGroupLeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupLeader
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setIsGroupLeader($isGroupLeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupLeader) && !is_bool($isGroupLeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupLeader, true), gettype($isGroupLeader)), __LINE__);
        }
        if (is_null($isGroupLeader) || (is_array($isGroupLeader) && empty($isGroupLeader))) {
            unset($this->IsGroupLeader);
        } else {
            $this->IsGroupLeader = $isGroupLeader;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PictureUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPictureUrl()
    {
        return isset($this->PictureUrl) ? $this->PictureUrl : null;
    }
    /**
     * Set PictureUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pictureUrl
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setPictureUrl($pictureUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pictureUrl) && !is_string($pictureUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureUrl, true), gettype($pictureUrl)), __LINE__);
        }
        if (is_null($pictureUrl) || (is_array($pictureUrl) && empty($pictureUrl))) {
            unset($this->PictureUrl);
        } else {
            $this->PictureUrl = $pictureUrl;
        }
        return $this;
    }
    /**
     * Get PrimaryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress|null
     */
    public function getPrimaryAddress()
    {
        return isset($this->PrimaryAddress) ? $this->PrimaryAddress : null;
    }
    /**
     * Set PrimaryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $primaryAddress
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setPrimaryAddress(\patest\StructType\Printing_AuxDataItem_ClientAddressDetailsPostalAddress $primaryAddress = null)
    {
        if (is_null($primaryAddress) || (is_array($primaryAddress) && empty($primaryAddress))) {
            unset($this->PrimaryAddress);
        } else {
            $this->PrimaryAddress = $primaryAddress;
        }
        return $this;
    }
    /**
     * Get SalutationIndividualText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalutationIndividualText()
    {
        return isset($this->SalutationIndividualText) ? $this->SalutationIndividualText : null;
    }
    /**
     * Set SalutationIndividualText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setSalutationIndividualText(\patest\StructType\GlobalString $salutationIndividualText = null)
    {
        if (is_null($salutationIndividualText) || (is_array($salutationIndividualText) && empty($salutationIndividualText))) {
            unset($this->SalutationIndividualText);
        } else {
            $this->SalutationIndividualText = $salutationIndividualText;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $printing_AuxDataItem_StandaloneClientTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($printing_AuxDataItem_StandaloneClientTypeItem)) {
                $invalidValues[] = is_object($printing_AuxDataItem_StandaloneClientTypeItem) ? get_class($printing_AuxDataItem_StandaloneClientTypeItem) : sprintf('%s(%s)', gettype($printing_AuxDataItem_StandaloneClientTypeItem), var_export($printing_AuxDataItem_StandaloneClientTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = is_array($type) ? implode(' ', $type) : null;
        }
        return $this;
    }
    /**
     * Get WebSite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebSite()
    {
        return isset($this->WebSite) ? $this->WebSite : null;
    }
    /**
     * Set WebSite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webSite
     * @return \patest\StructType\Printing_AuxDataItem_StandaloneClient
     */
    public function setWebSite($webSite = null)
    {
        // validation for constraint: string
        if (!is_null($webSite) && !is_string($webSite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webSite, true), gettype($webSite)), __LINE__);
        }
        if (is_null($webSite) || (is_array($webSite) && empty($webSite))) {
            unset($this->WebSite);
        } else {
            $this->WebSite = $webSite;
        }
        return $this;
    }
}
