<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.ClientContactDetail StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_ClientContactDetail extends Printing_Item_ComplexProperty_Base
{
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Detail;
    /**
     * The IsPrimary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrimary;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Printing.AuxDataItem.ClientContactDetail
     * @uses Printing_AuxDataItem_ClientContactDetail::setDetail()
     * @uses Printing_AuxDataItem_ClientContactDetail::setIsPrimary()
     * @uses Printing_AuxDataItem_ClientContactDetail::setNote()
     * @uses Printing_AuxDataItem_ClientContactDetail::setType()
     * @param string $detail
     * @param bool $isPrimary
     * @param \patest\StructType\GlobalString $note
     * @param string $type
     */
    public function __construct($detail = null, $isPrimary = null, \patest\StructType\GlobalString $note = null, $type = null)
    {
        $this
            ->setDetail($detail)
            ->setIsPrimary($isPrimary)
            ->setNote($note)
            ->setType($type);
    }
    /**
     * Get Detail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDetail()
    {
        return isset($this->Detail) ? $this->Detail : null;
    }
    /**
     * Set Detail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $detail
     * @return \patest\StructType\Printing_AuxDataItem_ClientContactDetail
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: string
        if (!is_null($detail) && !is_string($detail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($detail, true), gettype($detail)), __LINE__);
        }
        if (is_null($detail) || (is_array($detail) && empty($detail))) {
            unset($this->Detail);
        } else {
            $this->Detail = $detail;
        }
        return $this;
    }
    /**
     * Get IsPrimary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrimary()
    {
        return isset($this->IsPrimary) ? $this->IsPrimary : null;
    }
    /**
     * Set IsPrimary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrimary
     * @return \patest\StructType\Printing_AuxDataItem_ClientContactDetail
     */
    public function setIsPrimary($isPrimary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrimary) && !is_bool($isPrimary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrimary, true), gettype($isPrimary)), __LINE__);
        }
        if (is_null($isPrimary) || (is_array($isPrimary) && empty($isPrimary))) {
            unset($this->IsPrimary);
        } else {
            $this->IsPrimary = $isPrimary;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\Printing_AuxDataItem_ClientContactDetail
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ContactTypeKind::valueIsValid()
     * @uses \patest\EnumType\ContactTypeKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\Printing_AuxDataItem_ClientContactDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ContactTypeKind::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ContactTypeKind', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\ContactTypeKind::getValidValues())), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
