<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.Account StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_Account extends Printing_AuxiliaryDataItem_Base
{
    /**
     * The ContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactPersonId;
    /**
     * The ContactPersonName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_Customer_ContactPersonName
     */
    public $ContactPersonName;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $GroupName;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The SalutationIndividualText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalutationIndividualText;
    /**
     * The TaxExemptNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxExemptNumber;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * Constructor method for Printing.AuxDataItem.Account
     * @uses Printing_AuxDataItem_Account::setContactPersonId()
     * @uses Printing_AuxDataItem_Account::setContactPersonName()
     * @uses Printing_AuxDataItem_Account::setGroupName()
     * @uses Printing_AuxDataItem_Account::setName()
     * @uses Printing_AuxDataItem_Account::setSalutationIndividualText()
     * @uses Printing_AuxDataItem_Account::setTaxExemptNumber()
     * @uses Printing_AuxDataItem_Account::setVatRegistrationNumber()
     * @param string $contactPersonId
     * @param \patest\StructType\Printing_AuxDataItem_Customer_ContactPersonName $contactPersonName
     * @param \patest\StructType\GlobalString $groupName
     * @param string $name
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @param string $taxExemptNumber
     * @param string $vatRegistrationNumber
     */
    public function __construct($contactPersonId = null, \patest\StructType\Printing_AuxDataItem_Customer_ContactPersonName $contactPersonName = null, \patest\StructType\GlobalString $groupName = null, $name = null, \patest\StructType\GlobalString $salutationIndividualText = null, $taxExemptNumber = null, $vatRegistrationNumber = null)
    {
        $this
            ->setContactPersonId($contactPersonId)
            ->setContactPersonName($contactPersonName)
            ->setGroupName($groupName)
            ->setName($name)
            ->setSalutationIndividualText($salutationIndividualText)
            ->setTaxExemptNumber($taxExemptNumber)
            ->setVatRegistrationNumber($vatRegistrationNumber);
    }
    /**
     * Get ContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactPersonId()
    {
        return isset($this->ContactPersonId) ? $this->ContactPersonId : null;
    }
    /**
     * Set ContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactPersonId
     * @return \patest\StructType\Printing_AuxDataItem_Account
     */
    public function setContactPersonId($contactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($contactPersonId) && !is_string($contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactPersonId, true), gettype($contactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactPersonId, true)), __LINE__);
        }
        if (is_null($contactPersonId) || (is_array($contactPersonId) && empty($contactPersonId))) {
            unset($this->ContactPersonId);
        } else {
            $this->ContactPersonId = $contactPersonId;
        }
        return $this;
    }
    /**
     * Get ContactPersonName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_Customer_ContactPersonName|null
     */
    public function getContactPersonName()
    {
        return isset($this->ContactPersonName) ? $this->ContactPersonName : null;
    }
    /**
     * Set ContactPersonName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_Customer_ContactPersonName $contactPersonName
     * @return \patest\StructType\Printing_AuxDataItem_Account
     */
    public function setContactPersonName(\patest\StructType\Printing_AuxDataItem_Customer_ContactPersonName $contactPersonName = null)
    {
        if (is_null($contactPersonName) || (is_array($contactPersonName) && empty($contactPersonName))) {
            unset($this->ContactPersonName);
        } else {
            $this->ContactPersonName = $contactPersonName;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $groupName
     * @return \patest\StructType\Printing_AuxDataItem_Account
     */
    public function setGroupName(\patest\StructType\GlobalString $groupName = null)
    {
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Printing_AuxDataItem_Account
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get SalutationIndividualText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalutationIndividualText()
    {
        return isset($this->SalutationIndividualText) ? $this->SalutationIndividualText : null;
    }
    /**
     * Set SalutationIndividualText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @return \patest\StructType\Printing_AuxDataItem_Account
     */
    public function setSalutationIndividualText(\patest\StructType\GlobalString $salutationIndividualText = null)
    {
        if (is_null($salutationIndividualText) || (is_array($salutationIndividualText) && empty($salutationIndividualText))) {
            unset($this->SalutationIndividualText);
        } else {
            $this->SalutationIndividualText = $salutationIndividualText;
        }
        return $this;
    }
    /**
     * Get TaxExemptNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxExemptNumber()
    {
        return isset($this->TaxExemptNumber) ? $this->TaxExemptNumber : null;
    }
    /**
     * Set TaxExemptNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxExemptNumber
     * @return \patest\StructType\Printing_AuxDataItem_Account
     */
    public function setTaxExemptNumber($taxExemptNumber = null)
    {
        // validation for constraint: string
        if (!is_null($taxExemptNumber) && !is_string($taxExemptNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxExemptNumber, true), gettype($taxExemptNumber)), __LINE__);
        }
        if (is_null($taxExemptNumber) || (is_array($taxExemptNumber) && empty($taxExemptNumber))) {
            unset($this->TaxExemptNumber);
        } else {
            $this->TaxExemptNumber = $taxExemptNumber;
        }
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return isset($this->VatRegistrationNumber) ? $this->VatRegistrationNumber : null;
    }
    /**
     * Set VatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatRegistrationNumber
     * @return \patest\StructType\Printing_AuxDataItem_Account
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        if (is_null($vatRegistrationNumber) || (is_array($vatRegistrationNumber) && empty($vatRegistrationNumber))) {
            unset($this->VatRegistrationNumber);
        } else {
            $this->VatRegistrationNumber = $vatRegistrationNumber;
        }
        return $this;
    }
}
