<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceModifierIdentity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceModifierIdentity
 * @subpackage Structs
 */
class PriceModifierIdentity extends AbstractStructBase
{
    /**
     * The CompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CompanyId;
    /**
     * The PriceModifierId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PriceModifierId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for PriceModifierIdentity
     * @uses PriceModifierIdentity::setCompanyId()
     * @uses PriceModifierIdentity::setPriceModifierId()
     * @uses PriceModifierIdentity::setTransactionGuid()
     * @param int $companyId
     * @param int $priceModifierId
     * @param string $transactionGuid
     */
    public function __construct($companyId = null, $priceModifierId = null, $transactionGuid = null)
    {
        $this
            ->setCompanyId($companyId)
            ->setPriceModifierId($priceModifierId)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get CompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCompanyId()
    {
        return isset($this->CompanyId) ? $this->CompanyId : null;
    }
    /**
     * Set CompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $companyId
     * @return \patest\StructType\PriceModifierIdentity
     */
    public function setCompanyId($companyId = null)
    {
        // validation for constraint: int
        if (!is_null($companyId) && !(is_int($companyId) || ctype_digit($companyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companyId, true), gettype($companyId)), __LINE__);
        }
        if (is_null($companyId) || (is_array($companyId) && empty($companyId))) {
            unset($this->CompanyId);
        } else {
            $this->CompanyId = $companyId;
        }
        return $this;
    }
    /**
     * Get PriceModifierId value
     * @return int|null
     */
    public function getPriceModifierId()
    {
        return $this->PriceModifierId;
    }
    /**
     * Set PriceModifierId value
     * @param int $priceModifierId
     * @return \patest\StructType\PriceModifierIdentity
     */
    public function setPriceModifierId($priceModifierId = null)
    {
        // validation for constraint: int
        if (!is_null($priceModifierId) && !(is_int($priceModifierId) || ctype_digit($priceModifierId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceModifierId, true), gettype($priceModifierId)), __LINE__);
        }
        $this->PriceModifierId = $priceModifierId;
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\PriceModifierIdentity
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
}
