<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PresaleUpdater StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PresaleUpdater
 * @subpackage Structs
 */
class PresaleUpdater extends AbstractStructBase
{
    /**
     * The AccessCodeMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $AccessCodeMode;
    /**
     * The AccessCreditCardTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AccessCreditCardTypeIds;
    /**
     * The AccessCreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCreditCompanyId;
    /**
     * The AllocationTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $AllocationTypeIds;
    /**
     * The AllowAdvertisingOnSeatGeek
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AllowAdvertisingOnSeatGeek;
    /**
     * The ClientTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $ClientTypeIds;
    /**
     * The DisplayDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DisplayDescription;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DisplayName;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * The IconUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IconUrl;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsActive;
    /**
     * The IsCodeTextSecret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCodeTextSecret;
    /**
     * The MaxTicketsPerAccessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsPerAccessCode;
    /**
     * The MaxTicketsPerCustomer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsPerCustomer;
    /**
     * The MaxTransactionsPerAccessCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $MaxTransactionsPerAccessCode;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The PaymentCorrelation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $PaymentCorrelation;
    /**
     * The PaymentCreditCardTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $PaymentCreditCardTypeIds;
    /**
     * The PaymentCreditCompanyId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentCreditCompanyId;
    /**
     * The PaymentMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $PaymentMode;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $PriceTypeIds;
    /**
     * The RankWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RankWeight;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The TestClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TestClientTypeId;
    /**
     * The VisibilityStart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RelativeTime
     */
    public $VisibilityStart;
    /**
     * The WrongCardMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WrongCardMessage;
    /**
     * Constructor method for PresaleUpdater
     * @uses PresaleUpdater::setAccessCodeMode()
     * @uses PresaleUpdater::setAccessCreditCardTypeIds()
     * @uses PresaleUpdater::setAccessCreditCompanyId()
     * @uses PresaleUpdater::setAllocationTypeIds()
     * @uses PresaleUpdater::setAllowAdvertisingOnSeatGeek()
     * @uses PresaleUpdater::setClientTypeIds()
     * @uses PresaleUpdater::setDisplayDescription()
     * @uses PresaleUpdater::setDisplayName()
     * @uses PresaleUpdater::setEndDate()
     * @uses PresaleUpdater::setIconUrl()
     * @uses PresaleUpdater::setIsActive()
     * @uses PresaleUpdater::setIsCodeTextSecret()
     * @uses PresaleUpdater::setMaxTicketsPerAccessCode()
     * @uses PresaleUpdater::setMaxTicketsPerCustomer()
     * @uses PresaleUpdater::setMaxTransactionsPerAccessCode()
     * @uses PresaleUpdater::setName()
     * @uses PresaleUpdater::setPaymentCorrelation()
     * @uses PresaleUpdater::setPaymentCreditCardTypeIds()
     * @uses PresaleUpdater::setPaymentCreditCompanyId()
     * @uses PresaleUpdater::setPaymentMode()
     * @uses PresaleUpdater::setPriceTypeIds()
     * @uses PresaleUpdater::setRankWeight()
     * @uses PresaleUpdater::setStartDate()
     * @uses PresaleUpdater::setTestClientTypeId()
     * @uses PresaleUpdater::setVisibilityStart()
     * @uses PresaleUpdater::setWrongCardMessage()
     * @param string[] $accessCodeMode
     * @param \patest\ArrayType\ArrayOfguid $accessCreditCardTypeIds
     * @param string $accessCreditCompanyId
     * @param \patest\ArrayType\ArrayOfguid $allocationTypeIds
     * @param bool $allowAdvertisingOnSeatGeek
     * @param \patest\ArrayType\ArrayOfguid $clientTypeIds
     * @param \patest\StructType\GlobalString $displayDescription
     * @param \patest\StructType\GlobalString $displayName
     * @param string $endDate
     * @param string $iconUrl
     * @param bool $isActive
     * @param bool $isCodeTextSecret
     * @param int $maxTicketsPerAccessCode
     * @param int $maxTicketsPerCustomer
     * @param string[] $maxTransactionsPerAccessCode
     * @param \patest\StructType\GlobalString $name
     * @param string[] $paymentCorrelation
     * @param \patest\ArrayType\ArrayOfguid $paymentCreditCardTypeIds
     * @param string $paymentCreditCompanyId
     * @param string[] $paymentMode
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     * @param int $rankWeight
     * @param string $startDate
     * @param string $testClientTypeId
     * @param \patest\StructType\RelativeTime $visibilityStart
     * @param string $wrongCardMessage
     */
    public function __construct(array $accessCodeMode = array(), \patest\ArrayType\ArrayOfguid $accessCreditCardTypeIds = null, $accessCreditCompanyId = null, \patest\ArrayType\ArrayOfguid $allocationTypeIds = null, $allowAdvertisingOnSeatGeek = null, \patest\ArrayType\ArrayOfguid $clientTypeIds = null, \patest\StructType\GlobalString $displayDescription = null, \patest\StructType\GlobalString $displayName = null, $endDate = null, $iconUrl = null, $isActive = null, $isCodeTextSecret = null, $maxTicketsPerAccessCode = null, $maxTicketsPerCustomer = null, array $maxTransactionsPerAccessCode = array(), \patest\StructType\GlobalString $name = null, array $paymentCorrelation = array(), \patest\ArrayType\ArrayOfguid $paymentCreditCardTypeIds = null, $paymentCreditCompanyId = null, array $paymentMode = array(), \patest\ArrayType\ArrayOfguid $priceTypeIds = null, $rankWeight = null, $startDate = null, $testClientTypeId = null, \patest\StructType\RelativeTime $visibilityStart = null, $wrongCardMessage = null)
    {
        $this
            ->setAccessCodeMode($accessCodeMode)
            ->setAccessCreditCardTypeIds($accessCreditCardTypeIds)
            ->setAccessCreditCompanyId($accessCreditCompanyId)
            ->setAllocationTypeIds($allocationTypeIds)
            ->setAllowAdvertisingOnSeatGeek($allowAdvertisingOnSeatGeek)
            ->setClientTypeIds($clientTypeIds)
            ->setDisplayDescription($displayDescription)
            ->setDisplayName($displayName)
            ->setEndDate($endDate)
            ->setIconUrl($iconUrl)
            ->setIsActive($isActive)
            ->setIsCodeTextSecret($isCodeTextSecret)
            ->setMaxTicketsPerAccessCode($maxTicketsPerAccessCode)
            ->setMaxTicketsPerCustomer($maxTicketsPerCustomer)
            ->setMaxTransactionsPerAccessCode($maxTransactionsPerAccessCode)
            ->setName($name)
            ->setPaymentCorrelation($paymentCorrelation)
            ->setPaymentCreditCardTypeIds($paymentCreditCardTypeIds)
            ->setPaymentCreditCompanyId($paymentCreditCompanyId)
            ->setPaymentMode($paymentMode)
            ->setPriceTypeIds($priceTypeIds)
            ->setRankWeight($rankWeight)
            ->setStartDate($startDate)
            ->setTestClientTypeId($testClientTypeId)
            ->setVisibilityStart($visibilityStart)
            ->setWrongCardMessage($wrongCardMessage);
    }
    /**
     * Get AccessCodeMode value
     * @return string[]|null
     */
    public function getAccessCodeMode()
    {
        return $this->AccessCodeMode;
    }
    /**
     * This method is responsible for validating the values passed to the setAccessCodeMode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAccessCodeMode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAccessCodeModeForArrayConstraintsFromSetAccessCodeMode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $presaleUpdaterAccessCodeModeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\AccessCodeScheme::valueIsValid($presaleUpdaterAccessCodeModeItem)) {
                $invalidValues[] = is_object($presaleUpdaterAccessCodeModeItem) ? get_class($presaleUpdaterAccessCodeModeItem) : sprintf('%s(%s)', gettype($presaleUpdaterAccessCodeModeItem), var_export($presaleUpdaterAccessCodeModeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCodeScheme', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\AccessCodeScheme::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AccessCodeMode value
     * @uses \patest\EnumType\AccessCodeScheme::valueIsValid()
     * @uses \patest\EnumType\AccessCodeScheme::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $accessCodeMode
     * @return \patest\StructType\PresaleUpdater
     */
    public function setAccessCodeMode(array $accessCodeMode = array())
    {
        // validation for constraint: list
        if ('' !== ($accessCodeModeArrayErrorMessage = self::validateAccessCodeModeForArrayConstraintsFromSetAccessCodeMode($accessCodeMode))) {
            throw new \InvalidArgumentException($accessCodeModeArrayErrorMessage, __LINE__);
        }
        $this->AccessCodeMode = is_array($accessCodeMode) ? implode(' ', $accessCodeMode) : null;
        return $this;
    }
    /**
     * Get AccessCreditCardTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAccessCreditCardTypeIds()
    {
        return isset($this->AccessCreditCardTypeIds) ? $this->AccessCreditCardTypeIds : null;
    }
    /**
     * Set AccessCreditCardTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $accessCreditCardTypeIds
     * @return \patest\StructType\PresaleUpdater
     */
    public function setAccessCreditCardTypeIds(\patest\ArrayType\ArrayOfguid $accessCreditCardTypeIds = null)
    {
        if (is_null($accessCreditCardTypeIds) || (is_array($accessCreditCardTypeIds) && empty($accessCreditCardTypeIds))) {
            unset($this->AccessCreditCardTypeIds);
        } else {
            $this->AccessCreditCardTypeIds = $accessCreditCardTypeIds;
        }
        return $this;
    }
    /**
     * Get AccessCreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCreditCompanyId()
    {
        return isset($this->AccessCreditCompanyId) ? $this->AccessCreditCompanyId : null;
    }
    /**
     * Set AccessCreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCreditCompanyId
     * @return \patest\StructType\PresaleUpdater
     */
    public function setAccessCreditCompanyId($accessCreditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCreditCompanyId) && !is_string($accessCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCreditCompanyId, true), gettype($accessCreditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCreditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCreditCompanyId, true)), __LINE__);
        }
        if (is_null($accessCreditCompanyId) || (is_array($accessCreditCompanyId) && empty($accessCreditCompanyId))) {
            unset($this->AccessCreditCompanyId);
        } else {
            $this->AccessCreditCompanyId = $accessCreditCompanyId;
        }
        return $this;
    }
    /**
     * Get AllocationTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getAllocationTypeIds()
    {
        return isset($this->AllocationTypeIds) ? $this->AllocationTypeIds : null;
    }
    /**
     * Set AllocationTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $allocationTypeIds
     * @return \patest\StructType\PresaleUpdater
     */
    public function setAllocationTypeIds(\patest\ArrayType\ArrayOfguid $allocationTypeIds = null)
    {
        if (is_null($allocationTypeIds) || (is_array($allocationTypeIds) && empty($allocationTypeIds))) {
            unset($this->AllocationTypeIds);
        } else {
            $this->AllocationTypeIds = $allocationTypeIds;
        }
        return $this;
    }
    /**
     * Get AllowAdvertisingOnSeatGeek value
     * @return bool|null
     */
    public function getAllowAdvertisingOnSeatGeek()
    {
        return $this->AllowAdvertisingOnSeatGeek;
    }
    /**
     * Set AllowAdvertisingOnSeatGeek value
     * @param bool $allowAdvertisingOnSeatGeek
     * @return \patest\StructType\PresaleUpdater
     */
    public function setAllowAdvertisingOnSeatGeek($allowAdvertisingOnSeatGeek = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowAdvertisingOnSeatGeek) && !is_bool($allowAdvertisingOnSeatGeek)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowAdvertisingOnSeatGeek, true), gettype($allowAdvertisingOnSeatGeek)), __LINE__);
        }
        $this->AllowAdvertisingOnSeatGeek = $allowAdvertisingOnSeatGeek;
        return $this;
    }
    /**
     * Get ClientTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getClientTypeIds()
    {
        return isset($this->ClientTypeIds) ? $this->ClientTypeIds : null;
    }
    /**
     * Set ClientTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $clientTypeIds
     * @return \patest\StructType\PresaleUpdater
     */
    public function setClientTypeIds(\patest\ArrayType\ArrayOfguid $clientTypeIds = null)
    {
        if (is_null($clientTypeIds) || (is_array($clientTypeIds) && empty($clientTypeIds))) {
            unset($this->ClientTypeIds);
        } else {
            $this->ClientTypeIds = $clientTypeIds;
        }
        return $this;
    }
    /**
     * Get DisplayDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDisplayDescription()
    {
        return isset($this->DisplayDescription) ? $this->DisplayDescription : null;
    }
    /**
     * Set DisplayDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $displayDescription
     * @return \patest\StructType\PresaleUpdater
     */
    public function setDisplayDescription(\patest\StructType\GlobalString $displayDescription = null)
    {
        if (is_null($displayDescription) || (is_array($displayDescription) && empty($displayDescription))) {
            unset($this->DisplayDescription);
        } else {
            $this->DisplayDescription = $displayDescription;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $displayName
     * @return \patest\StructType\PresaleUpdater
     */
    public function setDisplayName(\patest\StructType\GlobalString $displayName = null)
    {
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \patest\StructType\PresaleUpdater
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Get IconUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIconUrl()
    {
        return isset($this->IconUrl) ? $this->IconUrl : null;
    }
    /**
     * Set IconUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iconUrl
     * @return \patest\StructType\PresaleUpdater
     */
    public function setIconUrl($iconUrl = null)
    {
        // validation for constraint: string
        if (!is_null($iconUrl) && !is_string($iconUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iconUrl, true), gettype($iconUrl)), __LINE__);
        }
        if (is_null($iconUrl) || (is_array($iconUrl) && empty($iconUrl))) {
            unset($this->IconUrl);
        } else {
            $this->IconUrl = $iconUrl;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * @return bool|null
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \patest\StructType\PresaleUpdater
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get IsCodeTextSecret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCodeTextSecret()
    {
        return isset($this->IsCodeTextSecret) ? $this->IsCodeTextSecret : null;
    }
    /**
     * Set IsCodeTextSecret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCodeTextSecret
     * @return \patest\StructType\PresaleUpdater
     */
    public function setIsCodeTextSecret($isCodeTextSecret = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCodeTextSecret) && !is_bool($isCodeTextSecret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCodeTextSecret, true), gettype($isCodeTextSecret)), __LINE__);
        }
        if (is_null($isCodeTextSecret) || (is_array($isCodeTextSecret) && empty($isCodeTextSecret))) {
            unset($this->IsCodeTextSecret);
        } else {
            $this->IsCodeTextSecret = $isCodeTextSecret;
        }
        return $this;
    }
    /**
     * Get MaxTicketsPerAccessCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsPerAccessCode()
    {
        return isset($this->MaxTicketsPerAccessCode) ? $this->MaxTicketsPerAccessCode : null;
    }
    /**
     * Set MaxTicketsPerAccessCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsPerAccessCode
     * @return \patest\StructType\PresaleUpdater
     */
    public function setMaxTicketsPerAccessCode($maxTicketsPerAccessCode = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsPerAccessCode) && !(is_int($maxTicketsPerAccessCode) || ctype_digit($maxTicketsPerAccessCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsPerAccessCode, true), gettype($maxTicketsPerAccessCode)), __LINE__);
        }
        if (is_null($maxTicketsPerAccessCode) || (is_array($maxTicketsPerAccessCode) && empty($maxTicketsPerAccessCode))) {
            unset($this->MaxTicketsPerAccessCode);
        } else {
            $this->MaxTicketsPerAccessCode = $maxTicketsPerAccessCode;
        }
        return $this;
    }
    /**
     * Get MaxTicketsPerCustomer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsPerCustomer()
    {
        return isset($this->MaxTicketsPerCustomer) ? $this->MaxTicketsPerCustomer : null;
    }
    /**
     * Set MaxTicketsPerCustomer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsPerCustomer
     * @return \patest\StructType\PresaleUpdater
     */
    public function setMaxTicketsPerCustomer($maxTicketsPerCustomer = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsPerCustomer) && !(is_int($maxTicketsPerCustomer) || ctype_digit($maxTicketsPerCustomer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsPerCustomer, true), gettype($maxTicketsPerCustomer)), __LINE__);
        }
        if (is_null($maxTicketsPerCustomer) || (is_array($maxTicketsPerCustomer) && empty($maxTicketsPerCustomer))) {
            unset($this->MaxTicketsPerCustomer);
        } else {
            $this->MaxTicketsPerCustomer = $maxTicketsPerCustomer;
        }
        return $this;
    }
    /**
     * Get MaxTransactionsPerAccessCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getMaxTransactionsPerAccessCode()
    {
        return isset($this->MaxTransactionsPerAccessCode) ? $this->MaxTransactionsPerAccessCode : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMaxTransactionsPerAccessCode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMaxTransactionsPerAccessCode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMaxTransactionsPerAccessCodeForArrayConstraintsFromSetMaxTransactionsPerAccessCode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $presaleUpdaterMaxTransactionsPerAccessCodeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\AccessCodeUsageType::valueIsValid($presaleUpdaterMaxTransactionsPerAccessCodeItem)) {
                $invalidValues[] = is_object($presaleUpdaterMaxTransactionsPerAccessCodeItem) ? get_class($presaleUpdaterMaxTransactionsPerAccessCodeItem) : sprintf('%s(%s)', gettype($presaleUpdaterMaxTransactionsPerAccessCodeItem), var_export($presaleUpdaterMaxTransactionsPerAccessCodeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AccessCodeUsageType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\AccessCodeUsageType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MaxTransactionsPerAccessCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AccessCodeUsageType::valueIsValid()
     * @uses \patest\EnumType\AccessCodeUsageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $maxTransactionsPerAccessCode
     * @return \patest\StructType\PresaleUpdater
     */
    public function setMaxTransactionsPerAccessCode(array $maxTransactionsPerAccessCode = array())
    {
        // validation for constraint: list
        if ('' !== ($maxTransactionsPerAccessCodeArrayErrorMessage = self::validateMaxTransactionsPerAccessCodeForArrayConstraintsFromSetMaxTransactionsPerAccessCode($maxTransactionsPerAccessCode))) {
            throw new \InvalidArgumentException($maxTransactionsPerAccessCodeArrayErrorMessage, __LINE__);
        }
        if (is_null($maxTransactionsPerAccessCode) || (is_array($maxTransactionsPerAccessCode) && empty($maxTransactionsPerAccessCode))) {
            unset($this->MaxTransactionsPerAccessCode);
        } else {
            $this->MaxTransactionsPerAccessCode = is_array($maxTransactionsPerAccessCode) ? implode(' ', $maxTransactionsPerAccessCode) : null;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\PresaleUpdater
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PaymentCorrelation value
     * @return string[]|null
     */
    public function getPaymentCorrelation()
    {
        return $this->PaymentCorrelation;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentCorrelation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentCorrelation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentCorrelationForArrayConstraintsFromSetPaymentCorrelation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $presaleUpdaterPaymentCorrelationItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentCorrelationType::valueIsValid($presaleUpdaterPaymentCorrelationItem)) {
                $invalidValues[] = is_object($presaleUpdaterPaymentCorrelationItem) ? get_class($presaleUpdaterPaymentCorrelationItem) : sprintf('%s(%s)', gettype($presaleUpdaterPaymentCorrelationItem), var_export($presaleUpdaterPaymentCorrelationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentCorrelationType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentCorrelationType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentCorrelation value
     * @uses \patest\EnumType\PaymentCorrelationType::valueIsValid()
     * @uses \patest\EnumType\PaymentCorrelationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentCorrelation
     * @return \patest\StructType\PresaleUpdater
     */
    public function setPaymentCorrelation(array $paymentCorrelation = array())
    {
        // validation for constraint: list
        if ('' !== ($paymentCorrelationArrayErrorMessage = self::validatePaymentCorrelationForArrayConstraintsFromSetPaymentCorrelation($paymentCorrelation))) {
            throw new \InvalidArgumentException($paymentCorrelationArrayErrorMessage, __LINE__);
        }
        $this->PaymentCorrelation = is_array($paymentCorrelation) ? implode(' ', $paymentCorrelation) : null;
        return $this;
    }
    /**
     * Get PaymentCreditCardTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getPaymentCreditCardTypeIds()
    {
        return isset($this->PaymentCreditCardTypeIds) ? $this->PaymentCreditCardTypeIds : null;
    }
    /**
     * Set PaymentCreditCardTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $paymentCreditCardTypeIds
     * @return \patest\StructType\PresaleUpdater
     */
    public function setPaymentCreditCardTypeIds(\patest\ArrayType\ArrayOfguid $paymentCreditCardTypeIds = null)
    {
        if (is_null($paymentCreditCardTypeIds) || (is_array($paymentCreditCardTypeIds) && empty($paymentCreditCardTypeIds))) {
            unset($this->PaymentCreditCardTypeIds);
        } else {
            $this->PaymentCreditCardTypeIds = $paymentCreditCardTypeIds;
        }
        return $this;
    }
    /**
     * Get PaymentCreditCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentCreditCompanyId()
    {
        return isset($this->PaymentCreditCompanyId) ? $this->PaymentCreditCompanyId : null;
    }
    /**
     * Set PaymentCreditCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentCreditCompanyId
     * @return \patest\StructType\PresaleUpdater
     */
    public function setPaymentCreditCompanyId($paymentCreditCompanyId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCreditCompanyId) && !is_string($paymentCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCreditCompanyId, true), gettype($paymentCreditCompanyId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentCreditCompanyId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentCreditCompanyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentCreditCompanyId, true)), __LINE__);
        }
        if (is_null($paymentCreditCompanyId) || (is_array($paymentCreditCompanyId) && empty($paymentCreditCompanyId))) {
            unset($this->PaymentCreditCompanyId);
        } else {
            $this->PaymentCreditCompanyId = $paymentCreditCompanyId;
        }
        return $this;
    }
    /**
     * Get PaymentMode value
     * @return string[]|null
     */
    public function getPaymentMode()
    {
        return $this->PaymentMode;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentMode method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentMode method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentModeForArrayConstraintsFromSetPaymentMode(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $presaleUpdaterPaymentModeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentValidationScheme::valueIsValid($presaleUpdaterPaymentModeItem)) {
                $invalidValues[] = is_object($presaleUpdaterPaymentModeItem) ? get_class($presaleUpdaterPaymentModeItem) : sprintf('%s(%s)', gettype($presaleUpdaterPaymentModeItem), var_export($presaleUpdaterPaymentModeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentValidationScheme', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentValidationScheme::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentMode value
     * @uses \patest\EnumType\PaymentValidationScheme::valueIsValid()
     * @uses \patest\EnumType\PaymentValidationScheme::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $paymentMode
     * @return \patest\StructType\PresaleUpdater
     */
    public function setPaymentMode(array $paymentMode = array())
    {
        // validation for constraint: list
        if ('' !== ($paymentModeArrayErrorMessage = self::validatePaymentModeForArrayConstraintsFromSetPaymentMode($paymentMode))) {
            throw new \InvalidArgumentException($paymentModeArrayErrorMessage, __LINE__);
        }
        $this->PaymentMode = is_array($paymentMode) ? implode(' ', $paymentMode) : null;
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     * @return \patest\StructType\PresaleUpdater
     */
    public function setPriceTypeIds(\patest\ArrayType\ArrayOfguid $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get RankWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRankWeight()
    {
        return isset($this->RankWeight) ? $this->RankWeight : null;
    }
    /**
     * Set RankWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rankWeight
     * @return \patest\StructType\PresaleUpdater
     */
    public function setRankWeight($rankWeight = null)
    {
        // validation for constraint: int
        if (!is_null($rankWeight) && !(is_int($rankWeight) || ctype_digit($rankWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rankWeight, true), gettype($rankWeight)), __LINE__);
        }
        if (is_null($rankWeight) || (is_array($rankWeight) && empty($rankWeight))) {
            unset($this->RankWeight);
        } else {
            $this->RankWeight = $rankWeight;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \patest\StructType\PresaleUpdater
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get TestClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTestClientTypeId()
    {
        return isset($this->TestClientTypeId) ? $this->TestClientTypeId : null;
    }
    /**
     * Set TestClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $testClientTypeId
     * @return \patest\StructType\PresaleUpdater
     */
    public function setTestClientTypeId($testClientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($testClientTypeId) && !is_string($testClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testClientTypeId, true), gettype($testClientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($testClientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $testClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($testClientTypeId, true)), __LINE__);
        }
        if (is_null($testClientTypeId) || (is_array($testClientTypeId) && empty($testClientTypeId))) {
            unset($this->TestClientTypeId);
        } else {
            $this->TestClientTypeId = $testClientTypeId;
        }
        return $this;
    }
    /**
     * Get VisibilityStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RelativeTime|null
     */
    public function getVisibilityStart()
    {
        return isset($this->VisibilityStart) ? $this->VisibilityStart : null;
    }
    /**
     * Set VisibilityStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RelativeTime $visibilityStart
     * @return \patest\StructType\PresaleUpdater
     */
    public function setVisibilityStart(\patest\StructType\RelativeTime $visibilityStart = null)
    {
        if (is_null($visibilityStart) || (is_array($visibilityStart) && empty($visibilityStart))) {
            unset($this->VisibilityStart);
        } else {
            $this->VisibilityStart = $visibilityStart;
        }
        return $this;
    }
    /**
     * Get WrongCardMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWrongCardMessage()
    {
        return isset($this->WrongCardMessage) ? $this->WrongCardMessage : null;
    }
    /**
     * Set WrongCardMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wrongCardMessage
     * @return \patest\StructType\PresaleUpdater
     */
    public function setWrongCardMessage($wrongCardMessage = null)
    {
        // validation for constraint: string
        if (!is_null($wrongCardMessage) && !is_string($wrongCardMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($wrongCardMessage, true), gettype($wrongCardMessage)), __LINE__);
        }
        if (is_null($wrongCardMessage) || (is_array($wrongCardMessage) && empty($wrongCardMessage))) {
            unset($this->WrongCardMessage);
        } else {
            $this->WrongCardMessage = $wrongCardMessage;
        }
        return $this;
    }
}
